<?php 
/**
 * iCrew v4 LITE - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 * 
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other 
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems. 
 * 
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Intermediate Services (with additions) 
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 * 
 */
?>

<div class="widget-advanced widget-advanced-alt">
   <div class="widget">
      <div class="widget-advanced">
         <div class="widget-header text-center">
            <!--<img src="" alt="background" class="widget-background animation-pulseSlow">-->
            <h3 class="widget-content widget-content-image widget-content-light clearfix">
               <a href="javascript:void(0)" class="widget-icon pull-right"><i class="fa fa-trophy"></i></a>
               <span class="themed-color-amethyst">The <strong>Hall of Fame</strong></span><br>
               <small>The Heroes of <?php echo SITE_NAME ?></small>
            </h3>
         </div>
         <div class="widget-main text-center">
            <p>At <?php echo SITE_NAME?> ,we believe that when we keep our Pilots <Strong>Happy</Strong>, they become our very best <strong>Ambassadors.</strong><br>This hall of fame contains the glory of our Pilots, who are exceptional, and a cut above the rest.</p>
         </div>
      </div>
   </div>
</div>
<?php MainController::Run('TouchdownStats', 'halloffame'); ?>
<div class="widget">
  <div class="widget-advanced widget-advanced-alt">
    <div class="widget-main">
      <h3> <strong>Award Winners</strong><br><small>These pilots, make us proud</small></h3>
      
      
      <div class="table-responsive">
        <table class="table table-hover">
          <thead>
            <th>Award Name</th>
            <th>Award type</th>
            <th>Awarded to</th>
            <th>Awarded on</th>
          </thead>
          <tbody>
            <?php $issuedawds = vAwardsData::GetAllIssuedAwards();
              foreach($issuedawds as $issuedawd)
              { ?>
              <?php 
                $pdata = PilotData::getPilotData($issuedawd->grt_pilotid);
                $pilotname = $pdata->firstname.' '.$pdata->lastname; 
                $awdetails = vAwardsData::GetAwardDetail($issuedawd->grt_awdid);
                $type = vAwardsData::GetTypeDetail($awdetails->typ_id);
                $awdetails->awd_name;
                $awdetails->typ_id;
              ?>
            <tr>
              <td class="text-success"><?php echo $awdetails->awd_name; ?></td>
              <td><?php echo $type->typ_name; ?></td>
              <td><a class="btn btn-default" href="<?php echo SITE_URL?>/index.php/profile/view/<?php echo $issuedawd->grt_pilotid; ?>"><?php echo $pilotname; ?></a></td>
              <td><?php echo date('d M Y', $issuedawd->grt_dategrant); ?></td> 
            </tr>
            <?php }
            ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<div class="widget">
  <div class="widget-advanced widget-advanced-alt">
    <div class="widget-main">
      <h3><strong>Awards Magazine</strong><br><small>List of Awards in our system</small></h3>
      <div class="gallery gallery-widget" data-toggle="lightbox-gallery">
        <div class="row">
          <?php $allawards = vAwardsData::GetAllAwards();
          foreach($allawards as $allaward)
          { ?>
          <div class="col-xs-6 col-sm-3">
            <a href="<?php echo $allaward->awd_image; ?>" class="gallery-link" title="<?php echo $allaward->awd_desc;   ?>">
              <img src="<?php echo $allaward->awd_image; ?>" alt="<?php echo $allaward->awd_name;  ?>">
            </a>
          </div>
          <?php }  
          ?>
        </div>
      </div>
    </div>
  </div>
</div>

		