<?php
   Template::show('ICSFleet/header.php');
   ?>
<style>
   @import url(https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600);
   body .title {
   width: 600px;
   margin: 0 auto;
   text-align: center;
   }
   body .title h1 {
   margin: 30px 0px 0px 0px;
   font-family: 'Source Sans Pro', sans-serif;
   font-weight: 400;
   color: #3d3d3d;
   }
   body .title h2 {
   margin: 10px 0px 0px 0px;
   font-size: 18px;
   color: #8B8B8B;
   font-weight: 400;
   font-family: 'Source Sans Pro', sans-serif;
   }
   body .ui {
   width: 900px;
   margin: 0 auto;
   margin-top: 50px;
   font-family: 'Source Sans Pro', sans-serif;
   color: white;
   box-shadow: none;
   }
   body .ui ul {
   margin: 0px 30px 10px 0px;
   padding: 0;
   list-style-type: none;
   font-size: 11px;
   font-weight: 400;
   line-height: 20px;
   }
   body .ui .drop {
   z-index: -3;
   opacity: 0;
   width: 240px;
   height: 10px;
   background-color: #454545;
			background: -moz-linear-gradient(135deg, #454545 0%, #a30000 100%);
			background: -webkit-linear-gradient(135deg, #454545 0%, #a30000 100%);
			background: linear-gradient(135deg, #454545 0%, #a30000 100%);
   position: absolute;
   color: white;
   bottom: 0;
   padding: 12px 30px 21px 30px;
   -webkit-transition-property: bottom,opacity;
   transition-property: bottom,opacity;
   -webkit-transition-duration: .3s;
   transition-duration: .3s;
   }
   body .ui .drop p {
   color: #f8fbfa;
   }
   body .ui_box {
   width: 300px;
   height: 220px;
   position: relative;
   background: #3d3d3d;
   float: left;
   box-shadow: -1px 0px rgba(255, 255, 255, 0.07);
   cursor: pointer;
   -webkit-transform: scale(1);
   transform: scale(1);
   -webkit-transition-property: background,-webkit-transform;
   transition-property: background,-webkit-transform;
   transition-property: transform,background;
   transition-property: transform,background,-webkit-transform;
   -webkit-transition-duration: .3s;
   transition-duration: .3s;
   }
   body .ui_box__inner {
   padding: 30px;
   }
   body .ui_box__inner span {
   font-size: 36px;
   font-weight: 700;
   }
   body .ui_box__inner .progress {
   width: 100%;
   margin-top: 10px;
   height: 6px;
   background: rgba(0, 0, 0, 0.3);
   margin-bottom: 15px;
   }
   body .ui_box__inner .progress_graph {
   float: right;
   border-bottom: 1px solid rgba(255, 255, 255, 0.09);
   width: 85px;
   text-align: center;
   position: relative;
   padding-left: 20px;
   top: 24px;
   }
   body .ui_box__inner .progress_graph__bar--1 {
   width: 10px;
   height: 20px;
   background: #4FA584;
   float: left;
   margin-right: 10px;
   position: relative;
   bottom: -10px;
   -webkit-animation: graph 1s;
   }
   body .ui_box__inner .progress_graph__bar--2 {
   width: 10px;
   -webkit-animation: graph2 1s;
   height: 30px;
   float: left;
   margin-right: 10px;
   background: #4FA584;
   }
   body .ui_box__inner .progress_graph__bar--3 {
   width: 10px;
   height: 24px;
   margin-right: 10px;
   -webkit-animation: graph3 1s;
   background: #4FA584;
   float: left;
   position: relative;
   bottom: -6px;
   }
   body .ui_box__inner .progress_graph__bar--4 {
   width: 10px;
   height: 14px;
   -webkit-animation: graph4 1s;
   bottom: -16px;
   position: relative;
   background: #4FA584;
   float: left;
   }
   body .ui_box__inner .progress_bar {
   height: 6px;
   float: left;
   width: 58%;
   background: #454545;
   -webkit-animation: bar 2s;
   }
   body .ui_box__inner .progress_bar--two {
   height: 6px;
   float: left;
   width: 78%;
   background: #454545;
   -webkit-animation: bar2 2s;
   }
   body .ui_box h2 {
   font-weight: normal;
   font-size: 16px;
   margin: -4px 0px 3px 0px;
   }
   body .ui_box p {
   font-size: 11px;
   color: #b6b6b6;
   clear: left;
   font-weight: 300;
   width: 160px;
   margin: 2px 0px 15px 0px;
   }
   body .ui_box:hover {
   background-color: #454545;
			background: -moz-linear-gradient(135deg, #454545 0%, #a30000 100%);
			background: -webkit-linear-gradient(135deg, #454545 0%, #a30000 100%);
			background: linear-gradient(135deg, #454545 0%, #a30000 100%);
   -webkit-transform: scale(1.1);
   transform: scale(1.1);
   -webkit-transition-property: background,-webkit-transform;
   transition-property: background,-webkit-transform;
   transition-property: transform,background;
   transition-property: transform,background,-webkit-transform;
   -webkit-transition-duration: .3s;
   transition-duration: .3s;
   position: relative;
   z-index: 1;
   }
   .ui_box:hover > .ui_box__inner p {
   color: #fff;
   }
   .ui_box:hover > .drop {
   -webkit-transition-property: bottom,opacity;
   transition-property: bottom,opacity;
   -webkit-transition-duration: .3s;
   transition-duration: .3s;
   bottom: -50px;
   opacity: 1;
   }
   .ui_box:hover > .drop .arrow {
   -webkit-transition-property: -webkit-transform;
   transition-property: -webkit-transform;
   transition-property: transform;
   transition-property: transform, -webkit-transform;
   -webkit-transition-duration: 1s;
   transition-duration: 1s;
   -webkit-transform: rotate(765deg);
   transform: rotate(765deg);
   }
   .ui_box:hover > .ui_box__inner .progress_graph > div {
   background: white;
   }
   .ui_box:hover > .ui_box__inner .progress .progress_bar, .ui_box:hover > .ui_box__inner .progress .progress_bar--two {
   background: white;
   }
   .stat_left {
   float: left;
   }
   .arrow {
   width: 4px;
   height: 4px;
   -webkit-transition-property: -webkit-transform;
   transition-property: -webkit-transform;
   transition-property: transform;
   transition-property: transform, -webkit-transform;
   -webkit-transition-duration: 1s;
   transition-duration: 1s;
   -webkit-transform: rotate(45deg);
   transform: rotate(45deg);
   -webkit-transition-timing-function: cubic-bezier(0.68, -0.55, 0.265, 1.55);
   border-top: 1px solid #454545;
   border-right: 1px solid #454545;
   float: right;
   position: relative;
   top: -24px;
   right: 0px;
   }
   @-webkit-keyframes bar {
   from {
   width: 0px;
   }
   to {
   width: 58%;
   }
   }
   @keyframes bar {
   from {
   width: 0px;
   }
   to {
   width: 58%;
   }
   }
   @-webkit-keyframes bar2 {
   from {
   width: 0px;
   }
   to {
   width: 78%;
   }
   }
   @keyframes bar2 {
   from {
   width: 0px;
   }
   to {
   width: 78%;
   }
   }
   @-webkit-keyframes graph {
   from {
   height: 0px;
   }
   to {
   height: 20px;
   }
   }
   @keyframes graph {
   from {
   height: 0px;
   }
   to {
   height: 20px;
   }
   }
   @-webkit-keyframes graph2 {
   from {
   height: 0px;
   }
   to {
   height: 30px;
   }
   }
   @keyframes graph2 {
   from {
   height: 0px;
   }
   to {
   height: 30px;
   }
   }
   @-webkit-keyframes graph3 {
   from {
   height: 0px;
   }
   to {
   height: 24px;
   }
   }
   @keyframes graph3 {
   from {
   height: 0px;
   }
   to {
   height: 24px;
   }
   }
   @-webkit-keyframes graph4 {
   from {
   height: 0px;
   }
   to {
   height: 13px;
   }
   }
   @keyframes graph4 {
   from {
   height: 0px;
   }
   to {
   height: 13px;
   }
   }
</style>
<?php
// START Flight History Modal - by Apoorv
$pastflights = ICSFleetData::getPirepsByAircraft($aircraft->id);
?>
<div id="acfthist" class="modal fade" role="dialog">
   <div class="modal-dialog modal-lg">
      <!-- Modal content-->
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title"><strong>Flight</strong> History for <?php echo $aircraft->registration; ?></h4>
         </div>
         <div class="modal-body">
            <?php
            if($pastflights!='')
            {
            ?>
            <div class="table-responsive">
               <table id="acfthistory" class="table table-hover table-striped">
                  <thead>
                     <tr>
                        <th>Flight #</th>
                        <th>PIC</th>
                        <th>Departure</th>
                        <th>Arrival</th>
                        <th>Duration</th>
                        <th>Date</th>
                     </tr>
                  </thead>
                  <tbody>
                     <?php
                     foreach($pastflights as $pirep)
                     {
                     ?>
                     <tr>
                        <td height="25" width="10%" align="center"><span><a class="btn btn-default btn-sm" data-toggle="tooltip" data-placement="top" title="Click to view PIREP" href="<?php echo url('/pireps/view/'.$pirep->pirepid);?>"><?php echo $pirep->code.$pirep->flightnum; ?></a></span></td>
                        <?php
                           $pilot = PilotData::GetPilotData($pirep->pilotid);
                           $depicao = $pirep->depicao;
                           $dep = OperationsData::getAirportInfo($depicao);
                           if($dep->hub == 1)
                           {
                             $depicao = '<span style="color: #00aa00;">'.$depicao.'</span>';
                           }
                           $arricao = $pirep->arricao;
                           $arr = OperationsData::getAirportInfo($arricao);
                           if($arr->hub == 1)
                           {
                             $arricao = '<span style="color: #00aa00;">'.$arricao.'</span>';
                           }
                        ?>
                        <td height="25" width="10%" align="center"><span><?php echo $pilot->firstname; ?> <?php echo $pilot->lastname; ?> (<?php echo PilotData::getPilotCode($pilot->code, $pilot->pilotid); ?>)</span></td>
                        <td height="25" width="10%" align="center"><span><?php echo $depicao; ?></span></td>
                        <td height="25" width="10%" align="center"><span><?php echo $arricao; ?></span></td>
                        <td height="25" width="10%" align="center"><span><?php echo $pirep->flighttime; ?></span></td>
                        <td height="25" width="10%" align="center"><span><?php echo $pirep->submitdate; ?></span></td>
                     </tr>
                     <?php
                     }
                     ?>
                  </tbody>
               </table>
            </div>
            <?php
            }
            else
            {
            ?>
            <p class="h4 text-danger">No Past Flight Details for <?php echo $aircraft->registration; ?>. This usually happens when the aircraft has not been inducted into the fleet yet.</p>
            <?php
            }
            ?>
         </div>
         <div class="modal-footer">
         <h5 class="modal-title text-center"><strong><?php echo SITE_NAME?></strong> | Flight Operations &copy; <?php echo date ("Y"); ?></h5>
         </div>
    </div>
  </div>
</div>
<?php
// End of Aircraft History - by Apoorv
?>
<div class="row">
	<div class="col-md-12">
		<div class="block full text-center">
			<h2>
				<strong>
					<span class="text-primary">
						<?php echo $aircraft->fullname;?> <?php echo $aircraft->registration;?>
					</span>
				</strong>
				<br>
				<small>
					<strong>Range: </strong> <?php echo $aircraft->range;?> | <strong> MTOW: </strong> <?php echo $aircraft->weight;?> | <strong>Max. Speed: </strong> <?php echo $aircraft->cruise;?>
				</small>
			 </h2>

			 <a href="<?php echo url('/ICSFleet/view_flights/').$aircraft->registration; ?>" class="btn btn-sm btn-success">Search for flights operated using <?php echo $aircraft->registration; ?></a>
			 <a href="<?php echo url('/ICSFleet/upload_screenshots/').$aircraft->registration; ?>" class="btn btn-sm btn-info">Upload screenshots for <?php echo $aircraft->registration; ?></a>
			 <!-- <a href="<?php echo url('/ICSFleet'); ?>" class="btn btn-sm btn-warning">Add Maintenance Log for <?php echo $aircraft->registration; ?></a> -->
		</div>
        <div class="ui">

        	<div class="block full" style="color: #000">
        		<?php
                  $last_flight = ICSFleetData::get_last_flight($aircraft->id);
                  /*
                  if($last_flight != '')
                  {
                     $last_pilot = PilotData::getPilotData($last_flight->pilotid);
                     $pilot_name = $last_pilot->firstname.' '.$last_pilot->lastname;
                     $current_location = OperationsData::getAirportInfo($last_flight->arricao);
                  }
                  else
                  {
                     */
                     $current_location = OperationsData::getAirportInfo($aircraft->location);

                  //}
        				//$next_flight = ICSFleetData::get_next_schedule($aircraft->id, $current_location->icao);

        			?>
        		<span class="pull-left">
        			<small>AIRCRAFT STATUS <?php echo $aircraft->registration; ?> <br></small>
        		</span>
        		<h3 >
        			<center>
        				<?php
                     $schedules = ICSFleetData::findSchedules_aircraft($aircraft->icao, $aircraft->location);
                     if($last_flight == '')
                     {
                        $status = "<span class='label label-default'>Not Inducted</span>";
                     }
                     else
                     {
                       if(ICSFleetData::acOnBids($aircraft->id))
                       {
                          $status = "<span class='label label-danger'>Booked</span>";
                       }
                       else if(count($schedules) == 0)
                       {
                          $status = "<span class='btn btn-alt btn-xs btn-danger'>Stranded</span>";
                       }
                       else
                       {
                          $status = "<span class='label label-info'>In Service</span> <br><small><span class='text-muted'>". count($schedules) ." flights available</span></small>";
                       }
                     }
                     echo $status;
        				?>
        				<br><br>
        				<strong><?php echo $current_location->icao; ?></strong> - <?php echo $current_location->name; ?>
        			</center>
        		</h3>
               <?php
                  if($last_flight != '')
                  {
               ?>
               <span class="text-muted">

                  <center>Last operated by <?php echo $pilot_name; ?> on <?php echo date(DATE_FORMAT, strtotime($last_flight->submitdate)); ?> for <?php echo $last_flight->code.$last_flight->flightnum; ?></center>
               </span>
               <?php
                  }
                  else
                  {
               ?>
               <span class="text-muted">
                     <center>This aircraft has not been flown before on <?php echo SITE_NAME; ?></center>
               </span>
               <?php
                  }
               ?>
               <br><br>
               <!-- Added by Apoorv - Aircraft History -->
               <div class="text-center">
                  <a href="#" class="btn btn-sm btn-info" data-toggle="modal" data-target="#acfthist">Aircraft History for <?php echo $aircraft->registration; ?></a>
               </div>
        		<br><br><br>
        		<?php
        			if($schedules != '') {
        				?>
        				<table class="table text-center table-responsive table-borderless">
        				<?php
        				echo '<span class="text-muted"><center>'.count($schedules). ' flight(s) available <br> <br> <br></center></span>';
        				foreach ($schedules as $nf) {
                     $depicao = $nf->depicao;
                     $dep = OperationsData::getAirportInfo($depicao);
                     if($dep->hub == 1)
                     {
                        $depicao = '<span style="color: #00aa00;">'.$depicao.'</span>';
                     }
                     $arricao = $nf->arricao;
                     $arr = OperationsData::getAirportInfo($arricao);
                     if($arr->hub == 1)
                     {
                        $arricao = '<span style="color: #00aa00;">'.$arricao.'</span>';
                     }
        					?>
        					<tr>
        						<td class="">
        							<?php echo $nf->code.$nf->flightnum; ?>
        						</td>
        						<td class="pull-center">
        							<center>
        								<?php echo $depicao .' <i class="fa fa-plane"></i>' .$arricao; ?>
        							</center>
        						</td>
        						<td class="pull-center">
        							<center>
        								<?php echo $nf->flighttime; ?> Hrs
        							</center>
        						</td>
                        <?php
                        if(Auth::$userinfo->rankid >= $aircraft->minrank)
                        {
                        ?>
        						<td>
        							<center><a href="<?php echo url('/ICSFleet/bidflight/').$nf->id."_".$aircraft->id; ?>" class="btn btn-success btn-xs btn-alt">Add Bid</a></center>
        						</td>
        						<td class="">
        							<a target="_blank" href="<?php echo url('/schedules/brief/').$nf->id; ?>" class="btn btn-warning btn-xs btn-alt">Flight Briefing</a>
        						</td>
                        <?php
                        }
                        ?>
        					</tr>
        					<?php
        				}
        				?>

        				</table>
        			<?php
        			} else {
        				?>
        					<a href="<?php echo url('ICSFleet/relief_flight/').$aircraft->id; ?>" target="_blank" class="btn btn-block btn-alt btn-warning">
        						REPOSITION <?php echo $aircraft->registration; ?>
        					</a>
        					<p class="text-muted text-center">
        						<br><br>
        						What will you get?
        					<ul class="text-center text-muted">
        						<li><i class="fa fa-check text-success"></i> Bonus vMoney for Repositioning this aircraft</li>
        						<li><i class="fa fa-check text-success"></i> Your name on the Repositioning Crew Hall of Fame</li>
        					</ul>
        					</o>
        				<?php
        			}
        		?>
        	</div>
            <div class="ui_box">
               <div class="ui_box__inner">
                  <h2>
                    Operated Flights
                  </h2>

                  <div class="stat">
                     <span><?php echo round(vFleetTrackData::countFlights($aircraft->id));?> Flights</span>
                  </div>
                  <p>Total recorded flights for <?php echo $aircraft->fullname; ?> (<?php echo $aircraft->icao; ?>),
                  <?php echo $aircraft->registration; ?> at <?php echo SITE_NAME; ?> since <?php echo date(DATE_FORMAT, strtotime(StatsData::getStartDate()->submitdate)); ?>

                  </p>
               </div>
               <div class="drop">
                  Updated as of <?php echo date(DATE_FORMAT); ?>
               </div>
            </div>


          <div class="ui_box">
               <div class="ui_box__inner">
                  <h2>
                     Airframe Hours
                  </h2>

                  <div class="stat">
                     <span><?php echo round(vFleetTrackData::countHours($aircraft->id));?> Hours</span>
                  </div>
                  <p>Recorded hours for <?php echo $aircraft->fullname; ?> (<?php echo $aircraft->icao; ?>),
                  <?php echo $aircraft->registration; ?> at <?php echo SITE_NAME; ?> since <?php echo date(DATE_FORMAT, strtotime(StatsData::getStartDate()->submitdate)); ?>

                  </p>
               </div>
               <div class="drop">
                  Updated as of <?php echo date(DATE_FORMAT); ?>
               </div>
            </div>

            <div class="ui_box">
               <div class="ui_box__inner">
                  <h2>
                    Passengers Transported
                  </h2>

                  <div class="stat">
                     <span><?php echo vFleetTrackData::countPassengers($aircraft->id);?></span>
                  </div>
                  <p><?php echo vFleetTrackData::countPassengers($aircraft->id); ?> passengers have been transported by <?php echo $aircraft->fullname; ?> (<?php echo $aircraft->icao; ?>),
                  <?php echo $aircraft->registration; ?> at <?php echo SITE_NAME; ?> since <?php echo date(DATE_FORMAT, strtotime(StatsData::getStartDate()->submitdate)); ?>

                  </p>
               </div>
               <div class="drop">
                  Updated as of <?php echo date(DATE_FORMAT); ?>
               </div>
            </div>
         </div>
	</div>
</div>
<br><br><br>

<div class="row">
   <div class="col-md-6">
      <div class="block">
         <div class="block-title">
            <h3>Aircraft <strong>Image</strong></h3>
         </div>
         <div class="gallery gallery-widget" data-toggle="lightbox-gallery">
			<div class="row">
    			<div class="col-md-12">
    				<?php



    				if(!empty($aircraft->imagelink)) {
    					?>
    					<a href="<?php echo $aircraft->imagelink; ?>" class="gallery-link" title="Image Info">
	        				<img src="<?php echo $aircraft->imagelink; ?>" alt="image">
        				</a>
    					<?php
    				} else {
    					echo "<h2>NO IMAGE YET!</h2>";
    				}
            	?>

    			</div>
    			<div class="col-md-12">
    				<br><br>
    				<h3>Uploaded Screenshots for <?php echo $registration; ?></h3>
    				<div class="gallery gallery-widget" data-toggle="lightbox-gallery">
               <div class="row">

               	<?php
               	if($screenshots != '') {
    					foreach ($screenshots as $ss) {
    						?>
    						<div class="col-xs-6 col-sm-3">
                    			<a href="<?php echo SITE_URL; ?>/pics/<?php echo $ss->file_name; ?>" class="gallery-link" title="Image Info">
                    				<img src="<?php echo SITE_URL; ?>/pics/<?php echo $ss->file_name; ?>" alt="<?php echo $registration; ?> - Error in viewing SS">
                    			</a>
                			</div>
    						<?php
    					}
    				}
    			?>

               </div>
               <center>
               		<a href="<?php echo url('/ICSFleet/upload_screenshots/').$aircraft->registration; ?>" class="btn btn-xs btn-alt btn-primary">
               			Upload screenshots for <?php echo $registration; ?>
               		</a>
               </center>
               <br><br>
            </div>
    			</div>
			</div>
		</div>
      </div>
   </div>
   <div class="col-md-6">
   	<?php
   		$param = array();
   		$param['a.registration'] = $aircraft->registration;


   		if(vFleetTrackData::countFlights($aircraft->id) >= 5) {
   			$pireps =	PIREPData::findPIREPS($params, 5);
   		} else {
   			$pireps =	PIREPData::findPIREPS($params, 1);
   		}


   	?>
   	<div class="block">
   		<div class="block-title">
   			<h3>Recent flights for <strong><?php echo $aircraft->registration; ?></strong></h3>
   		</div>
		<div class="mapcenter" align="center">
			<div id="ics_fleet_recent_flights_map" style="width: 90%; height: 300px"></div>
      <br />
		</div>

<script src="<?php echo SITE_URL; ?>/lib/skins/iCrew/js/pages/tablesDatatables.js"></script>
<script>$(function(){ TablesDatatables.init(); });</script>
<script src="<?php echo SITE_URL?>/lib/js/base_map.js"></script>
<script type="text/javascript">

const map = createMap({
	render_elem: 'ics_fleet_recent_flights_map',
	provider: '<?php echo Config::Get("MAP_TYPE"); ?>',
});
var iconBase = 'https://icrew.skydream-airlines.com/iCrew/map/';



	map.setView([0, 0], 1.5);
	<?php
	$x = 3;
	foreach ($pireps as $pirep) {
   			// GET DEP & ARR;
   			$depdata = OperationsData::getAirportInfo($pirep->depicao);
   			$dep_coords = '['.$depdata->lat.','.$depdata->lng.']';

   			$arr = OperationsData::getAirportInfo($pirep->arricao);
   			$arr_coords = '['.$arr->lat.','.$arr->lng.']';
   			?>


		var dep_airport<?php echo $x; ?> = L.latLng(<?php echo $depdata->lat; ?>, <?php echo $depdata->lng; ?>);

		selDepMarker = L.marker(dep_airport<?php echo $x; ?>, {
		}).addTo(map);

		var arr_airport<?php echo $x; ?> = L.latLng(<?php echo $arr->lat; ?>, <?php echo $arr->lng; ?>);
		selDepMarker = L.marker(arr_airport<?php echo $x; ?>, {
		}).addTo(map);

		let point_set_<?php echo $x; ?> = [];
		point_set_<?php echo $x; ?>.push(dep_airport<?php echo $x; ?>);
		point_set_<?php echo $x; ?>.push(arr_airport<?php echo $x; ?>);


			const Points_layer_<?php echo $x; ?> = L.geodesic([point_set_<?php echo $x; ?>], {
				color: 'black',
				weight: 5,
				opacity: 1,
				dashArray: '10,9',
				lineJoin: 'round'
			}).addTo(map);

   	<?php
   	$x++;
   		}
   	?>





 var legend = L.control({position: 'bottomright'});

	legend.onAdd = function (map) {

    var div = L.DomUtil.create('div', 'info legend');
        div.innerHTML = '<img src="<?php echo SITE_URL; ?>/iCrew/favicon.png" style="width: 50px; height: auto;" /> <span class="text-primary">Recent Flights Map</span> ';
	//<br><span class="label label-success">Direct Flights</span><br><span class="label label-warning">Connecting Flights</span>

    return div;
	};

	legend.addTo(map);

</script>

      </div>
   </div>
</div>
