<?php

	//QR Code library, added for PIA Virtual. Make sure you have php-soundforge QRCode library installed!
	define ('phpqr_path' , CORE_LIB_PATH.'/phpqrcode' );
    define ('temp_path', CORE_PATH.'/lib/phpqrcode/temp');
     $PNG_TEMP_DIR = phpqr_path.'/temp'.DIRECTORY_SEPARATOR;

    //html PNG location prefix
    $PNG_WEB_DIR = SITE_URL.'/core/lib/phpqrcode/temp/';



    include phpqr_path."/qrlib.php";

/**
 * iCrew v4 Premium - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 *
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems.
 *
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Premium Services (with additions)
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 *
 */
?>
<!-- Blank Header -->
<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="gi gi-airplane"></i><Strong>Flights search for <?php echo $registration; ?></Strong><br><small> Flight Operations | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>
<ol class="breadcrumb breadcrumb-top">
  <li><a href="<?php echo SITE_URL; ?>/index.php"><i class="fa fa-home"></i></a></li>
  <li><a href="<?php echo SITE_URL; ?>/index.php/ICSFleet">Fleet</a></li>
  <li>Search Results</li>
</ol>
<!-- END Blank Header -->

<!-- Example Block -->
<div class="row">
	<div class="col-md-12">
		<div class="block">
<!-- Example Title -->
<div class="block-title">
	<h2><i class="gi gi-search"></i> Results</h2>
</div>
<!-- END Example Title -->

<!-- Example Content -->

<?php


if(!$allroutes) {




            	?>
<div class="box-body">
    <div class="alert alert-danger">
        <h4>Whooooops</h4>
        <p>
        	Looks like there are no flights for <?php echo $registration; ?>. Please try some other aircraft
        </p>
	</div>

<?php } else { ?>
<div class="row">

	<div class="">


        <?php
        foreach($allroutes as $route)
        {

            /* THIS BEGINS ONE TABLE ROW */
        ?>

         <?php $cload = round($route->distance);
        	if($cload < 1000) {
        		$cload_clr = 'success';
        		$notes ='<small><span class="label label-success">SHORT HAUL</span></small>';
        	}
        	else if($cload < 2500) {
        		$cload_clr = 'success';
        		$notes ='<small><span class="label label-success">MEDIUM HAUL</span></small>';
        	}
        	else if($cload < 3500) {
        		$cload_clr = 'warning';
        		$notes ='<small><span class="label label-warning">LONG HAUL</span></small>';
        	}
        	else {
        		$cload_clr = 'danger';
        		$notes = '<small><span class="label label-danger">ULTRA LONG HAUL</span></small>';
        	}
        ?>


        <div class="col-md-4">
			<div class="block full">
						<center>
					<h3>
						<span class="label label-primary"><strong><?php echo $route->code.''.$route->flightnum; ?></strong></span><br>
						<small>
							<span class="text-muted">
								<a href="javascript:void(0)" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Departing @ <?php echo $route->deptime; ?> UTC"><?php echo $route->depicao; ?></a> <i class="fa fa-plane"></i>
								<a href="javascript:void(0)" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Arriving @ <?php echo $route->arrtime; ?> UTC">
									<?php echo $route->arricao; ?></a>
							</span>
						</small>
            <?php
            // Not all airline uses CodeShare, so normally the code gets ignored. 28.03.2019
              $cs = CodeShareData::get_codeshares($route->id);
              if($cs == '') {
                $airline = OperationsData::getAirlineByCode($route->code);
                $operator = $airline->name;
                $logo = SITE_URL."/lib/images/airline/".$route->code.".png";
              } else {
                $op = CodeShareData::check_airline($cs->operator);
                $operator = $op->name;
                $logo = $op->image;
              }

				$schedule_id = SITE_URL."/index.php/schedules/bidSchedule/".$route->id;
        		// user data
    			$filename = $PNG_TEMP_DIR.'test'.md5($schedule_id.'|'.$errorCorrectionLevel.'|'.$matrixPointSize).'.png';
    			QRcode::png($schedule_id, $filename, "Q", "2", 2);

    			//display generated file

            ?>
            <br>
            <img src="<?php echo $logo; ?>" style="height: 50px; width: auto;" />
            	<h5>Operated by <?php echo $operator; ?></h5>
						<h6><?php echo $route->aircraft.' ('.$route->registration.')'; ?></h6>
						<span class="badge"><?php echo $route->flighttime; ?> Hrs</span> <?php echo $notes; ?>
						<br><br>
						<?php echo '<img src="'.$PNG_WEB_DIR.basename($filename).'" />'; ?>
						<h6><i class="text-muted">Scan the code to bid this flight <br>
						<small>(ID: <?php echo md5($route->flightnum); ?>)</small></i></h6>
					</h3>
				</center>
				<ul class="pager">
					<!--<li class="previous"><a href="javascript:void(0)" data-toggle="tooltip" data-placement="top" title="" data-original-title="Departing @ <?php echo $route->deptime; ?> UTC"><?php echo $route->depicao; ?></a></li>-->
					<!--<li class="next"><a href="javascript:void(0)" data-toggle="tooltip" data-placement="top" title="" data-original-title="Arriving @ <?php echo $route->arrtime; ?> UTC"><?php echo $route->arricao; ?></a></li>-->
					<ul class="pagination text-center">
						<li>
							<?php
							# Don't allow overlapping bids and a bid exists
							if(Config::Get('DISABLE_SCHED_ON_BID') == true && $route->bidid != 0) {
								echo '<a id="'.$route->id.'" class="addbid" href="'.actionurl('/schedules/addbid').'">Add to Bid</a>';
								} else {
									if(Auth::LoggedIn()) { ?>
									<a onclick="setTimeout('window.location.href=\'<?php echo SITE_URL; ?>/index.php/schedules/brief/<?php echo $route->id; ?>\';', 2000); hotsnackbar('hsdone', 'Your bid has been added!'); play(); loadScheduleBrief();"  id="<?php echo $route->id; ?>" class="addbid" href="<?php echo url('/schedules/addbid'); ?>" data-toggle="tooltip" data-placement="top" title="" data-original-title="Add bid!"><i class="fa fa-plus"></i></a>
									<?php
									}
								}
							?>
						</li>

						<li><a href="<?php echo url('/schedules/details/'.$route->id);?>" target="_blank" data-toggle="tooltip" data-placement="top" title="" data-original-title="View flight info" ><i class="fa fa-info"></i></a></li>
					</ul>

				</ul>



			</div>
		</div>

	<?php
     /* END OF ONE TABLE ROW */
    }
    ?>
</div>
<!-- /.box-body -->
<?php } ?>

<!-- END Example Content -->
</div>
<!-- END Example Block -->
<!--Snackbar-->





</div>
	</div>
</div>
	<!--snackbar(); -->
  <div id="snackbar"><strong>Success! </strong>Your bid has been added!</div>
<audio src="http://api.voicerss.org/?key=3cb117cb67c34a69986f4ffd768b21a8&hl=en-gb&src=your%20bid%20has%20been%20added" id="audio"></audio>
<!--END Snackbar-->
<!-- User Settings, modal which opens from Settings link (found in top right user menu) and the Cog link (found in sidebar user info) -->
<div id="flighbook" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header text-center">
                <h2 class="modal-title">Bon Voyage!</h2>
            </div>
            <!-- END Modal Header -->

            <!-- Modal Body -->
            <div class="modal-body">
                <center>
                	<i class="fa fa-check fa-5x text-success"></i>
                	<p>Flight Booked!</p>
                	<a href="<?php echo url('/schedules/brief/'.$route->id);?>" target="_blank"><span class="label animation-pulse"><button type="button" class="btn btn-alt btn-default">Go to Briefing</button></span></a>
                </center>
            </div>
            <!-- END Modal Body -->
        </div>
    </div>
</div>
<!-- END User Settings -->
<script>
   function play() {
        var audio = document.getElementById('audio');
        if (audio.paused) {
            audio.play();
            $('#play').removeClass('glyphicon-play-circle')
            $('#play').addClass('glyphicon-pause')
        }else{
            audio.pause();
            audio.currentTime = 0
            $('#play').addClass('glyphicon-play-circle')
            $('#play').removeClass('glyphicon-pause')
        }
    }
   </script>

   <script>

   $("document").ready(function() {
    setTimeout(function() {
        hotsnackbar('hsinfo', '<?php echo count($allroutes); ?> schedules loaded from database');
    },10);
	});
   </script>
