<?php 
   Template::show('ICSFleet/header.php');
   ?>
<style>
   .loading_text {
   position: relative;
   color: rgba(0, 0, 0, .3);
   }
   .loading_text:before {
   content: attr(data-text);
   position: absolute;
   overflow: hidden;
   max-width: 7em;
   white-space: nowrap;
   color: #000;
   animation: loading 7s linear;
   }
   @keyframes loading {
   0% {
   max-width: 0;
   }
   }
</style>
<div class="row">
   <div class="col-md-12">
      <div class="block">
         <h3 class="text-center">
            <strong>Fleet Map for </strong><span class="label label-primary"><?php echo $icao; ?></span>
         </h3>
         <div id="ajax_map">
            <center>
               <h2 class="loading_text" data-text="Initializing Fleet Map...please wait">Initializing Fleet Map...please wait</h2>
            </center>
            <script src="<?php echo SITE_URL?>/lib/js/base_map.js"></script>
         </div>
         <script>
            $(document).ready(function() {
            	$.ajaxSetup({ cache: true }); // This part addresses an IE bug.  without it, IE will only load the first number and will never refresh
            	$('#ajax_map').load('<?php echo SITE_URL; ?>/action.php/ICSFleet/_map_generate/<?php echo $icao; ?>').fadeIn("slow");
            	
            setInterval(function() {
            $.bootstrapGrowl("<h4>iCrew <strong>Notifications </strong> </h4> Updating live flights.... ", {
            ele: 'body', // which element to append to
            type: 'success', // (null, 'info', 'danger', 'success')
            offset: {from: 'top', amount: 20}, // 'top', or 'bottom'
            align: 'right', // ('left', 'right', or 'center')
            width: 250, // (integer, or 'auto')
            delay: 1000, // Time while the message will be displayed. It's not equivalent to the *demo* timeOut!
            allow_dismiss: true, // If true then will display a cross to close the popup.
            stackup_spacing: 10 // spacing between consecutively stacked growls.
            });
            }, 10000);
            });
         </script>
      </div>
   </div>
   <div class="col-md-12">
      <div class="block">
         <h5 class="text-center">There are <strong><?php echo count($fleet); ?></strong> <?php echo $icao; ?>'s in the <?php echo SITE_NAME; ?> fleet.</h5>
         <div class="table-responsive">
            <table id="fleet-table" class="table datatable">
               <thead>
                  <th>Aircraft</th>
                  <th>Registration</th>
                  <th>Category</th>
                  <th>Current Location</th>
                  <th>Status</th>
                  <th>Last Operation</th>
                  <th>Options</th>
               </thead>
               <tbody>
                  <?php 
                     foreach ($fleet as $fleet) {
                        $last_flight = ICSFleetData::get_last_flight($fleet->id);
                        $style = "";
                        $tag="";
                        
                        $location = $fleet->location;
                        $loc = OperationsData::getAirportInfo($location);
                        if($loc->hub == 1)
                        {
                        $location = '<span style="color: #00aa00;">'.$location.'</span>';
                        }
      //               	 	$params = array();
                        // $params['s.aircraft'] = $fleet->id;
                        // $params['s.depicao'] = $fleet->location;
                        // $schedules = SchedulesData::findSchedules($params);
                        $schedules = ICSFleetData::findSchedules_aircraft($fleet->icao, $fleet->location);
                     	if($last_flight == '') {
                     		$status = "<span class='label label-default'>Not Inducted</span>";
                        }
                        else {
                        	$onbid = ICSFleetData::acOnBids($fleet->id);
                        	$biddedBy = PilotData::getPilotData($onbid[0]->pilotid);
                 			if($onbid) {
                              $status = "<span class='label label-danger' data-toggle='tooltip' data-placement='top' title='Booked by ".$biddedBy->code.$biddedBy->pilotid." ".$biddedBy->firstname." ".$biddedBy->lastname.$onbid->pilotid."'>Booked</span>";
                           } else if(count($schedules) == 0) {
                              $status = "<span class='btn btn-alt btn-xs btn-danger'>Stranded</span>";
                           } else {
                              $status = "<span class='label label-info'>In Service</span> <br><small><span class='text-muted'>". count($schedules) ." flights available</span></small>";	
                           }
                        }
                        
                        if(Auth::$userinfo->rankid < $fleet->minrank)
                        {
                           $style='style="color: #ccc;"';
                           $tag="&nbsp; <span class='label label-default'>Unavailable</span>";
                        }
                        else
                        {
                           if(Auth::$userinfo->rankid >= 7 && $fleet->minrank >= 7)
                           {
                              $tag="&nbsp; <span class='label' style='background-color: #FCB900;'><i class='fa fa-shield'></i> Reserved</span>";
                           }
                        }
                     	?>
                  <tr <?php echo $style; ?>>
                     <td><?php echo $fleet->fullname; ?></td>
                     <td><?php echo $fleet->registration.$tag; ?></td>
                     <td><?php echo ICSFleetData::get_category($fleet->category_id); ?></td>
                     <th class="text-center">
                        <?php echo $location; ?>
                     </th>
                     <th><?php echo $status; ?></th>
                     <th>
                        <?php $last = '<a class="btn btn-alt btn-sm btn-primary" href="'.url('/pireps/view/'.$last_flight->pirepid).'">View '.$last_flight->code.$last_flight->flightnum.' ('.$last_flight->depicao.' - '.$last_flight->arricao.')</a>';
                        echo date(DATE_FORMAT, strtotime($last_flight->submitdate)).' ('.ICSFleetData::time_elapsed_string($last_flight->submitdate); ?>)
                     </th>
                     <td>
                        <a href="<?php echo url('/ICSFleet/view_aircraft/'); ?><?php echo $fleet->registration; ?>" class="btn btn-sm btn-success">View</a>
                        <!--<a href="<?php echo url('/ICSFleet/mx_report/'); ?><?php echo $fleet->registration; ?>" class="btn btn-sm btn-warning">Add MX report</a>-->
                        <?php echo $last; ?>
                     </td>
                  </tr>
                  <?php 
                     }
                     ?>
               </tbody>
            </table>
         </div>
      </div>
   </div>
</div>
<script>
   var TablesDatatables = function() {
   
      return {
          init: function() {
              /* Initialize Bootstrap Datatables Integration */
              App.datatables();
   
              /* Initialize Datatables */
              $('#fleet-table').dataTable({
                  columnDefs: [ { orderable: false} ],
                  pageLength: 10,
                  lengthMenu: [[10, 20, 30, -1], [10, 20, 30, 'All']]
              });
   
              /* Add placeholder attribute to the search input */
              $('.dataTables_filter input').attr('placeholder', 'Search');
          }
      };
   }();
</script>
<script>
   $(function(){ TablesDatatables.init(); });
</script>