<?php
   /**
    * THIS FILE PROVIDES ASYNCHRONOUS JAVASCRIPT DRIVEN DATA FOR THE ACARS MAP // TRACKFLIGHT.
    *
    *
    *
    * iCrew v4 Premium - Virtual Airline Crew Center
    * Copyright (c) 2017 iCrewSystems
    *
    * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
    * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
    * No part of the website design or layout may be reproduced or transmitted in any form or by any other
    * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
    * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems.
    *
    * @author: Leonard Selvaraja
    * @copyright: Copyright (c) 2017, iCrewSystems
    * @link http://www.icrewsystems.com
    * @service name: iCrewSystems Virtual Airline Intermediate Services (with additions)
    * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
    */

    	$acarsdata = ACARSData::GetACARSData();
   ?>
<style>
   .loading_text {
   position: relative;
   color: rgba(0, 0, 0, .3);
   }
   .loading_text:before {
   content: attr(data-text);
   position: absolute;
   overflow: hidden;
   max-width: 7em;
   white-space: nowrap;
   color: #000;
   animation: loading 7s linear;
   }
   @keyframes loading {
   0% {
   max-width: 0;
   }
   }
</style>
<div class="row">
	<div class="col-md-12" id="live_flights">
   <div class="block">
      <div class="block-title">
         <div class="block-options pull-right">
            <span class="label label-default">Loading</span>
         </div>
         <h3><i class="gi gi-airplane"></i> <strong>Live </strong> Flights List</h3>
      </div>
      <h2 class="loading_text" data-text="Initializing radar...">Initializing radar...please wait</h2>
   </div>
 </div>

 <div class="col-md-12" style="display: none;" id="live_flights_temp">
   <div class="block">
      <div class="block-title">
         <div class="block-options pull-right">
            <?php if(!$acarsdata)
               { echo '<span class="label label-default">Receiver Offline</span>';}
               else
               { echo '<span class="label label-danger animation-pulse">Live Feed</span>';}
               ?>
            <button id="trigger_button" class="btn btn-sm btn-default"><i class="fa fa-refresh"></i></button>
         </div>
         <h3><i class="gi gi-airplane"></i> <strong>Live </strong> Flights List</h3>
      </div>
      <?php
          if(!$acarsdata) { ?>
            <div class="alert alert-info">
              <h3><strong>Oh Snap! ^_^ </strong></h3>
              No aircraft are in the air, and that's just `plane` wrong, don't you think? Make a bid and fly!
            </div>
          <?php } else { ?>
        	<div class="table-responsive">
        		<table class="table table-responsive table-hover table-striped">
              <thead>
                 	<tr>
                 		<td>Airline</td>
                 		<td>Flight</td>
                 		<td>Pilot</td>
                 		<td>Route</td>
                 		<td>Aircraft</td>
                 		<td>Status</td>
                 		<td>Progress</td>
                 		<td>Network</td>
                 		<td>Track</td>
                    <td>Share</td>
                 	</tr>
              </thead>
              <tbody>
                 <?php
                 foreach($acarsdata as $flight) {
                   /*ALGORITHM FOR FLIGHT PROGRESS*/
                     $depicao = $flight->depicao;
                     $arricao = $flight->arricao;
                     $dist = OperationsData::getAirportDistance($depicao, $arricao);
                     $distremain = $flight->distremain;
                     if($distremain == 0) {
                       $distremain = 1;
                     }

                     if($dist == 0) {
                       $dist = 1;
                     }
                     $progress = 100 - (($distremain / $dist) * 100);
                     $progressbar_val = floor($progress);
                     if($progressbar_val < 10)
                     {
                       $progressbar_clr = 'info';
                     }
                     elseif($progressbar_val < 50)
                     {
                       $progressbar_clr = 'success';
                     }
                     elseif($progressbar_val < 80)
                     {
                       $progressbar_clr = 'warning';
                     }
                     elseif($progressbar_val < 100)
                     {
                       $progressbar_clr = 'danger';
                     }

                     /*The Progress Bar*/
                     $progressbar = '<div class="progress progress-striped active">
                     <div class="progress-bar progress-bar-'.$progressbar_clr.'" role="progressbar" aria-valuenow="'.$progressbar_val.'" aria-valuemin="0" aria-valuemax="100" style="width: '.$progressbar_val.'%"></div>
                     </div>';

                     	$properflightnum = SchedulesData::getProperFlightNum($flight->flightnum);
                    ?>
                  <tr>
                     <td> <?php echo '<img src="'.fileurl('/lib/images/airline/'.$properflightnum['code'].'.png').'" alt="'.$airline->name.'" width="90px;" height="auto;" />'; ?></td>
                     <td><?php echo $flight->flightnum ?></td>
                     <td><?php echo $flight->pilotname ?></td>
                     <td><?php echo $flight->depicao ?> <i class="fa fa-plane"></i> <?php echo $flight->arricao ?></td>
                     <td><span class="label label-success"><?php echo $flight->aircraftname ?></span> <span class="label label-warning"><?php if (is_null($flight, 'aircraftreg')) { echo $flight->aircraft; } else { echo $flight->aircraftreg; } ?></span></td>
                          <td><?php
            $phase = $flight->phasedetail;
            if($phase == "Preflight")
            {
            	echo '	<span class="label label-default">
            				'. $phase .'
            			</span>';
            }
            else if ($phase == "Taxiing to Runway")
            {
            	echo '	<span class="label label-warning animation-pulse">
            				'. $phase.'
            			</span>';
            }
            else if ($phase == "Pushing Back")
            {
            	echo '	<span class="label label-warning animation-pulse">
            				'. $phase .'
            			</span>';
            }
            else if ($phase == "Taking Off")
            {
            	echo '	<span class="label label-danger animation-pulse">
            			'. $phase.'
            			</span>';
            }
            else if ($phase == "Climbing")
            {
            	echo '	<span class="label label-primary animation-pulse">
            			'. $phase .'
            			</span>';
            }
            else if ($phase == "Cruising")
            {
            	echo '	<span class="label label-success">
            				'. $phase.' </span>';
            }
            else if ($phase == "Descending")
            {
            	echo '	<span class="label label-warning animation-pulse">
            				'. $phase .'
            			</span>';
            }
            else if ($phase == "Approaching")
            {
            	echo '	<span class="label label-primary animation-pulse">
            				'. $phase .'
            			</span>';
            }
            else if ($phase == "Final Approach")
            {
            	echo '	<span class="label label-danger animation-pulse">
            				'. $phase .'
            			</span>';
            }
            else if ($phase == "Landing")
            {
            	echo '	<span class="label label-primary animation-pulse">
            				'. $phase .'
            			</span>';
            }
            else if ($phase == "Taxiing to Gate")
            {
            	echo '	<span class="label label-default animation-pulse">
            				'. $phase .'
            			</span>';
            }
            else
            {
            	echo '	<span class="label label-danger animation-pulse">
            				'. $phase .'
            			</span>';
            }

            ?>	</td>
                     <td><?php echo $progressbar; ?></td>
                     <td>
                    	<center>
                    		<?php
                        // $this->set('acarsdata', ACARSData::GetACARSData());
                        if(!$flight->online)
                        {
                        	echo 'OFFLINE';
                        }
                        else {
                        	switch ($flight->online) {

                        		case 'IVAO':
                        			echo '<img src="'.SITE_URL.'/iCrew/brand/ivao.png" style="width: 50px; height: auto;">';
                        		break;

                        		case 'VATSIM':
                        			echo '<img src="'.SITE_URL.'/iCrew/brand/vatsim.png" style="width: 90px; height: auto;">';
                        		break;

                        		default:
                        			?>
                              <center>
                                <?php echo strtoupper($flight->online); ?>
                              </center>
                              <?php
                        		break;
                        	}
                        	}
                        	?>
                    	</center>
                     </td>

                        <?php
                        		$string = $flight->pilotid.'#'.$flight->flightnum;
                        		$decrypt = base64_encode($string);
                        		$flighturl = SITE_URL.'/index.php/ICSMap/track/'.$decrypt;
                        ?>
                     <td>
                       <a target="_blank" href="<?php echo $flighturl; ?>" class="btn btn-xs btn-info"><i class="fa fa-map-marker"></i> Track Flight</button></a>
                     </td>
                     <td>
                        <a onclick="copyToClipboard('#trackurl')" class="btn btn-xs btn-primary">
                          Share Tracking URL
                        </a>
                        <p style="display: none;" id="trackurl"><?php echo $flighturl; ?></p>
                     </td>

                     <script>
                      function copyToClipboard(element) {
                          var $temp = $("<input>");
                            $("body").append($temp);
                            $temp.val($(element).text()).select();
                            document.execCommand("copy");
                            hotsnackbar('hsdone', 'URL Copied to clipboard');
                            $temp.remove();
                          }
                      </script>
                  </tr>
                  <?php
                }
                ?>
              </tbody>
            </table>
          </div>
      <?php } ?>
    </div>
  </div>

</div>

<script>
   $("#trigger_button").click(function() {
    $('#live_flights_temp').load('<?php echo SITE_URL; ?>/live_uplink.php').fadeIn("slow");
    $.bootstrapGrowl("<h4>iCrew <strong>Notifications </strong> </h4> Updating live flights.... ", {
      ele: 'body', // which element to append to
      type: 'success', // (null, 'info', 'danger', 'success')
      offset: {from: 'top', amount: 20}, // 'top', or 'bottom'
      align: 'right', // ('left', 'right', or 'center')
      width: 250, // (integer, or 'auto')
      delay: 1000, // Time while the message will be displayed. It's not equivalent to the *demo* timeOut!
      allow_dismiss: true, // If true then will display a cross to close the popup.
      stackup_spacing: 10 // spacing between consecutively stacked growls.
    });

   });
</script>
<script>
   setTimeout(function() {
    $('#live_flights').load('<?php echo SITE_URL; ?>/live_uplink.php').fadeIn("slow");
   }, 2); // <-- time in milliseconds
</script>
<script>
   $(document).ready(function() {
   	$.ajaxSetup({ cache: false }); // This part addresses an IE bug.  without it, IE will only load the first number and will never refresh
   setInterval(function() {
   $('#live_flights_temp').hide();
   $('#live_flights').load('<?php echo SITE_URL; ?>/live_uplink.php').fadeIn("slow");
   }, 120000);
   });
</script>
