<?php 
/**
 * iCrew v4 Premium - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 * 
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other 
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems. 
 * 
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Premium Services (with additions) 
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 * 
 */

//$nats = file('https://icrew.skydream-airlines.com/westbound_nats.php'); 
$nats = file('https://api.flightplandatabase.com/nav/NATS');
//We are getting the contents for the west bound tracks from a file which i formerly created.
//So totally there should be 11 Variables if we consider all of the NATs into one Array.
// Each of those 11 will go through this code, hence we initialize each $nats as $nat 

$data = array();

foreach ($nats as $nat)
{
	$i = 1;
	//First, we are seperating all the NATS using the space in between them
	$nat_exp = explode(" ", $nat);
	
		foreach($nat_exp as $ntx) {
			
			//We are initializing the name of the NAT, because that's always the first variable in the array :P
			$NAT_NAME = $nat_exp[0]; //So, we call the name of the NAT in the Map Javascript as NAT_NAME;
			
			//This peice of code is to go through each and every string of the array, and the next step 
			//will only get executed if the Boolean value returns 1 (True). 
			$str = "$ntx?"; $find="/";$position = strpos($str,$find);
			if ($position == true){
				//Now that we have the variables which only have the forward slash in them,
				//we are seperating all those variables(NATS) with the space between them.
				$split_with_slash = explode(" ", $ntx);
				foreach ($split_with_slash as $sws) $i + 1; {
					
					//--	echo $sws.' ';
					//Now that we have seperated individual Positions, we are breaking down the 
					//variable further.
					$final_split = str_split($sws);
					//Bravo, so this is how you get the individual NAT positions.
					$nat_lat =  $final_split[0].''.$final_split[1];
					$nat_lng = $final_split[3].''.$final_split[4];
					//To call the NAT's Lattitude and Longitude in the Google Maps JS, use '$nat_lat' and '$nat_lng'
					//echo $nat_exp[0].''.$i;
					$json = $nat_exp[0].'';
					//echo "'.$NAT_NAME = {lat: $nat_lat, lng: $nat_lng};";
					?> 
					<script>
						//var A1 = {lat: 58, lng: -23};
					</script>
					<?php
					$i++;
				}
			}
			
		}
}

$json = json_decode($json);


$natdata = array();
foreach($json as $nat) {
	// echo "NAT: ". $nat->ident;
	$route = array();
	for($i = 0; $i < count($nat->route->nodes); $i++) {
		// echo $nat->route->nodes[$i]->ident.' Coords: ';
		// echo $nat->route->nodes[$i]->lat.', '.$nat->route->nodes[$i]->lon;
		
		$levels = null;
		$direction = null;
	
		// $route .= $nat->route->nodes[$i]->ident.', ';
		
		$route[] = array(
			'ident' => $nat->route->nodes[$i]->ident,
			'lat' => $nat->route->nodes[$i]->lat,
			'lon' => $nat->route->nodes[$i]->lon,
		);
		
		if(empty($nat->route->eastLevels)) {
			$direction = 'Westbound';
			foreach($nat->route->westLevels as $eastLevel) {
				$levels[] = $eastLevel;
			}
		} else {
			$direction = 'Eastbound';
			foreach($nat->route->eastLevels as $eastLevel) {
				$levels[] = $eastLevel;
			}
		}
	}
	
	
	$data = array(
		'ident' => $nat->ident,
		'route' => $route,
		'levels' => $levels,
		'direction' => $direction,
		'validity' => date(DATE_FORMAT . ' h:i', strtotime($nat->validFrom)) .' to '. date(DATE_FORMAT . ' h:i', strtotime($nat->validTo)),
	);
	
	$natdata[] = $data;
	
}

?>

<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="gi gi-group"></i>NAT <strong>Tracks</strong><br><small>Oceanic Procedures | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>


<div class="row">
	<div class="col-md-12">
		<div class="block">
			<div class="block-title">
				<h3>North Atlantic Tracks</h3>
			</div>
			
			<div class="table-responsive">
				<table class="table table-hover">
					<thead>
						<th>IDENT</th>
						<th>ROUTE</th>
						<th>LEVELS</th>
						<th>VALIDITY</th>
					</thead>
					
					<tbody>
						<?php foreach($json as $nat) {
							
							?>
							<tr>
								<td>
									<span class="label label-primary">
										NAT <?php echo $nat->ident; ?>
									</span>
								</td>
								<td>
									<?php 
										for($i = 0; $i < count($nat->route->nodes); $i++) {
											?>
											<span data-toggle="tooltip" data-placement="top" title="<?php echo 'LAT: '. $nat->route->nodes[$i]->lat.', LON: '.$nat->route->nodes[$i]->lon; ?>">
												<?php echo $nat->route->nodes[$i]->ident.' '; ?>
											</span>
											<?php
											
										}
									?>
								</td>
								<td>
									<?php
										if(empty($nat->route->eastLevels)) {
											echo "Westbound: ";
											foreach($nat->route->westLevels as $eastLevel) {
												echo $eastLevel . ' ';
											}
										} else {
											echo "Eastbound: ";
											foreach($nat->route->eastLevels as $eastLevel) {
												echo $eastLevel . ' ';
											}
										}
									?>
								</td>
								<td>
								<?php echo date(DATE_FORMAT . ' h:i', strtotime($nat->validFrom)); ?>z to <?php echo date(DATE_FORMAT . ' h:i', strtotime($nat->validTo)); ?>z
								</td>
								<?php 
								
								?>
							</tr>
							<?php
							}

						?>
					</tbody>
				</table>
			</div>
		</div>
		
		
		<div class="block">
			<div class="block-title">
				<h3>NAT Map</h3>
			</div>
			<div class="mapcenter" align="center">
				<div id="natmap" style="width:<?php echo  Config::Get('MAP_WIDTH');?>; height: 300px"></div>
			</div>
			<br><br>
		</div>
	</div>
</div>

<script src="<?php echo SITE_URL?>/lib/js/base_map.js"></script>
<script type="text/javascript">
	const map = createMap({
		render_elem: 'natmap',
		provider: '<?php echo Config::Get("MAP_TYPE"); ?>',
		center: {lat: 52, lng: -37},
		zoom: '2',
	});
	
	
	const nats = <?php echo json_encode($natdata); ?>;
	console.log(nats);
	
	
	nats.forEach(function(nat, i) {
		// const marker = L.marker(nat.lat, {
		// 	icon: icon,
		// 	title: nat.i,
		// })
		// .bindPopup(tmpl("navpoint_bubble", { nav: nav }))
		// .addTo(map);
		
		// console.log(nat.route.length);
		let points = [];
		
		for(i = 0; i < nat.route.length; i++) {
			L.marker([nat.route[i].lat, nat.route[i].lon])
			.bindPopup( 'TRACK ' + nat.ident + ' ' + nat.route[i].ident + ' (' + nat.direction + ')')
			.addTo(map);
			
			points.push([nat.route[i].lat, nat.route[i].lon]);
		}
		
		if(nat.direction == 'Westbound') {
			var color = 'red';
		} else {
			var color = 'blue';
		}
		
		const selPointsLayer = L.geodesic([points], {
			color: color,
		    weight: 1,
			opacity: .7,
		}).addTo(map);
		
		console.log(nat.ident);
	});
	
</script>