<?php 
   Template::show('ICSTour/header_secondary');
   ?>
   <style>
   .loading_text {
   position: relative;
   color: rgba(0, 0, 0, .3);
   }
   .loading_text:before {
   content: attr(data-text);
   position: absolute;
   overflow: hidden;
   max-width: 7em;
   white-space: nowrap;
   color: #000;
   animation: loading 7s linear;
   }
   @keyframes loading {
   0% {
   max-width: 0;
   }
   }
</style>
<div class="row">
   <div class="col-md-12">
      <div class="block full block-alt-noborder">
         <h1 class="sub-header text-center"><?php echo $tour->title; ?>
            <br>
            <small>
            <span class="h4 text-muted">
            This tour is operated by <?php echo $tour->airline; ?> flight codes.
            </span>
            </small>
            
            <center>
            	<?php 
        	$isParticipating = ICSTourData::isParticipating(Auth::$userinfo->pilotid, $tour->id);
        	if($isParticipating) {
        		echo "<h5><span class='label label-success'>Signed Up <i class='fa fa-check'></i></span></h5>";
        	}
         ?>
            </center>
         </h1>
         <center>
            <img src="<?php echo SITE_URL; ?>/lib/images/airline/<?php echo $tour->airline; ?>.png" style="width: 150px; height: auto;" />
         </center>
         <div class="row">
            <div class="col-md-3 text-center">
               <span class="label label-primary">
               Tour Poster 
               </span> <br><br>
               <a href="<?php echo $tour->poster; ?>" data-toggle="lightbox-image">
               <img src="<?php echo $tour->poster; ?>" alt="image" style="width: 350px; height: auto;" class="img-responsive">
               </a>
            </div>
            <div class="col-md-9">
               <span class="label label-primary">
               Tour Description 
               </span> <br><br>
               <p>
                  <?php echo $tour->description; ?>
               </p>
               <span class="label label-primary">
               Additional Details 
               </span> <br><br>
               <p>
                  <strong>Allowed Airframe(s):</strong> <?php echo $tour->airframes; ?> <br>
                  <strong>Total Legs: </strong><?php echo $tour->total_legs; ?> <br>
                  <strong>Starting Date:</strong> <?php echo date(DATE_FORMAT, strtotime($tour->startdate)); ?> <br>
                  <strong>Ending Date:</strong> <?php echo date(DATE_FORMAT, strtotime($tour->enddate)); ?> <br>
               </p>
               <br>
               <div class="block-section text-center">
				<?php
					$imailmessage='Hey, did you see the '.$tour->title.' tour? I am intrested to fly it with you. I think it will be fun. 
					<br><br>Check out this link: '.SITE_URL.'/ICSTour/details/'.$tour->id.' for more details about this tour.<br> <br>Regards, <br'.Auth::$userinfo->firstname.'';
					$message = 'Captain '.Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname.' is flying the '.$tour->title.', a tour organized by '.SITE_NAME.'. '.$tour->description.'. If you are interested to join, sign up as a Virtual Pilot at '.SITE_URL.'';
					$tmessage = 'Captain '.Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname.' is flying the '.$tour->title.', a tour organized by '.SITE_NAME.'. '.$tour->description.'. If you are interested to join, sign up as a Virtual Pilot at '.SITE_URL.' %23virtualairline %'.VA_TAGLINE.' %23pilot';
					$fblink = ' http://www.facebook.com/sharer/sharer.php?u='.SITE_URL.'&quote='.$message.'';
					$twitterlink = 'https://twitter.com/intent/tweet?text='.$tmessage.'';
					$gplus = 'https://plusone.google.com/_/+1/confirm?hl=en&url='.SITE_URL.'&title=_TITLE_';
					
					if(ICSTourData::isEligible(Auth::$userinfo->pilotid, $tour->id)) {
						if($isParticipating) {
							?>
								<a href="<?php echo url('ICSTour/fly/').$tour->id; ?>" class="btn btn-success btn-md">Fly this tour <i class="fa fa-plane"></i></a>
							<?php
						} else {
							?>
								<a href="<?php echo url('ICSTour/participate/').$tour->id; ?>" class="btn btn-success btn-md">Fly this tour <i class="fa fa-plane"></i></a>
							<?php	
						}
					} else {
						?>
						<a href="#" class="btn btn-danger btn-md" disabled>Not eligible, <?php echo RanksData::getRankInfo($tour->minrank)->rank; ?> rank required to fly this tour</a>
						<?php
					}
				?>
				<a target="_blank" href="<?php echo url('Mail/newmail?subject=Tour Invite&message='.urlencode($imailmessage).''); ?>" class="btn btn-effect-rippl btn-md btn-default">Invite your friends to fly via iMail</a>
				<a target="_blank" href="<?php echo $fblink; ?>" class="btn btn-effect-ripple btn-default" data-toggle="tooltip" title="" style="overflow: hidden; position: relative;" data-original-title="Share about this tour on Facebook"><i class="fa fa-facebook"></i></a>
				<a target="_blank" href="<?php echo $twitterlink; ?>" class="btn btn-effect-ripple btn-default" data-toggle="tooltip" title="" style="overflow: hidden; position: relative;" data-original-title="Share about this tour on Twitter"><i class="fa fa-twitter"></i></a>
				<!--<a target="_blank" href="<?php echo $gplus; ?>" class="btn btn-effect-ripple btn-default" data-toggle="tooltip" title="" style="overflow: hidden; position: relative;" data-original-title="Share about this tour on Google Plus"><i class="fa fa-google-plus"></i></a>-->
				</div>
            </div>
         </div>
      </div>
      
      <div class="row">
      	<div class="col-md-6">
      		<div class="block">
      			<div class="block-title">
      				<h3>Tour <strong>Legs</strong></h3>
      			</div>
      			
      	            <table class="table">
					<thead>
						<tr>
							<th>Leg #</th>
							<th>Departure</th>
							<th>Destination</th>
							<th>Distance</th>
						</tr>
					</thead>
					<tbody>
				<?php 
				
				
					$i = 1;
					$legs = ICSTourData::getTourLegs($tour->id);
					foreach($legs as $leg) {
						 
						?>
						<tr>
							<td><?php echo $i; ?>
							</td>
							<td>
								<a href="<?php echo url('airports/get_airport?icao=').$leg->depicao; ?>" data-toggle="tooltip" title="View Airport Information" class="btn btn-default"><?php echo $leg->depicao; ?></a>
							</td>
							<td>
								<a href="<?php echo url('airports/get_airport?icao=').$leg->arricao; ?>" data-toggle="tooltip" title="View Airport Information" class="btn btn-default"><?php echo $leg->arricao; ?></a>
							</td>
							<td>
								<?php 
									echo round(OperationsData::getAirportDistance($leg->depicao, $leg->arricao)); 
								?> NM
							</td>
						</tr>
						<?php
						$i++;
					}
				?>
					</tbody>
				</table>
      </div>
      	</div>
      <div class="col-md-6">
      		<div class="block">
      			<div class="block-title">
      				<h3>Tour <strong>Map</strong></h3>
      			</div>
      			<?php 
      				MainController::Run('ICSTour', 'tourmap', $tour->id);
      			?>
      		</div>
      	</div>
      </div>
      
      <div class="block">
         <div class="block-title">
            <h3>Tour <strong>Participants</strong></h3>
         </div>
         <?php 
        	if(count($tourParticipants) == 0) {
        		?>
        		<div class="alert alert-success">
        			<h3>Are you ready to lead the way, <?php echo Auth::$userinfo->firstname; ?>?</h3>
        			<p>There are no participants for this tour yet, be the first to fly this tour</p>
        		</div>
        		<?php
        	} else {
        		?>
        
         <table class="table">
         	<thead>
         		<th>Pilot</th>
         		<th>Current Leg</th>
         		<th>Current Location</th>
         		<th>Status</th>
         		<th>Started On</th>
         		<th>Ended On</th>
         	</thead>
         	<tbody>
         		<?php
         			foreach ($tourParticipants as $tp) {
         				?>
         				<tr>
         					<td><?php $pilot = PilotData::getPilotData($tp->pilotid); echo PilotData::getPilotCode($pilot->code, $pilot->pilotid).' '.$pilot->firstname.' '.$pilot->lastname; ?></td>
         					<td><?php echo $tp->current_leg; ?> / <?php echo $tour->total_legs; ?></td>
         					<td><?php echo $tp->current_location; ?></td>
         					<td><?php echo ICSTourData::getTourProgress_status($tp->status); ?></td>
         					<td><?php echo date(DATE_FORMAT, strtotime($tp->started_on)); ?></td>
         					<td><?php 
         					if($tp->ended_on != null) {
         						echo date(DATE_FORMAT, strtotime($tp->ended_on));
         					} else {
         						echo "<span class='label label-danger'>Not completed tour</span>";
         					}
         					
         					?></td>
         				</tr>
         				<?php
         			}
         		?>
         	</tbody>
         </table>
         
         <?php } ?>
      </div>
   </div>
</div>