<?php 
   Template::show('ICSTour/header_secondary');
   ?>
<div class="row">
   <div class="col-md-12">
      <div class="widget">
         <div class="widget-advanced">
            <div class="widget-header text-center themed-background-dark">
               <h1 class="widget-content-light">
                  <?php echo $tour->title; ?>
               </h1>
            </div>
            <div class="widget-main">
               <a href="javascript:void(0)" data-toggle="tooltip" title="" data-original-title="You are currently in Tour" class="widget-image-container animation-fadeIn">
               <span class="widget-icon themed-background"><i class="fa fa-plane"></i></span>
               </a>
               <br>
               <small>
               <span class="h4 text-muted">
               This tour is operated by <?php echo $tour->airline; ?> flight codes. You can use the <?php echo $tour->airframes; ?> on this tour.
               </span>
               
               </small>
            </div>
         </div>
			<div class="widget-extra themed-background-muted">
            <div class="row text-center">
               <div class="col-md-12">
                  <h3 class="widget-content-light ">
                     There are <strong><?php
                        echo count($tourParticipants);
                        ?></strong> pilots currently on this tour
                  </h3>
               </div>
            </div>
         </div>
      </div>
      <div class="row">
         <div class="col-md-6">
            <div class="block">
               <div class="block-section">
                  <h3>
                     Where to <strong>next?</strong>
                  </h3>
                  <p>
                     <?php 
                        $nextleg = ICSTourData::getTourLegs_progress($tour->id, $progress->current_leg);
                        ?>
                     The Leg #<?php echo $progress->current_leg; ?> of <?php echo $tour->title; ?> takes you from <?php echo $nextleg->depicao; ?>
                     to <?php echo $nextleg->arricao; ?>
                  </p>
                  <?php 
                     if($current_location->icao == $nextleg->depicao) {
                     	$modalID = 'flyNextLegModal';
                     	?>
                  <a data-toggle="modal" data-target="#flyNextLegModal" class="btn btn-lg btn-success btn-alt btn-block">
                  You are in position for Leg #<?php echo $progress->current_leg; ?>
                  <i class="fa fa-check"></i>
                  </a>
                  <!-- Modal -->
                  <div class="modal fade" id="flyNextLegModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                     <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                           <div class="modal-header">
                              <h3 class="modal-title" id="exampleModalLabel">
                                 Leg #<?php echo $progress->current_leg;?> for <strong><?php echo $tour->title; ?></strong>
                              </h3>
                           </div>
                           <div class="modal-body text-left">
                           	<div class="row text-center">
                           		<div class="col-md-4 text-right text-success">
                           			<h2>
                           				<strong>
                           					<?php echo $nextleg->depicao; ?>
                           				</strong>
                           			</h2>
                           		</div>
                           		<div class="col-md-4">
                           			<h2>
                           				<i class="fa fa-plane animation pulse"></i>
                           			</h2>
                           		</div>
                           		<div class="col-md-4 text-left text-danger">
                           			<h2>
                           				<strong>
                           					<?php echo $nextleg->arricao; ?>
                           				</strong>
                           			</h2>
                           		</div>
                           	
                           	<div class="col-md-12">
                           		<hr>
                           		<span class="text-muted">
                           			<small>
                           				If the aircraft is not present in <?php echo $nextleg->depicao; ?>, it will be relocated instantly to accomodate this tour leg
                           			</small>
                           		</span>
                           		<br><br>
                           	</div>
                           	<form action="<?php echo url('ICSTour/generateFlight/').$tour->id.'/'.$nextleg->legid; ?>" method="POST">
                           	<div class="col-md-6">
                           		<p>In what fleet?</p>
                           		<div class="form-group">
                           			<select class="form-control" id="icao" onChange="loadRegistrations();" required>
                           				<option value="INVALID" selected disabled>Select fleet ICAO</option>
                           				<?php
                           					$airframes = $tour->airframes;
                           					$aircrafts = explode(',', $airframes);
                           					foreach ($aircrafts as $aircraft) {
                           						?>
                           						<option value="<?php echo $aircraft; ?>"><?php echo $aircraft; ?></option>		
                           						<?php
                           					}
                           				?>
                           			</select>
                           		</div>
                           	</div>
                           	<div class="col-md-6">
                           		<p>what a/c registration to use for this leg</p>
                           		
                           		<div id="dynamicAircraftRegistration">
                           			<p class="text-muted">
                           				-- SELECT AIRCRAFT ICAO --
                           			</p>
                           		</div>
                           		<script>
                           		function loadRegistrations() {
                           			var aircraftICAO = document.getElementById('icao');
                           			var icao = aircraftICAO.value;
                           			console.log('Loading registrations for ' + icao);
                           			// THIS IS THE AJAX CALL. It's telling to load the content from the URL to the div with id "dynamicAircraftRegistration"
                           			$('#dynamicAircraftRegistration').load('<?php echo SITE_URL; ?>/action.php/ICSTour/generateAircraftRegistrations/' + icao).fadeIn("slow");	
                           			
                           			
                           			
                           			    // This was the Green Notification that y'all saw. It's called Bootstrap Growl JS plugin. 
                           				$.bootstrapGrowl("<h4>iCrew <strong>Notifications </strong> </h4> Registrations loaded for " + icao, {
											ele: 'body', // which element to append to
											type: 'success', // (null, 'info', 'danger', 'success')
											offset: {from: 'top', amount: 20}, // 'top', or 'bottom'
											align: 'right', // ('left', 'right', or 'center')
											width: 250, // (integer, or 'auto')
											delay: 1000, // Time while the message will be displayed. It's not equivalent to the *demo* timeOut!
											allow_dismiss: true, // If true then will display a cross to close the popup.
											stackup_spacing: 10 // spacing between consecutively stacked growls.
										});
                           			}
                           		</script>
                           	</div>
                           	</div>
                        	
                        		<br><br>
                              <div class="well well-md">
                                 I, <?php echo Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname; ?> acknowledge and approve that 
                                 my tour leg shall be generated using the above mentioned aircraft. I know that this will create a special flight 
                                 in my virtual airline's schedules database, I will fly this leg at my earliest convenience.
                              </div>
                              <br>
                              Upon clicking "Accept" the system will 
                              <br><br>
                              <ul class="fa-ul">
                                 <li><i class="fa fa-check fa-li text-success"></i>Create a custom schedule for the tour leg</li>
                                 <li><i class="fa fa-check fa-li text-success"></i>Re-locate aircraft (if necessary)</li>
                                 <li><i class="fa fa-check fa-li text-success"></i>Add the flight to your bid list</li>
                                 <li><i class="fa fa-check fa-li text-success"></i>Re-direct you to flight briefing page</li>
                              </ul>
                           </div>
                           <div class="modal-footer">
                           	  <?php 
                           	  $distance = round(OperationsData::getAirportDistance($nextleg->depicao, $nextleg->arricao));
                           	  $flightnumber = (rand(1000,9999));
							?>
                              <input type="hidden" name="code" value="<?php echo $tour->airline; ?>" />
                              <input type="hidden" name="flightnum" value="<?php echo $flightnumber; ?>" />
                              <input type="hidden" name="depicao" value="<?php echo $nextleg->depicao; ?>" />
                              <input type="hidden" name="arricao" value="<?php echo $nextleg->arricao; ?>" />
                              <input type="hidden" name="enabled" value="1" />
                              <input type="hidden" name="distance" value="<?php echo $distance; ?>" />
                              <input type="hidden" name="flighttype" value="P" />  
                              <input type="hidden" name="payforflight" value="1000" />  
                              <input type="hidden" name="price" value="199" />  
                              <!-- Change this in other VA, specific to UPSVAC -->
                              <input type="hidden" name="flightlevel" value="30000" />
                              <input type="hidden" name="notes" value="Tour leg #<?php echo $progress->current_leg; ?> (<?php echo $tour->title; ?>) generated for <?php echo Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname; ?> on <?php echo date(DATE_FORMAT); ?>" />
                              <input type="submit" value="Accept" class="btn btn-sm btn-primary" />
                              <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Close</button>
                              </form>
                           </div>
                        </div>
                     </div>
                  </div>
                  <?php
                     } else {	
                     	$modalID = 'relocateOptionsModal';
                     ?>
                  <a data-toggle="modal" data-target="#relocateOptionsModal" class="btn btn-lg btn-danger btn-alt btn-block">
                  You must be at <?php echo $nextleg->depicao; ?> to begin Leg #<?php echo $progress->current_leg; ?> <i class="fa fa-times"></i>
                  </a>
                  <br>
                  <small>
                  <span class="text-muted">
                  Your current location is <?php echo $current_location->icao ?>. Click on the button above to know your options.
                  </span>
                  </small>
                  <!-- Modal -->
                  <div class="modal fade" id="relocateOptionsModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                     <div class="modal-dialog" role="document">
                        <div class="modal-content">
                           <div class="modal-header">
                              <h3 class="modal-title" id="exampleModalLabel">
                                 Time to make a <strong>decision</strong>
                              </h3>
                           </div>
                           <div class="modal-body">
                              You can either Jumpseat to <strong><?php echo $nextleg->depicao; ?> Airport</strong>, or operate a schedule to that airport (if available) and resume the tour.
                              <br><br>
                              <?php
                                 $link = SITE_URL.'/index.php/ICSTour/jumpseat_new/'.$current_location->icao.'/'.$nextleg->depicao.'/'.$tour->id;
                                 
                                     	?>
                              <div class="row">
                                 <div class="col-md-6">
                                    <a href="<?php echo $link; ?>" class="btn btn-sm btn-primary btn-block">
                                    Instant relocate to <?php echo $nextleg->depicao; ?>
                                    </a>
                                 </div>
                                 <div class="col-md-6">
                                    <form action="<?php echo SITE_URL; ?>/index.php/schedules/findFlight" target="_blank" method="POST">
                                       <input type="hidden" name="depicao" value="<?php echo $current_location->icao; ?>" />
                                       <input type="hidden" name="arricao" value="<?php echo $nextleg->depicao; ?>" />
                                       <button type="submit" class="btn btn-sm btn-primary btn-block">
                                       Search for schedules from <?php echo $current_location->icao; ?> to <?php echo $nextleg->depicao; ?>
                                       </button>
                                    </form>
                                 </div>
                              </div>
                           </div>
                           <div class="modal-footer">
                              <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                           </div>
                        </div>
                     </div>
                  </div>
                  <?php
                     }
                          	?>
               </div>
            </div>
         </div>
         <div class="col-md-6">
            <div class="block">
               <div class="block-title">
                  <h2>Tour <strong>Progress</strong></h2>
               </div>
               <div class="block-section text-center">
                  <?php 
                     $total = $progress->total_legs;
                     $current = $progress->current_leg;
                     
                     $percent = round(($current / $total) * 100);
                     
                     if($current == 1) {
                     	$color = 'danger';
                     	$percent = 0;
                     }
                     else if($percent < 50) {
                     	$color = 'info';
                     } else if($percent > 90) {
                     	$color = 'warning';
                     	  if($percent == 100) {
                     		$color = 'warning';
                     		$percent = 90;
                     	  } 
                    } 
                     
                   
                     
                     else if($percent > 99) {
                     	$color = 'success';
                     	$percent = 100;
                     } 
                     
                     else {
                     	$color = 'danger';
                     }
                     ?>
                  <div class="progress progress-striped active">
                     <div class="progress-bar progress-bar-<?php echo $color; ?>" role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $percent; ?>%"></div>
                  </div>
                  <p>
                     Leg <?php echo $current; ?>/<?php echo $total; ?>, <span class="text-<?php echo $color;?>"><?php echo $percent; ?>% </span>of <?php echo $tour->title; ?> completed
                  </p>
                  <h4>
                     Share your <strong>tour progress</strong>
                  </h4>
                  <div class="btn-group">
                  	 <?php
                  $imailmessage='Hey, did you see the '.$tour->title.' tour? I am intrested to fly it with you. I think it will be fun. 
                  <br><br>Check out this link: '.SITE_URL.'/ICSTour/details/'.$tour->id.' for more details about this tour.<br> <br>Regards, <br'.Auth::$userinfo->firstname.'';
                  $message = 'Captain '.Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname.' is flying the '.$tour->title.', a tour organized by '.SITE_NAME.'. '.$tour->description.'. If you are interested to join, sign up as a Virtual Pilot at '.SITE_URL.'';
                  $tmessage = 'Captain '.Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname.' is flying the '.$tour->title.', a tour organized by '.SITE_NAME.'. '.$tour->description.'. If you are interested to join, sign up as a Virtual Pilot at '.SITE_URL.' %23virtualairline %'.VA_TAGLINE.' %23pilot';
                  $fblink = ' http://www.facebook.com/sharer/sharer.php?u='.SITE_URL.'&quote='.$message.'';
                  $twitterlink = 'https://twitter.com/intent/tweet?text='.$tmessage.'';
                  $gplus = 'https://plusone.google.com/_/+1/confirm?hl=en&url='.SITE_URL.'&title=_TITLE_';
                  ?>
                    	<a target="_blank" href="<?php echo url('Mail/newmail?subject=Group Flight Invite&message='.urlencode($imailmessage).''); ?>" class="btn btn-effect-rippl btn-md btn-default">Invite your friends to fly via iMail</a>
            			<a target="_blank" href="<?php echo $fblink; ?>" class="btn btn-effect-ripple btn-default" data-toggle="tooltip" title="" style="overflow: hidden; position: relative;" data-original-title="Share about this tour on Facebook"><i class="fa fa-facebook"></i></a>
            			<a target="_blank" href="<?php echo $twitterlink; ?>" class="btn btn-effect-ripple btn-default" data-toggle="tooltip" title="" style="overflow: hidden; position: relative;" data-original-title="Share about this tour on Twitter"><i class="fa fa-twitter"></i></a>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<div class="row">
   <div class="col-md-6">
      <div class="block">
         <div class="block-title">
            <h3>Tour <strong>Legs</strong></h3>
         </div>
         <table class="table" id="tourtable">
            <thead>
               <tr>
                  <th>Leg #</th>
                  <th>Departure</th>
                  <th>Destination</th>
                  <th>Distance</th>
                  <th>Status</th>
               </tr>
            </thead>
            <tbody>
               <?php 
                  $i = 1;
                  $legs = ICSTourData::getTourLegs($tour->id);
                  foreach($legs as $leg) {
                  	 
                  	?>
               <tr>
                  <td><?php echo $i; ?>
                  </td>
                  <td>
                     <a href="<?php echo url('airports/get_airport?icao=').$leg->depicao; ?>" data-toggle="tooltip" title="View Airport Information" class="btn btn-default"><?php echo $leg->depicao; ?></a>
                  </td>
                  <td>
                     <a href="<?php echo url('airports/get_airport?icao=').$leg->arricao; ?>" data-toggle="tooltip" title="View Airport Information" class="btn btn-default"><?php echo $leg->arricao; ?></a>
                  </td>
                  <td>
                     <?php 
                        echo round(OperationsData::getAirportDistance($leg->depicao, $leg->arricao)); 
                        ?> NM
                  </td>
                  <td>
                     <?php 
                        if($progress->current_leg == $i) {
                        	?>
                     <a data-toggle="modal" data-target="#<?php echo $modalID; ?>" class="btn btn-sm btn-success">Fly now <i class="fa fa-plane"></i></a>
                     <?php
                        } else if($progress->current_leg > $i) {
                        	?>
                     <span class="label label-success">
                     Flown <i class="fa fa-check"></i>
                     </span>
                     <?php
                        } else {
                        	?>
                     <span class="label label-warning">
                     Locked <i class="fa fa-lock"></i>
                     </span>
                     <?php
                        } 
                        ?>
                  </td>
               </tr>
               <?php
                  $i++;
                  }
                  ?>
            </tbody>
         </table>
      </div>
   </div>
   <div class="col-md-6">
      <div class="block">
         <div class="block-title">
            <h3>Tour <strong>Map</strong></h3>
         </div>
         <?php 
            MainController::Run('ICSTour', 'tourmap', $tour->id);
            ?>
      </div>
   </div>
</div>
<div class="row">
   <div class="col-md-12">
      <div class="block">
         <div class="block-title">
            <h3>Tour <strong>Participants</strong></h3>
         </div>
         <?php 
            if(count($tourParticipants) == 0) {
            	?>
         <div class="alert alert-success">
            <h3>Are you ready to lead the way, <?php echo Auth::$userinfo->firstname; ?>?</h3>
            <p>There are no participants for this tour yet, be the first to fly this tour</p>
         </div>
         <?php
            } else {
            	?>
         <table class="table">
            <thead>
               <th>Pilot</th>
               <th>Current Leg</th>
               <th>Current Location</th>
               <th>Status</th>
               <th>Started On</th>
               <th>Ended On</th>
            </thead>
            <tbody>
               <?php
                  foreach ($tourParticipants as $tp) {
                  	
                  	
                  	$current = $tp->current_leg;
                  	$total = $tour->total_legs;
                  	
                  	if($current > $total) {
                  		$current = $total;
                  	} 
                  	
                  	?>
               <tr>
                  <td><?php $pilot = PilotData::getPilotData($tp->pilotid); echo PilotData::getPilotCode($pilot->code, $pilot->pilotid).' '.$pilot->firstname.' '.$pilot->lastname; ?></td>
                  <td><?php echo $current; ?> / <?php echo $tour->total_legs; ?></td>
                  <td><?php echo $tp->current_location; ?></td>
                  <td><?php echo ICSTourData::getTourProgress_status($tp->status); ?></td>
                  <td><?php echo date(DATE_FORMAT, strtotime($tp->started_on)); ?></td>
                  <td><?php 
                     if($tp->ended_on != null) {
                     	echo date(DATE_FORMAT, strtotime($tp->ended_on));
                     } else {
                     	echo "<span class='label label-danger'>Not completed tour</span>";
                     }
                     
                     ?></td>
               </tr>
               <?php
                  }
                  ?>
            </tbody>
         </table>
         <?php } ?>
      </div>
   </div>
</div>
<script src="<?php echo SITE_URL; ?>/lib/skins/iCrew/js/pages/tablesDatatables.js"></script>
<script>$(function(){ TablesDatatables.init(); });</script>
<script>
   $(document).ready(function() {
   	$('#tourtable').DataTable();
   });
</script>