<?php 
   Template::show('ICSTour/header');
   ?>

    

<div class="tab-content">
   <div class="tab-pane active" id="home" role="tabpanel">
      <div class="row">
         <div class="col-md-6">
            <div class="block">
               <div class="block-title">
                  <h3>My <strong>Active Tours</strong></h3>
               </div>
               <?php 
                  if(count($participatingTours) > 0) {
                  	foreach ($participatingTours as $tour) {
                  		// Get Tour details 
                  		$tourDetails = ICSTourData::getTour($tour->tourid);
                  		// Get Tour Legs
                  		$tourLeg = ICSTourData::getTourLegBy_legid($tour->current_leg);
                  		?>
               <a href="<?php echo url("ICSTour/fly/").$tour->tourid; ?>" class="widget widget-hover-effect1">
                  <div class="widget-simple">
                     <h3 class="widget-content text-left animation-pullDown">
                        <strong><?php echo $tourDetails->title; ?></strong><br>
                        <small><span class="label label-primary">Leg #<?php echo $tour->current_leg; ?></span> | <?php echo $tourLeg->depicao; ?> <i class="fa fa-plane"></i> <?php echo $tourLeg->arricao; ?></small>
                     </h3>
                  </div>
               </a>
               <?php
                  }
                  } else {
                  ?>
               <div class="alert alert-info">
                  Hey <?php echo Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname; ?>, looks like you haven't signed up for any tours yet. Don't worry, once you sign up, we'll have something to show here.
               </div>
               <?php 
                  }
                         ?>
            </div>
         </div>
         <div class="col-md-6">
            <div class="row">
               <div class="col-md-12">
                  <a href="#activetours" data-toggle="tab" class="widget widget-hover-effect1">
                     <div class="widget-simple">
                        <div class="widget-icon pull-left themed-background-autumn animation-fadeIn">
                           <span class="text-success">
                           <strong><?php echo count($tours); ?></strong>
                           </span>
                        </div>
                        <h3 class="widget-content text-right animation-pullDown">
                           Available Tours
                           <small>Explore the world</small>
                        </h3>
                     </div>
                  </a>
               </div>
               <!--<div class="col-md-6">-->
               <!--   <a href="<?php echo url('charter'); ?>" target="_blank" class="widget widget-hover-effect1">-->
               <!--      <div class="widget-simple">-->
               <!--         <div class="widget-icon pull-left themed-background-autumn animation-fadeIn">-->
               <!--            <i class="fa fa-globe text-primary"></i>-->
               <!--         </div>-->
               <!--         <h3 class="widget-content text-right animation-pullDown">-->
               <!--            Explore more? <br>-->
               <!--            <small>Generate Charter Flights</small>-->
               <!--         </h3>-->
               <!--      </div>-->
               <!--   </a>-->
               <!--</div>-->
            </div>
            <div class="block full block-alt-noborder">
               <h3>
                  <small>Not sure which tour to fly?</small><br>
                  <?php echo $randomTour->title; ?> <span class="label label-primary"><?php echo $randomTour->total_legs; ?> Legs</span>
               </h3>
               <?php 
            	if(ICSTourData::isEligible(Auth::$userinfo->pilotid, $randomTour->id)) {
            		?>
            		<span class="text-success">You are eligible to fly this tour <i class="fa fa-check"></i></span>
            		<?php
            	} else {
            		?>
            		<span class="text-danger">You are not eligible to fly this tour <i class="fa fa-times"></i></span>	
            		<?php
            	}
            	?>
            </div>
         </div>
      </div>
   </div>
   <div class="tab-pane" id="activetours" role="tabpanel" aria-labelledby="activetours">

<div class="row">
	<div class="col-md-12">
		<div class="block">
			<div class="block-title">
				<h3>All <strong>Tours</strong></h3>
			</div>
			<table id="tourtable" class="table table-bordered table-striped table-hover"style="width:100%" >
				<thead>
				<tr>
                     <th>ID</th>
                     <th>Tour Name</th>
                     <th>Total Legs</th>
                     <th>Between</th>
                     <th>Dates</th>
                     <th>Rank Requirement</th>
                     <th>Sign-ups</th>
                     <th>Options</th>
                  </tr>
				</thead>
				<tbody>
				<?php
                     foreach($tours as $tour) {
                     	
                     	
                     ?>
                  	 <tr>
                     <td><code><?php echo $tour->id; ?></code></td>
                     <td class="text-center"><?php echo $tour->title; ?></td>
                     <td class="text-center"><?php echo $tour->total_legs; ?></td>
                    <td class="text-center"><?php echo ICSTourData::TourisBetween($tour->id, $tour->total_legs); ?></td>
                     <td><?php echo date(DATE_FORMAT, strtotime($tour->startdate)); ?> to <?php echo date(DATE_FORMAT, strtotime($tour->enddate)); ?></td>
                     <td>
                     	<?php 
                     	if($tour->minrank == 0) {
                     		?>
                     		<span class="label label-success">No Restrictions</span>
                     		<br><span class="text-success">You are eligible to fly this tour <i class="fa fa-check"></i></span>
                     		<?php
                     	} else {
                     		if(ICSTourData::isEligible(Auth::$userinfo->pilotid, $tour->id)) { 
                     		?>
                     			<h3 class="label label-success"><?php echo RanksData::getRankInfo($tour->minrank)->rank; ?></h3>
								<br><span class="text-success">You are eligible to fly this tour <i class="fa fa-check"></i></span>
							<?php
							} else { 
							 ?>
							 <h3 class="label label-danger"><?php echo RanksData::getRankInfo($tour->minrank)->rank; ?></h3>
								<br><span class="text-danger">You are not eligible to fly this tour <i class="fa fa-times"></i></span>
								<?php
							}
                     	}
                     	?>
                     </td>
                    <td class="text-center"><?php 
                    	$signups = count(ICSTourData::getTourParticipants($tour->id));
                    	if($signups == 0) {
                    		echo "<span class='label label-primary'>No participants, be the first!</span>";
                    	} else {
                    		echo $signups;
                    	}
                     ?></td>
                     <td>
                        <a href="<?php echo url('ICSTour/details/').$tour->id; ?>" style="text-decoration: none;" class="btn btn-primary btn-sm">Tour Details</a>
                     </td>
                  </tr>
                  <?php
                     }
                     ?>
				</tbody>
			</table>
			<br>
		</div>
	</div>
</div>


   </div>
   <div class="tab-pane" id="profile" role="tabpanel" aria-labelledby="profile">
   	<div class="row">
		<div class="col-md-12">
			<p>
				Coming Soon
			</p>
		</div>
	</div>	
   </div>
   <div class="tab-pane" id="settings" role="tabpanel" aria-labelledby="settings">
   	<div class="row">
		<div class="col-md-12">
			<p>
				Coming Soon
			</p>
		</div>
	</div>	
   </div>
</div>

<script src="<?php echo SITE_URL; ?>/lib/skins/iCrew/js/pages/tablesDatatables.js"></script>
<script>$(function(){ TablesDatatables.init(); });</script>
<script>
    $(document).ready(function() {
    	$('#tourtable').DataTable();
	});
</script>
