<?php 
   Template::show('ICSTour/header_secondary');
   ?>
<div class="row">
   <div class="col-md-12">
   	<div class="widget">
   <div class="widget-simple text-center">
      <h4 class="widget-content">
         <h1 class="sub-header text-center"><?php echo $tour->title; ?>
            <br>
            <small>
            <span class="h4 text-muted">
            This tour is operated by <?php echo $tour->airline; ?> flight codes.
            </span>
            </small>
         </h1>
      </h4>
      <img src="<?php echo $tour->poster; ?>" style="width: 450px; border-radius: 5px; height: auto;" />
      <h3><br><br>
      	<span class="label label-primary">Allowed Airframe(s) </span>&nbsp;<?php echo $tour->airframes; ?>, </h3>
      <div class="block-section text-center">
		<?php
			$imailmessage='Hey, did you see the '.$tour->title.' tour? I am intrested to fly it with you. I think it will be fun. 
			<br><br>Check out this link: '.SITE_URL.'/ICSTour/details/'.$tour->id.' for more details about this tour.<br> <br>Regards, <br'.Auth::$userinfo->firstname.'';
			$message = 'Captain '.Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname.' is flying the '.$tour->title.', a tour organized by '.SITE_NAME.'. '.$tour->description.'. If you are interested to join, sign up as a Virtual Pilot at '.SITE_URL.'';
			$tmessage = 'Captain '.Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname.' is flying the '.$tour->title.', a tour organized by '.SITE_NAME.'. '.$tour->description.'. If you are interested to join, sign up as a Virtual Pilot at '.SITE_URL.' %23virtualairline %'.VA_TAGLINE.' %23pilot';
			$fblink = ' http://www.facebook.com/sharer/sharer.php?u='.SITE_URL.'&quote='.$message.'';
			$twitterlink = 'https://twitter.com/intent/tweet?text='.$tmessage.'';
			$gplus = 'https://plusone.google.com/_/+1/confirm?hl=en&url='.SITE_URL.'&title=_TITLE_';
		?>
<a target="_blank" href="<?php echo url('Mail/newmail?subject=Group Flight Invite&message='.urlencode($imailmessage).''); ?>" class="btn btn-effect-rippl btn-md btn-default">Invite your friends to fly via iMail</a>
<a target="_blank" href="<?php echo $fblink; ?>" class="btn btn-effect-ripple btn-default" data-toggle="tooltip" title="" style="overflow: hidden; position: relative;" data-original-title="Share about this tour on Facebook"><i class="fa fa-facebook"></i></a>
<a target="_blank" href="<?php echo $twitterlink; ?>" class="btn btn-effect-ripple btn-default" data-toggle="tooltip" title="" style="overflow: hidden; position: relative;" data-original-title="Share about this tour on Twitter"><i class="fa fa-twitter"></i></a>
<!--<a target="_blank" href="<?php echo $gplus; ?>" class="btn btn-effect-ripple btn-default" data-toggle="tooltip" title="" style="overflow: hidden; position: relative;" data-original-title="Share about this tour on Google Plus"><i class="fa fa-google-plus"></i></a>-->

</div>
   </div>
   <div class="widget-extra themed-background-muted">
      <div class="row text-center">
         <div class="col-md-12">
            <h3 class="widget-content-light ">
               There are <strong><?php
                  echo count($tourParticipants);
                  ?></strong> pilots currently on this tour
            </h3>
         </div>
      </div>
   </div>
</div>
   </div>
   
   <div class="col-md-6">
      		<div class="block">
      	<div class="block-title">
      		<h3>Tour <strong>Legs</strong></h3>
      	</div>
      	            <table class="table" id="tourtable">
					<thead>
						<tr>
							<th>Leg #</th>
							<th>Departure</th>
							<th>Destination</th>
							<th>Distance</th>
							<th>Status</th>
						</tr>
					</thead>
					<tbody>
				<?php 
				
				
					$i = 1;
					$legs = ICSTourData::getTourLegs($tour->id);
					foreach($legs as $leg) {
						 
						?>
						<tr>
							<td><?php echo $i; ?>
							</td>
							<td>
								<a href="<?php echo url('airports/get_airport?icao=').$leg->depicao; ?>" data-toggle="tooltip" title="View Airport Information" class="btn btn-default"><?php echo $leg->depicao; ?></a>
							</td>
							<td>
								<a href="<?php echo url('airports/get_airport?icao=').$leg->arricao; ?>" data-toggle="tooltip" title="View Airport Information" class="btn btn-default"><?php echo $leg->arricao; ?></a>
							</td>
							<td>
								<?php 
									echo round(OperationsData::getAirportDistance($leg->depicao, $leg->arricao)); 
								?> NM
							</td>
							<td>
								<span class="label label-success">
									Completed <i class="fa fa-check"></i>
								</span>
							</td>
						</tr>
						<?php
						$i++;
					}
				?>
					</tbody>
				</table>
      </div>
      	</div>
   <div class="col-md-6">
      		<div class="block">
      			<div class="block-title">
      				<h3>Tour <strong>Map</strong></h3>
      			</div>
      			<?php 
      				MainController::Run('ICSTour', 'tourmap', $tour->id);
      			?>
      		</div>
      	</div>
      	
      	<div class="col-md-12">
      		<div class="block">
         <div class="block-title">
            <h3>Tour <strong>Participants</strong></h3>
         </div>
         <?php 
        	if(count($tourParticipants) == 0) {
        		?>
        		<div class="alert alert-success">
        			<h3>Are you ready to lead the way, <?php echo Auth::$userinfo->firstname; ?>?</h3>
        			<p>There are no participants for this tour yet, be the first to fly this tour</p>
        		</div>
        		<?php
        	} else {
        		?>
        
         <table class="table">
         	<thead>
         		<th>Pilot</th>
         		<th>Current Leg</th>
         		<th>Current Location</th>
         		<th>Status</th>
         		<th>Started On</th>
         		<th>Ended On</th>
         	</thead>
         	<tbody>
         		<?php
         			foreach ($tourParticipants as $tp) {
         				?>
         				<tr>
         					<td><?php $pilot = PilotData::getPilotData($tp->pilotid); echo PilotData::getPilotCode($pilot->code, $pilot->pilotid).' '.$pilot->firstname.' '.$pilot->lastname; ?></td>
         					<td><?php echo $tp->current_leg; ?> / <?php echo $tour->total_legs; ?></td>
         					<td><?php echo $tp->current_location; ?></td>
         					<td><?php echo ICSTourData::getTourProgress_status($tp->status); ?></td>
         					<td><?php echo date(DATE_FORMAT, strtotime($tp->started_on)); ?></td>
         					<td><?php 
         					if($tp->ended_on != null) {
         						echo date(DATE_FORMAT, strtotime($tp->ended_on));
         					} else {
         						echo "<span class='label label-danger'>Not completed tour</span>";
         					}
         					
         					?></td>
         				</tr>
         				<?php
         			}
         		?>
         	</tbody>
         </table>
         
         <?php } ?>
      </div>
      	</div>
</div>

<script src="<?php echo SITE_URL; ?>/lib/skins/iCrew/js/pages/tablesDatatables.js"></script>
<script>$(function(){ TablesDatatables.init(); });</script>
<script>
    $(document).ready(function() {
    	$('#tourtable').DataTable();
	});
</script>