
<div class="mapcenter" align="center">
	<div id="tour_leg_map" style="width: 80%; height: 500px"></div>
	<br><br>
</div>

<style>
	.leaflet-pulsing-icon {
    border-radius: 100%;
    box-shadow: 1px 1px 8px 0 rgba(0,0,0,0.75);
}

.leaflet-pulsing-icon:after {
    content: "";
    border-radius: 100%;
    height: 300%;
    width: 300%;
    position: absolute;
    margin: -100% 0 0 -100%;

}

@keyframes pulsate {
    0% {
        transform: scale(0.1, 0.1);
        opacity: 0;
        -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
        filter: alpha(opacity=0);
    }
    50% {
        opacity: 1;
        -ms-filter: none;
        filter: none;
    }
    100% {
        transform: scale(1.2, 1.2);
        opacity: 0;
        -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
        filter: alpha(opacity=0);
    }
}
</style>
<script src="<?php echo SITE_URL?>/lib/js/base_map.js"></script>
<script src="https://rawgit.com/mapshakers/leaflet-icon-pulse/master/src/L.Icon.Pulse.js"></script>

<link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.0.6/dist/MarkerCluster.css" />
<link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.0.6/dist/MarkerCluster.Default.css" />
<script src="https://unpkg.com/leaflet.markercluster@1.0.6/dist/leaflet.markercluster.js"></script>

<script type="text/javascript">

	// Creating a new map element.
	const map = createMap({
		render_elem: 'tour_leg_map',
		provider: '<?php echo Config::Get("MAP_TYPE"); ?>',
	});
	
		function get_api_request(yourUrl){
			var Httpreq = new XMLHttpRequest(); 
			Httpreq.open("GET",yourUrl,false);
			Httpreq.send(null);
			return Httpreq.responseText;          
		}
				
	//Initializing Cluster Group
	var markersLayer = new L.LayerGroup(); 
	var markers = L.markerClusterGroup();
	map.addLayer(markersLayer);
	
		var current_location = "<?php echo SITE_URL; ?>/action.php/schedules/current_location_api/<?php echo Auth::$userinfo->pilotid; ?>";
		
		var current_location = JSON.parse(get_api_request(current_location));
		
		
		var pulsingIcon_currentlocation = L.icon.pulse({
			iconSize: [12,12],
            fillColor: 'red',
            color: 'red',
            animate: true,
            heartbeat: 1
		});
		
		var pulsingIcon_displayairport = L.icon.pulse({
			iconSize: [12,12],
            fillColor: 'purple',
            color: 'purple',
            animate: true,
            heartbeat: 1
		});
		
		var current_location_pulsing_marker = L.marker([current_location.lat, current_location.lng],{icon: pulsingIcon_currentlocation}).bindTooltip("You are at " + current_location.name).addTo(map);
		var marker = L.marker(<?php echo $leg->deplat ?>, <?php echo $leg->deplng ?>).addTo(map);
		var marker = L.marker(<?php echo $leg->arrlat ?>, <?php echo $leg->arrlng ?>).addTo(map);
 		
 				
 				
			
			
	var airport_polyline_dep = new L.LatLng(<?php echo $leg->deplat ?>, <?php echo $leg->deplng ?>);
	var airport_polyline = new L.LatLng(<?php echo $leg->arrlat ?>, <?php echo $leg->arrlng ?>);
	var pointList = [airport_polyline_dep, airport_polyline];
	
	var drawPolyline = new L.Polyline(pointList, {
	    color: 'black',
    	weight: 2,
    	opacity: 1,
    	smoothFactor: 1
	});
	
	drawPolyline.addTo(map);
			
	var legend = L.control({position: 'bottomright'});
	legend.onAdd = function (map) {

    var div = L.DomUtil.create('div', 'info legend');
        div.innerHTML = '<img src="<?php echo SITE_URL; ?>/iCrew/favicon.png" style="width: 50px; height: auto;" /><span class="text-primary">Tour Map</span> ';
    return div;
	};
	legend.addTo(map);
	
	map.fitBounds(drawPolyline.getBounds());

</script>
  