<div id="ajax_map">
		<div class="mapcenter" align="center">
            <div id="tourmap_leaflet" style="width: 80%; height: 500px"></div>
            <br><br>
         </div>
         <style>
            .leaflet-pulsing-icon {
            border-radius: 100%;
            box-shadow: 1px 1px 8px 0 rgba(0,0,0,0.75);
            }
            .leaflet-pulsing-icon:after {
            content: "";
            border-radius: 100%;
            height: 300%;
            width: 300%;
            position: absolute;
            margin: -100% 0 0 -100%;
            }
            @keyframes pulsate {
            0% {
            transform: scale(0.1, 0.1);
            opacity: 0;
            -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
            filter: alpha(opacity=0);
            }
            50% {
            opacity: 1;
            -ms-filter: none;
            filter: none;
            }
            100% {
            transform: scale(1.2, 1.2);
            opacity: 0;
            -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
            filter: alpha(opacity=0);
            }
            }
         </style>
         <script src="<?php echo SITE_URL?>/lib/js/base_map.js"></script>
         <script src="https://rawgit.com/mapshakers/leaflet-icon-pulse/master/src/L.Icon.Pulse.js"></script>
         <link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.0.6/dist/MarkerCluster.css" />
         <link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.0.6/dist/MarkerCluster.Default.css" />
         <script src="https://unpkg.com/leaflet.markercluster@1.0.6/dist/leaflet.markercluster.js"></script>
         <script type="text/javascript">
            // Creating a new map element.
            const map = createMap({
            	render_elem: 'tourmap_leaflet',
            	provider: '<?php echo Config::Get("MAP_TYPE"); ?>',
            	center: [<?php echo Config::Get("MAP_CENTER_LAT"); ?>, <?php echo Config::Get("MAP_CENTER_LNG"); ?>],
            });

            	function get_api_request(yourUrl){
            		var Httpreq = new XMLHttpRequest();
            		Httpreq.open("GET",yourUrl,false);
            		Httpreq.send(null);
            		return Httpreq.responseText;
            	}

            //Initializing Cluster Group
            var markersLayer = new L.LayerGroup();
            var markers = L.markerClusterGroup();
            map.addLayer(markersLayer);

            	var apiURL = "<?php echo SITE_URL; ?>/action.php/ICSTour/tour_map_api/<?php echo $tourid;?>";
            	var current_location = "<?php echo SITE_URL; ?>/action.php/schedules/current_location_api/<?php echo Auth::$userinfo->pilotid; ?>";

            	var current_location = JSON.parse(get_api_request(current_location));

            	var data = JSON.parse(get_api_request(apiURL));
            	// console.log(data);
				var flights = data.legs;
				console.log(flights[0]);
            	var pulsingIcon_currentlocation = L.icon.pulse({
            		iconSize: [12,12],
                       fillColor: 'red',
                       color: 'red',
                       animate: true,
                       heartbeat: 1
            	});

            	var pulsingIcon_displayairport = L.icon.pulse({
            		iconSize: [12,12],
                       fillColor: 'purple',
                       color: 'purple',
                       animate: true,
                       heartbeat: 1
            	});

            	var current_location_pulsing_marker = L.marker([current_location.lat, current_location.lng],{icon: pulsingIcon_currentlocation}).bindTooltip("You are at " + current_location.name).addTo(map);
            	var current_location_polyline = new L.LatLng(current_location.lat, current_location.lng);


            	for(i=0; i<flights.length; i++) {

            		var marker = L.marker([flights[i].departure.lat, flights[i].departure.lng]).bindTooltip(flights[i].departure.icao + " - Leg #" + i).addTo(map);
            			marker.bindPopup('<p class="text-center">Leg #' + i + ' <br> ' + flights[i].legdata.depicao + ' - ' + flights[i].legdata.arricao + '</h4></center></p>');
            				markers.addLayer(marker);
            				markers.addTo(markersLayer);


            var airport_polyline_dep = new L.LatLng(flights[i].departure.lat, flights[i].departure.lng);
            var airport_polyline = new L.LatLng(flights[i].arrival.lat, flights[i].arrival.lng);
            var pointList = [airport_polyline_dep, airport_polyline];
	
			
			const selPointsLayer = L.geodesic([pointList], {
					color: 'black',
               		weight: 2,
               		opacity: 1,
               		smoothFactor: 1
				}).addTo(map);
				
				
            // var drawPolyline = new L.geodesic(pointList, {
            //     color: 'black',
            //   	weight: 2,
            //   	opacity: 1,
            //   	smoothFactor: 1
            // });

            // drawPolyline.addTo(map);

            	if(i == 0) {
            		var depmarker = L.marker([flights[i].departure.lat, flights[i].departure.lng],{icon: pulsingIcon_displayairport}).bindTooltip("Departure Airport " + flights[i].departure.name).addTo(map);
            		console.log("last");
            	}

            	}

				var southWest = L.latLng(-89.98155760646617, -180), northEast = L.latLng(89.99346179538875, 180);
				var bounds = L.latLngBounds(southWest, northEast);
				map.setMaxBounds(bounds);
            var legend = L.control({position: 'bottomright'});
            legend.onAdd = function (map) {

               var div = L.DomUtil.create('div', 'info legend');
                   div.innerHTML = '<img src="<?php echo SITE_URL; ?>/iCrew/favicon.png" style="width: 50px; height: auto;" /><span class="text-primary">Tour Map</span> ';
               return div;
            };
            legend.addTo(map);

            map.fitBounds(selPointsLayer.getBounds());

         </script>
         
</div>