<div class="row">
  <div class="block-full">

    <div class="col-md-12">
      <?php
        MainController::Run('ICSMap', 'flightlist');
      ?>

      <div class="block">
        <div class="block-title">
          <div class="block-options pull-right">
            <?php $lastbid = SchedulesData::GetAllBids();
              if(count($lastbid) > 0)
              {
                $departurestatus = 'Upcoming';
                $animation = 'animation-pulse';
                $departurecolor = 'success';
              }
              else
              {
                $departurestatus = 'No Departures';
                $animation = '';
                $departurecolor = 'info';
              }

            ?>
              <span class="label label-<?php echo $departurecolor.' '.$departurecolor?> "><?php echo $departurestatus ?></span>
          </div>
        </div>
        <h3><i class="fa fa-clock-o"></i> <Strong>Upcoming</Strong> Departures</h3>

              <?php

              if (count($lastbid) > 0)
              { ?>
              <div class="table-responsive">
                <table id="upcomingdepartures" class="table table-hover table-striped">
                <thead>
                  <tr>
                    <th><div align="center">OPR</div></th>
                    <th><div align="center">FLT</div></th>
                    <th><div align="center">PIC</div></th>
                    <th><div align="center">ADD</div></th>
                    <th><div align="center">EXP</div></th>
                    <th><div align="center">DEP</div></th>
                    <th><div align="center">ARR</div></th>
                    <th><div align="center">REG</div></th>
                  </tr>
                </thead>
              <tbody>
              <?php
                foreach($lastbid as $lastbid)
                {
                ?>
                <tr>
                <?php
                $flightid = $lastbid->id;
                ?>
                <td height="25" width="10%" align="center">
                  <img src="<?php echo fileurl('/lib/images/airline/'.$lastbid->code.'.png'); ?>" alt="" width="90px;" height="auto;" />
                </td>
                <td height="25" width="10%" align="center">
                  <span><?php echo $lastbid->code; ?><?php echo $lastbid->flightnum; ?></span>
                </td>
                <?php
                $params = $lastbid->pilotid;

                $pilot = PilotData::GetPilotData($params);
                $pname = $pilot->firstname;
                $psurname = $pilot->lastname;
                $now = strtotime(date(DATE_FORMAT,strtotime($lastbid->dateadded)));
                $expire_time = '+'.Config::Get('BID_EXPIRE_TIME').' hours';
                $date = date(DATE_FORMAT, strtotime($expire_time, $now));

                ?>
                <td height="25" width="10%" align="center"><span><?php echo $pname; ?> <?php echo $psurname; ?></span></td>
                <td height="25" width="10%" align="center"><span class="text-success"><?php echo date(DATE_FORMAT,strtotime($lastbid->dateadded)); ?></span></td>
                <td height="25" width="10%" align="center"><span class="text-danger"><?php echo $date; ?></span></td>
                <td height="25" width="10%" align="center"><span><font face=""><?php echo '<a class="btn btn-default btn-sm" data-toggle="tooltip" data-placement="top" title="Click to view Airport Information!" href="  '.SITE_URL.'/index.php/airports/get_airport?icao='.$lastbid->depicao.'">'.$lastbid->depicao.'</a>';?></font></span></td>
                <td height="25" width="10%" align="center"><span><font face=""><?php echo '<a class="btn btn-default btn-sm" data-toggle="tooltip" data-placement="top" title="Click to view Airport Information!" href=" '.SITE_URL.'/index.php/airports/get_airport?icao='.$lastbid->arricao.'">'.$lastbid->arricao.'</a>';?></font></span></td>
                <td height="25" width="10%" align="center"><span><a class="btn btn- btn-sm" data-toggle="tooltip" data-placement="top" title="Click to view Aircraft Information!" href="<?php echo SITE_URL?>/index.php/vFleetTracker/view/<?php echo '' . $lastbid->registration . ''; ?>"><?php echo $lastbid->registration; ?></a></td>
                </tr>
                <?php
                } ?>
                </tbody>
              </table>
              </div>

              <?php	} else { ?>

                <div class="alert alert-danger">
                  <strong>Oops</strong><br>
                  There are no upcoming departures at the moment.
                </div>

                <?php
                }
                ?>



      </div>
    </div>

      <div class="col-md-12">
          <!-- Latest Orders Block -->
          <div class="block">
              <!-- Latest Orders Title -->
              <div class="block-title">
                  <div class="block-options pull-right">
                      <a href="<?php echo url('/Pireps/mine');?>" class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="View Mine"><i class="fa fa-eye"></i></a>
                  </div>
              </div>
              <h3><i class="gi gi-airplane"></i> <strong>Latest</strong> PIREPs</h3>
              <!-- END Latest Orders Title -->

              <!-- Latest Orders Content -->
              <?php
        $count = 25;
        $pireps = PIREPData::getRecentReportsByCount($count);
        ?>


        <div  class="table-responsive">
          <table  id="recentpireps" class="table table-striped table-responsive">
          <thead>
            <tr>
              <th>
                OPR
              </th>
              <th>FLT</th>
              <th>DEP</th>
              <th>ARR</th>
              <th>BLK</th>
              <th>PIC</th>
              <th>STS</th>
              <th>PIREP</th>
              <th>DOF</th>
              <th>Options</th>
            </tr>
          </thead>
        <tbody>

         <?php

         if(count($pireps) > 0)
        {
         foreach ($pireps as $pirep)
         {
           $pilotinfo = PilotData::getPilotData($pirep->pilotid);
           $pilotid = PilotData::getPilotCode($pilotinfo->code, $pilotinfo->pilotid);

           if($pirep->accepted == PIREP_REJECTED) $status = '<span class="label label-danger">Rejected</span>';
           elseif($pirep->accepted == PIREP_ACCEPTED) $status = '<span class="label label-success">Accepted</span>';
           elseif ($pirep->accepted == PIREP_PENDING) $status = '<span class="label label-warning animation-pulse">Pending</span>';
          elseif($pirep->accepted == PIREP_INPROGRESS)  $status = '<span class="label label-warning animation-pulse">Under Manual Review</span>';

           echo '<tr>';
           echo '<td><img src="'.fileurl('/lib/images/airline/'.$pirep->code.'.png').'" alt="" width="90px;" height="auto;" />';
           echo '<td>'.$pirep->code.$pirep->flightnum.'</td>';
           echo '<td>'.$pirep->depicao.'</td>';
           echo '<td>'.$pirep->arricao.'</td>';
           echo '<td>'.$pirep->flighttime.' Hrs</td>';
           echo '<td><Strong>'.$pilotinfo->firstname.' '.$pilotinfo->lastname.'</strong></td>';
           $schedule = SchedulesData::getScheduleByFlight($pirep->code,$pirep->flightnum);
            $fltime = explode(".", $schedule->flighttime);
            $minstar = substr($fltime[1],0,1);
            $minstarmin = substr($fltime[1],1,2);
            if($minstar == 0) {
              $minstar = 1;
            } else {
              $flmin = $minstar * 10;
            }

            if($fltime[0] == 0) {
              $fltime[0] = 1;
            } else {
              $flhou = $fltime[0] * 60;
            }

            $flminu = $flhou + $flmin + $minstarmin;
            $actfltime = explode(".", $pirep->flighttime);
            $actminstar = substr($actfltime[1],0,1);
            $actminstarmin = substr($actfltime[1],1,2);

            if($actminstar == 0) {
              $actminstar = 1;
            }
            else {
              $actflmin = $actminstar * 10;
            }

            $actflhou = $actfltime[0] * 60;
            $actflminu = $actflhou + $actflmin + $actminstarmin;
            if(($flminu - 20) > $actflminu) {
              echo '<td><span class="text-info"><Strong>EARLY</strong></span></td>';
            } elseif (($flminu + 15) < $actflminu) {
            echo '<td><span class="text-success"><Strong>ON TIME</strong></span></td>';
            } else {
            echo '<td><span class="text-success"><Strong>ON TIME</strong></span></td>'; }

           echo '<td>'.$status.'</td>';
           echo '<td>'.date('H:i d-m-Y', $pirep->submitdate).' UTC</td>';
           echo '<td class="btn-group btn-group-xs">
              <a href="'.SITE_URL.'/index.php/pireps/view/'.$pirep->pirepid.'" class="btn btn-xs btn-default" data-toggle="tooltip" title="" data-original-title="View PIREP"><i class="gi gi-send "></i></a>
              <a href="'.SITE_URL.'/index.php/profile/view/'.$pirep->pilotid.'" class="btn btn-xs btn-default" data-toggle="tooltip" title="" data-original-title="View Pilot"><i class="fa fa-eye "></i></a>
            </td>';
           echo '</tr>';
         }
        }
        else
        {
           echo '<tr><td>There are no recent flights!</td></tr>';
        }
        ?>
          </tbody>
        </table>
        </div>
              <!-- END Latest Orders Content -->
          </div>




          <!-- END Latest Orders Block -->
      </div>
  </div>
</div>

<script src="<?php echo SITE_URL; ?>/lib/skins/iCrew/js/pages/tablesDatatables.js"></script>
<script>$(function(){ TablesDatatables.init(); });</script>
<script>
$(document).ready(function() {
		$('#upcomingdepartures').DataTable();
		$('#recentpireps').DataTable();
	});
</script>
