<?php 
/**
 * iCrew v4 LITE - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 * 
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other 
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems. 
 * 
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Intermediate Services (with additions) 
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 */
?>
<div class="content-header">
    <div class="header-section">
        <h1>
        <i class="fa fa-graduation-cap" aria-hidden="true"></i><strong>AirCrew</strong> Ranking<br><small>  &copy; <?php echo SITE_NAME ?></small> 
        </h1>
    </div>
</div>
<ol class="breadcrumb breadcrumb-top">
  <li><a href="<?php echo SITE_URL ?>"><i class="fa fa-home"></i></a></li>
  <li><a href="<?php echo SITE_URL ?>/index.php/Ranks">Ranks</a></li>
</ol>
<?php $ranks = RanksData::getAllRanks();
?>


 
<div class="row">
	<div class="col-md-12">
		<div class="block">
			<div class="block-title">
				<h3>Pilot <strong>Ranks</strong></h3>
			</div>
			<p class="alert alert-info">
				At <?php echo SITE_NAME ?>, the Pilots are automatially promoted once they reach their hours requirement! Transfer hours will  count towards promotions, however you will need to take the exam required for that rank promotion.
			</p>
			<div class="table-responsive">
				<table class="table table-hover">
         	<thead>
	            <h4>
	            	<tr>
		               <th>Rank Title</th>
	<th>Minimum Hours</th>
	<th>Rank Image</th>
	<th>Pay Rate</th>
	<th>Total Pilots</th>
	            	</tr>
	            </h4>
         	</thead>
         	<?php
foreach($ranks as $rank)
{
?>
         	<tbody>
	            <tr>
	            	<td align="center"><?php echo $rank->rank; ?></td>
	<td align="center"><?php echo $rank->minhours; ?></td>
	<td align="center"><img src="<?php echo $rank->rankimage; ?>" /></td>
	<td align="center"><?php echo Config::Get('MONEY_UNIT').$rank->payrate.'/hr'; ?></td>
	<td align="center"><?php echo $rank->totalpilots; ?></td>
			 </tr>
	         </tbody>
	         <?php } ?>
      	</table>
			</div>
      	
		</div>
	</div>
</div>