<?php
   //QR Code library, added for PIA Virtual. Make sure you have php-soundforge QRCode library installed!
   define ('phpqr_path' , CORE_LIB_PATH.'/phpqrcode' );
     define ('temp_path', CORE_PATH.'/lib/phpqrcode/temp');
      $PNG_TEMP_DIR = phpqr_path.'/temp'.DIRECTORY_SEPARATOR;

     //html PNG location prefix
     $PNG_WEB_DIR = SITE_URL.'/core/lib/phpqrcode/temp/';



     include phpqr_path."/qrlib.php";
   ?>

   <div class="col-md-12 text-center">
      <a href="javascript:void(0)" class="widget widget-hover-effect5">
         <div class="widget-extra-full">
            <span class="h3 themed-color-dark animation-expandOpen">
            <span class="label label-primary"><?php echo $pilot->code.$pilot->pilotid; ?></span> <?php echo $pilot->firstname.' '.$pilot->lastname; ?>
            </span>
         </div>
      </a>
   </div>
  <div class="row text-center">
   <div class="col-md-12">
      <div class="block">
         <div class="block-title" id="headingOne">
            <h2><span class="badge badge-success">
              <?php $pilotrosters = ROData::getRoster_pilot_active($pilot->pilotid);
               echo count($pilotrosters)?> Rosters
             </span>
           </h2>
         </div>
         <?php
            if(count($pilotrosters) > 0) {
              $nextflight = ROData::nextFlight_rShow($pilot->pilotid);
              $route = $nextflight;
              ?>
         <div class="row">
            <div class="col-md-12">
                  <h3>
                     <span class="label label-primary"><strong><?php echo $route->code.''.$route->flightnum; ?></strong></span><br>
                     <small>
                     <span class="text-muted">
                     <a href="javascript:void(0)" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Departing @ <?php echo $route->deptime; ?> UTC"><?php echo $route->depicao; ?></a> <i class="fa fa-plane"></i>
                     <a href="javascript:void(0)" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Arriving @ <?php echo $route->arrtime; ?> UTC">
                     <?php echo $route->arricao; ?></a>
                     </span>
                   </small>
                 </div>
              <?php $cload = round($route->distance);
                 if($cload < 1000) {
                   $cload_clr = 'success';
                   $notes ='<small><span class="label label-success">SHORT HAUL</span></small>';
                 }
                 else if($cload < 2500) {
                   $cload_clr = 'success';
                   $notes ='<small><span class="label label-success">MEDIUM HAUL</span></small>';
                 }
                 else if($cload < 3500) {
                   $cload_clr = 'warning';
                   $notes ='<small><span class="label label-warning">LONG HAUL</span></small>';
                 }
                 else {
                   $cload_clr = 'danger';
                   $notes = '<small><span class="label label-danger">ULTRA LONG HAUL</span></small>';
                 }
                 ?>
                     <?php
                        // Not all airline uses CodeShare, so normally the code gets ignored. 28.03.2019
                          $cs = CodeShareData::get_codeshares($route->id);
                          if($cs == '') {
                            $airline = OperationsData::getAirlineByCode($route->code);
                            $operator = $airline->name;
                            $logo = SITE_URL."/lib/images/airline/".$route->code.".png";
                          } else {
                            $op = CodeShareData::check_airline($cs->operator);
                            $operator = $op->name;
                            $logo = $op->image;
                          }

                        $schedule_id = SITE_URL."/index.php/schedules/bidSchedule/".$route->id;
                        // user data
                        $filename = $PNG_TEMP_DIR.'test'.md5($schedule_id.'|'.$errorCorrectionLevel.'|'.$matrixPointSize).'.png';
                        QRcode::png($schedule_id, $filename, "Q", "2", 2);

                        //display generated file

                        ?>
                     <div class="col-md-4">
                       <img src="<?php echo $logo; ?>" style="height: 50px; width: auto;" />
                       <h5>Operated by <?php echo $operator; ?></h5>
                       <h6><?php echo $route->aircraft.' ('.$route->registration.')'; ?></h6>
                       <span class="badge"><?php echo $route->flighttime; ?> Hrs</span> <?php echo $notes; ?>
                     </div>

                     <div class="col-md-4">
                       <?php echo '<img src="'.$PNG_WEB_DIR.basename($filename).'" />'; ?>
                       <h6><i class="text-muted">Scan the code to accept roster, add bid & generate roster <br>
                          <small>(ID: <?php echo md5($route->flightnum); ?>)</small></i>
                       </h6>
                     </div>

                     <div class="col-md-4">
                       <br>
                       Departing at <?php echo $nextflight->deptime; ?>, <?php echo date(DATE_FORMAT . " (l)", strtotime($nextflight->deptime)); ?>
                       <br><br>
                       <span class="btn-group text-center">
                       <a href="javascript:void(0)" class="btn btn-md btn-default" data-toggle="tooltip" title="" data-original-title="Roster Status">Roster Accepted</a>
                       <a href="javascript:void(0)" class="btn btn-md btn-primary" data-toggle="tooltip" title="" data-original-title="Edit"> Bid Added <i class="fa fa-check"></i></a>
                       </span>

                       <ul class="pager">
                          <!--<li class="previous"><a href="javascript:void(0)" data-toggle="tooltip" data-placement="top" title="" data-original-title="Departing @ <?php echo $route->deptime; ?> UTC"><?php echo $route->depicao; ?></a></li>-->
                          <!--<li class="next"><a href="javascript:void(0)" data-toggle="tooltip" data-placement="top" title="" data-original-title="Arriving @ <?php echo $route->arrtime; ?> UTC"><?php echo $route->arricao; ?></a></li>-->
                          <ul class="pagination text-center">
                             <li>
                                <?php
                                   # Don't allow overlapping bids and a bid exists
                                   if(Config::Get('DISABLE_SCHED_ON_BID') == true && $route->bidid != 0) {
                                     echo '<a id="'.$route->id.'" class="addbid" href="'.actionurl('/schedules/addbid').'">Add to Bid</a>';
                                     } else {
                                       if(Auth::LoggedIn()) { ?>
                                <a onclick="setTimeout('window.location.href=\'<?php echo SITE_URL; ?>/index.php/schedules/brief/<?php echo $route->id; ?>\';', 2000); hotsnackbar('hsdone', 'Your bid has been added!'); play(); loadScheduleBrief();"  id="<?php echo $route->id; ?>" class="addbid" href="<?php echo url('/schedules/addbid'); ?>" data-toggle="tooltip" data-placement="top" title="" data-original-title="Add bid!"><i class="fa fa-plus"></i></a>
                                <?php
                                   }
                                   }
                                   ?>
                             </li>
                             <li><a href="<?php echo url('/schedules/details/'.$route->id);?>" target="_blank" data-toggle="tooltip" data-placement="top" title="" data-original-title="View flight info" ><i class="fa fa-info"></i></a></li>
                          </ul>
                       </ul>

                     </div>

             </div>


         <!-- Card -->

         <!-- Card -->
         <?php
            }

            else {
              ?>
         <!-- Card -->
         <div class="card weather-card">
            <!-- Card content -->
            <div class="card-body pb-3">
               <!-- Title -->
               <span class="card-title font-weight-bold">Oops</span>
               <p class="card-text">
                  There are no rosters active for this pilot!
               </p>

            </div>
         </div>
         <!-- Card -->
         <?php
            }
            ?>
      </div>
   </div>
 </div>


<div class="row">
   <!-- Card content -->
   <div class="col-md-12">

     <div class="block">
      <!-- Title -->

      <?php $pattern = ROData::getPattern($pilot->pilotid); ?>
      <h4 class="text-center">Generated pattern (active rosters)</h4>
      <!-- <span class="card-title font-weight-bold">27-05-2019, Tuesday </span> -->
      <div class="text-center">
         <p>
            <?php echo $pattern; ?>
            <!-- <sup><span class="text-success ">Bid added by pilot <i class="fa fa-check text-success"></i></span> </sup> -->
            <br><small><span class="text-muted"><?php echo count($pilotrosters); ?> flight(s) generated</span></small>
         </p>

      <span class="btn btn-sm btn-warning" data-toggle="collapse" href="#collapse_data_<?php echo $pilot->pilotid; ?>">
      Show rosters (detailed)
      </span>
      </div>
      <hr class="">
      <div class="collapse-content">
         <div class="collapse" id="collapse_data_<?php echo $pilot->pilotid; ?>">
            <table class="table table-borderless table-sm mb-0 text-center">
               <tbody>
                  <?php
                     $p_rosters = ROData::getRoster_pilot_active($pilot->pilotid);
                     foreach ($p_rosters as $pr) {
                       $pr_sch = SchedulesData::getSchedule($pr->schedule_id);
                     ?>
                  <tr>
                     <td class="">
                        <p class="card-text">
                        <div class="btn-group" role="group">
                           <button type="button" class="btn btn-info btn-sm btn-rounded"><?php echo date("l ".DATE_FORMAT, strtotime($pr->scheduled_on)); ?></button>
                           <?php if($pr->operation == 'scheduled') { $pr_clr = "success"; } else { $pr_clr = "danger"; } ?>
                           <button type="button" class="btn btn-<?php echo $pr_clr; ?> btn-sm btn-rounded"><?php echo $pr->operation; ?></button>
                           <button type="button" class="btn btn-primary btn-sm btn-rounded"><?php echo $pr_sch->code.$pr_sch->flightnum; ?></button>
                        </div>
                        <br><br>
                        <?php echo $pr_sch->depicao; ?> <i class="fa fa-plane"></i> <?php echo $pr_sch->arricao; ?> on <?php echo $pr_sch->registration.'('.$pr_sch->aircraft.')'; ?>
                        <!-- <sup><span class="text-success">Pilot location Sync <i class="fa fa-check"></i></span></sup> -->
                        <br>departing at <?php echo $pr_sch->deptime; ?> | Duty Hours : <?php echo date("H:i", strtotime($pr_sch->flighttime)); ?> Hrs</p>
                     </td>

                  </tr>
                  <?php
                     }
                     ?>
               </tbody>
            </table>
         </div>
      </div>
    </div>
   </div>
</div>
