<?php 
/**
 * iCrew v4 Premium - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 * 
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other 
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems. 
 * 
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Premium Services (with additions) 
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 * 
 */
?>

<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="fa fa-plane"></i><strong>Roster List</strong><br><small> Flight Operations | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>
<div class="alert alert-success">
	There are currently <?php $grp = PilotGroups::getUsersInGroup(12); echo count($grp); ?> pilots on the roster list
</div>
<div class="block full">
    <div class="block-title">
    <h1><i class="hi hi-map-marker"></i> <?php echo $title?></h1>
    </div>
    <div class="table-responsive">
        <table id="example-datatable" class="table table-vcenter table-condensed table-bordered">
            <?php 
            
            
            if(!$allpilots)
            {
             echo '<div class="alert alert-danger"> <Strong>Oops</strong> <br>No Pilots in this Hub </div>';	
            }
            else
            { ?>
            <thead>
                <tr>
                    <th class="text-center">ID</th>
                    <th class="text-center">Country</th>
                    <th class="text-center">Name</th>
                    <th class="text-center">Rank</th>
                    <th class="text-center">View Pilot</th>
                </tr>
            </thead>
            <tbody>
                <?php
                
					foreach($allpilots as $pilot)
						{
							$groupcheck = PilotGroups::checkUserInGroup($pilot->pilotid, 12);
							/* 
								To include a custom field, use the following example:
										
								<td>
									<?php echo PilotData::GetFieldValue($pilot->pilotid, 'VATSIM ID'); ?>
								</td>
										
								For instance, if you added a field called "IVAO Callsign":
										
									echo PilotData::GetFieldValue($pilot->pilotid, 'IVAO Callsign');		
							*/
							if($pilot->retired == 1) { continue;
						}
						if($groupcheck == true) { ?>
						<tr>
							<td class="text-center"><?php echo PilotData::GetPilotCode($pilot->code, $pilot->pilotid)?></td>
							<td class="text-center"><img src="<?php echo Countries::getCountryImage($pilot->location);?>"> <?php echo Countries::getCountryName($pilot->location);?></td>
							<td class="text-center"><?php echo $pilot->firstname.' '.$pilot->lastname?> <span class="label label-success"><?php if($pilot->staff == 1) { echo 'Staff'; } ?></span></td>
							<td class="text-center"><?php echo $pilot->rank;?></td>
							<td class="text-center"><a class="btn btn-xs btn-default" href="<?php echo url('/profile/view/'.$pilot->pilotid);?>"><i class="fa fa-eye"></i></a></td>
						</tr>			
					<?php	}
				?>
                
                <?php } ?>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>
<!-- END Datatables Content -->