<!-- Blank Header -->
<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="gi gi-sun fa-spin"></i><strong>WX</strong> Briefing room<br><small>Flight Operations | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>
<!-- END Blank Header -->
<!-- Metar ICAO -->
<div class="row">
	<div class="col-md-4"></div>
    <div class="col-md-4">
		<div class="block">
    		<!-- Metar ICAO  Title -->
    		<div class="block-title">
        		<h2><i class="gi gi-cloud"></i> Live Airport WX</h2>
    		</div>
    		<!-- END Metar ICAO  Title -->

    		<!-- Metar ICAO  Content -->
    		<form action="<?php echo url('/AdvancedWX/metarxml');?>" method="post" class="form-horizontal form-bordered">
                <div class="form-group">
                    <label class="col-md-3 control-label">Enter ICAO</label>
                    <div class="col-md-6">
                        <input type="text" name="icao" class="form-control" placeholder="<?php echo Auth::$userinfo->hub;?>" required="required"><br>
                        <input type="submit" class="btn btn-sm btn-primary" value="Get Current WX">

                   	</div>
                </div>
            </form>
    		<!-- END Metar ICAO  Content -->
		</div>
	</div>
</div>
<div class="row">
	<div class="col-md-6 col-lg-6"><div class="block">
    		<!-- Metar ICAO Key  Title -->
    		<div class="block-title">
        		<h2><i class="gi gi-eye_open"></i></i> <Strong>RAW </Strong>WX Data </h2>
    		</div>
    		<!-- END Metar ICAO Key Title -->

    		<!-- Metar ICAO Key Content -->
    		<p><?php if (!$metar) { echo '<h2><small>METAR currently not available</small></h2>'; } else { echo $metar; } ?></p>
    		<p><?php if (!$taf) { echo '<h2><small>TAF currently not available</small></h2>'; } else { echo $taf; } ?></p>
    		<!-- END Metar ICAO Key Content -->
		</div></div>
	<div class="col-md-6 col-lg-6">
		<div class="block">
			<div class="block-title">
				<h3><strong>Airport </strong>WX Condition </h3>
			</div>

			<?php
    		$vis = $visibility.$sky1;

    		if (!$vis)
    		{
    			echo '<h3><Small>Please enter airport</small>  <Span class="label label-default">ICAO</span></h3>';
    		}
    			else if($vis < 1.5)
    		{
    			echo '<h3><Span class="label label-danger">CLOSED</span></h3>';
    		}
    		else
    		{
    			echo '<h3><Span class="label label-success">OPEN</span></h3>';
    		}
    		?>
    		<!--Dont edit anything beyond this-->

			  <?php

    		$vfr = "VFR";
    		$mvfr = "MVFR";
    		$ifr = "IFR";

    		if ($flightrules == $vfr)
    		{
    			$atisflightrules = 'Visual Flight Rules and Instrument Flight Rules are operational';
    		}
    		else if($flightrules == $mvfr)
    		{
    			$atisflightrules =  'Marginal V F R conditions, request for Special V F R clearance, and Instrument Flight Rules';
    		}
    		else if($flightrules == $ifr)
    		{
    			$atisflightrules =  'V F R operations suspended due to poor Visibility, Airport is currently operating only I F R';
    		}
    		else
    		{
    			$atisflightrules =  'Operations suspended due to dangerous weather conditions';
    		}

    		echo $atisflightrules;
    		?>

    		<br><br>

    		<?php

        //Generating ATIS Information alphabet in accordance with the LMT of your Area.
    			{
    			  $info =	date("H",strtotime($time));
    			switch ($info) {
    case 1:
        $information = "A";
    break;
     case 2:
        $information = "B";
    break; case 3:
        $information = "C";
    break; case 4:
        $information = "D";
    break; case 5:
        $information = "E";
    break; case 6:
        $information = "F";
    break; case 7:
        $information = "G";
    break; case 8:
        $information = "I";
    break; case 9:
        $information = "J";
    break; case 10:
        $information = "K";
    break; case 11:
        $information = "L";
    break; case 12:
        $information = "M";
    break; case 13:
        $information = "N";
    break; case 14:
        $information = "O";
    break; case 15:
        $information = "P";
    break; case 16:
        $information = "Q";
    break; case 17:
        $information = "R";
    break; case 18:
        $information = "S";
    break; case 19:
        $information = "T";
    break; case 20:
        $information = "U";
    break; case 21:
        $information = "V";
    break; case 22:
        $information = "W";
    break; case 23:
        $information = "X";
    break; case 24:
        $information = "Y";
    break;

    default:
        $information = "F";
    }

	       echo "On initial contact, advice you have information <span class='label label-default'>$information</span>";
    		?>



    	<?php



        switch ($information) {
    case "A":
        $atisinfo = "Alfa";
    break;
     case "B":
        $atisinfo = "Bravo";
    break;
    case "C":
        $atisinfo = "Charlie";
    break;
    case "D":
        $atisinfo = "delta";
    break;
    case "E":
        $atisinfo = "echo";
    break;
    case "F":
        $atisinfo = "foxtrot";
    break;
    case "G":
        $atisinfo = "golf";
    break;
    case "H":
        $atisinfo = "hotel";
    break;
    case "I":
        $atisinfo = "india";
    break;
    case "J":
        $atisinfo = "juliet";
    break;
    case "K":
        $atisinfo = "kilo";
    break;
    case "L":
        $atisinfo = "lima";
    break;
    case "M":
        $atisinfo = "Mike";
    break;
    case "N":
        $atisinfo = "November";
    break;
    case "O":
        $atisinfo = "Oscar";
    break;
    case "P":
        $atisinfo = "Papa";
    break;
    case "Q":
        $atisinfo = "Qubec";
    break;
    case "R":
        $atisinfo = "Romeo";
    break;
    case "S":
        $atisinfo = "sierra";
    break;
    case "T":
        $atisinfo = "tan go";
    break;
    case "U":
        $atisinfo = "uniform";
    break;
    case "V":
        $atisinfo = "Victor";
    break;
    case "W":
        $atisinfo = "whiskey";
    break;case "X":
        $atisinfo = "x ray";
    break;
    case "Y":
        $atisinfo = "Yankee";
    break;
    case "Z":
        $atisinfo = "Zulu";
    break;


    default:
        $atisinfo = "golf";
}
    	 //Additional Information
    	  $airports = OperationsData::getAirportInfo($stationid);
    	  $airportname = $airports->name;
    	  $source = $time; //Loaded from AWC ADDS XML Data
    	  $date = new DateTime($source);
        $atistime = $date->format('H  i ');
    	  $atisdate = $date->format('d m');
    	  $i = $winddir;
        $atiswinddir = (string)$i;
        $atiswinddir1 = $atiswinddir[0];
        $atiswinddir2 = $atiswinddir[1];
        $atiswinddir3 = $atiswinddir[2];
        $j = $windspd;
        $atiswindspd = (string)$j;
        $atiswindspd1 = $atiswindspd[0];
        $atiswindspd2 = $atiswindspd[1];
        $atiswindspd3 = $atiswindspd[2];
        $k = $altimeter;
        $inhg = (string)$k;
        $inhg1 = $inhg[0];
        if ($inhg[1] == 9)
        {
          $inhg02 = "Niner";
        }
        else
        {
          $inhg02 = $inhg2;
        }
        if ($inhg[2] == 9)
        {
          $inhg03 = "Niner";
        }
        else
        {
          $inhg03 = $inhg[2];
        }
        if ($inhg[3] == 9)
        {
          $inhg04 = "Niner";
        }
        else
        {
          $inhg04 = $inhg[3];
        }
        if(!$skycondition3 OR !$skycondition4)
					{
					switch($skycondition0)
					{
					case "SCT":
					  $atiscloud1 = "Scattered";
					 break;
					 case "BKN":
					  $atiscloud1 = "Broken";
					 break;
					 case "OVC":
					  $atiscloud1 = "over cast";
					 break;
					 case "Clear":
					  $atiscloud1 = "clear";
					 break;
					 case "CAVOK":
					  $atiscloud1 = "Scattered";
					 break;
					 case "NSC":
					  $atiscloud1 = "No significant clouds";
					 break;
					 case "VV":
					  $atiscloud1 = "Clouds cannot be seen due to heavy percipitation";
					 break;
					 case "NSC":
					  $atiscloud1 = "No significant clouds";
					 break;
					 default:
					   $atiscloud1 = "Clear";
					}

					{
					  if($atiscloud1 == "clear")
					  {
					    $atiscloud2 = " ";
					  }
					  else
					  {
					    $atiscloud2 = $skycondition0;
					  }
					}

					}
					else
					{
					  switch($skycondition0)
					{
					case "SCT":
					  $atiscloud1 = "Scattered";
					 break;
					 case "BKN":
					  $atiscloud1 = "Broken";
					 break;
					 case "OVC":
					  $atiscloud1 = "over cast";
					 break;
					 case "Clear":
					  $atiscloud1 = "clear";
					 break;
					 case "CAVOK":
					  $atiscloud1 = "Scattered";
					 break;
					 case "NSC":
					  $atiscloud1 = "No significant clouds";
					 break;
					 case "VV":
					  $atiscloud1 = "Clouds cannot be seen due to heavy percipitation";
					 break;
					 case "NSC":
					  $atiscloud1 = "No significant clouds";
					 break;

					 default:
					   $atiscloud1 = "Clear";
					}
					{
					  if($atiscloud1 == "clear")
					  {
					    $atiscloud2 = " ";
					  }
					  else
					  {
					    $atiscloud2 = $skycondition0;
					  }
					}
					switch($skycondition3)
					{
					case "SCT":
					  $atiscloud3 = "Scattered";
					 break;
					 case "BKN":
					  $atiscloud3 = "Broken";
					 break;
					 case "OVC":
					  $atiscloud3 = "over cast";
					 break;
					 case "Clear":
					  $atiscloud3 = "clear";
					 break;
					 case "CAVOK":
					  $atiscloud3 = "Scattered";
					 break;
					 case "NSC":
					  $atiscloud3 = "No significant clouds";
					 break;
					 case "VV":
					  $atiscloud3 = "Clouds cannot be seen due to heavy percipitation";
					 break;
					 case "NSC":
					  $atiscloud3 = "No significant clouds";
					 break;
					 default:
					   $atiscloud3 = "Clear";
					}
					{
					  if($atiscloud3 == "clear")
					  {
					    $atiscloud4 = " ";
					  }
					  else
					  {
					    $atiscloud4 = $skycondition4;
					  }
					}
					  $skycondition3.' Clouds At '.$skycondition4.' Feet';
					}

	 }
       // Modify the content as you like, but donot change the $object
    	 if(!$metar)
    	 {
    	   $broadcast = "$airportname Information is currently unavailable, please try again later. sorry for the inconvenience";
    	 }
    	 else
    	 {
    	   $broadcast = SITE_NAME." Automatic terminal information service, $airportname information $atisinfo, recorded at $atistime zulu, wind direction $atiswinddir1, $atiswinddir2, $atiswinddir3 degrees, at ,$atiswindspd1, $atiswindspd2, $atiswindspd3 knots, visibility $visibility miles, altimeter $inhg1,$inhg02, point,$inhg03,$inhg04 , sky condition, $atiscloud1, at $atiscloud2 feet, $atiscloud3, at $atiscloud4 feet, temprature , $temperature degrees, dew point, $dewpoint degrees, $atisflightrules,  on initial contact advice aircraft type and gate, this was A-TIS information $atisinfo";
    	 }


    	?>


    	<!-- Supported languages :
    	  en-au	: English (Australia)
        en-ca	: English (Canada)
        en-gb	: English (Great Britain)
        en-in	: English (India)
        en-us	: English (United States)
      -->
      <!--Now the Audio part, paste your API Key HERE!-->
    	<audio src="http://api.voicerss.org/?key=<?php echo VOICE_API; ?>&hl=en-us&src='<?php echo $broadcast?>'" id="audio"></audio>

      <br><button class="btn btn-info btn-md" id="play" onclick="play()">  VOICE ATIS </button>

		</div>
	</div>
</div>



<div class="row">
	<div class="col-md-6 col-lg-6">
		<div class="block">
    		<!-- Metar ICAO Results  Title -->
    		<div class="block-title">
        		<h2><i class="gi gi-resize_full"></i> <Strong>Decoded</Strong> WX  </h2>
    		</div>
    		<!-- END Metar ICAO Results Title -->
    		<!-- Metar ICAO Results Content -->
    		<ul class="fa-ul">
    			<li><span class="label label-primary">Station ID :</span> <?php echo $icao;?> (<?php echo $stationname;?>)</li><br>
    			<li><span class="label label-default">Observation made at</span> <?php echo $time;?></li><br>
    			<li><span class="label label-default">Wind Direction:</span> <?php echo $winddir;?> &deg; At Speed: <?php echo $windspd;?> kts</li><br>
    			<li><span class="label label-default">Sky Condition :</span>
                <?php
             echo $clouds;
                
				//	if(!$skycondition3 OR !$skycondition4)
				//	{
				//		echo $skycondition0.' Clouds At '.$skycondition1.' Feet';
				//	}
				//	else
				//	{
				//		echo $skycondition0.' Clouds At '.$skycondition1.' Feet / '.$skycondition3.' Clouds At '.$skycondition4.' Feet';
				//	}
				?></li><br>
    			<li><span class="label label-default">Visibility:</span> <?php echo $visibility.$sky1;?> Miles</li><br>
    			<li><span class="label label-default">Temperature:</span> <?php echo $temperature.$sky1;?>&deg; C / Dew Point <?php echo $dewpoint;?>&deg; C</li><br>
    			<li><span class="label label-default">Altimeter:</span> <?php echo $altimeter;?> inHg</li><br>

    		</ul>
    		<!-- END Metar ICAO Results Content -->
		</div>
	</div>
	<div class="col-md-6 col-lg-6">
		<div class="block">
    		<!-- Metar ICAO Charts Title -->
    		<div class="block-title">
        		<h2><i class="hi hi-file"></i> Aerodrome Charts</h2>
    		</div>
    		<!-- END Metar ICAO Charts Title -->

    		<!-- Metar ICAO Charts Content -->
    		<a href="https://charts.navigraph.com/airports/<?php echo $stationid; ?>/charts" target="_blank" class="btn btn-block btn-md btn-success btn-alt">Open Navigraph <i class="fa fa-share"></i></a>
    		<br>
    		<!-- END Metar ICAO Charts Content -->
    		</div>
</div>
</div>




	<div class="row">
		<div class="col-md-12">
			<div class="block">
				<div class="block-title">
					<div class="block-options pull-right">
						<span class="label label-danger animation-pulse">LIVE</span>
					</div>
					<h3><strong>WX</strong> Map</h3>
				</div>
				<iframe width="1200" height="450" src="https://embed.windyty.com/?<?php echo $airports->lat.','.$airports->lng; ?>,5,in:12,menu,message,marker"></iframe>
				<p class="text-muted"><small>Powered by <a href="http://windytv.com">windyty.com</a></small> </p>
			</div>
		</div>
	</div>
<!-- END Metar ICAO  Block -->

<script>
    function play() {
        var audio = document.getElementById('audio');
        if (audio.paused) {
            audio.play();
            $('#play').removeClass('glyphicon-play-circle')
            $('#play').addClass('glyphicon-pause')
        }else{
            audio.pause();
            audio.currentTime = 0
            $('#play').addClass('glyphicon-play-circle')
            $('#play').removeClass('glyphicon-pause')
        }
    }
</script>
