<div class="content-header">
    <div class="header-section">
        <h1><i class="fa fa-wrench"></i>Maintenance<strong> Hangar</strong> <br> <small>Flight Operations | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small></h1>
    </div>
</div>
<ol class="breadcrumb breadcrumb-top">
  <li><a href="<?php echo SITE_URL?>/index.php"><i class="fa fa-home"></i></a></li>
  <li><a href="<?php echo SITE_URL?>/index.php/Schedules">Flight Operations</a></li>
  <li><a href="<?php echo SITE_URL?>/index.php/aircraftmaintenance">Maintenance Hanger</a></li>
</ol>
<div class="row text-center">
    <div class="col-sm-12 col-lg-6">
        <a href="#totalfleet" data-toggle="modal" class="widget widget-hover-effect2">
            <!-- i want fleet data to be mirrored in this link-->
            <div class="widget-extra themed-background-success">
                <h4 class="widget-content-light"><span class="animation-pulse"> <strong>Total </strong>Aircraft</h4></span>
            </div>
            <div class="widget-extra-full"><span class="h2 themed-color-dark animation-expandOpen"><?php echo StatsData::TotalAircraftInFleet(); ?></span></div>
        </a>
    </div>

    <div class="col-sm-12 col-lg-6">
        <a href="#maint" data-toggle="modal" class="widget widget-hover-effect2">
            <!-- i will have to make a table for the maintainence aircrafts-->
            <div class="widget-extra themed-background-danger">
                <h4 class="widget-content-light"><span class="animation-pulse">Maintenance <strong>Reports</strong></h4></span>
            </div>
            <div class="widget-extra-full"><span class="h2 themed-color-dark animation-expandOpen"><?php echo round(vFleetTrackData::countmaint(-500));?>
        </span></div>
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="block">
            <div class="block-title">
                <div class="block-options pull-right">
                    <label class="label label-info animation-pulseSlows">Current</label>
                </div>
                <h3><strong>Fleet</strong> Status</h3>
            </div>
            <div class="table-responsive">
    <table class="table table-hover table-striped ">
        <thead>
            <tr>
                <thead>
                    <th>Aircraft</th>
                    <th>Last Operation</th>
                    <th>Operated By</th>
                    <th>Operated On</th>
                    <th>Current location</th>
                    <!--<th>Service Facility</th>-->
                    <th>Reported Damage</th>
                </thead>
            </tr>
        </thead>
        <tbody>
            <?php
        $allaircrafts = vFleetTrackData::getAllAircraft();
        foreach($allaircrafts as $aircraft)
        {
	        $lastflight = vFleetTrackData::getLastFlightAircraft($aircraft->id);
	        if($lastflight)
	        {		
		        $last = '<a class="btn btn-default btn-sm" href="'.url('/pireps/view/'.$lastflight->pirepid).'">'.$lastflight->code.$lastflight->flightnum.' ('.$lastflight->depicao.' - '.$lastflight->arricao.')</a>';
	        }
	        else
	        {
		        $last = 'No Flights Yet!';	
	        }

	        $location = vFleetTrackData::getLastFlightAircraft($aircraft->id);
	        if($location)
	        {		
		        $lastlocation = $location->arricao;
	        }
	        else    
	        {
		        $lastlocation = 'Home Airport';	
	          }

        ?>
                <!--To check if the Aircraft is at a HUB-->
                <?php 

          if($lastlocation == "CYUL" || $lastlocation == "EBCI" || $lastlocation == "EDDF" || $lastlocation == "EGCC" || $lastlocation == "EGPP" || $lastlocation == "EGKK" || $lastlocation == "EGNT")
          {
            $mainthanger = "<i class='fa fa-check'></i>";
            $labelclr = "success";
          }
          else
          {
            $mainthanger = "<i class='gi gi-remove_2'></i>";
            $labelclr = "danger";
          }
        ?>
                    <!--To check if the Landing rate is within limits or not-->
                    <?php
          $landingrate = $lastflight->landingrate;
          $maxlr = -500;
          if($landingrate < $maxlr)
          {
            $damage = "YES";
            $lrclr = "danger";
          }
          else 
          {
            $damage = "NO";
            $lrclr = "success";
          }
        ?>
                        <!--To get Pilot name-->
                        <?php 
          $pilotid = $lastflight->pilotid;
          $pilotdata = PilotData::getPilotData($pilotid);
          if(!$pilotname)
          {
            $pilotname = "Operations Team";
          }
          else
          {
            $pilotname = $pilotdata->firstname.' '.$pilotdata->lastname;
          }
          if(!$lastflight->submitdate)
          {
            $flightdate = "01-01-2019";
          }
          else
          {
            $flightdate = $lastflight->submitdate;
          }
          

        ?>
                            <tr>
                                <td>
                                    <?php echo $aircraft->registration;?> (
                                        <?php echo $aircraft->icao;?>)</td>
                                <td>
                                    <?php echo $last;?>
                                </td>
                                <td>
                                    <?php echo $pilotname; ?>
                                </td>
                                <td>
                                    <?php echo date('d-m-Y', strtotime($flightdate)); ?>
                                </td>
                                <td>
                                    <?php echo $lastlocation;?>
                                </td>
                                <!--<td align="center"><span class="label label-<?php echo $labelclr; ?>"> <?php echo $mainthanger; ?></span></td>-->
                                <td><span class="text-<?php echo $lrclr; ?>"><strong><?php echo $damage; ?></strong></span></td>
                            </tr>
                            <?php
      }
    ?>
        </tbody>
    </table>
</div>
        </div>
    </div>
</div>

<!-- Modal -->
<div id="totalfleet" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h3 class="modal-title text-center"><small><?php echo SITE_NAME?> <Strong>Maintenance</Strong><br></small> Fleet Strength </h3>
            </div>

            <div class="modal-body">
              <div style="overflow: auto; height: 350px; border: 0px solid #666; margin-bottom: 20px; padding: 5px; padding-top: 0px; padding-bottom: 20px;">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <h3><th>Aircraft Registration</th>
								            <th>Total Flights</th>
            <th>Total Hours</th>
            <th>Total Miles</th>
    	      <th>View</th></h3>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- ADD THE FLEET DETAILS MANUALLY-->
                            
                                <?php
        $allaircrafts = vFleetTrackData::getAllAircraft();
        foreach($allaircrafts as $aircraft)
        {
	        $lastflight = vFleetTrackData::getLastFlightAircraft($aircraft->id);
	        if($lastflight)
	        {		
		        $last = '<a href="'.url('/pireps/view/'.$lastflight->pirepid).'">'.$lastflight->code.$lastflight->flightnum.' ('.$lastflight->depicao.' - '.$lastflight->arricao.')</a>';
	        }
	        else
	        {
		        $last = 'No Flights Yet!';	
	        }

	        $location = vFleetTrackData::getLastFlightAircraft($aircraft->id);
	        if($location)
	        {		
		        $lastlocation = $location->arricao;
	        }
	        else    
	        {
		        $lastlocation = 'N/A';	
	          }

        ?>
                    <tr>                                                 <td>
                                            <?php echo $aircraft->registration;?>
                                        </td>
                                        <td>
                                            <?php echo vFleetTrackData::countFlights($aircraft->id);?>
                                        </td>
                                        <td>
                                            <?php echo round(vFleetTrackData::countHours($aircraft->id));?>
                                        </td>
                                        <td>
                                            <?php echo round(vFleetTrackData::countMiles($aircraft->id));?>
                                        </td>
                                        <td><a class="btn btn-md btn-info" href="<?php echo url('/vFleetTracker/view/'.$aircraft->registration);?>">View Aircraft</a></td>
                                        <?php }  ?>
                                    </tr>
                        </tbody>
                    </table>
                </div>
            </div>
              </div>
            </div>
    </div>
</div>

<div id="maint" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h3 class="modal-title text-center"><small><?php echo SITE_NAME?> <Strong>Maintenance</Strong><br></small> Under Maintenance </h3>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <h3>
                              <th>Aircraft Registration</th>
								              <th>Submitted by</th>
								              <th>Reason</th>
								            </h3>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- ADD THE FLEET DETAILS MANUALLY-->
                            <?php
 $allaircrafts = vFleetTrackData::getAllAircraft();
 foreach($allaircrafts as $aircraft)
 {
    $lastflight = vFleetTrackData::getLastFlightAircraft($aircraft->id);  
 if($lastflight)
{		
 $last = '<a href="'.url('/pireps/view/'.$lastflight->pirepid).'">'.$lastflight->code.$lastflight->flightnum.' ('.$lastflight->depicao.' - '.$lastflight->arricao.')</a>';
 }
else
{
$last = 'No Flights Yet!';	
}
$location = vFleetTrackData::getLastFlightAircraft($aircraft->id);
if($location)
 {		
$lastlocation = $location->arricao;
 }
else    
{
$lastlocation = 'N/A';	
}

$pilotid = $lastflight->pilotid;
$pilotdata = PilotData::getPilotData($pilotid);
$pilotname = $pilotdata->firstname.' '.$pilotdata->lastname;
$flightdate = $lastflight->submitdate;
$hoursdone = vFleetTrackData::countHours($aircraft->id);
$flightsdone = vFleetTrackData::countFlights($aircraft->id);
if(!$pilotdata)
{
  $maintreason = '<span class="text-muted">Not Operational</span>';
}
else 
{
  { 
    if($hoursdone > 25)
    {
      $maintreason = '<span class="text-success">A Check</span>';
      $maintreason1 = ' ';
      $maintreason2 = ' ';
    }
  else
    {
      $maintreason = '<span class="text-warning">Hard Landing</span>';
      $maintreason1 = '<span class="text-info">General Maintenance</span>';
      $maintreason2 = ' ';
    }
  }
  if($aircraft->registration == 'VT-ITC')
  {
    $maintreason = ' ';
    $maintreason1 = ' ';
    $maintreason2 = '<span class="text-danger">Abnormal Engine Noise</span> ';
  }
}
?>

                                <?php 
                          $landingrate = $lastflight->landingrate;
                          $maxlr = -400;
                          if($landingrate < $maxlr)
                          {
                            ?>
                                    <tr>
                                        <td>
                                            <?php echo $aircraft->registration;?>
                                        </td>
                                        <td>
                                            <?php if(!$pilotdata) { echo "N/A"; } else {  echo $pilotname; } ?>
                                        </td>
                                        <td>
                                            <?php if($maintreason == ' ') { echo ''; } else { echo $maintreason; } ?>
                                                <?php if($maintreason1 == ' ') { echo ''; } else { echo ', '.$maintreason1; } ?>
                                                    <?php if($maintreason2 == ' ') { echo ''; } else { echo ', '.$maintreason2; } ?>
                                        </td>
                                    </tr>
                                    <?php
                          }

                        ?>
                                        <?php }  ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>

    </div>
</div>