<?php 
/**
 * iCrew v4 LITE - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 * 
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other 
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems. 
 * 
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Intermediate Services (with additions) 
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 */
?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css"/>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.5.0/css/buttons.dataTables.min.css"/>
<link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/blitzer/jquery-ui.css">
<link rel="stylesheet" type="text/css" href="<?php echo SITE_URL?>/lib/css/tooltipster.bundle.min.css" />
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.0/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.0/js/buttons.flash.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.0/js/buttons.html5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.0/js/buttons.print.min.js"></script>
<!-- <script type="text/javascript" src="https://cdn.datatables.net/v/bs/dt-1.10.12/datatables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/v/bs/dt-1.10.12/datatables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/v/bs/dt-1.10.12/datatables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/v/bs/dt-1.10.12/datatables.min.js"></script> -->

<script type="text/javascript" src="<?php echo SITE_URL?>/lib/js/tooltipster.bundle.min.js"></script>
<div class="content-header">
	<div class="header-section">
		<h1><i class="fa fa-plane"></i><strong>Airport</strong> Database<br><br><small>Flight Operations | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small></h1>
	</div>
</div>

<div class="row">
  <div class="col-md-12">
    <div class="block">
      <div class="block-title">
        <h3>The <strong>Destination Map</strong></h3>
      </div>
       <div class="alert alert-warning">
       	<strong>Attention</strong><br>
       	All flights depicted on this map are from your current ACARS Location. If you donot find a schedule which operates to your desired destination from your current location, take a Jumpseat or create a Charter.
       </div>
			<?php
		        Template::Show('airportsmap.php')
		    ?>
    </div>
  </div>
</div>



<div class="row">
		<div class="col-md-12">
			<div class="block">
				<div class="block-title">
					<div class="block-options pull-right">
						<button type="button" class="btn btn-sm btn-default">Total Airports : <?php $allairports = OperationsData::GetAllAirports(); echo count($allairports); ?></button>
					</div>
					<h3><Strong>Airport</Strong> Table</h3>
				</div>
				<div class="table-responsive">
					<table id="airport" class="table table-hover">
						
							<thead><strong></strong>
								<td><strong>ICAO</strong></td>
								<td><strong>Airport Name</strong></td>
								<td><strong>Airport Country</strong></td>
								<td><strong>Country Image</strong></td>
								<td><Strong>Airport Information</Strong></td>
								<td><Strong>View Schedules</Strong></td>
							</thead>
						
						<tbody>
							<?php $allairports = OperationsData::GetAllAirports(); ?>
							<?php foreach ($allairports as $airport) {?>
							<tr>
								<td><?php echo $airport->icao;?></td>
								<td><?php echo $airport->name; ?> </td>
								<td><?php echo $airport->country; ?></td>
								<td><?php $country = $airport->country;
									$imgicao = array_search($country, Countries::$countries);
									?> <img class="tooltipster" src="<?php echo Countries::getCountryImage($imgicao);?>" alt="<?php echo $country; ?> (Unable to load Image)">
								</td>
								<td>
									<Center>
										<a class="btn btn-alt" href=" <?php echo SITE_URL ?>/index.php/airports/get_airport?icao=<?php echo $airport->icao; ?>"><?php echo $airport->icao?></a>
									</Center>
								</td>
								<td>
									<!--Php Dump, donot modify anything on this-->
								
								<?php 
									$crl =  $airport->icao;
									$nxtflt = SchedulesData::findSchedules(array( 's.depicao' => $crl));
								?>
								<?php 
								if(count($nxtflt) < 0) 
									{
										$hub =  Auth::$userinfo->hub;
										$nxtflt = SchedulesData::findReturn(array( 's.arricao' => $hub));
											
								foreach($nxtflt as $schedule)
								{
									$alertclr = "danger";
									$airlinecode = $schedule->code;
									$flightnumber = $schedule->flightnum;
									$arrivalicao = $schedule->arricao;
									$disabled = 'disabled';
								}
								}
								else
								{
								
									foreach($nxtflt as $schedule)
									{
										$alertclr = "success";
										$airlinecode = $schedule->code;
										$flightnumber = $schedule->flightnum;
										$arrivalicao = $schedule->arricao;
										$disabled = ' ';
									}
								}
								?>
								
								<form id="form" action="<?php echo url('/schedules/view');?>" method="post">
									<div class="nav-tabs-custom">
										<div class="tab-content">
											<p>
		        						<div class="tab-pane fade in" id="tab_1"><br>
		                        			<p>Select your dep airport:</p>
		                        			<div class="form-group">
		                            			<select id="depicao" name="depicao" class="form-control select-chosen">
		                            				<option value="<?php echo $crl;?>"><?php echo $crl;?></option>
		                            			</select>
		                        			</div>
		                        			<input type="submit" name="submit" value="Search" class="btn btn-flat btn-primary" />
		                    			</div>
		                    	
		                		
		                    	<div class="tab-pane fade in" id="tab_3"><br>
		                        	<p>Select aircraft:</p>
		                        		<div class="form-group">
		                            		<select id="equipment" name="equipment" class="form-control select-chosen">
		                            			<option value="">Select equipment</option>
		                            			<?php
													if(!$equipment) $equipment = array();
													foreach($equipment as $equip)
													{
														echo '<option value="'.$equip->name.'">'.$equip->name.'</option>';
													}
		                            			?>
		                            		</select>
		                        		</div>
		                        		<input type="submit" name="submit" value="Search" class="btn btn-flat btn-primary" />
		                    	</div>
		                    	
		                    		<div class="tab-pane fade in" id="tab_4"><br>
                        				<p>Select Distance:</p>
                        				<div class="form-group">
                            				<select id="type" name="type" class="form-control select-chosen">
                                				<option value="greater">Greater Than</option>
                                				<option value="less">Less Than</option>
                            				</select>
                        				</div>
                        				<div class="form-group">
                            				<input type="text" name="distance" value="" class="form-control" />
                        				</div>
                        				<input type="submit" name="submit" value="Search" class="btn btn-flat btn-primary" />
                        				<input type="hidden" name="action" value="findflight" />
                    				</div></p>
                					</div>
            						</div>
            						<?php   
            						if(count($nxtflt) == 0)
            						{
            							$title = ' No Flights available';
            						}
            						else if(count($nxtflt) == 1)
            						{
            							$title = count($nxtflt).' Flight available';
            						}
            						else if(count($nxtflt) > 1)
            						{
            							$title = count($nxtflt).' Flights available';
            						}
            						 
            						?>
        						<Center>
									<input type="submit" name="submit" data-toggle="tooltip" title=" <?php echo $title ?>" value="View Flights" class="btn btn-alt btn-sm btn-success"/><br><br>
								</Center>
							</form>
						</td>
					</tr>
				<?php } ?>
				</tbody>
			</table>
		</div>
	</div>
</div>
</div>

	