<?php if(!defined('IN_PHPVMS') && IN_PHPVMS !== true) { die(); } ?>
<?php
   /**
    * iCrew v4 Premium - Virtual Airline Crew Center
    * Copyright (c) 2017 iCrewSystems
    *
    * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
    * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
    * No part of the website design or layout may be reproduced or transmitted in any form or by any other
    * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
    * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems.
    *
    * @copyright: Copyright (c) 2017, iCrewSystems
    * @link http://www.icrewsystems.com
    * @service name: iCrewSystems Virtual Airline Premium Services (with additions)
    * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
    *
    */
   ?>
<?php
   if (!isset($_SERVER['REQUEST_URI']) || ltrim($_SERVER['REQUEST_URI'],'/') !== SITE_URL.'/index.php/login') {
   	if(!Auth::LoggedIn()) {
   		header('Location:'.SITE_URL.'/index.php/login');
   	}
   }
   ?>
<!-- Page Wrapper -->
<!-- In the PHP version you can set the following options from inc/config file -->
<!--
   Available classes:

   'page-loading'      enables page preloader
   -->
<div id="page-wrapper" class="page-loading">
<!-- Preloader -->
<!-- Preloader functionality (initialized in js/app.js) - pageLoading() -->
<!-- Used only if page preloader is enabled from inc/config (PHP version) or the class 'page-loading' is added in #page-wrapper element (HTML version) -->
<?php
   if(LOADING_SCREEN == 1) {
   	?>
<div class="preloader themed-background-dark">
   <style>
      @import url(https://fonts.googleapis.com/css?family=Quattrocento+Sans);
      .loading {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: #fafafa;
      z-index: 9999;
      }
      .loading-text {
      position: absolute;
      top: 0;
      bottom: 0;
      left: 0;
      right: 0;
      margin: auto;
      text-align: center;
      width: 100%;
      height: 100px;
      line-height: 100px;
      }
      .loading-text span {
      display: inline-block;
      margin: 0 20px;
      color: #000000;
      font-family: "Quattrocento Sans", sans-serif;
      }
      .loading-text span:nth-child(1) {
      -webkit-filter: blur(0px);
      filter: blur(0px);
      -webkit-animation: blur-text 1.5s 0s infinite linear alternate;
      animation: blur-text 1.5s 0s infinite linear alternate;
      }
      .loading-text span:nth-child(2) {
      -webkit-filter: blur(0px);
      filter: blur(0px);
      -webkit-animation: blur-text 1.5s 0.2s infinite linear alternate;
      animation: blur-text 1.5s 0.2s infinite linear alternate;
      }
      .loading-text span:nth-child(3) {
      -webkit-filter: blur(0px);
      filter: blur(0px);
      -webkit-animation: blur-text 1.5s 0.4s infinite linear alternate;
      animation: blur-text 1.5s 0.4s infinite linear alternate;
      }
      .loading-text span:nth-child(4) {
      -webkit-filter: blur(0px);
      filter: blur(0px);
      -webkit-animation: blur-text 1.5s 0.6s infinite linear alternate;
      animation: blur-text 1.5s 0.6s infinite linear alternate;
      }
      .loading-text span:nth-child(5) {
      -webkit-filter: blur(0px);
      filter: blur(0px);
      -webkit-animation: blur-text 1.5s 0.8s infinite linear alternate;
      animation: blur-text 1.5s 0.8s infinite linear alternate;
      }
      .loading-text span:nth-child(6) {
      -webkit-filter: blur(0px);
      filter: blur(0px);
      -webkit-animation: blur-text 1.5s 1s infinite linear alternate;
      animation: blur-text 1.5s 1s infinite linear alternate;
      }
      .loading-text span:nth-child(7) {
      -webkit-filter: blur(0px);
      filter: blur(0px);
      -webkit-animation: blur-text 1.5s 1.2s infinite linear alternate;
      animation: blur-text 1.5s 1.2s infinite linear alternate;
      }
      @-webkit-keyframes blur-text {
      0% {
      -webkit-filter: blur(0px);
      filter: blur(0px);
      }
      100% {
      -webkit-filter: blur(4px);
      filter: blur(4px);
      }
      }
      @keyframes blur-text {
      0% {
      -webkit-filter: blur(0px);
      filter: blur(0px);
      }
      100% {
      -webkit-filter: blur(4px);
      filter: blur(4px);
      }
      }
   </style>
   <div id="loader-wrapper">
      <div class="loading">
         <div class="loading-text">
            <span class="loading-text-words"><img src="<?php echo SITE_URL; ?>/iCrew/favicon.png" width="100" ></span>
            <br>
            <center>
               <span class="baumans"> 	<i class="fa fa-code"></i> with <i class="fa fa-heart"></i> by icrewsystems</span>
            </center>
         </div>
      </div>
   </div>
</div>
<?php
   } else {
   	?>
<script>console.log('Loading Screen: Disabled');</script>
<?php
   }
   ?>
<!-- END Preloader -->
<!-- Page Container -->
<!-- In the PHP version you can set the following options from inc/config file -->
<!--
   Available #page-container classes:

   '' (None)                                       for a full main and alternative sidebar hidden by default (> 991px)

   'sidebar-visible-lg'                            for a full main sidebar visible by default (> 991px)
   'sidebar-partial'                               for a partial main sidebar which opens on mouse hover, hidden by default (> 991px)
   'sidebar-partial sidebar-visible-lg'            for a partial main sidebar which opens on mouse hover, visible by default (> 991px)
   'sidebar-mini sidebar-visible-lg-mini'          for a mini main sidebar with a flyout menu, enabled by default (> 991px + Best with static layout)
   'sidebar-mini sidebar-visible-lg'               for a mini main sidebar with a flyout menu, disabled by default (> 991px + Best with static layout)

   'sidebar-alt-visible-lg'                        for a full alternative sidebar visible by default (> 991px)
   'sidebar-alt-partial'                           for a partial alternative sidebar which opens on mouse hover, hidden by default (> 991px)
   'sidebar-alt-partial sidebar-alt-visible-lg'    for a partial alternative sidebar which opens on mouse hover, visible by default (> 991px)

   'sidebar-partial sidebar-alt-partial'           for both sidebars partial which open on mouse hover, hidden by default (> 991px)

   'sidebar-no-animations'                         add this as extra for disabling sidebar animations on large screens (> 991px) - Better performance with heavy pages!

   'style-alt'                                     for an alternative main style (without it: the default style)
   'footer-fixed'                                  for a fixed footer (without it: a static footer)

   'disable-menu-autoscroll'                       add this to disable the main menu auto scrolling when opening a submenu

   'header-fixed-top'                              has to be added only if the class 'navbar-fixed-top' was added on header.navbar
   'header-fixed-bottom'                           has to be added only if the class 'navbar-fixed-bottom' was added on header.navbar

   'enable-cookies'                                enables cookies for remembering active color theme when changed from the sidebar links
   -->
<div id="page-container" class="sidebar-mini footer-fixed sidebar-no-animations disable-menu-autoscroll sidebar-visible-lg sidebar-visible-lg-mini-xs enable-cookies">
<!-- Alternative Sidebar --><!---mini-->
<div id="sidebar-alt">
   <!-- Wrapper for scrolling functionality -->
   <div id="sidebar-alt-scroll">
      <!-- Sidebar Content -->
      <div class="sidebar-content">
         <!-- Activity -->
         <span href="javascript:void(0)" class="sidebar-title">
         <i class="fa fa-circle text-success pull-right"></i></i>Online
         </span>
         <div class="sidebar-section">
            <!--User's Online-->
            <ul class="chat-users clearfix">
               <li>
                  <div class="chat-talk-info">
                     <?php
                        $usersonline = StatsData::UsersOnline();
                        $guestsonline = StatsData::GuestsOnline();
                        ?>
                     <h5><?php
                        $shown = array();
                        foreach($usersonline as $pilot)
                        {
                        if(in_array($pilot->pilotid, $shown))
                        continue;
                        else
                        $shown[] = $pilot->pilotid;
                        $pilotCode = PilotData::getPilotCode($pilot->code, $pilot->pilotid).'_'.$pilot->hub;
                        if(!file_exists(SITE_ROOT.AVATAR_PATH.'/'.$pilotCode.'.png')) {
                        $image = SITE_URL.'/lib/images/noavatar.png';
                        } else {
                        $image = SITE_URL.AVATAR_PATH.'/'.$pilotCode.'.png';
                        }

                        echo "<p>";
                        echo '<img src="'.$image.'" alt="avatar" class="img-circle pull-left" />';
                        echo '<Strong>'.$pilot->firstname.'</strong>  '.$pilot->lastname.'<br />';
                        echo '<small></small>';
                        echo "</p>";
                        }
                        ?>
                     </h5>
                  </div>
               </li>
            </ul>
            <!-- END Users Online -->
         </div>

         <!-- Friend Requests -->
         <span href="javascript:void(0)" class="sidebar-title">
         <i class="fa fa-users pull-right"></i> <strong></strong> Friend Requests
         </span>
         <div class="sidebar-section">
            <?php
               $friendrequests = ICSFriends::getAllRequests(Auth::$userinfo->pilotid);
               if($friendrequests) {
               $notify = 1;
               foreach ($friendrequests as $request) {
               $friend_data = PilotData::getPilotData($request->self_id);
               ?>
            <div class="alert alert-alt alert-success">
               <small><?php echo date("d/m/y", strtotime($request->date)); ?></small><br>
               <i class="fa fa-plus fa-fw"></i> <a href="<?php echo SITE_URL; ?>/index.php/profile/view/<?php echo $request->friend_id; ?>"><strong><?php echo $friend_data->firstname; ?> <?php echo $friend_data->lastname; ?></strong></a> would like to become friends!<br>
               <form class="form form-horizontal" action="<?php echo SITE_URL; ?>/index.php/Friends/AcceptRequest" method="post">
                  <div class="form-action form-group">
                     <input type="hidden" name="friendid" value="<?php echo $request->friend_id; ?>" />
                     <input type="hidden" name="id" value="<?php echo $request->id; ?>" />
                     <input type="hidden" name="selfid" value="<?php echo $request->self_id; ?>" />
                     &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                     <button type="submit" class="btn btn-xs btn-success" name="action" value="accept" ><i class="fa fa-check"></i> Accept</button>
                     <button type="submit" class="btn btn-xs btn-danger" name="action" value="reject" ><i class="fa fa-times"></i> Reject</button>
                  </div>
               </form>
            </div>
            <?php
               }
               } else {
               ?>
            <div class="alert alert-success">
               <small>No pending requests at the moment!</small>
            </div>
            <?php
               }
               ?>
         </div>
         <span href="javascript:void(0)" class="sidebar-title">
         <i class="fa fa-bell pull-right"></i> <strong></strong>Latest News
         </span>
         <div class="sidebar-section">
            <?php MainController::Run('PopUpNews', 'PopUpNewsList', 1); ?>
         </div>
         <!-- END Friend Requests -->
      </div>
      <!-- END Sidebar Content -->
   </div>
   <!-- END Wrapper for scrolling functionality -->
</div>
<!-- END Alternative Sidebar -->
<!-- Main Sidebar -->
<div id="sidebar" class="themed-background-dark">
   <!-- Wrapper for scrolling functionality -->
   <div id="sidebar-scroll">
      <!-- Sidebar Content -->
      <div class="sidebar-content">
         <!-- Brand -->
         <a href="<?php echo url('/Profile'); ?>" class="sidebar-brand">
         <i class="gi gi-flash"></i><span class="sidebar-nav-mini-hide"><img src="<?php echo SITE_URL; ?>/iCrew/v4logo.png" style="height: 30px; width: auto;"></span>
         </a>
         <!-- END Brand -->
         <!-- User Info -->
         <div class="sidebar-section sidebar-user clearfix sidebar-nav-mini-hide">
            <div class="sidebar-user-avatar">
               <a href="<?php echo url('/Profile'); ?>">
               <?php
                  $authProperCode = PilotData::getPilotCode(Auth::$userinfo->code, Auth::$userinfo->pilotid);
                  $pilotCode = PilotData::getPilotCode(Auth::$userinfo->code, Auth::$userinfo->pilotid).'_'.Auth::$userinfo->hub;
                  if(!file_exists(SITE_ROOT.AVATAR_PATH.'/'.$pilotCode.'.png')) {
                  $image = SITE_URL.'/lib/images/noavatar.png';
                  } else {
                  $image = SITE_URL.AVATAR_PATH.'/'.$pilotCode.'.png';
                  }
                  ?> <img src="<?php echo $image; ?>" alt="avatar"> <?php
                  ?>
               </a>
            </div>
            <div class="sidebar-user-name"><?php echo Auth::$userinfo->code.Auth::$userinfo->pilotid; ?></div>
            <div class="sidebar-user-links">
               <a href="<?php echo url('/profile/view/'); ?><?php echo Auth::$userinfo->pilotid;?>" data-toggle="tooltip" data-placement="bottom" title="Profile"><i class="gi gi-user"></i></a>
               <a href="<?php echo url('/Mail'); ?>" data-toggle="tooltip" data-placement="bottom" title="Messages"><i class="gi gi-envelope"></i></a>
               <!-- Opens the user settings modal that can be found at the bottom of each page (page_footer.html in PHP version) -->
               <a href="<?php echo url('/Profile/editprofile'); ?>" class="enable-tooltip" data-placement="bottom" title="Settings"><i class="gi gi-cogwheel"></i></a>
               <a href="<?php echo url('/Logout'); ?>" data-toggle="tooltip" data-placement="bottom" title="Logout"><i class="gi gi-exit"></i></a>
            </div>
         </div>
         <!-- END User Info -->
         <!-- Sidebar Navigation -->
         <ul class="sidebar-nav">
            <?php
               $totaldays = Config::Get('PILOT_INACTIVE_TIME');
               if($userinfo->lastpirep == '0000-00-00 00:00:00') {
               $inactive_bar = 'You must file a PIREP once every 30 days to remain active';
               $inactive_clr = 'success';

               } else {
                          $datebefore1 = substr($userinfo->lastpirep, 0, 10);
                          $datetoday2 = date("Y-m-d");
               $datebefore3 = strtotime($datebefore1);
               $datetoday4 = strtotime($datetoday2);
               $newdate = $datetoday4-$datebefore3;
               $lastpirep = floor($newdate/(60*60*24));
               $daysleft = $totaldays-$lastpirep;

               $active = Auth::$userinfo->retired;
               if($active != 0) {
               if ($daysleft <= 0) {
               $inactive_bar = 'Due to irregular PIREPs, you have been de-rostered. Click the activate button or go to your settings';
                              $inactive_clr = 'danger';
                              $inactivity_btn = '	<span class="sidebar-header-options clearfix">
               <a href="'.SITE_URL.'/index.php/activate" data-toggle="tooltip" title="" data-original-title="Activate Profile"><i class="fa fa-link"></i></a>
               </span>';
               } else if($daysleft < 30) {
               $inactive_bar = 'Oops, you only have '.$daysleft.' before the system automatically re-rosters you. File a PIREP once in every 30 days to avoid this';
               $inactive_clr = 'warning';
               }
               } else {
               // Do nothing
               }

               }
               ?>
            <?php if($inactivity_btn) {
               ?>
            <div class="sidebar-header sidebar-nav-mini-hide">
               <?php echo $inactivity_btn; ?>
               <span class="sidebar-header-title">Activity Monitor</span>
            </div>
            <div class="sidebar-section sidebar-nav-mini-hide">
               <div class="alert alert-<?php echo $inactive_clr; ?> alert-alt">
                  <small><?php if($userinfo->totalpay == 0) { echo ''; } else { echo date("d-m-Y", strtotime($userinfo->lastpirep)); } ?></small><br>
                  <i class="fa fa-exclamation fa-fw"></i> <?php echo $inactive_bar; ?>
               </div>
            </div>
            <?php
               }
               ?>
            <li>
               <a href="<?php echo url('/Profile'); ?>" class=" "><i class="gi gi-stopwatch sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">Dashboard</span></a>
            </li>
            <li>
               <a href="<?php echo url('/Mail'); ?>"><i class="gi gi-envelope sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">iMail</span></a>
            </li>

            <li>
               <a href="#" class="sidebar-nav-menu"><i class="fa fa-angle-left sidebar-nav-indicator sidebar-nav-mini-hide"></i><i class="gi gi-airplane sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">Flight Operations </a>
               <ul>
                  <li>
                     <a href="<?php echo url('/schedules'); ?>">Flight Operations Center</a>
                  </li>
				  <li>
                     <a href="<?php echo url('/ICSNAts'); ?>">North Atlantic Tracks</a>
                  </li>
                  <li>
                  	<a href="<?php echo url('/allroutes'); ?>">Timetable</a>
                  </li>
                  <!-- <li>-->
                  <!--   <a href="<?php echo url('/charter'); ?>">Charter </a>-->
                  <!--</li>-->
                  <li>
                     <a href="<?php echo url('/advancedwx'); ?>">WX Briefing Room</a>
                  </li>
                  <li>
                     <a href="<?php echo url('/Schedules/VADS'); ?>">Flight Briefing Room</a>
                  </li>
                  <!--<li>-->
                  <!--	<a href="<?php echo url('/ICSFleet'); ?>">Aircraft Hangar</a>-->
                  <!--</li>-->
                  <li>
                     <a href="<?php echo url('/Schedules/bids'); ?>">Current Bookings</a>
                  </li>
                  <li>
                     <a href="<?php echo url('/Pireps/mine'); ?>">Electronic Logbook</a>
                  </li>
                  </li>
                  <li>
                     <a href="<?php echo url('/loa'); ?>">Leave Request</a>
                  </li>
               </ul>
            </li>
            <li>
               <a href="<?php echo url('/Events'); ?>"><i class="gi gi-calendar sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">Events Center</span></a>
            </li>
            <li>
               <a href="<?php echo url('/ICSTour'); ?>"><i class="fa fa-plane sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">Tour Center</span></a>
            </li>
            <li>
               <a href="<?php echo url('/charter'); ?>"><i class="fa fa-globe sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">Charters</span></a>
            </li>
            <li>
               <a href="#" class="sidebar-nav-menu"><i class="fa fa-angle-left sidebar-nav-indicator sidebar-nav-mini-hide"></i><i class="gi gi-group sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">Corporate </span></a>
               <ul>
               	<?php
               		if(PilotGroups::group_has_perm(Auth::$usergroups, HUB_MGR) ||  PilotGroups::group_has_perm(Auth::$usergroups, ACCESS_ADMIN)) {
               			?>
						<!-- <li>
							<a target="_blank" href="<?php echo url('/HubOps'); ?>">Hub Administration</a>
						</li> -->
						<?php
               		}
               	?>
                  <li>
                     <a href="<?php echo url('/Team'); ?>">Staff Team</a>
                  </li>
                  <li>
                     <a href="<?php echo url('/ICSFleet'); ?>">Fleet Tracker</a>
                  </li>
                  <li>
                     <a href="<?php echo url('/pilots'); ?>">Active Pilot List</a>
                  </li>
                  <li>
                     <a href="<?php echo url('/Timeline'); ?>">Airline Timeline</a>
                  </li>
                  <li>
                     <a href="<?php echo url('/Halloffame'); ?>">Hall of Fame</a>
                  </li>
                  <li>
                     <a href="<?php echo url('/Finances'); ?>">Airline Revenue</a>
                  </li>
                  <li>
                     <a href="<?php echo url('/Ranks'); ?>">Ranking Insignia</a>
                  </li>

                   <li>
                     <a href="<?php echo url('/Profile/badge'); ?>">Forum Signature </a>
                   </li>
                  <li>
                     <a href="<?php echo url('/Credits'); ?>">Credits & Partners</a>
                  </li>
                  <li>
                     <a target="_blank" href="<?php echo url('/Privacy'); ?>">Privacy Policy </a>
                  </li>
               </ul>
            </li>
            <li>
               <a href="#" class="sidebar-nav-menu"><i class="fa fa-angle-left sidebar-nav-indicator sidebar-nav-mini-hide"></i><i class="gi gi-cloud sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">Utilities</span></a>
               <ul>
                  <li>
                     <a href="<?php echo url('/Downloads'); ?>">Downloads</a>
                  </li>
                  <li>
                     <a href="<?php echo url('/Livestream'); ?>">Livestream</a>
                  </li>
                  <li>
                     <a href="<?php echo url('/Twitch'); ?>">Twitch</a>
                  </li>
                  <li>
                     <a href="<?php echo url('/Screenshots'); ?>">Screenshot Center</a>
                  </li>
                  <!--<li>
                     <a href="<?php echo url('/Rfinder') ?>">Online Route Finder</a>
                     </li>-->
               </ul>
            </li>
            <?php
               $socialmedia = Config::get('ALLOW_SOCIAL_MEDIA');
               $whatsapp = Config::get('WHATSAPP_GROUP_INVITE');
               $facebook = Config::get('FACEBOOK_PAGE');
               $twitter = Config::get('TWITTER_PAGE');
               $instagram = Config::get('INSTAGRAM_PAGE');
               $discord = Config::get('DISCORD');
               $youtube = Config::get('YOUTUBE');
               $forum = Config::get('FORUM');

               if($socialmedia == true)
               { ?>
            <li>
               <a href="#" class="sidebar-nav-menu"><i class="fa fa-angle-left sidebar-nav-indicator sidebar-nav-mini-hide"></i><i class="hi hi-thumbs-up sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">Community</span></a>
               <ul>
                   
                  <?php if($facebook == true)
                     { ?>
                  <li>
                     <a target="_blank" href="<?php echo Config::get('FACEBOOK_PAGE_LINK'); ?>">Facebook</a>
                  </li>
                  <?php } ?>
                  
                  <?php if($twitter == true)
                  { ?>
                  <li>
                     <a target="_blank" href="<?php echo Config::get('TWITTER_PAGE_LINK'); ?>">Twitter </a>
                  </li>
                  <?php } ?>
                  
                  <?php if(instagram == true)
                  { ?>
                  <li>
                     <a target="_blank" href="<?php echo Config::get('INSTAGRAM_PAGE_LINK'); ?>">Instagram </a>
                  </li>
                  <?php } ?>
                  
                  <?php if($youtube == true)
                  { ?>
                  <li>
                     <a target="_blank" href="<?php echo Config::get('YOUTUBE_LINK'); ?>">Youtube </a>
                  </li>
                  <?php } ?>
                  
                  <?php if($discord == true)
                     { ?>
                  <li>
                     <a href="<?php echo url('/Discord'); ?>">Discord </a>
                  </li>
                  <?php } ?>
                  
                  <?php if($forum == true)
                     { ?>
                  <li>
                     <a href="<?php echo Config::get('FORUM_LINK'); ?>">Forum</a>
                  </li>
                  <?php } ?>
                 
                  <?php if($whatsapp == true)
                     { ?>
                  <li>
                     <a href="<?php echo url('/Whatsapp'); ?>">Whatsapp Group</a>
                  </li>
                  <?php } ?>
                  <li>
                     <a href="<?php echo url('/Radio'); ?>">Radio</a>
                  </li>
               </ul>
            </li>
            <?php	}
               ?>
            <li>
               <a href="<?php echo url('/Documentation'); ?>"><i class="gi gi-book sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">Documentation</span></a>
            </li>
            <li>
               <a href="<?php echo url('/leaderboard'); ?>"><i class="fa fa-trophy sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">Leaderboards </span></a>
            </li>
            <li>
               <a href="<?php echo url('/Helpdesk'); ?>"><i class="fa fa-support sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">Help Desk</span></a>
            </li>
            <li>
               <a href="<?php echo url('/FAQ'); ?>"><i class="fa fa-question sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">FAQ</span></a>
            </li>
            
           <!-- <li>
               <a href="#" class="sidebar-nav-menu"><i class="fa fa-angle-left sidebar-nav-indicator sidebar-nav-mini-hide"></i><i class="gi gi-cloud sidebar-nav-icon"></i><span class="sidebar-nav-mini-hide">Support VUA</span></a>
               <ul>
                  <li>
                     <a href="https://www.paypal.com/us/fundraiser/charity/3972355" target="_blank">Donate To Paypal</a>
                  </li>
                  <li>
                     <a href="https://smile.amazon.com/ch/85-0664857" target="_blank">Donate To Amazon Smiles</a>
                  </li>
                  <li>
                     <a href="https://vuashop.myspreadshop.com/" target="_blank ">Visit Our Shop</a>
                  </li>
               </ul>
            </li>-->
         </ul>
         <!-- Messages -->
         <!-- END Sidebar Navigation -->
      </div>
      <!-- END Sidebar Content -->
   </div>
   <!-- END Wrapper for scrolling functionality -->
</div>
<!-- END Main Sidebar -->
<!-- Main Container -->
<div id="main-container">
<!-- Header -->
<!-- In the PHP version you can set the following options from inc/config file -->
<!--
   Available header.navbar classes:

   'navbar-default'            for the default light header
   'navbar-inverse'            for an alternative dark header

   'navbar-fixed-top'          for a top fixed header (fixed sidebars with scroll will be auto initialized, functionality can be found in js/app.js - handleSidebar())
       'header-fixed-top'      has to be added on #page-container only if the class 'navbar-fixed-top' was added

   'navbar-fixed-bottom'       for a bottom fixed header (fixed sidebars with scroll will be auto initialized, functionality can be found in js/app.js - handleSidebar()))
       'header-fixed-bottom'   has to be added on #page-container only if the class 'navbar-fixed-bottom' was added
   -->
<header class="navbar navbar-inverse">
   <!-- Left Header Navigation -->
   <ul class="nav navbar-nav-custom">
      <!-- Main Sidebar Toggle Button -->
      <li>
         <a href="javascript:void(0)" onclick="App.sidebar('toggle-sidebar');this.blur();">
         <i class="fa fa-bars fa-fw"></i>
         </a>
      </li>
      <?php
         if(ICREW_MULTI_LANG_SUPPORT) {
         	?>
      <li class="dropdown">
         <a href="javascript::void(0);" data-toggle="modal" data-target="#trans">
         <i class="fa fa-globe"></i>
         </a>
      </li>
      <div id="trans" class="modal fade" role="dialog">
         <div class="modal-dialog">
            <div class="modal-content">
               <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">×</button>
                  <h4 class="modal-title">Language <strong>Options</strong><br>
                     <small><?php echo SITE_NAME; ?></small>
                  </h4>
               </div>
               <div class="modal-body text-">
                  <form>
                     <div class="alert alert-success">
                        As per <?php echo SITE_NAME; ?>'s policy, iCrew v<?php echo ICS_VERSION; ?> is being offered in
                        English & online client-side translation is rendered in Japanse. To continue, please select the
                        the language to "<?php echo LANGUAGE_NAME; ?>" and the contnet will reload automatically.
                     </div>
                     <div id="google_translate_element"></div>
                     <script type="text/javascript">
                        function googleTranslateElementInit() {
                          new google.translate.TranslateElement({pageLanguage: 'en', includedLanguages: '<?php echo TRANSLATE_TO; ?>', autoDisplay: true, multilanguagePage: true}, 'google_translate_element');
                        }
                     </script>
                     <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
                  </form>
               </div>
               <div class="modal-footer text-center">
                  <center>Translation Services by <a href="https://translate.google.com" target="_blank" class="text-muted">Google</a></center>
               </div>
            </div>
         </div>
      </div>
      <?php
         }
         ?>
      <!-- END Main Sidebar Toggle Button -->
      <!-- Template Options -->
      <!-- Change Options functionality can be found in js/app.js - templateOptions() -->
      <!--<li class="dropdown">
         <a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown">
         <i class="gi gi-settings"></i>
         </a>
         <ul class="dropdown-menu dropdown-custom dropdown-options">
            <li class="dropdown-header text-center">Header Style</li>
            <li>
               <div class="btn-group btn-group-justified btn-group-sm">
                  <a href="javascript:void(0)" class="btn btn-primary" id="options-header-default">Light</a>
                  <a href="javascript:void(0)" class="btn btn-primary" id="options-header-inverse">Dark</a>
               </div>
            </li>
            <li class="dropdown-header text-center">Page Style</li>
            <li>
               <div class="btn-group btn-group-justified btn-group-sm">
                  <a href="javascript:void(0)" class="btn btn-primary" id="options-main-style">Default</a>
                  <a href="javascript:void(0)" class="btn btn-primary" id="options-main-style-alt">Alternative</a>
               </div>
            </li>
         </ul>
         </li>-->
      <!-- END Template Options -->
   </ul>
   <!-- END Left Header Navigation -->
   <!-- Right Header Navigation -->
   <ul class="nav navbar-nav-custom pull-right">
      <!-- Alternative Sidebar Toggle Button -->
      <div id="myNav" class="overlay">
         <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">&times;</a>
         <div class="overlay-content">
            <h1> <strong>Quick</strong> Access</h1>
            <a href="<?php echo SITE_URL?>/index.php/Schedules"><i class="fa fa-paper-plane"></i> Bid a flight </a>
            <a href="<?php echo SITE_URL?>/index.php/Schedules/bids"> <i class="fa fa-plane"></i> Current Bids</a>
            <a href="<?php echo SITE_URL?>/index.php/discord"><i class="fa fa-phone"></i> Discord</a>
            <a href="<?php echo SITE_URL?>/index.php/helpdesk"><i class="fa fa-life-bouy"></i> Help</a>
            <?php MainController::Run('Simplenews', 'Newslist','1'); ?>
            <a href="<?php echo url('/Logout'); ?>"><i class="fa fa-power-off"></i> Log Out</a>
         </div>
     </div>      
      <?php if(PilotGroups::group_has_perm(Auth::$usergroups, ACCESS_ADMIN)) {
         echo '<li>';
           echo '<a data-toggle="modal" data-target="#adminactions">';
           $params = array('p.accepted' => PIREP_PENDING);
           $pireps = PIREPData::findPIREPS($params);
           
           $count = count($pireps);
           
           $params = array('p.accepted' => PIREP_INPROGRESS);
           $pireps = PIREPData::findPIREPS($params);
           
           $count = $count + count($pireps);
           
           
         if(empty($pireps))
         {
           $status = '<i class="fa fa-info"></i>';
           $messagepirep = 'All PIREPs have been processed, no actions required';
           $textcolor = 'success';
         }
         else
         {
         foreach ($pireps as $pirep)
         {
         if($pirep->accepted == '1')
         {
           $status = '<i class="fa fa-file-powerpoint-o"></i>';
           $messagepirep = 'All PIREPs have been processed, no actions required';
           $textcolor = 'success';
         }
         else if($pirep->accepted == '2')
         {
           $status = '<i class="fa fa-file-powerpoint-o"></i>';
           $messagepirep = 'Attention! There are PIREPs which are waiting to be processed, immediate action required!';
           $textcolor = 'success';
         }
         else
         {
           $status = '<i class="fa fa-file-powerpoint-o"></i><span class="label label-danger label-indicator animation-pulse">'.$count.'</span>';
           $messagepirep = 'Attention! There are PIREPs which are waiting to be processed, immediate action required!';
           $textcolor = 'danger';
         }
         } }
         echo $status;
         }
         echo '</a>';
         echo '</li>';
         ?>
      <li>
         <a data-toggle="modal" data-target="#mailcheck">
         <?php MainController::Run('Mail', 'checkmail');  ?>
         </a>
      </li>
      <li>
         <a href="javascript:void(0)" onclick="openNav()">
         <i class="fa fa-bolt"></i>
         </a>
      </li>
      <li>
        <a><span id="clockbox"></span></a>
      </li>
      <li class="dropdown hidden-xs">
         <style>@import url('https://fonts.googleapis.com/css?family=Baumans');
            p.baumans {
            font-family: 'Baumans', cursive;
            font-size: 20px;
            text-align: center;
            }
         </style>
      </li>
      <li>
         <!-- If you do not want the main sidebar to open when the alternative sidebar is closed, just remove the second parameter: App.sidebar('toggle-sidebar-alt'); -->
         <a href="javascript:void(0)" onclick="App.sidebar('toggle-sidebar-alt', 'toggle-other');this.blur();">
         <i class="gi gi-share_alt"></i>
         <span class="label label-primary label-indicator animation-floating"><?php if($notify == 1) { ?> <i class="fa fa-exclamation"></i> <?php } ?></span>
         </a>
      </li>
      <!-- END Alternative Sidebar Toggle Button -->
      <!-- User Dropdown -->
      <li class="dropdown">
         <a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown">
         <?php
            $pilotCode = PilotData::getPilotCode(Auth::$userinfo->code, Auth::$userinfo->pilotid).'_'.Auth::$userinfo->hub;
            if(!file_exists(SITE_ROOT.AVATAR_PATH.'/'.$pilotCode.'.png')) {
            $image = SITE_URL.'/lib/images/noavatar.png';
            } else {
            $image = SITE_URL.AVATAR_PATH.'/'.$pilotCode.'.png';
            }

            ?>
         <img src="<?php echo $image; ?>" alt="avatar"> <i class="fa fa-angle-down"></i>
         </a>
         <ul class="dropdown-menu dropdown-custom dropdown-menu-right">
            <li class="dropdown-header text-center">Account</li>
            <li>
               <a href="<?php echo url('/Mail'); ?>">
               <i class="fa fa-envelope-o fa-fw pull-right"></i>
               Messages
               </a>
               <a href="<?php echo url('/FAQ'); ?>"><i class="fa fa-question fa-fw pull-right"></i>
               FAQ
               </a>
            </li>
            <li class="divider"></li>
            <li>
               <a href="<?php echo url('/profile/view/'); ?><?php echo Auth::$userinfo->pilotid;?>">
               <i class="fa fa-user fa-fw pull-right"></i>
               Profile
               </a>
               <!-- Opens the user settings modal that can be found at the bottom of each page (page_footer.php in PHP version) -->
               <a href="<?php echo url('/Profile/editprofile'); ?>" data-toggle="modal">
               <i class="fa fa-cog fa-fw pull-right"></i>
               Settings
               </a>
            </li>
            <?php
               $webmail_link = str_replace('icrew', 'webmail', SITE_URL);
               if(PilotGroups::group_has_perm(Auth::$usergroups, ACCESS_ADMIN)) { echo '
               <li class="divider"></li>
               <li>
               	<a target="_blank" href="'.SITE_URL.'/admin/">
                       <i class="fa fa-cog fa-fw pull-right"></i>
                       Admin Panel
                   </a>
                   <a target="_blank" href="'.$webmail_link .'">
                       <i class="fa fa-envelope fa-fw pull-right"></i>
                       Staff Email
                   </a>
               </li>
               '; } ?>
            <li class="divider"></li>
            <li>
               <a href="<?php echo url('/Logout'); ?>"><i class="fa fa-ban fa-fw pull-right"></i> Logout</a>
            </li>
         </ul>
      </li>
      <!-- END User Dropdown -->
   </ul>
   <div id="adminactions" class="modal fade" role="dialog">
      <div class="modal-dialog">
         <!-- Modal content-->
         <div class="modal-content">
            <div class="modal-header">
               <button type="button" class="close" data-dismiss="modal">&times;</button>
               <h4 class="modal-title">Admin <Strong>Actions</Strong></h4>
            </div>
            <div class="modal-body text-<?php echo $textcolor; ?>">
               <p><?php echo $messagepirep; ?></p>
            </div>
            <div class="modal-footer">
               <a target="_blank" href="<?php echo SITE_URL ?>/admin/index.php/pirepadmin/viewpending" type="button" class="btn btn-default">Open Admin Panel</a>
            </div>
         </div>
      </div>
   </div>
   <div id="mailcheck" class="modal fade" role="dialog">
      <div class="modal-dialog">
         <!-- Modal content-->
         <div class="modal-content">
            <div class="modal-header">
               <button type="button" class="close" data-dismiss="modal">&times;</button>
               <h4 class="modal-title text-center">iMail<strong> <i>v4</i>  </strong></h4>
            </div>
            <div class="modal-body">
               <?php
                  $item = MailData::checkformail();
                     $items = $item->total;
                     $this->set('items', $items);





                  if($items <= 0) {
                  $messagemail = 'You dont have any new mails, why not send one to your pilots?';
                  }
                  else {
                  $messagemail = 'You have '.$items.' new mail(s) waiting to be read.<br><br>';
                  $unread = MailData::get_iMail_subjects();

                  foreach ($unread as $urd) {
                  	$sent = $urd->who_from;
                  	$iMail_subject = $urd->subject;
                  	$messagemail .= '<li><strong>'.$iMail_subject->Mail_subject.'</strong> from '.PilotData::getPilotData($sent)->firstname.' on '.date(DATE_FORMAT, strtotime($urd->date)).'</li>';
                  	$allread = '<a class="btn btn-warning btn-md" href="'.SITE_URL.'/index.php/Mail/markallread">Mark all as Read</a>';
                  }
                  }

                  ?>
               <p>
                  Hello <?php echo Auth::$userinfo->firstname; ?>,
                  <?php echo '<ul>'.$messagemail.'</ul>'; ?>
               </p>
               <p><a class="btn btn-default btn-md" href="<?php echo SITE_URL ?>/index.php/Mail">Open MailBox</a> <?php echo $allread; ?></p>
            </div>
            <div class="modal-footer">
               <h5 class="modal-title text-center"><strong><?php echo SITE_NAME?></strong> | Communications Department &copy; <?php echo date ("Y"); ?></h5>
            </div>
         </div>
      </div>
   </div>
   <!-- END Right Header Navigation -->
</header>
<!-- END Header -->
<!-- Page content -->
<div id="page-content">
<!-- Modal -->
