<?php Template::Show('charter/header.php'); ?>

<?php
?>
<div class="row">
	<div class="col-md-12">
      <a href="javascript::(0)" class="widget widget-hover-effect5">
         <div class="widget-simple">
            <h3 class="widget-content text-center animation-pullDown">
               <strong><?php echo $icao->icao; ?></strong><br>
               <small><?php echo $icao->name; ?> in <?php echo $icao->country; ?></small>
            </h3>
         </div>
      </a>
   </div>
  <div class="col-md-12">
    <div class="block">
      <div class="block-title">
        <h2><strong>Create</strong> Charter</h2>
      </div>

      <div class="alert alert-success">
      	<strong><h3>Attention</h3></strong>
      	Charter Operations allow you to fly to any corner of the world without being limited to the schedules. You need vMoney to buy charter flights.
      	Each charter flight cost is based upon the distance between them. This enforces the pilots to operate scheduled flights as well.
      	<br><br>
      	Enjoy your freedom in the virtual skies!
      </div>

      <div class="row">
      	<div class="col-md-6">
      	<form action="<?php echo url('/charter/process');?>" method="post" class="form-horizontal form-bordered">
           <div class="form-group">
            <label class="col-md-3 control-label" for="aircraft">Aircraft</label>
              <div class="col-md-6">
                <select class="form-control" id="aircraft" name="aircraft" required="required">
                <?php
                foreach($allaircraft as $aircraft) {
					echo '<option value="'.$aircraft->id.'" '.$sel.'>'.$aircraft->fullname.' ('.$aircraft->registration.')</option>';
                }
				?>
              </select>
              </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 control-label" for="depicao">Departure Airfield (ICAO)</label>
              <div class="col-md-6">
                <input id="depicao" name="depicao" placeholder="Enter Departure ICAO Code" class="airport_select form-control" maxlength="4" value="<?php echo $icao->icao;?>"required="required">
              </div>
          </div>


          <div class="form-group">
              <div class="col-md-12">
                <center>
                	<input type="button" class="btn btn-success btn-sm" id="go" onclick="swapValues()" value="Swap Airports">
                </center>
              </div>
          </div>


          <div class="form-group">
            <label class="col-md-3 control-label" for="arricao">Arrival Airfield (ICAO)</label>
              <div class="col-md-6">
                <input id="arricao" name="arricao" placeholder="Enter Arrival ICAO Code" class="airport_select form-control" maxlength="4" value="<?php echo $schedule->arricao;?>" required="required">
              </div>
          </div>

			<script>
			function swapValues(){
				var tmp = document.getElementById("depicao").value;
				document.getElementById("depicao").value = document.getElementById("arricao").value;
				document.getElementById("arricao").value = tmp;
			}
			</script>


			<center>
				<div class="form-group pull-center">
					<input type="submit" value="Process Charter" class="btn btn-sm btn-primary" />
					<a href="<?php echo SITE_URL; ?>/index.php/charter" class="btn btn-sm btn-danger">
						Back
					</a>
				</div>
			</center>
			</form>
      	</div>

      	<div class="col-md-6">
      		<div class="mapcenter" align="center">
         		<div id="routemap" style="width: 80%; height: <?php echo Config::Get('MAP_HEIGHT')?>"></div>
        	</div>


        	<br><br>
      	</div>
     </div>
    </div>
  </div>
</div>

<script src="<?php echo SITE_URL?>/lib/js/base_map.js"></script>
<script type="text/javascript">
   // Write the PIREP data out into JSON
   // The big reason being we don't need to have PHP writing JS - yuck
   const dep = JSON.parse('<?php echo json_encode($icao); ?>');
   const map = createMap({
   	zoom: 2,
   	render_elem: 'routemap',
   	provider: '<?php echo Config::Get("MAP_TYPE"); ?>',
   	center: [dep.latitude, dep.longitude],
   });


   const depCoords = L.latLng(dep.latitude, dep.longitude);
   selDepMarker = L.marker(depCoords).bindPopup(dep.name + " - " + dep.icao + ", "+ dep.country).addTo(map);

   //let points = [];


   //const selPointsLayer = L.geodesic([points], {
   //	color: 'black',
   //    weight: 5,
   //	opacity: .7,
   //	dashArray: '10,9',
   //	lineJoin: 'round'
   //}).addTo(map);

    var legend = L.control({position: 'bottomright'});

   	legend.onAdd = function (map) {

       var div = L.DomUtil.create('div', 'info legend');
           div.innerHTML = '<span class="label label-primary">Charter Operations Map</span> ';

       return div;
   	};

   	legend.addTo(map);

   map.fitBounds(selPointsLayer.getBounds());
</script>
