<?php
	Config::set('CHARTER_AIRPORT_REFRESH_TIME', 10000);
	Template::show('charter/header');
	$refreshtime = Config::get('CHARTER_AIRPORT_REFRESH_TIME');
?>
<script src="<?php echo SITE_URL?>/lib/js/base_map.js"></script>


<div class="row">
	<div class="col-md-12">
		<div class="block block-full">
			<ul class="nav-horizontal text-center" >
				<li>
					<a data-toggle="tab" href="#exploring"  class="themed-color-spring">
						EXPLORE
					</a>
				</li>
				<li>
					<a data-toggle="tab" href="#schedule"  class="themed-color-spring">
						I KNOW WHERE
					</a>
				</li>
				<br>
			</ul>
		</div>
	</div>


	<div class="col-md-12">
		<div class="block block-full">
			<div class="tab-content">

				<div id="default" class="tab-pane fade in active">
					<h3>
						<?php
							$welcome_message = CharterData::getSettingValue('welcome_message');
							if($welcome_message != '') {
								echo $welcome_message;
							} else {
								echo "What do you feel like doing today? Would you like to explore? Or do you know where exactly you want to fly?";
							}
						?>
					</h3>
				</div>


				<div id="exploring" class="tab-pane fade in">
					<div id="update_destination">

						<h3>
							Exploring? How about
							<?php

							$destination_tip = Charter::destination_tip();

							echo $destination_tip->icao.' in '.$destination_tip->city.', '.$destination_tip->country; ?>

							<img src="<?php echo Countries::getCountryImage($destination_tip->countrycode); ?>" style="height: 20px; width: auto;" />
						</h3>

						<a href="<?php echo url('charter/create/explore?icao=').$destination_tip->icao; ?>" class="btn btn-success btn-block">
							Charter to <?php echo $destination_tip->icao; ?>
						</a>

					</div>


					<script>
					$(document).ready(function(){
							setInterval(function(){
								$("#update_destination").load(window.location.href + " #update_destination" );
							}, <?php echo $refreshtime; ?>);
					});

					function update() {
						console.log("Updating destination...");
						$("#update_destination").load(window.location.href + " #update_destination" );
					}

					</script>



						<br><br>

						Doesn't feel like it? We've got the whole world.
						<br><br>
						<a onclick="update();" class="btn btn-block btn-primary btn-alt">
							Try another destination
						</a>


						<br><br>

				</div>


				<div id="schedule" class="tab-pane fade in">
						<h3>
							You know where you want to fly? Cool! We have <?php echo count($totalairports); ?> airports in our database ready for you.
						</h3>

						<a href="<?php echo url('charter/create'); ?>" class="btn btn-block btn-primary">
							Create Charter Flight
						</a>
						<br><br>

				</div>
			</div>
		</div>
	</div>


</div>

	<!--<div class="mapcenter" align="center">-->
	<!--							<div id="route_map" style="width: 80%; height: 500px"></div>-->
	<!--						</div>-->
						<script type="text/javascript">
						// Creating a new map element.
						const map = createMap({
							render_elem: 'route_map',
							center: [51.505, -0.09],
							provider: '<?php echo Config::Get("MAP_TYPE"); ?>',
						});

						</script>
