<?php Template::Show('charter/header.php'); ?>
<?php
$icao = 'CH';
$price = Auth::$userinfo->pilotid;
$count = SchedulesData::countCharterSchedules($icao, $price);
if($count < 30)
{
?>

<div class="row">
  <div class="col-md-12">
    <div class="block">
      <div class="block-title">
        <h2><strong>Create</strong> Charter</h2>
      </div>
      
        <form action="<?php echo url('/Charter/schedules');?>" method="post" class="form-horizontal form-bordered">
          <div class="form-group">
            <label class="col-md-3 control-label" for="code">Flight Type</label>
            <div class="col-md-3">
              <select class="form-control" id="code" name="code">
                <?php
                foreach($allairlines as $airline)
                {
								if($airline->code == "CH")
								{
									echo '<option value="'.$airline->code.'">'.$airline->name.'</option>';				    
								}
								else
								{
									continue;
								}
								}
								?>
              </select>
            </div>
          </div>
             
          <div class="form-group">
            <label class="col-md-3 control-label" for="name">Your ID:</label>
            <div class="col-md-3">
              <input type="text" class="form-control" id="name" placeholder="IGO<?php echo Auth::$userinfo->pilotid; ?>" disabled="">
            </div>
          </div> 
          
          
            <label for="price"></label>
            <input type="hidden" name="price" value="<?php $pilotid = PilotData::GetPilotCode(Auth::$userinfo->code, Auth::$userinfo->pilotid); echo Auth::$userinfo->pilotid; ?>" style="font-weight: 700" />
          
					
					<div class="form-group">
            <label class="col-md-3 control-label" for="flightnum">Flight #</label>
              <div class="col-md-3">
                    <input id="flightnum" name="flightnum" class="form-control"value="<?php echo $schedule->depicao;?>" />
                    <span class="help-block"><span class="text-danger">*</span> Enter an ID between 100 - 999</span>
              </div>  
          </div>
          
          <div class="form-group">
            <label class="col-md-3 control-label" for="depicao">Departure Airfield</label>
              <div class="col-md-3">
                <input id="depicao" name="depicao" class="airport_select form-control" value="<?php echo $schedule->depicao;?>" />
                <span class="help-block"><span class="text-danger">*</span> Enter a Valid Airfield only</span>
              </div>  
          </div>
        
          <div class="form-group">
            <label class="col-md-3 control-label" for="arricao">Arrival Airfield</label>
              <div class="col-md-3">
                <input id="arricao" name="arricao" class="airport_select form-control" value="<?php echo $schedule->arricao;?>" /> 
                  
              </div>  
          </div>
				
					<div class="form-group">
            <label class="col-md-3 control-label" for="deptime">Departure Time</label>
              <div class="col-md-3">
                  <input id="deptime" name="deptime" class="form-control" value="<?php echo $schedule->deptime?>" />
                  <span class="help-block"><span class="text-danger">*</span> HH:MM format in UTC</span>
              </div>  
          </div>
          
					<div class="form-group">
            <label class="col-md-3 control-label" for="arrtime">Arrival Time</label>
              <div class="col-md-3">
                   <input id="arrtime" name="arrtime" class="form-control" value="<?php echo $schedule->arrtime?>" />
                   
              </div>  
          </div>
					
					<div class="form-group">
            <label class="col-md-3 control-label" for="distance">Distance</label>
              <div class="col-md-3">
                <input id="distance" name="distance" class="form-control" value="<?php echo $schedule->distance?>" />
                <span class="help-block"><span class="text-danger">*</span> Distance in nm, enter 0 or leave blank to calculate Automatically</span>
              </div>  
          </div>
					
					<div class="form-group">
            <label class="col-md-3 control-label" for="flighttime">Flight Time</label>
              <div class="col-md-3">
                    <input id="flighttime" name="flighttime" class="form-control" value="<?php echo $schedule->flighttime?>" />
                    <span class="help-block"><span class="text-danger">*</span> HH:MM format</span>
                </div>  
          </div>	
					
					<div class="form-group">
            <label class="col-md-3 control-label" for="aircraft">Aircraft</label>
              <div class="col-md-3">
                <select class="form-control" id="aircraft" name="aircraft">
                <?php
                foreach($allaircraft as $aircraft)
                {
                  if($aircraft->registration == $schedule->registration)
									$sel = 'selected';
									else
									$sel = '';
									echo '<option value="'.$aircraft->id.'" '.$sel.'>'.$aircraft->fullname.' ('.$aircraft->registration.')</option>';
                  
                }
								?>
              </select>
              <span class="help-block"><span class="text-danger">*</span>Select Wandurlust Fleet if you're flying an aircraft other than the A320</span>
              </div>
          </div>
						
				  <div class="form-group">
            <label class="col-md-3 control-label" for="flightlevel">Cruise Alt</label>
              <div class="col-md-3">
                <input id="flightlevel" name="flightlevel" class="form-control" value="<?php echo $schedule->flightlevel?>" />
                <span class="help-block">Enter full Altitude to be accurrate with the ACARS Tracking Software (Optional)</span>
              </div>  
          </div>	
              
					<div class="form-group">
            <label class="col-md-3 control-label" for="route">Route</label>
              <div class="col-md-3">
                <textarea rows="3" class="form-control" placeholder="Route with DEPP/ARR " name="route" style="width: 100%; height: 75px; font-weight:700" id="route"><?php echo $schedule->route?></textarea>
                <span class="help-block">Optional</span>
              </div>  
          </div>
					
					<div class="form-group">
            <label class="col-md-3 control-label" for="notes">Notes</label>
              <div class="col-md-3">
                <textarea rows="9" class="form-control" placeholder="Charter Notes" name="notes" style="width: 100%; height: 150px; font-weight:700"><?php echo $schedule->notes?></textarea>
                <span class="help-block">Specify your Name and HUB</span>
              </div>  
          </div>	
						
				  <div class="form-group">
            <label class="col-md-4 control-label"><a href="#myModal" data-toggle="modal">Flight Status</a> <span class="text-danger">*</span></label>
              <div class="col-md-8">
                <label class="switch switch-primary" for="enabled">
                  <?php $checked = ($schedule->enabled==1 || !$schedule)?'CHECKED':''; ?>
                  <input type="checkbox" id="enabled" name="enabled" value="1">
                  <span data-toggle="tooltip" title="" data-original-title="I agree to the terms and activate this leg in bids"></span>
                </label>
              </div>
          </div>
				
					 <center>
					   <div class="form-group pull-center">
             <input type="hidden" name="action" value="<?php echo $action?>" style="font-weight: 700" />
							<input type="hidden" name="id" value="<?php echo $schedule->id?>" style="font-weight: 700" />
							<input type="hidden" id="<?php echo $route->id; ?>" class="addbid" name="addbid" value="<?php echo $route->id?>" style="font-weight: 700" />
						<input type="submit" value="<?php echo $title?>" class="btn btn-sm btn-primary" />
					
          </div>
					 </center>  
					
						
					</form>
					

<?php
}
elseif($count >= 30)
{
?>

<?php
}
?>
      
    </div>
  </div>
</div>
	
<div id="myModal" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title"><strong><?php echo SITE_NAME; ?></strong> | Charter Operations</h4>
      </div>
      <div class="modal-body">
      <p>1.0<br>You agree that you have supplied all the necessary information for creating a charter leg</p>
       <p>1.1<br>You acknowledge that only 30 Charter legs can be created and if you exhaust your limit, you may be charged credit for creating new set of Charters</p>
       <p>1.2<br><?php echo SITE_NAME; ?> Flight Operations department holds the rights to disable any leg if they find it to be inappropriate</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-info" data-dismiss="modal">Okay, i've read them</button>
      </div>
    </div>

  </div>
</div>


