<?php Template::Show('charter/header.php'); ?>

<?php
if ((Auth::$userinfo->totalhours)>MIN_HOURS)
{
  {}
}
else 
{
	$hours = MIN_HOURS - (Auth::$userinfo->totalhours);
  echo '<div class="alert alert-info">
  <h4><strong>Oh Snap, not there yet</strong></h4>
  Looks like you donot meet the requirements to operate Charters,You currently have <span class="text-success">'.Auth::$userinfo->totalhours.' hours</span> and you need <span class="text-success">'.round($hours).' hours</span> more.
  <br>See you soon....
</div>';
}
?>
<div class="block block-alt-noborder">
    <!-- Charters MainBlock Content -->
    <div class="row">
        <div class="col-md-6 col-lg-3 col-lg-offset-1">
            <div class="block-section">
                <h3 class="sub-header text-center"><strong><font face="bauhaus">Are you ready?</font></strong></h3>
                <p class="clearfix"><i class="fa gi gi-heart_empty fa-4x text-danger pull-left animation-pulse"></i>
                <span class="text-info">Anything</span>, <span class="text-success">Anytime</span>, <span class="text-warning">Anywhere</span>
                Happy Freedom from rosters!
                Your Aircraft awaits!
                </p><br><br><br>
                <?php if ((Auth::$userinfo->totalhours)>MIN_HOURS)
                {
                  $color = 'primary';
                }
                else 
                {
                 $disabled = 'disabled';
                 $color = 'default';
                }
                ?>
                <p>
                    <a href="<?php echo SITE_URL?>/index.php/charter/addschedule" class="btn btn-lg btn-<?php echo $color?> btn-block <?php echo $disabled?>"><i class="fa fa-send"></i> Go Charters</a>
                </p>
            </div>
        </div>
        <div class="col-md-6 col-lg-6 col-lg-offset-1">
            <!-- Charters Notifications -->
            <h3 class="sub-header"><strong>Charter</strong> Notification</h3>
          	<?php
											$bids = SchedulesData::getBids(Auth::$userinfo->pilotid);
											if(!$bids)
											{
											?>
												<div class="alert alert-info fade in">
												 <strong>Bonjour Captain!</strong> you haven't booked any charters yet!
												</div>											
											<?php	
											}
											else
											{
											?>
											
											<div class="alert alert-warning alert-dismissable fade in">
											  Hola Captain! You already have a <strong>charter</strong> in your Bids
											  <a href="<?php echo SITE_URL?>/index.php/schedules/bids">
											    <font face="Tahoma" style="font-size: 9pt; text-decoration:none" color="#015566">
											      (Take me there)
											    </font>
											 </a>
											</div>
											
											<?php
											}
											?>	
           	<!-- END Charters Notifications -->
        </div>
        <div class="col-md-6 col-lg-6 col-lg-offset-1">
            <!-- Intro Content -->
            <h3 class="sub-header">The <strong>Essentials</strong> </h3>
            <a class="btn btn-default btn-md" href="<?php echo SITE_URL?>/index.php/Downloads"> Livries</a>
            <a class="btn btn-default btn-md" href="<?php echo SITE_URL?>/index.php/Documentation">Rules</a> 
            <a class="btn btn-warning btn-md" href="<?php echo SITE_URL?>/index.php/helpdesk">Facing an issue? </a>
            <br><br>
        </div>
    </div>
    <!-- END FAQ Content -->
</div>
<!-- END FAQ Block -->
	<?php
      $icao = 'CH';
      $price = Auth::$userinfo->pilotid;
      $count = SchedulesData::countCharterSchedules($icao, $price);
      $remaining = 30 - $count;
    ?>
        <div class="block-options pull-right text-right">
            <span class="label label-success">(<?php echo $count?> / 30) charters created, you have <?php echo $remaining?> charters left!</span>
          </div>
          
    <?php
				$schedules = SchedulesData::findSchedules($params, $count = '', $start = '');
				foreach($schedules as $route)
				{
				if($route->price == Auth::$userinfo->pilotid && $route->code == 'CH')
				{
					if(Config::Get('DISABLE_SCHED_ON_BID') == true && $route->bidid != 0)
					{
						continue;
					}
		?>
	
    
<div class="row">
  <div class="col-md-12">
    <div class="block">
      <div class="block-title">
          
        <h2>Flight <i>ID</i> : <Strong><?php echo $route->code . $route->flightnum?></Strong></h2>
      </div>
    <div class="table-responsive">
      <table class="table table-responsive table-hover">
        <thead>
          <tr>
            <th>Departure</th>
            <th>Arrival</th>
            <th>Distance</th>
            <th>Duration</th>
            <th>Aircraft</th>
            <th>Status</th>
            <th>Options</th>
          </tr>
        </thead>
        <tbody>
        <tr>
            <td><?php echo $route->depicao?></td>
            <td><?php echo $route->arricao?></td>
            <td><?php echo $route->distance?> <i>nm</i></td>
            <td><?php echo $route->flighttime ?> <i>hrs</i></td>
            <td><?php echo $route->aircraft ?></td>
            <!--Donot edit beyond this-->
            <td><?php 
                  if($route->bidid != 0)
                  {
                    echo '<span class="text-success">On Bids</span>';
                  }
                  else 
                  {
                    echo '<span class="text-danger">Not on Bids</span>';
                  }
                ?>
            </td>
            <td>
              <a id="<?php echo $route->id; ?>" class="addbid btn btn-default" href="<?php echo url('/schedules/addbid');?>" data-toggle="tooltip" title="Bid this Flight">
              <i class="fa fa-paper-plane text-success"></i>
              </a>
              <a href="<?php echo SITE_URL?>/index.php/charter/editschedule?id=<?php echo $route->id?>" class="btn btn-default"  data-toggle="tooltip" title="Edit this Flight">
              <i class="fa fa-wrench text-warning"></i></a>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
    </div>  
  </div>
</div>

<!--DONT DELETE THESE-->	
<?php
}
?>


<?php
}
?>		