<?php
   Template::show('charter/header');
   ?>
<div class="row">
   <div class="col-md-12">
      <div class="block">
         <div class="block-title">
            <h3>Process <strong>Charter</strong></h3>
         </div>
         <?php
            $acspeed = $aircraft->maxspeed;
            if($acspeed == 0) {
            	$acspeed = '250';
            }
            $time = ($distance / $acspeed);

            $flightnumber = (rand(1000,9999));

            $cost = CharterData::getSettingValue('cost_per_mile') * $distance;
            $ticek_price = CharterData::getSettingValue('price_per_mile') * $distance;
            $charge_for_charter = CharterData::getSettingValue('charge_for_charter');
            ?>
         <div class="well">
            <p style="font-family: Calibri; text-transform: capitalize;">
               // <strong>CHARTER FLIGHT </strong> <?php echo strtoupper($departure->icao.' ('.$departure->name.')'); ?> TO <?php echo strtoupper($arrival->icao.' ('.$arrival->name.')'); ?> <br>
               // <strong>AIRCRAFT</strong> <?php echo $aircraft->icao; ?> <?php echo strtoupper($aircraft->fullname); ?> <br>
               // <strong>GC DISTANCE</strong> <?php echo $distance; ?>NM<br>
               // <strong>EET</strong> <?php echo $time; ?>HR<br>
               // <strong>Ticket price</strong> <?php echo $ticek_price; ?>$<br>
               <?php if($charge_for_charter == 1) { ?>
					// <strong>EST. COST</strong>  <?php echo Config::get('MONEY_UNIT'); ?><?php echo $cost; ?>
				<?php
				}
            	?>
            </p>
         </div>
         <!--<div class="mapcenter" align="center">-->
         <!--	<div id="routemap" style="width: 80%; height: <?php echo Config::Get('MAP_HEIGHT')?>"></div>-->
         <!--</div>-->
         <form action="<?php echo url('/charter/createFlight');?>" method="POST" class="form-horizontal form-bordered">

           <div class="form-group">
              <label class="col-md-3 control-label">Airline</label>
              <div class="col-md-3">
                <select class="form-control" name="code">
                  <option value="<?php echo CharterData::getCharterAirlineCode(); ?>"><?php echo CharterData::getCharterAirlineCode(); ?> (Charter Operations)</option>
                  <?php
                    foreach ($airlines as $airline) {
                      ?>
                      <option value="<?php echo $airline->code; ?>"><?php echo $airline->code; ?> (<?php echo $airline->name; ?>)</option>
                      <?php
                    }
                  ?>

                </select>
              </div>
           </div>


           <!-- <div class="form-group">
              <label class="col-md-3 control-label">Generated Callsign</label>
              <div class="col-md-3">
                 <input type="text" name="flightnum" class="form-control" value="<?php echo $flightnumber; ?>">
              </div>
           </div> -->

           <div class="form-group">
              <label class="col-md-3 control-label">Departure Time</label>
              <div class="col-md-3">
                 <div class="input-group bootstrap-timepicker">
                    <input type="text" name="deptime" id="dephour" class="form-control input-timepicker24">
                    <span class="input-group-btn">
                    <a href="javascript:void(0)" class="btn btn-success"><i class="fa fa-clock-o"></i></a>
                    </span>
                 </div>
              </div>
           </div>
            <div class="form-group">
               <label class="col-md-3 control-label">Arrival Time</label>
               <div class="col-md-3">
                  <div class="input-group bootstrap-timepicker">
                     <input type="text" name="arrtime" id="arrhour" class="form-control input-timepicker24">
                     <span class="input-group-btn">
                     <a href="javascript:void(0)" class="btn btn-md btn-danger"><i class="fa fa-clock-o"></i></a>
                     </span>
                  </div>
               </div>
            </div>
            <center>
               <div class="form-group pull-center">
                  <!-- Button trigger modal -->
                  <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#exampleModal">
                  Accept
                  </button>
                  <!-- Modal -->
                  <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                     <div class="modal-dialog" role="document">
                        <div class="modal-content">
                           <div class="modal-header">
                              <h4 class="modal-title" id="exampleModalLabel">
                                 <strong> Charter Flight Acceptance
                                 <br><small><?php echo SITE_NAME; ?> | Flight Operations</small>
                                 </strong>
                              </h4>
                           </div>
                           <div class="modal-body text-left">
                              <div class="well well-md">
                                 I, <?php echo Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname; ?> acknowledge  that
                                 my charter flight will be created with the above mentioned details against the flight number
                                 <?php echo $flightnumber; ?>.

                                 <?php if($charge_for_charter == 1) {
                                 	?>
                                	I accept the charge of <?php echo Config::get('MONEY_UNIT'); ?><?php echo $cost; ?> (vMoney) for
                                	this charter operation.
                                 	<?php
                                 }
                                 ?>

                                 I shall do my best to fly this flight at my earliest convenience.
                              </div>
                              <br>
                              Upon clicking "Accept" the system will
                              <br><br>
                              <ul class="fa-ul">
                                 <li><i class="fa fa-check fa-li text-success"></i>Create a custom schedule for the charter</li>
                                 <li><i class="fa fa-check fa-li text-success"></i>Add the flight to your bid list</li>
                                 <li><i class="fa fa-check fa-li text-success"></i>Re-direct you to flight briefing page</li>
                              </ul>
                           </div>
                           <div class="modal-footer">
                              <!-- <input type="hidden" name="code" value="<?php echo CharterData::getCharterAirlineCode(); ?>" /> -->
                              <input type="hidden" name="flightnum" value="<?php echo $flightnumber; ?>" />
                              <input type="hidden" name="aircraft" value="<?php echo $aircraft->id; ?>" />
                              <input type="hidden" name="depicao" value="<?php echo $departure->icao; ?>" />
                              <input type="hidden" name="arricao" value="<?php echo $arrival->icao; ?>" />
                              <input type="hidden" name="enabled" value="1" />
                              <input type="hidden" name="distance" value="<?php echo $distance; ?>" />
                              <input type="hidden" name="flighttype" value="P" />
                              <input type="hidden" name="flightlevel" value="30000" />
                              <input type="hidden" name="flighttime" value="<?php echo $time; ?>" />
                              <input type="hidden" name="notes" value="Charter Operation by <?php echo Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname; ?>" />
                              <input type="submit" value="Accept" class="btn btn-sm btn-primary" />
                              <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Close</button>
                           </div>
                        </div>
                     </div>
                  </div>
                  <a href="<?php echo SITE_URL; ?>/index.php/charter" class="btn btn-sm btn-danger">
                  Back
                  </a>
               </div>
            </center>
         </form>
      </div>
   </div>
</div>
<script src="<?php echo SITE_URL?>/lib/js/base_map.js"></script>
<script type="text/javascript">
   // Write the PIREP data out into JSON
   // The big reason being we don't need to have PHP writing JS - yuck
   const dep = JSON.parse('<?php echo json_encode($departure); ?>');
   const arr = JSON.parse('<?php echo json_encode($arrival); ?>');
   console.log(dep);
   const map = createMap({
   	zoom: 2,
   	render_elem: 'routemap',
   	provider: '<?php echo Config::Get("MAP_TYPE"); ?>',
   });


   const depCoords = L.latLng(dep.latitude, dep.longitude);
   selDepMarker = L.marker(depCoords).bindPopup(dep.name + " " + dep.icao + " You depart from here!").addTo(map);

   const arrCoords = L.latLng(arr.latitude, arr.longitude);
   selArrMarker = L.marker(arrCoords).bindPopup(arr.name + " " + arr.icao + " You will arrive here!").addTo(map);

   let points = [];
   points.push(depCoords);

   points.push(arrCoords);

   const selPointsLayer = L.geodesic([points], {
   	color: 'black',
       weight: 5,
   	opacity: .7,
   	dashArray: '10,9',
   	lineJoin: 'round'
   }).addTo(map);

    var legend = L.control({position: 'bottomright'});

   	legend.onAdd = function (map) {

       var div = L.DomUtil.create('div', 'info legend');
           div.innerHTML = '<span class="label label-primary">Charter Operations Map</span> ';

       return div;
   	};

   	legend.addTo(map);

   map.fitBounds(selPointsLayer.getBounds());
</script>
