<?php
/**
 * iCrew v4 Premium - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 *
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems.
 *
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Premium Services (with additions)
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 *
 */
?>
<!-- Blank Header -->
<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="gi gi-airplane"></i><Strong>CodeShare Flights</Strong><br><small> Flight Operations | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>
<ol class="breadcrumb breadcrumb-top">
  <li><a href="<?php echo SITE_URL; ?>/index.php"><i class="fa fa-home"></i></a></li>
  <li><a href="<?php echo SITE_URL; ?>/index.php/Schedules">Flight Operations</a></li>
  <li>CodeShares</li>
</ol>
<!-- END Blank Header -->

<!-- Example Block -->
<div class="row">
	<div class="col-md-12">
		<div class="block">
<!-- Example Title -->
<div class="block-title">
	<h2><i class="fa fa-planes"></i> Available<strong> CodeShares</strong></h2>
</div>
<!-- END Example Title -->

<!-- Example Content -->

<div class="row">

	<div class="">


        <?php
        foreach($codeshares as $route)
        {
            $route = SchedulesData::getScheduleDetailed($route->schedid);
            /* Uncomment this code if you want only schedules which are from the last PIREP that
                pilot filed */
            /*if(Auth::LoggedIn())
            {
                $search = array(
                    'p.pilotid' => Auth::$userinfo->pilotid,
                    'p.accepted' => PIREP_ACCEPTED
                );

                $reports = PIREPData::findPIREPS($search, 1); // return only one

                if(is_object($reports))
                {
                    # IF the arrival airport doesn't match the departure airport
                    if($reports->arricao != $route->depicao)
                    {
                        continue;
                    }
                }
            }*/

            /*
            Skip over a route if it's not for this day of week
            Left this here, so it can be omitted if your VA
             doesn't use this.

            Comment out these two lines if you don't want to.
            */

            /*	Check if a 7 is being used for Sunday, since PHP
                thinks 0 is Sunday */
            $route->daysofweek = str_replace('7', '0', $route->daysofweek);

            if(strpos($route->daysofweek, date('w')) === false)
                continue;

            /* END DAY OF WEEK CHECK */

            /*
            This will skip over a schedule if it's been bid on
            This only runs if the below setting is enabled

            If you don't want it to skip, then comment out
            this code below by adding // in front of each
            line until the END DISABLE SCHEDULE comment below

            If you do that, and want to show some text when
            it's been bid on, see the comment below
            */
            if(Config::Get('DISABLE_SCHED_ON_BID') == true && $route->bidid != 0)
            {
                continue;
            }
            /* END DISABLE SCHEDULE ON BID */


            /*	Skip any schedules which have aircraft that the pilot
                is not rated to fly (according to RANK), only skip them if
                they are logged in. */
            if(Config::Get('RESTRICT_AIRCRAFT_RANKS') === true && Auth::LoggedIn())
            {
                /*	This means the aircraft rank level is higher than
                    what the pilot's ranklevel, so just do "continue"
                    and move onto the next route in the list
                 */
                if($route->aircraftlevel > Auth::$userinfo->ranklevel)
                {
                    continue;
                }
            }

            /* THIS BEGINS ONE TABLE ROW */
        ?>

         <?php $cload = round($route->distance);
        	if($cload < 1000) {
        		$cload_clr = 'success';
        		$notes ='<small><span class="label label-success">SHORT HAUL</span></small>';
        	}
        	else if($cload < 2500) {
        		$cload_clr = 'success';
        		$notes ='<small><span class="label label-success">MEDIUM HAUL</span></small>';
        	}
        	else if($cload < 3500) {
        		$cload_clr = 'warning';
        		$notes ='<small><span class="label label-warning">LONG HAUL</span></small>';
        	}
        	else {
        		$cload_clr = 'danger';
        		$notes = '<small><span class="label label-danger">ULTRA LONG HAUL</span></small>';
        	}
        ?>


        <div class="col-md-4">
			<div class="block full">
				<center>
					<h3>
						<strong><?php echo $route->code.''.$route->flightnum; ?> <sup></sup></strong><br>
            <?php
              $cs = CodeShareData::get_codeshares($route->id);
              $op = CodeShareData::check_airline($cs->operator);
              $operator = $op->name;
            ?>
            <img src="<?php echo $op->image; ?>" style="height: 70px; width: auto;" />
            <h5>Operated by <?php echo $operator; ?></h5>
						<h6><?php echo $route->aircraft.' ('.$route->registration.')'; ?></h6>
						<span class="badge"><?php echo $route->flighttime; ?> Hrs</span> <?php echo $notes; ?>
					</h3>
				</center>
				<ul class="pager">
					<li class="previous"><a href="javascript:void(0)" data-toggle="tooltip" data-placement="top" title="" data-original-title="Departing @ <?php echo $route->deptime; ?> UTC"><?php echo $route->depicao; ?></a></li>
					<ul class="pagination text-center">
						<li>
							<?php
							# Don't allow overlapping bids and a bid exists
							if(Config::Get('DISABLE_SCHED_ON_BID') == true && $route->bidid != 0) {
								echo '<a id="'.$route->id.'" class="addbid" href="'.actionurl('/schedules/addbid').'">Add to Bid</a>';
								} else {
									if(Auth::LoggedIn()) { ?>
									<a onclick="setTimeout('window.location.href=\'<?php echo SITE_URL; ?>/index.php/schedules/brief/<?php echo $route->id; ?>\';', 2000); hotsnackbar('hsdone', 'Your bid has been added!'); play(); loadScheduleBrief();"  id="<?php echo $route->id; ?>" class="addbid" href="<?php echo url('/schedules/addbid'); ?>" data-toggle="tooltip" data-placement="top" title="" data-original-title="Add bid!"><i class="fa fa-plus"></i></a>
									<?php
									}
								}
							?>
						</li>

						<li><a href="<?php echo url('/schedules/details/'.$route->id);?>" target="_blank" data-toggle="tooltip" data-placement="top" title="" data-original-title="View flight info" ><i class="fa fa-info"></i></a></li>
					</ul>
					<li class="next"><a href="javascript:void(0)" data-toggle="tooltip" data-placement="top" title="" data-original-title="Arriving @ <?php echo $route->arrtime; ?> UTC"><?php echo $route->arricao; ?></a></li>
				</ul>

			</div>
		</div>

	<?php
     /* END OF ONE TABLE ROW */
    }
    ?>
</div>
<!-- /.box-body -->


<!-- END Example Content -->
</div>
<!-- END Example Block -->
<!--Snackbar-->





</div>
	</div>
</div>
	<!--snackbar(); -->
  <div id="snackbar"><strong>Success! </strong>Your bid has been added!</div>
<audio src="http://api.voicerss.org/?key=3cb117cb67c34a69986f4ffd768b21a8&hl=en-gb&src=your%20bid%20has%20been%20added" id="audio"></audio>
<!--END Snackbar-->
<!-- User Settings, modal which opens from Settings link (found in top right user menu) and the Cog link (found in sidebar user info) -->
<div id="flighbook" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header text-center">
                <h2 class="modal-title">Bon Voyage!</h2>
            </div>
            <!-- END Modal Header -->

            <!-- Modal Body -->
            <div class="modal-body">
                <center>
                	<i class="fa fa-check fa-5x text-success"></i>
                	<p>Flight Booked!</p>
                	<a href="<?php echo url('/schedules/brief/'.$route->id);?>" target="_blank"><span class="label animation-pulse"><button type="button" class="btn btn-alt btn-default">Go to Briefing</button></span></a>
                </center>
            </div>
            <!-- END Modal Body -->
        </div>
    </div>
</div>
<!-- END User Settings -->
<script>
   function play() {
        var audio = document.getElementById('audio');
        if (audio.paused) {
            audio.play();
            $('#play').removeClass('glyphicon-play-circle')
            $('#play').addClass('glyphicon-pause')
        }else{
            audio.pause();
            audio.currentTime = 0
            $('#play').addClass('glyphicon-play-circle')
            $('#play').removeClass('glyphicon-pause')
        }
    }
   </script>

   <script>

   $("document").ready(function() {
    setTimeout(function() {
        hotsnackbar('hsinfo', '<?php echo count($codeshares); ?> CodeShares loaded from database');
    },10);
	});
   </script>
