<?php 
/**
 * iCrew v4 LITE - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 * 
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other 
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems. 
 * 
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Intermediate Services (with additions) 
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 * 
 */
?>

<div class="widget-advanced widget-advanced-alt">
   <div class="widget">
      <div class="widget-advanced">
         <div class="widget-header text-center">
            <h3 class="widget-content widget-content-image widget-content-light clearfix">
               <a href="javascript:void(0)" class="widget-icon pull-right"><i class="fa fa-trophy"></i></a>
               <span class="themed-color-amethyst"> <strong><?php echo SITE_NAME ?></strong></span><br>
               <small> Credits & Partners </small>
            </h3>
         </div>
      </div>
   </div>
</div>

<div class="widget">
  <div class="widget-advanced widget-advanced-alt">
    <div class="widget-main">
      <h3> <strong>Credits</strong><br><small>The <strong>Pioneers</strong></small></h3>
      <div class="alert alert-info">
      		<p><?php echo SITE_NAME?> was made with <i class="fa fa-heart text-danger"></i> for all of it's Crew Members, but it would be lifeless without the contributions of the below mentioned people</p>
      </div>
      
      <div class="table-responsive">
        <table class="table table-hover">
        	<thead>
        		<th>Developer</th>
        		<th>Description</th>
        		<th>View</th>
        	</thead>
    <?php
        foreach($credits as $credit)
        { ?>
        	
        	<tbody>
        		<td>
        			<?php if($credit->image != '') 
        			{
        				echo '<img src="'.$credit->image.'" alt="'.$credit->name.'" style="max-height: 100px; max-width: 200px;" />';
        			}
        			?>
        		</td>
        		<td >
        			<?php  if($credit->description != '')
        			{
        				echo $credit->description;
        			} else {
        				echo 'No description provided, click the link to know more!';
        			}
        			?>
        		</td>
        		<td>
        			<?php if($credit->link != '')
        			{
        				echo '<a class="btn btn-md btn-default" href="'.$credit->link.'" target="_blank">'.$credit->name.'</a>';
        			}
        			else
        			{
        				echo 'Website not found :(';
        			}
        			?>
        		</td>
        	</tbody>
        <?php } ?>
		</table>
      </div>
    </div>
  </div>
</div>
		