<?php
/**
 * iCrew v4 LITE - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 *
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems.
 *
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Intermediate Services (with additions)
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 *
 */
?>
<div class="content-header">
    <div class="header-section">
        <h1><i class="fa fa-download"></i><Strong>Downloads</Strong><br><small>Crew Resources | <?php echo SITE_NAME ?> &copy; <?php echo date("Y");?></small></h1>
    </div>
</div>
<div class="row">
	<div class="col-md-12">
		<div class="block">
			<div class="block-title">
				<h3>Flight Operations <Strong>Essentials</Strong></h3>
			</div>
				<div class="row">
					<div class="col-sm-12">
						<div class="media-items animation-fadeInQuickInv">
							<div class="media-items-options text-right">
								<a target="_blank" href="https://smartcars.tfdidesign.com/central/download" class="btn btn-xs btn-alt btn-default"><i class="fa fa-download fa-2x"></i></a>
							</div>
							<div class="media-items-content">
								<i class="gi gi-radar fa-5x fa-spin"></i>
							</div>
							<h4>
								<strong>SmartCARS 3.0 Software</strong><br>
								<small> <?php echo SITE_NAME; ?> Flight Logging Software powered by TFDi Design SmartCARS v3.0 (Must have for flighttracking)</small><br><br>
							</h4>
						</div>
					</div>
					<div class="col-sm-12">
						<div class="media-items animation-fadeInQuickInv">
							<div class="media-items-options text-right">
								<a target="_blank" href="https://smartcars.tfdidesign.com/central/download" class="btn btn-xs btn-alt btn-default"><i class="fa fa-download fa-2x"></i></a>
							</div>
							<div class="media-items-content">
								<i class="gi gi-wifi fa-5x"></i>
							</div>
							<h4>
								<strong>SmartCARS 3.0 Software</strong><br>
								<small> <?php echo SITE_NAME; ?> Flight Logging Software powered by TFDi Design SmartCARS v3.0 (Old version of smartacars)</small><br><br>
							</h4>
						</div>
					</div>
					<div class="col-sm-6">
						<div class="media-items animation-fadeInQuickInv">
							<div class="media-items-options text-right">
								<a href="https://tfdidesign.com/smartcars/app.php?action=download&airlineid=<?php echo SMARTCARS_PURCHASE_ID; ?>&language=en-US" class="btn btn-xs btn-alt btn-default"><i class="fa fa-download fa-2x"></i></a>
							</div>
							<div class="media-items-content">
								<i class="gi gi-wifi fa-5x"></i>
							</div>
							<h4>
								<strong>SmartCARS 2.0 Software</strong><br>
								<small> <?php echo SITE_NAME; ?> Flight Logging Software powered by TFDi Design SmartCARS v2.0 (Old version of smartacars)</small><br><br>
							</h4>
						</div>
					</div>
					<div class="col-sm-6">
						<div class="media-items animation-fadeInQuickInv">
							<div class="media-items-options text-right">
								<a href="https://tfdidesign.com/dl.php?type=d&id=15" class="btn btn-xs btn-alt btn-default"><i class="fa fa-download fa-2x"></i></a>
							</div>
							<div class="media-items-content">
								<i class="fa fa-file fa-5x text-success"></i>
							</div>
							<h4>
								<strong>SmartCARS User Manual</strong><br>
								<small> smartCARS is an easy to use and modern virtual flight tracking application designed and developed by TFDi Design. Download this easy to read manual to know more. (Windows only)</small>
							</h4>
						</div>
					</div>
				</div>
		</div>
	</div>
</div>
<div class="row">
  <div class="col-md-6">
	<div class="block">
		<div class="block-title">
			<h3><strong>ACARS</strong> Configurations</h3>
		</div>
		  For XPlane Users on Apple platform, XACARS must be used to log flights.
      A configuration file is required for XACARS to log you inside. The file can be downloaded below
		  <a target="_blank" href="/downloads/XACARS.zip" class="btn  btn-sm btn-block btn-primary">
        ACARS Client (Windows, Mac, Linux)
      </a>
      <a target="_blank" href="<?php echo SITE_URL; ?>/action.php/ACARS/xacarsconfig" class="btn btn-sm  btn-block btn-primary">
        Download Configuration file
      </a>
      <br />
	</div>
</div>

<div class="col-md-6">
<div class="block">
  <div class="block-title">
    <h3><strong>Minimum</strong> Requirements</h3>
  </div>
  Make sure you have these installed, otherwise the ACARS trackers will not work.
  <ul>
    <li>Windows Vista or later</li>
    <li><a class="text-info" href="http://www.microsoft.com/en-us/download/details.aspx?id=30653">.NET Framework 4.5 </a></li>
    <li><a class="text-info" href="http://www.schiratti.com/dowson.html">FSUIPC</a> or <a class="text-info" href="https://tfdidesign.com/dl.php?type=d&id=22">XPUIPC</a> (For XPLANE Users)</li>
    <li><a class="text-info"  href="https://google.com/search?q=Visual C++ 2010 Libraries">Visual C++ 2010 Libraries</a></li>
    <li><a class="text-info" href="http://tfdidesign.com/dl.php?type=d&id=8">DirectX June 2010 Redistributable</a></li>
  </ul>
</div>
</div>

  <div class="col-md-12">
    <div class="block">
    <!-- Block Title -->
    <div class="block-title">
        <h2><i class="gi gi-cloud"></i> Available <strong>Downloads</strong></h2>
    </div>
    <!-- END Block Title -->
		<!---->
	<!-- Draggable Blocks Row -->
	<div class="row">
	<?php
		if(!$allcategories)
		{
		echo 'Do you wish to add something? Mail us at '.SITE_EMAIL.'';
		return;
		}
		?>
		<table class="table table-hover">
         	<thead>
	            <h4>
	            	<tr>
		               <th>Name</th>
		               <th>Description</th>
		               <th>Download</th>
	            	</tr>
	            </h4>
         	</thead>
         		<tbody>
		<?php
		foreach($allcategories as $category)
		{
		?>
		<?php
		# This loops through every download available in the category
			$alldownloads = DownloadData::GetDownloads($category->id);

				if(!$alldownloads)
				{
					echo 'There are no downloads under this category';
					$alldownloads = array();
				}
				?>

         	<?php
				foreach($alldownloads as $download)
				{
				?>
				<tr>
					<td><?php echo $download->name?></td>
					<td><?php echo $download->description?></td>
					<td><a href="<?php echo url('/downloads/dl/'.$download->id);?>"><button type="button" class="btn btn-md btn-primary">Download <i class="fa fa-download"></i></button></a></td>
				</tr>
				<?php
				}
				?>
				<?php
				}
				?>
				</tbody>
				</table>

	   </div>
	   <div class="alert alert-info">
			<h5><strong>Do you wish to add more?</strong></h5>
			Your contributions are more than welcome, please send us your requests to <?php echo SITE_EMAIL ?> and we will add them to the list with your credits.
		</div>
	</div>
  </div>
</div>
