<?php
	$pics = file_get_contents(SITE_URL.'/iCrew/backgrounds/backgrounds.txt'); //Take the contents from the file to the variable
	$pictures = explode(',',$pics); //Split it by ','
?>
<div class="row">
	<div class="col-md-12">
		<div class="widget">
			<div class="widget-advanced widget-advanced-alt">
				<div class="widget-header text-left">
					<img src="<?php echo $pictures[array_rand($pictures)]; ?>" alt="" class="widget-background animation-pulseSlow" style="width: 100%; height: auto;">
					<h3 class="widget-content widget-content-image widget-content-light clearfix">
						<span class="widget-icon pull-right">
							<i class="fa fa-calendar animation-pulse"></i>
						</span>
						Events<strong>Center</strong><br><small><?php echo SITE_NAME; ?> | <?php echo VA_TAGLINE; ?></small><br>
					</h3>
				</div>

				<div class="row text-center">
					<div class="col-xs-12 push-inner-top-bottom border-right">
						<h2 class="h5 text-info text-uppercase push"><strong>EVENT # <?php echo $event->id; ?></strong></h2>
						<h3 class="widget-heading">
							&quot;<?php echo $event->title; ?>&quot;
						</h3>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-md-12">
		<div class="block">
			<div class="block-title">
				<div class="block-options pull-right">
					<?php
						$imailmessage='Hey, did you see the new event? I am intrested to fly for that with you. Checkout this link and book your slot %0D%0A %0D%0A'.SITE_URL.'/index.php/events/get_event?id='.$event->id.' %0D%0A %0D%0A <br> <br>Regards, <br>%0D%0A'.Auth::$userinfo->firstname.'';
						$imaillink = SITE_URL.'/index.php/Mail/newmail?subject=Group Flight Invite&message='.$imailmessage.'';
					?>
					<!--<a href="<?php echo $imaillink; ?>" class="btn btn-effect-ripple btn-danger" data-toggle="tooltip" title="" style="overflow: hidden; position: relative;" data-original-title="Invite Pilots via iMail"><i class="fa fa-user-plus"></i></a>-->
				</div>
				<h2><i class="fa fa-calendar-o"></i> <?php echo date('d F Y', strtotime($event->date)); ?></h2>
			</div>
		<article class="article-story">
		<div class="row">
			<div class="col-md-12 text-center">
				<div class="gallery animation-fadeInQuick2" data-toggle="lightbox-gallery">
					<div class="row">
						<style>
							.img-rounded-corners {
								border-radius: 5px;
							}
						</style>
						<div class="col-md-12 gallery-image">
							<?php
								if($event->image == '') {
									$image = SITE_URL.'/iCrew/404.png';
								} else {
									$image = $event->image;
								}
							?>
							<img src="<?php echo $image; ?>" style="width: 500px; height: auto;" alt="Event poster" class="img-rounded-corners">
							<div class="gallery-image-options text-center">
								<div class="btn-group btn-group-sm">
									<br /><br />
									<a href="<?php echo $image; ?>" class="gallery-link btn btn-sm pull-center btn-alt btn-default" title="<?php echo $event->title; ?>">View Full</a>
								</div>
							</div>
						</div>
					</div>
				</div>
				<h3>Event <strong>description</strong></h3>
				<blockquote class="blockquote text-left">
					 <?php echo $event->description; ?>
				</blockquote>
				<hr>
				<div class="block-section text-center">
				<?php
					$message = 'Captain '.Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname.' is flying for the '.$event->title.' event organized by '.SITE_NAME.'. If you are intrested to join the event, sign up as a Virtual Pilot Now!';
					$tmessage = 'Captain '.Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname.' is flying for the '.$event->title.' event organized by '.SITE_NAME.'. If you are intrested to join the event, sign up as a Virtual Pilot Now! %23virtualairline %emiratesvirtual %23pilot';
					$fblink = ' http://www.facebook.com/sharer/sharer.php?u='.SITE_URL.'&quote='.$message.'';
					$twitterlink = 'https://twitter.com/intent/tweet?text='.$tmessage.'';
					$gplus = 'https://plusone.google.com/_/+1/confirm?hl=en&url='.SITE_URL.'&title=_TITLE_';
				?>
				<a target="_blank" href="<?php echo $imaillink; ?>" class="btn btn-effect-ripple btn-block btn-danger" data-toggle="tooltip" title="" style="overflow: hidden; position: relative;" data-original-title="Invite Pilots via iMail">Invite your friends to fly via iMail</a>
				<br>
				<a target="_blank" href="<?php echo $fblink; ?>" class="btn btn-effect-ripple btn-default" data-toggle="tooltip" title="" style="overflow: hidden; position: relative;" data-original-title="Share about event on Facebook"><i class="fa fa-facebook"></i></a>
				<a target="_blank" href="<?php echo $twitterlink; ?>" class="btn btn-effect-ripple btn-default" data-toggle="tooltip" title="" style="overflow: hidden; position: relative;" data-original-title="Share about event on Twitter"><i class="fa fa-twitter"></i></a>
				</div>
				</div>

		</div>
			<?php
			$flightinfo = SchedulesData::getProperFlightNum($event->schedule);
			$schedule = SchedulesData::getScheduleByFlight($flightinfo['code'], $flightinfo['flightnum']);
			//print_r($schedule); ?>
	<div class="row">
		<div class="col-md-12">
			<div class="mapcenter" align="center">
			   <div id="route_map" style="width: 80%; height: 500px"></div>
			</div>

			<style>
			   .leaflet-pulsing-icon {
			   border-radius: 100%;
			   box-shadow: 1px 1px 8px 0 rgba(0,0,0,0.75);
			   }
			   .leaflet-pulsing-icon:after {
			   content: "";
			   border-radius: 100%;
			   height: 300%;
			   width: 300%;
			   position: absolute;
			   margin: -100% 0 0 -100%;
			   }
			   @keyframes pulsate {
			   0% {
			   transform: scale(0.1, 0.1);
			   opacity: 0;
			   -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
			   filter: alpha(opacity=0);
			   }
			   50% {
			   opacity: 1;
			   -ms-filter: none;
			   filter: none;
			   }
			   100% {
			   transform: scale(1.2, 1.2);
			   opacity: 0;
			   -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
			   filter: alpha(opacity=0);
			   }
			   }
			</style>
			<script src="<?php echo SITE_URL?>/lib/js/base_map.js"></script>
			<script src="https://rawgit.com/mapshakers/leaflet-icon-pulse/master/src/L.Icon.Pulse.js"></script>
			<link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.0.6/dist/MarkerCluster.css" />
			<link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.0.6/dist/MarkerCluster.Default.css" />
			<script src="https://unpkg.com/leaflet.markercluster@1.0.6/dist/leaflet.markercluster.js"></script>
			<script src="https://iosphere.github.io/Leaflet.hotline/dist/leaflet.hotline.js"></script>
			<script type="text/javascript">
			   // Creating a new map element.
			   const map = createMap({
			   	render_elem: 'route_map',
			   	provider: '<?php echo Config::Get("MAP_TYPE"); ?>',
			   });

			   	function get_api_request(yourUrl){
			   		var Httpreq = new XMLHttpRequest();
			   		Httpreq.open("GET",yourUrl,false);
			   		Httpreq.send(null);
			   		return Httpreq.responseText;
			   	}

					var current_location = "<?php echo SITE_URL; ?>/action.php/schedules/current_location_api";

					var current_location = JSON.parse(get_api_request(current_location));

					var pulsingIcon_currentlocation = L.icon.pulse({
						iconSize: [12,12],
			            fillColor: 'red',
			            color: 'red',
			            animate: true,
			            heartbeat: 1
					});

					var current_location_pulsing_marker = L.marker([current_location.lat, current_location.lng],{icon: pulsingIcon_currentlocation}).bindTooltip("You are at " + current_location.name).addTo(map);


			   	 var legend = L.control({position: 'bottomright'});
			   legend.onAdd = function (map) {

			      var div = L.DomUtil.create('div', 'info legend');
			          div.innerHTML = '<img src="<?php echo SITE_URL; ?>/iCrew/favicon.png" style="width: 50px; height: auto;" />';
			      return div;
			   };
			   legend.addTo(map);

			    // Flight Map Altitudes
				var hotlineOptions = {
					min: 0,
					max: 41000,
					palette: {
						0.1: '#f2ff00',
						0.3: '#73ff00',
						0.5: '#00ff80',
						0.7: '#00d5ff',
						0.8: '#0004ff',
						1.0: '#7b00ff',
			        },
			        weight: 3,
			        outlineColor: '#000000',
			        outlineWidth: 1,
				};


			   //Initializing Cluster Group
			   var markersLayer = new L.LayerGroup();
			   var markers = L.markerClusterGroup();
			   map.addLayer(markersLayer);

			   	var eventdata = '<?php echo json_encode($event); ?>';
			   	var departure = JSON.parse(get_api_request("<?php echo SITE_URL; ?>/action.php/pireps/airportdata_api/<?php echo $event->dep; ?>"));
			   	var marker = L.marker([departure.lat, departure.lng]).bindTooltip(departure.icao +" "+ departure.name).addTo(map);

			   	var arrival = JSON.parse(get_api_request("<?php echo SITE_URL; ?>/action.php/pireps/airportdata_api/<?php echo $event->arr; ?>"));
			   	var marker = L.marker([arrival.lat, arrival.lng]).bindTooltip(arrival.icao +" "+ arrival.name).addTo(map);


			   var depCoords = new L.LatLng(departure.lat, departure.lng);
			   var arrCoords = new L.LatLng(arrival.lat, arrival.lng);


			   let points = []; // For Waypoints when there is no "RawData"
			   points.push(depCoords);
			   points.push(arrCoords);

			   const selPointsLayer = L.geodesic([points], {
			   color: 'black',
			      weight: 2,
				opacity: 1,
			   }).addTo(map);
				
				map.fitBounds(selPointsLayer.getBounds());
			</script>

		</div>
		<div class="col-md-6">
			<a target="_blank" href="<?php echo SITE_URL; ?>/index.php/airports/get_airport?icao=<?php echo $event->dep; ?>" class="widget widget-hover-effect2">
				<div class="widget-simple">
					<div class="widget-content text-center">
						<h3 class="widget-heading text-success">
							<strong><?php echo $event->dep; ?></strong><small>Departure</small>
						</h3>
					</div>
				</div>
			</a>
		</div>
		<div class="col-md-6">
			<a target="_blank" href="<?php echo SITE_URL; ?>/index.php/airports/get_airport?icao=<?php echo $event->arr; ?>" class="widget widget-hover-effect2">
				<div class="widget-simple">
					<div class="widget-content text-center">
						<h3 class="widget-heading text-danger">
							<strong><?php echo $event->arr; ?></strong><small>Arrival</small>
						</h3>
					</div>
				</div>
			</a>
		</div>
		<div class="col-md-12">

			<?php
				if($event->schedule == '') {
					$link = 'javascript::void(0)';
					$disabled = "disabled";
					$target_blank = "";
					$text = 'Oops! Schedule not found. Contact admins';
					$color = 'muted';
				} else {
					$link = SITE_URL.'/index.php/schedules/bidSchedule/'.$event->schedule;
					$disabled = "";
					$target_blank = "target='_blank'";
					$text = 'Click to bid schedule #'.$event->schedule.'';
					$color = 'info';
				}
			?>
			 <a <?php echo $target_blank; ?> href="<?php echo $link; ?>" class="widget themed-background-<?php echo $color; ?> widget-hover-effect4" <?php echo $disabled; ?>>
				<div class="widget-simple">
					<div class="widget-content-light text-center">
						<i class="fa fa-3x fa-plane push-bit"></i><br>
							<?php echo $text; ?>
					</div>
				</div>
			</a>
		</div>


	</div>

	<div class="col-md-12">
		<?php
			$signups = EventsData::get_signups($event->id);
			$availslots = ($event->slot_limit) - (count($signups));
			$percent = round(($availslots / $event->slot_limit) / 100);
			if($percent == 0) {
				$percent = 1;
			}
		?>

		<div class="alert alert-warning">
			There are <?php echo $availslots; ?> out of <?php echo $event->slot_limit; ?> departure slot(s) available at an interval of <?php echo $event->slot_interval; ?> minutes for this event.
		</div>

		<div class="progress progress-striped active">
			<div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $percent; ?>%"></div>
		</div>
	</div>
	<table class="table">
		<tbody>
			<?php
        if(!Auth::LoggedIn()) {
            ?>
        <tr>
            <td align="left">
    <?php
    $count=0;
                    if (!$signups) {
                        echo 'No Signups';
                    }
                    else {
                        foreach ($signups as $signup) {
                            $pilot = PilotData::getPilotData($signup->pilot_id);
                            echo date('G:i', strtotime($signup->time)).' - ';
                            echo PilotData::GetPilotCode($pilot->code, $pilot->pilotid).' - ';
                            echo $pilot->firstname.' '.$pilot->lastname.'<br />';
                            $count++;
                        }
                    }
                    ?>
            </td>
        </tr>
                    <?php
                }
                else { ?>
        <tr>
    <?php
            $check = EventsData::check_signup(Auth::$userinfo->pilotid, $event->id);
            if($check->total >= '1') {
        echo '<tr><td align="left">';
                    $slot_time = strtotime($event->time);
                    $slots=1;
                    while ($slots <= $event->slot_limit):
                        $test = date('G:i',$slot_time);
                        $check2 = EventsData::signup_time($event->id, $test);
                        if(!$check2) {
                        	 echo '<a class="btn btn-default" href="javascript::void(0);" disabled>
                            Slot # '.$slots.' - Departing '.date('G:i', $slot_time).' UTC</a>
                            <br />';
                            $slots++;
                        }
                        else {
                            $pilot = PilotData::getPilotData($check2->pilot_id);

                            echo '<a class="btn btn-primary">';
                            echo date('G:i', $slot_time).' - ';
                            echo PilotData::GetPilotCode($pilot->code, $pilot->pilotid).' - ';
                            echo $pilot->firstname.' '.$pilot->lastname;
														echo '</a>';
                            if($pilot->pilotid == Auth::$pilotid)
                            {
															echo "   <span class='text-success'>(Your slot!)</span>";
															echo '  <a class="label label-danger label-xs" href="'.SITE_URL.'/index.php/events/remove_signup?id='.$pilot->pilotid.'&event='.$event->id.'">Click here to cancel this slot</a>';
                            }

                            echo '<br />';
                        }
                        $slot_time = $slot_time + ($event->slot_interval * 60);

                    endwhile;
                    echo '</td></tr>';
                }
                else {
                   echo '<tr><td align="left">';
                    $slot_time = strtotime($event->time);
                    $slots=1;
                    while ($slots <= $event->slot_limit):
                        $test = date('G:i',$slot_time);
                        $check2 = EventsData::signup_time($event->id, $test);
                        if(!$check2) {
                            echo '<a class="btn btn-success btn-effect-ripple" href="'.SITE_URL.'/index.php/events/signup?eid='.$event->id.'&pid='.Auth::$userinfo->pilotid.'&time='.date('G:i', $slot_time).'">
                            Slot # '.$slots.' - Departing '.date('G:i', $slot_time).' UTC</a>
                            <br />';
                            $slots++;
                        }
                        else {
                            $pilot = PilotData::getPilotData($check2->pilot_id);
                            echo date('G:i', $slot_time).' - ';
                            echo PilotData::GetPilotCode($pilot->code, $pilot->pilotid).' - ';
                            echo $pilot->firstname.' '.$pilot->lastname.'<br />';
                        }
                        $slot_time = $slot_time + ($event->slot_interval * 60);

                    endwhile;
                    echo '</td></tr>';
                    ?>
        </tr>
                    <?php
                }
            }
            ?>
		</tbody>
    </table>
</article>

</div>
</div>
</div>
