<?php
	$pics = file_get_contents(SITE_URL.'/iCrew/backgrounds/backgrounds.txt'); //Take the contents from the file to the variable
	$pictures = explode(',',$pics); //Split it by ','
?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@5.2.0/main.css" integrity="sha256-ejA/z0dc7D+StbJL/0HAnRG/Xae3yS2gzg0OAnIURC4=" crossorigin="anonymous">
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.2.0/main.min.js" integrity="sha256-izRz5kNrZijklla/aBIkhdoxtbRpqQzHaaABtK0Tqe4=" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.2.0/locales-all.min.js" integrity="sha256-lzGk5yFyeVNNegd9br6MXZUXLeMoy1xV5N/k71kFXbw=" crossorigin="anonymous"></script>

<div class="row">
	<div class="col-md-12">
		<div class="widget">
			<div class="widget-advanced widget-advanced-alt">
				<div class="widget-header text-left">
					<img src="<?php echo $pictures[array_rand($pictures)]; ?>" alt="" class="widget-background animation-pulseSlow" style="width: 100%; height: auto;">
					<h3 class="widget-content widget-content-image widget-content-light clearfix">
						<span class="widget-icon pull-right">
							<i class="fa fa-calendar animation-pulse"></i>
						</span>
						Events<strong> Center</strong><br><small>Events & Tours Department | <?php echo SITE_NAME; ?> &copy; <?php echo date("Y"); ?></small><br>
					</h3>
				</div>
			<div class="widget-main">
				<div class="row text-center">
					<div class="col-xs-6 push-inner-top-bottom border-right">
						<h2 class="h5 text-info text-uppercase push"><strong>Total Events</strong></h2>
						<h3 class="widget-heading">
							<?php $totalevents = EventsData::get_events(); echo count($totalevents); ?>
						</h3>
					</div>
				<div class="col-xs-6 push-inner-top-bottom">
					<h2 class="h5 text-danger text-uppercase push"><strong>Next Event</strong></h2>
						<h3 class="widget-heading">
							<?php
								function get_upcoming_event() {
									$query = "SELECT * FROM ".TABLE_PREFIX."events
									WHERE date >= NOW()
									ORDER BY date ASC LIMIT 1";
								return DB::get_results($query);
								}

								$upcomingevent = get_upcoming_event();
								if(!$upcomingevent) {
								echo '<small>No events published, do you wanna <a href="#" class="text-primary" data-toggle="modal" data-target="#eventsSuggestionModal"><i>suggest?</i></a></small>';
								}
								else {
								foreach ($upcomingevent as $upce) {
								echo $upce->title;
								}
								}
							?>
						</h3>
				</div>
				</div>
			</div>
		</div>
	</div>
<!-- Modal -->
<div class="modal fade" id="eventsSuggestionModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h3 class="modal-title" id="exampleModalLabel">Suggest an <strong>event</strong><br />
					<small>We would love to take your suggestion, <?php echo Auth::$userinfo->firstname; ?></small>
				</h3>
      </div>
      <div class="modal-body">
        <form id="suggestion_form" class="form" action="" method="POST" onsubmit="send(event,this)">
					<div class="form-group">
						Where do you think we could have this <strong>event</strong>?<br />
						<input type="text" class="form-control" name="where" value="<?php echo Auth::$userinfo->hub; ?> Airport" required/>
					</div>

					<div class="form-group">
						What tye of event is this?<br />
						<select class="form-control" name="type" required>
							<option value="Group Flight">
								Group Flight
							</option>
							<option value="Fly IN / Fly OUT">
								Fly IN / Fly OUT
							</option>
							<option value="Special Operations">
								Special Operations
							</option>
							<option value="Other">
								Other VA (mention VA name in message)
							</option>
						</select>
					</div>

					<div class="form-group">
						<strong>When</strong> would you want to have it?
						<input type="date" class="form-control" name="when" required/>
					</div>

					<div class="form-group">
						Is it organized by a network/group/another VA? (We will be open to partner with them)<br />
						<select class="form-control" name="network" required>
							<option value="No Network">
								No
							</option>
							<option value="IVAO">
								IVAO
							</option>
							<option value="VATSIM">
								VATSIM
							</option>
							<option value="POSCON">
								POSCON
							</option>
							<option value="VIRTUAL AIRLINE">
								Other VA (mention VA name in message)
							</option>
						</select>
					</div>

					<div class="form-group">
						Your message to our staff. Tell us why you think this event would be a success.
						<br />
						<textarea class="form-control" name="message" rows="3" required>Tell us! We're eage</textarea>
					</div>


      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="submit" class="btn btn-primary">Send Suggestion</button>
				</form>
      </div>
    </div>
  </div>
</div>

<script>
function send(e,form) {
	e.preventDefault();
	$('#eventsSuggestionModal').modal('hide');
	$.ajax({
         type: 'POST',
         url: "<?php echo url('events/s'); ?>",
         data: $('#suggestion_form').serialize(),
         success: function(response) {
					 $.bootstrapGrowl("<h4>iCrew <strong>Notifications </strong> </h4> Yay! We sent your event suggestion. Thank you so much.", {
 						ele: 'body', // which element to append to
 						type: 'success', // (null, 'info', 'danger', 'success')
 						offset: {from: 'top', amount: 20}, // 'top', or 'bottom'
 						align: 'right', // ('left', 'right', or 'center')
 						width: 250, // (integer, or 'auto')
 						delay: 15000, // Time while the message will be displayed. It's not equivalent to the *demo* timeOut!
 						allow_dismiss: false, // If true then will display a cross to close the popup.
 						stackup_spacing: 10 // spacing between consecutively stacked growls.
 						});
         },
        error: function() {
					$.bootstrapGrowl("<h4>iCrew <strong>Notifications </strong> </h4> Whoops! Something went wrong. Please contact us through available alternate channels.", {
 						ele: 'body', // which element to append to
 						type: 'danger', // (null, 'info', 'danger', 'success')
 						offset: {from: 'top', amount: 20}, // 'top', or 'bottom'
 						align: 'right', // ('left', 'right', or 'center')
 						width: 250, // (integer, or 'auto')
 						delay: 15000, // Time while the message will be displayed. It's not equivalent to the *demo* timeOut!
 						allow_dismiss: true, // If true then will display a cross to close the popup.
 						stackup_spacing: 10 // spacing between consecutively stacked growls.
 						});
        }
     });
}
</script>
<script>

      document.addEventListener('DOMContentLoaded', function() {
        var calendarEl = document.getElementById('calendar');
        var calendar = new FullCalendar.Calendar(calendarEl, {
					// plugins: [ 'interaction', 'dayGrid', 'timeGrid', 'list' ],
						header: {
							left: 'prev,next today',
							center: 'title',
							right: 'dayGridMonth,timeGridWeek,timeGridDay,listMonth'
						},
          initialView: 'dayGridMonth',
					defaultDate: '2019-08-16',
					buttonIcons: true, // show the prev/next text
					weekNumbers: false,
					navLinks: false, // can click day/week names to navigate views
					editable: false,
					eventLimit: false, // allow "more" link when too many events
					events: <?php echo $allevents; ?>,

						eventClick: function(info) {
							renderModal(info.event);
							$('#eventModal').modal('show');
  				}
        });
        calendar.render();
      });

			function renderModal(event) {
				document.getElementById("event_name").innerHTML = event.title;
				document.getElementById("event_description").innerHTML = event.extendedProps.description;
				document.getElementById("event_link").href = "events/view/" + event.id;
			}

			function modifyEvent(event) {
				$('#eventModal').modal('show');
			}

      </script>

			<?php
				// $date = date('Y-m-d');
	      // $query = "SELECT * FROM ".TABLE_PREFIX."events
	      //         WHERE date >= '$date'
	      //         ORDER BY date DESC";
				//
				// print_r($query);
				// $query = DB::get_results($query);
				// print_r($query);
			?>
			<div class="modal fade" id="eventModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
         <div class="modal-dialog" role="document">
            <div class="modal-content">
               <div class="modal-header">
                  <h3 class="modal-title" id="exampleModalLabel"><span id="event_name">Not passed</span> <br><small><span class="text-muted">View Calendar Event</span></small></h2>
               </div>
               <div class="modal-body">
                  <blockquote class="blockquote text-left">
                     <span id="event_description">
                  </blockquote>
                  <hr>
									<a href="#" id="event_link" class="btn btn-primary btn-block">Take a look</a>
               </div>
               <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
               </div>
            </div>
         </div>
      </div>
<div class="col-md-6">
	<div class="block">
		<div class="block-title">
			<h3><strong>Events</strong> Calendar</h3>
		</div>
		<div id="calendar"></div>
		<br />
	</div>
</div>
<div class="col-md-6">
		<div class="block">
			<div class="block-title">
				<h3>The <strong>Events</strong> Timeline</h3>
			</div>
			<div class="timeline block-content-full">
				<?php
					//Getting the Events
					$pastevents = EventsData::get_past_events();
					$upcomingevents = EventsData::get_upcoming_events();
					//For each event, we are going to have 3 entries
					//1. Event published, 2. Events Details (5 days prior to event date), 3. Event Succes or Not.
				?>
				<div style="overflow: auto; height: 430px; border: 0px solid #666; margin-bottom: 20px; padding: 5px; padding-top: 0px; padding-bottom: 20px;">
					<ul class="timeline-list">
					<?php
						if($upcomingevents) {
							foreach ($upcomingevents as $upcomingevent) {
							?>
							<li>
							<div class="timeline-time"><span class="text-muted text-center"><small><?php echo date(DATE_FORMAT, strtotime($upcomingevent->date)); ?></small></span></div>
							<div class="timeline-icon themed-background-fire themed-border-fire"><i class="fa fa-calendar-o"></i></div>
							<div class="timeline-content">
							<p class="push-bit">
								<strong>
									We have an upcoming event called
									<a class="animation pulseSlow" href="<?php echo SITE_URL; ?>/index.php/events/get_event?id=<?php echo $upcomingevent->id; ?>"><?php echo $upcomingevent->title; ?></a>. Click to sign up.
								</strong>
							</p>
							<?php
								if($upcomingevent->description)
									{
										echo "&quot;".$upcomingevent->description."&quot;";
									}
							?>
							<?php if($upcomingevent->image !== 'none') {
								?>
							<div class="row">
								<div class="col-sm-6 col-md-4 block-section">
									<br>
									<div class="gallery-image-container animation-fadeInQuick2" data-category="travel">
										<img src="<?php echo $upcomingevent->image; ?>" width="100%" height="auto;" alt="<?php echo $upcomingevent->title; ?>">
										<a href="<?php echo $upcomingevent->image; ?>" class="gallery-image-options" data-toggle="lightbox-image" title="<?php echo $upcomingevent->title; ?>">
											<h2 class="text-light"><strong>View event poster</strong></h2>
											<i class="fa fa-search-plus fa-3x text-light"></i>
										</a>
									</div>
								</div>
							</div>
							<?php } ?>
							</div>
							</li>
						<?php
						}
					}


						if(count($pastevents) > 0) {
						foreach ($pastevents as $pastevent) {
							//Number of Pilots who flew (Event Status : Success / Failure).
							$signups = EventsData::get_signups($pastevent->id);
							if($signups) {
							$eventsts = 'Success';
							?>
								<li>
									<div class="timeline-time"><span class="text-muted text-center"><small><?php echo date(DATE_FORMAT, strtotime($pastevent->date)); ?></small></span></div>
									<div class="timeline-icon"><i class="fa fa-info text-success"></i></div>
									<div class="timeline-content">
									<p class="push-bit"><strong><?php echo $pastevent->title; ?></strong> - Event Over, Status : <strong><span class="text-success">Success</span></strong></p>
									<p class="push-bit"><?php echo count($signups); ?> pilots flew for this event! </p>
									<?php

									foreach($signups as $signup) {
										$eventpilotdetail = PilotData::getPilotData($signup->pilot_id);
										$signupimage = PilotData::getPilotAvatar($signup->pilot_id);
										?>
										<a href="javascript:void(0)" data-toggle="tooltip" data-placement="top" title="" style="overflow: hidden; position: relative;" data-original-title="Pilot Name : <?php echo $eventpilotdetail->firstname.' '.$eventpilotdetail->lastname; ?>">
											<img src="<?php echo $signupimage; ?>" alt="Unable to get image" height="100" class="img-circle push-bit">
										</a>
										<?php
									}
									?>

									</div>
								</li>


							<?php } else { ?>
								<li>
									<div class="timeline-time"><span class="text-muted text-center"><small><?php echo date(DATE_FORMAT, strtotime($pastevent->date)); ?></small></span></div>
									<div class="timeline-icon"><i class="fa fa-info text-danger"></i></div>
									<div class="timeline-content">
									<p class="push-bit"><strong><?php echo $pastevent->title; ?></strong> - Event Over, Status : <strong><span class="text-danger">Failure</span></strong></p>
									<p class="push-bit">No Pilots flew for this event :( </p>
									</div>
								</li>

							<?php
								}
							?>
							<li>
							<div class="timeline-time"><span class="text-muted text-center"><small><?php echo date(DATE_FORMAT, strtotime($pastevent->date)); ?></small></span></div>
							<div class="timeline-icon"><i class="fa fa-plane text-warning"></i></div>
							<div class="timeline-content">
							<p class="push-bit">
								<strong>
									New event added by Events manager
									<a href="<?php echo SITE_URL; ?>/index.php/events/get_event?id=<?php echo $pastevent->id; ?>"><?php echo $pastevent->title; ?></a>
								</strong>
							</p>
							<?php echo $pastevent->description; ?>
							<?php if($pastevent->image !== 'none') {
								?>
							<div class="row">
								<div class="col-sm-6 col-md-4 block-section">
									<br>
									<div class="gallery-image-container animation-fadeInQuick2" data-category="travel">
										<img src="<?php echo $pastevent->image; ?>" width="100%" height="auto;" alt="<?php echo $pastevent->title; ?>">
										<a href="<?php echo $pastevent->image; ?>" class="gallery-image-options" data-toggle="lightbox-image" title="<?php echo $pastevent->title; ?>">
											<h2 class="text-light"><strong>View event poster</strong></h2>
											<i class="fa fa-search-plus fa-3x text-light"></i>
										</a>
									</div>
								</div>
							</div>
							<?php } ?>
							</div>
							</li>
						<?php
						}
					} else {
						?>
						<li>
							<div class="timeline-content">
								<p class="alert alert-danger">
									<strong>
										Oooops
									</strong><br>
										There are no past event records at <?php echo SITE_NAME; ?>
								</p>
							</div>
							</li>
						<?php
						}
					?>
					</ul>
				</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!--<a href="<?php echo url('/events/get_rankings'); ?>">Show Pilot Rankings For Events</a>-->
