<?php
//simpilotgroup addon module for phpVMS virtual airline system
//
//simpilotgroup addon modules are licenced under the following license:
//Creative Commons Attribution Non-commercial Share Alike (by-nc-sa)
//To view full license text visit http://creativecommons.org/licenses/by-nc-sa/3.0/
//
//@author David Clark (simpilot)
//@copyright Copyright (c) 2009-2010, David Clark
//@license http://creativecommons.org/licenses/by-nc-sa/3.0/
?>
<!-- Blank Header -->
<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="gi gi-calendar"></i><Strong>Events</Strong>Center<br><small>Flight Operations | <?php echo SITE_NAME ?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>
<!-- END Blank Header -->
<ol class="breadcrumb breadcrumb-top">
  <li><a href="<?php echo SITE_URL?>/index.php"><i class="fa fa-home"></i></a></li>
  <li><a href="<?php echo SITE_URL?>/index.php/Schedules">Flight Operations</a></li>
  <li><a href="<?php echo SITE_URL?>/index.php/events">Events Center</a></li>
</ol>

<div class="block">
    <div class="block-title">
    	<h3>
    		Events Attendence Statistics
    	</h3>
    </div>
    <table class="table table-hover">
        <thead>
            <th>Pilot</th>
            <th># Of Events Attended</th>
        </thead>
    <?php
    if(!$rankings)
    {
        echo '<tr><td colspan="2">No Rankings Available</td></tr>';
    }
    else
    {
    foreach($rankings as $rank)
        {
        $pilot = PilotData::getPilotData($rank->pilot_id);

        echo '<tr><td>'.PilotData::getPilotCode($pilot->code, $pilot->pilotid).' - '.$pilot->firstname.' '.$pilot->lastname.'</td><td>'.$rank->ranking.'</td></tr>';
    }
    }
    ?>
    </table>
</div>
<hr />
<a class="btn btn-danger btn-block" href="<?php echo SITE_URL; ?>/index.php/events"><b>Return To Events Listing</b></a>