<?php 
/**
 * iCrew v4 LITE - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 * 
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other 
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems. 
 * 
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Intermediate Services (with additions) 
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 * 
 */
?>

<!-- FAQ Header -->
<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="fa fa-info"></i>Frequently Asked Questions<br><small>Public Relations | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>
<!-- END FAQ Header -->
<ol class="breadcrumb breadcrumb-top">
  <li><a href="<?php echo SITE_URL ?>"><i class="fa fa-home"></i></a></li>
  <li>FAQ</li>
</ol>
<!-- FAQ Block -->
<div class="block block-alt-noborder">
    <!-- FAQ Content -->
    <div class="row">
        <div class="col-md-6 col-lg-3 col-lg-offset-1">
            <div class="block-section">
                <h3 class="sub-header text-center"><strong>Any Questions?</strong></h3>
                <p class="clearfix"><i class="fa fa-question fa-5x text-danger pull-left animation-pulse"></i>Hello Pilots, if you have any questions for us, please find them here. If you can't find an anwser to your question, do contact us.</p>
                <p>
                	
                	<?php 
                	/*
                		$contact_link = SITE_URL;
                		$contact_link = str_replace('icrew.','', $contact_link);
                		$contact_link = $contact_link .'/contact';
                		*/
                		
                	?>
                    <a href="mailto:icrew@vuainc.org" class="btn btn-lg btn-success btn-block"><i class="fa fa-envelope-o"></i> Contact Us</a>
                </p>
            </div>
        </div>
        <div class="col-md-6 col-lg-6 col-lg-offset-1">
            <!-- Intro Content -->
            <h3 class="sub-header"><strong>Welcome</strong></h3>
            <div id="faq1" class="panel-group">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-angle-right"></i> <a class="accordion-toggle" data-toggle="collapse" data-parent="#faq1" href="#faq1_q1">What makes <?php echo SITE_NAME ?> unique?</a></h4>
                    </div>
                    <div id="faq1_q1" class="panel-collapse collapse in">
                        <div class="panel-body">
                            <p>We provide a unique pilot experience by bringing together a strong, friendly community, advanced software and realistic policies and procedures. Combined, we are able to strike a balance between realism and simulation that focuses on making things as realistic as possible while making concessions for simulator limitations.</p>
                            <p class="remove-margin">Our constant innovation is driven by monthly town hall meetings which helps us discuss the next round of features or to discuss pain points that pilots are experiencing. The result is an ever-evolving system designed with one goal: Improve the pilot experience.</p>
                        </div>
                    </div>
                </div>
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-angle-right"></i> <a class="accordion-toggle" data-toggle="collapse" data-parent="#faq1" href="#faq1_q2">What is the plan for <?php echo SITE_NAME ?>? Where are you headed?</a></h4>
                    </div>
                    <div id="faq1_q2" class="panel-collapse collapse">
                        <div class="panel-body">Our goal is to continue growing and improving the pilot experience. <?php echo SITE_NAME ?> is powered by iCrew <?php echo ICS_VERSION ?>, the world's most advanced pilot crew center, which is scheduled for updates every 6 calendar months. Because of this, cutting edge technology, flight simulation advancement and pilot experiences keep expanding.</div>
                    </div>
                </div>
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-angle-right"></i> <a class="accordion-toggle" data-toggle="collapse" data-parent="#faq1" href="#faq1_q3">Does<?php echo SITE_NAME ?> have an overall mission? Why was it created?</a></h4>
                    </div>
                    <div id="faq1_q3" class="panel-collapse collapse">
                        <div class="panel-body">
                        	<p><?php echo SITE_NAME ?> was started in an effort to create a professional, modern Virtual Airline that was realistic, while maintaining the entertainment aspect of Flight Simulation.</p>
                        	<p class="remove-margin">While we continue to improve and evolve, pushing the boundaries of what has been done by other Virtual Airlines, we hope that others will follow suit and help bring modernization to legacy Flight Sim organizations.</p>
                      	</div>
                    </div>
                </div>
            </div>
            <!-- END Intro Content -->

            <!-- Features Content -->
            <h3 class="sub-header"><strong>Flight Operations</strong></h3>
            <div id="faq2" class="panel-group">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-angle-right"></i> <a class="accordion-toggle" data-toggle="collapse" data-parent="#faq2" href="#faq2_q1">Which flights can I operate?</a></h4>
                    </div>
                    <div id="faq2_q1" class="panel-collapse collapse">
                        <div class="panel-body">You can operate any flight in our database .</div>
                    </div>
                </div>
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-angle-right"></i> <a class="accordion-toggle" data-toggle="collapse" data-parent="#faq2" href="#faq2_q2">Can I fly anywhere I want, or is it limited by the schedule?</a></h4>
                    </div>
                    <div id="faq2_q2" class="panel-collapse collapse">
                        <div class="panel-body">Any flight that is in our system can be flown. Alternativly you may charter a flight using our ACARS system to anywhere you want!</div>
                    </div>
                </div>
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-angle-right"></i> <a class="accordion-toggle" data-toggle="collapse" data-parent="#faq2" href="#faq2_q3">How do you determine or get the timetables? Is it always accurate?</a></h4>
                    </div>
                    <div id="faq2_q3" class="panel-collapse collapse">
                        <div class="panel-body">
                        	<p>We do our best to keep our timetables as up to date as possible. That said, we receive the initial schedule from <?php echo Auth::$pilot->code; ?> Group's Website and then adjust it a bit to take simulator limitations into account.</p>
                        	<p class="remove-margin">We try our best to update our schedules on a monthly, or bi-monthly basis to make sure your routes are always up-to-date.</p>
                        </div>
                    </div>
                </div>
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-angle-right"></i> <a class="accordion-toggle" data-toggle="collapse" data-parent="#faq2" href="#faq2_q4">What if I need to divert during a flight? Are diversions/emergencies allowed?</a></h4>
                    </div>
                    <div id="faq2_q4" class="panel-collapse collapse">
                        <div class="panel-body">Yes, we do allow flight diversions or simulated emergencies, as long as it is documented in the flight report.</div>
                    </div>
                </div>
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-angle-right"></i> <a class="accordion-toggle" data-toggle="collapse" data-parent="#faq2" href="#faq2_q5">Do I need to operate flights at their real world time?</a></h4>
                    </div>
                    <div id="faq2_q5" class="panel-collapse collapse">
                        <div class="panel-body">Yes. Our schedules are created using UTC time. Most simulators have an option to use UTC time within the settings. If you simulator doesn't have this option, simple math will do the trick!</div>
                    </div>
                </div>
            </div>
            <!-- END Features Content -->
        </div>
    </div>
    <!-- END FAQ Content -->
</div>
<!-- END FAQ Block -->