<div class="mapcenter" align="center">
	<div id="pirep_routes_map" style="width: 80%; height: 500px"></div>
</div>


<style>
	.leaflet-pulsing-icon {
    border-radius: 100%;
    box-shadow: 1px 1px 8px 0 rgba(0,0,0,0.75);
}

.leaflet-pulsing-icon:after {
    content: "";
    border-radius: 100%;
    height: 300%;
    width: 300%;
    position: absolute;
    margin: -100% 0 0 -100%;

}

@keyframes pulsate {
    0% {
        transform: scale(0.1, 0.1);
        opacity: 0;
        -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
        filter: alpha(opacity=0);
    }
    50% {
        opacity: 1;
        -ms-filter: none;
        filter: none;
    }
    100% {
        transform: scale(1.2, 1.2);
        opacity: 0;
        -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
        filter: alpha(opacity=0);
    }
}
</style>
<script src="<?php echo SITE_URL?>/lib/js/base_map.js"></script>
<script src="https://rawgit.com/mapshakers/leaflet-icon-pulse/master/src/L.Icon.Pulse.js"></script>

<link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.0.6/dist/MarkerCluster.css" />
<link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.0.6/dist/MarkerCluster.Default.css" />
<script src="https://unpkg.com/leaflet.markercluster@1.0.6/dist/leaflet.markercluster.js"></script>

<script type="text/javascript">

	// Creating a new map element.
	const map = createMap({
		render_elem: 'pirep_routes_map',
		provider: '<?php echo Config::Get("MAP_TYPE"); ?>',
	});
	
		function get_api_request(yourUrl){
			var Httpreq = new XMLHttpRequest(); 
			Httpreq.open("GET",yourUrl,false);
			Httpreq.send(null);
			return Httpreq.responseText;          
		}
				
	//Initializing Cluster Group
	var markersLayer = new L.LayerGroup(); 
	var markers = L.markerClusterGroup();
	map.addLayer(markersLayer);
	
		var apiURL = "<?php echo SITE_URL; ?>/action.php/pireps/get_pireps/217";
		var flights = JSON.parse(get_api_request(apiURL));
		for(i=0; i<flights.length; i++) {
			
			var marker = L.marker([flights[i].deplat, flights[i].deplng]).bindTooltip(flights[i].arricao + " - " +  flights[i].code + flights[i].flightnum).addTo(map);
				marker.bindPopup('<p class="text-center"><center><img src="<?php echo SITE_URL; ?>/lib/images/airline/' + flights[i].code + '.png" style="width: 100px; height: auto;" /> <br> <h4 class="text-center"> ' + flights[i].code + flights[i].flightnum + '<br> <small> ' + flights[i].depicao + ' ' + flights[i].arricao + '</small></h4> <br>' + flights[i].aircraft + '<br> <span class="label label-primary">' + flights[i].source + '</span> <br><br></center></p>');
				markers.addLayer(marker);
				markers.addTo(markersLayer);
				
				
			var marker = L.marker([flights[i].arrlat, flights[i].arrlng]).bindTooltip(flights[i].arricao + " - " +  flights[i].code + flights[i].flightnum).addTo(map);
				marker.bindPopup('<p class="text-center"><center><img src="<?php echo SITE_URL; ?>/lib/images/airline/' + flights[i].code + '.png" style="width: 100px; height: auto;" /> <br> <h4 class="text-center"> ' + flights[i].code + flights[i].flightnum + '<br> <small> ' + flights[i].depicao + ' ' + flights[i].arricao + '</small></h4> <br>' + flights[i].aircraft + '<br> <span class="label label-primary">' + flights[i].source + '</span> <br><br></center></p>');
				markers.addLayer(marker);
				markers.addTo(markersLayer);
				
				
				var airport_polyline_dep = new L.LatLng(flights[i].deplat, flights[i].deplng);
			var airport_polyline = new L.LatLng(flights[i].arrlat, flights[i].arrlng);
			var pointList = [airport_polyline_dep, airport_polyline];
		
	var drawPolyline = new L.geodesic(pointList, {
	    color: 'black',
    	weight: 2,
    	opacity: 1,
    	smoothFactor: 1
	});
	
	drawPolyline.addTo(map);
		}
		
			
	var legend = L.control({position: 'bottomright'});
	legend.onAdd = function (map) {

    var div = L.DomUtil.create('div', 'info legend');
        div.innerHTML = '<img src="<?php echo SITE_URL; ?>/iCrew/favicon.png" style="width: 50px; height: auto;" /><span class="text-primary">Schedule Map</span> ';
    return div;
	};
	legend.addTo(map);

</script>
