<?php 
/**
 * iCrew v4 LITE - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 * 
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other 
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems. 
 * 
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Intermediate Services (with additions) 
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 * 
 */
?>
<!-- Header -->
<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="fa fa-spin fa-support"></i><strong> Help</strong> Desk<br><small>Public Relations | <?php echo SITE_NAME; ?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>
<!-- Header -->
<ol class="breadcrumb breadcrumb-top">
  <li><a href="<?php echo SITE_URL?>/index.php"><i class="fa fa-home"></i></a></li>
  <li>Help Desk</li>
</ol>
<div class="row">
	<div class="col-md-12">
		<div class="block">
			<div class="block-title">
				<h2><i class="gi gi-stopwatch"></i> DashBoard</h2>
			</div>
			<div class="alert alert-info">
				Have you read the FAQs yet? We advise you to read the FAQs before opening a support ticket! Click <a href="<?php echo SITE_URL?>/index.php/FAQ">here</a>
			</div>
			<ul class="nav-horizontal text-center" >
				<li>
					<a data-toggle="tab" href="#home"  class="themed-color-spring"><i class="fa fa-5x fa-question"></i> I HAVE A QUESTION</a>
				</li>
				<li>
					<a data-toggle="tab" href="#menu1"  class="themed-color-spring"><i class="fa fa-5x fa-support"></i> SOMETHING ELSE</a>
				</li>
				<br>
			</ul>
			<br>
		</div>
	</div>
</div>

<div class="tab-content">
	
	
  <div id="home" class="tab-pane fade in active">
   	<div class="row">
		<div class="col-md-12">
			<div class="block">
				<div class="block-title">
				<h3>
					<strong>Known</strong> Queries
				</h3>
		 	</div>
			
			<!-- Features Content -->
            <div id="faq2" class="panel-group">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title">
                        	<i class="fa fa-angle-right"></i>
                        	<a class="accordion-toggle" data-toggle="collapse" data-parent="#faq2" href="#faq2_q1">
                        		Why was my PIREP rejected? 
                        	</a>
                        </h4>
                    </div>
                    <div id="faq2_q1" class="panel-collapse collapse">
                        <div class="panel-body">
                        	Your PIREP might be rejected because of a violation of Flight Operation Regulations. 
                        	<br>If you think your PIREP was rejected by mistake, open a ticket <a data-toggle="tab" href="#menu1">here.</a>
                        </div>
                    </div>
                </div>
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-angle-right"></i>
                        <a class="accordion-toggle" data-toggle="collapse" data-parent="#faq2" href="#faq2_q2">
                        	I am unable to login to file PIREPS
                        </a>
                        </h4>
                    </div>
                    <div id="faq2_q2" class="panel-collapse collapse">
                        <div class="panel-body">
                        	Yes, this is because your account was marked inactive since no activity was observed. To re-activate your account, navigate <a data-toggle="tab" href="#menu1">here.</a>
                        </div>
                    </div>
                </div>
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-angle-right"></i> <a class="accordion-toggle" data-toggle="collapse" data-parent="#faq2" href="#faq2_q3">
                        	I made a bid, but it doesn't show up on the "My Bids" page.</a></h4>
                    </div>
                    <div id="faq2_q3" class="panel-collapse collapse">
                        <div class="panel-body">
                        	Your bid will be automatically cancelled if you do not operate the flight within 48 hours from the time of bidding. However, you can re-bid the flight anytime.
                        </div>
                    </div>
                </div>
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-angle-right"></i> 
                        <a class="accordion-toggle" data-toggle="collapse" data-parent="#faq2" href="#faq2_q4">
                        	Can I use any aircraft?	
                        </a>
                        </h4>
                    </div>
                    <div id="faq2_q4" class="panel-collapse collapse">
                        <div class="panel-body">
                        Yes. I'ts fun. Remember that.
                        </div>
                    </div>
                </div>
               
                
            </div>
            
			</div>
		</div>
	</div>
 </div>
  
  
  <div id="menu1" class="tab-pane fade">
    <div class="row">
	<div class="col-md-12">
	<div class="block">
		<div class="block-title">
			<h3>
				<strong>Support</strong> Form
			</h3>
		 </div>
        <form action="Helpdesk/sendmail" method="post" class="form-horizontal form-bordered">
                <div class="form-group">
                    <label class="col-md-3 control-label" for="name">Your Name</label>
                    <div class="col-md-6">
                        <input type="text" id="name" name="pilot-name" class="form-control" value="<?php echo Auth::$pilot->firstname.' '.Auth::$pilot->lastname; ?>" disabled>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label" for="pilotid">Pilot ID</label>
                    <div class="col-md-6">
                        <input type="text" id="pilotid" name="pilot-id" class="form-control" value="<?php echo Auth::$pilot->code; ?><?php echo Auth::$pilot->pilotid; ?>" disabled>
                    </div>
                </div>
               
				<div class="form-group">
                    <label class="col-md-3 control-label" for="mail"> Email</label>
                    <div class="col-md-6">
                        <input type="text" id="mail" name="pilot-mail" class="form-control" value="<?php echo Auth::$pilot->email; ?>" disabled>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="col-md-3 control-label" for="summary"> Issue summary</label>
                    <div class="col-md-6">
                        <input type="text" id="issuesummary" name="summary" class="form-control" placeholder="PIREP, Bug, Account Re-activation...">
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="col-md-3 control-label" for="comment"> Description</label>
                    <div class="col-md-6">
                     <textarea  id="description" name="comment" class="form-control" placeholder="Let us know..." rows="7"></textarea>
                    </div>
                </div>
                
              
              <div class="form-group form-actions">
                    <div class="col-md-9 col-md-offset-3">
                         <button type="submit" class="btn  btn-sm btn-primary" data-toggle="modal" href="#myModal" >Send</button>
                        <button type="reset" class="btn  btn-sm btn-warning">Reset</button>
                    </div>
                </div>
                </form>
   
	</div>
	</div>
	</div>
  </div>
  
  
 
</div>

<div id="myModal" class="modal fade">
	<div class="modal-dialog">
		<div class="modal-content">
		 	<!-- Modal Header -->
        <div class="modal-header text-center">
        	<h2 class="modal-title">Success!</h2>
       	</div>
        	
        	<div class="modal-body">
                			<center>
                				<i class="fa fa-check fa-5x text-success"></i>
                				<p>Your support ticket has been succesfully filed. </p>
                				<small>The form will now be reset.</small>
                			</center>
        				</div>
            <!-- END Modal Body -->
            <!-- Modal Footer-->
            			<div class="modal-footer">
            				<center>
            					<p>iCrew Systems &copy; 2017</p>
            				</center>
            			</div>
    			  </div>
				</div>		
        	</div>
