<div class="content-header">
    <div class="header-section">
        <h1><i class="fa fa-twitch"></i>Live<strong> Streaming</strong> <br> <small>Media Department | <?php echo SITE_NAME?>&copy; <?php echo date("Y"); ?></small></h1>
    </div>
</div>
<ol class="breadcrumb breadcrumb-top">
  <li><a href="<?php echo SITE_URL?>/index.php"><i class="fa fa-home"></i></a></li>
  <li>Livestream</li>
</ol>
       <div class="row">
          <div class="block">
            <div class="block-title">
                <h3>Link your <strong>YouTube / Twitch Account</strong></h3>
            </div>
            <p>Do you want your flights to be streamed? Link up your Twitch account and we'll do the rest!</p>
            <p><a href="<?php echo SITE_URL?>/index.php/Profile/editprofile" class="btn btn-info btn-md">Link account</a></p>
        </div>
        
        <div class="block">
            <div class="block-title">
                <div class="block-options pull-right">
                    <label class="label label-info">LIVE</label>
                </div>
                <h2>On Going Flights</h2>
            </div>

            <?php
		if(!$acarsdata)
		{ echo '
		<div class="alert alert-danger">
					<h3><strong>Uh-Oh! </strong></h3>
					<p>Currently there are no Pilots who are streaming their flights. Would you like to stream? Link up your account!</p>
		</div>
		'; }
		else {
			?>
			
			   <div class="table-responsive">
      <table class="table table-hover table-striped">
        <thead>
          <tr>
            <td>Flight</td>
            <td>Pilot</td>
            <td>Departure</td>
            <td>Arrival</td>
            <td>Status</td>
            <td>Network</td>
            <td>Options</td>
          </tr>
        </thead>
        
       
  	<tbody>
         
  <?php
			foreach($acarsdata as $flight)
		{ ?>
  <tr>
          <td>
            <?php echo $flight->flightnum ?>
          </td>
          <td>
            <?php echo $flight->pilotname ?>
          </td>
          <td>
            <?php echo $flight->depicao ?>
          </td>
          <td>
            <?php echo $flight->arricao ?>
          </td>
          <td>
            <?php 
						$phase = $flight->phasedetail;
						  if($phase == "Preflight")
						  {
  							echo '	<span class="label label-default">
								'. $phase .'
									</span>';
						  }
						  else if ($phase == "Taxiing to Runway")
						  {
  							echo '	<span class="label label-warning animation-pulse">
										'. $phase.'
									</span>';
						  }
						  else if ($phase == "Pushing Back")
						  {
  							echo '	<span class="label label-warning animation-pulse">
										'. $phase .'
									  </span>';
						  }
						  else if ($phase == "Taking Off")
						  {
  							echo '	<span class="label label-primary animation-pulse">
									  '. $phase.'
									</span>';
						  }
						  else if ($phase == "Climbing")
						  {
							echo '	<span class="label label-primary animation-pulse">
									'. $phase .'
									</span>';
						  }
						  else if ($phase == "Cruising")
						  {
							echo '	<span class="label label-success">
										'. $phase.' </span>';
  						}
						  else if ($phase == "Descending")
						  {
							echo '	<span class="label label-warning animation-pulse">
										'. $phase .'
									</span>';
						  }
						  else if ($phase == "Approaching")
						  {
							echo '	<span class="label label-primary animation-pulse">
										'. $phase .'
									</span>';
						  }
						  else if ($phase == "Final Approach")
						  {
							 echo '	<span class="label label-primary animation-pulse">
										'. $phase .'
									</span>';
						  }
						  else if ($phase == "Landing")
						  {
							echo '	<span class="label label-primary animation-pulse">
										'. $phase .'
									</span>';
						  }
						  else if ($phase == "Taxiing to Gate")
						  {
  							echo '	<span class="label label-default animation-pulse">
										'. $phase .'
									</span>';
	  					}
						  else 
						  {
							echo '	<span class="label label-danger animation-pulse">
										'. $phase .'
									</span>';
						  }

					    ?> 
					    </td>
            <td>
                <?php if(!$flight->online)
                {
                  echo 'Offline';
                }
                else
                {
                  echo $flight->online;
                }
                ?>
            </td>
            <td>
              <?php 
              $pilotid = $flight->pilotid;
              $pilotdata = PilotData::getPilotData($pilotid); 
              echo $pilotdata->livestream;
              if(!$livestream)
              {
                echo '<a target="_blank" href="https://go.twitch.tv/'.$pilotdata->livestream.'" class="btn btn-info btn-md">Watch</a>';
              }
              else
              {
              echo '<a href="javascript::void(0);" class="btn btn-default">Not Streaming</a>';
                
              }
              ?>
            </td>
        </tr>
        <?php
          }
          
          ?>
        
       </tbody>
       </table>
  </div>
          <?php
		}
        ?>
 </div>

          
        <div class="block">
            <div class="block-title">
                <h2><i class="gi gi-stopwatch"></i> <strong>Past</strong> Flights</h2>
            </div>

              <ul class="nav-horizontal text-center">
                <li>
                    <a data-toggle="tab" href="#home"><i class="fa fa-5x fa-youtube"></i> Yotube</a>
                </li>
                <li>
                    <a data-toggle="tab" href="#menu1"><i class="fa fa-5x fa-twitch"></i> Twitch</a>
                </li>
                <br>
              </ul>
            <br>
            
            <div class="tab-content">

            <!--<div id="home" class="tab-pane fade in active">
                <iframe 
                            width="100%" 
                            height="500"
                            src="https://www.youtube.com/embed/nS9NL5AQJxc" 
                            frameborder="0" 
                            scrolling="no" 
                            allowfullscreen>
                            </iframe>
            </div>

            <div id="menu1" class="tab-pane fade">
                <div class="row">
                    <iframe 
                            src="" 
                            height="500" 
                            width="100%" 
                            frameborder="0" 
                            scrolling="no" 
                            allowfullscreen="true">
                            </iframe>
                </div>
            </div>-->
        </div>
        </div>
<br><br>
        
      

</div>
 