<?php
/**
 * iCrew v4 Premium - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 *
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems.
 *
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Premium Services (with additions)
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 *
 */
?>
<div class="block full">
    <div class="block-title">
    <h1><i class="hi hi-map-marker"></i> <?php echo $title?></h1>
    </div>
    <div class="table-responsive">
    	 <script src="<?php echo SITE_URL; ?>/lib/skins/iCrew/js/pages/tablesDatatables.js"></script>
          <script>$(function(){ TablesDatatables.init(); });</script>
        <table id="pilots" class="table table-vcenter table-condensed table-bordered">
            <?php
            if(!$allpilots)
            {
             echo '<div class="alert alert-danger"> <Strong>Oops</strong> <br>No Pilots in this Hub </div>';
            }
            else
            { ?>
            <thead>
                <tr>
                    <th class="text-center">ID</th>
                    <th class="text-center">Country</th>
                    <th class="text-center">Name</th>
                    <th class="text-center">Hours</th>
                    <th class="text-center">Rank</th>
                    <th class="text-center">IVAO</th>
                    <th class="text-center">VATSIM</th>
                    <th class="text-center">Rank Image</th>
                    <th class="text-center">View Pilot</th>

                </tr>
            </thead>
            <tbody>
                <?php
					foreach($allpilots as $pilot)
						{
							/*
								To include a custom field, use the following example:

								<td>
									<?php echo PilotData::GetFieldValue($pilot->pilotid, 'VATSIM ID'); ?>
								</td>

								For instance, if you added a field called "IVAO Callsign":

									echo PilotData::GetFieldValue($pilot->pilotid, 'IVAO Callsign');
							*/
							if($pilot->retired == 2) { continue;
						}
				?>
                <tr>
                    <td class="text-center">
					            <?php echo PilotData::GetPilotCode($pilot->code, $pilot->pilotid)?>
          					</td>
					          <td class="text-left"><img src="<?php echo Countries::getCountryImage($pilot->location);?>"> <?php echo Countries::getCountryName($pilot->location);?></td>
                    <td class="text-left"><?php echo $pilot->firstname.' '.$pilot->lastname?>
                      <br />
                      <?php
                      $groups = PilotData::getPilotGroups($pilot->pilotid);
                      foreach ($groups as $group) {
                        switch($group->name) {
                          case "Administrators":
                            $color = 'success';
                            $icon = '<i class="fa fa-star"></i>';
                          break;

                          default:
                          $color = 'info';
                          $icon = '';
                          break;

                        }
                        ?>
                          <span class="label label-<?php echo $color; ?>"><?php echo $group->name.' '.$icon; ?></span>
                        <?php
                      }
                      ?>
                    </td>
                    <td class="text-center"><?php echo $pilot->totalhours;?></td>
                    <td class="text-center"><?php echo $pilot->rank;?></td>
                    <td class="text-center"><?php $ivao = PilotData::GetFieldValue($pilot->pilotid, 'IVAO'); if(!$ivao) { echo '<span class="text-muted">Not linked</span>'; } else { echo '<a href="https://www.ivao.aero/Member.aspx?Id='.$ivao.'" class="btn btn-default btn-md" target="_blank">'.$ivao.'</a>'; }?></td>
                    <td class="text-center"><?php $vatsim =  PilotData::GetFieldValue($pilot->pilotid, 'VATSIM'); if(!$vatsim) { echo '<span class="text-muted">Not linked</span>'; } else { echo '<a href="https://cert.vatsim.net/vatsimnet/status.php?id='.$vatsim.'" class="btn btn-default btn-md" target="_blank">'.$vatsim.'</a>'; } ?></td>
                    <td class="text-center"><img src="<?php echo $pilot->rankimage ?>" class="img-rounded" alt="<?php echo $pilot->rank?>" width="Auto;" height="Auto;"></td>
                    <td class="text-center"><a class="btn btn-xs btn-default" href="<?php echo url('/profile/view/'.$pilot->pilotid);?>"><i class="fa fa-eye"></i></a></td>

				</tr>
                <?php } ?>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>
 <script>
    $(document).ready(function() {
    $('#pilots').DataTable();
        });
        </script>
