<?php if(!defined('IN_PHPVMS') && IN_PHPVMS !== true) { die(); } ?>
<?php
/**
 * iCrew v4 Premium - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 *
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems.
 *
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Premium Services (with additions)
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 *
 */
?>
    <!-- Load and execute javascript code used only in this page -->
    <script src="<?php echo SITE_URL?>/lib/skins/iCrew/js/pages/formsWizard.js"></script>
    <script>
        $(function() {
            FormsWizard.init();
        });
    </script>

    <!-- Wizard Header -->
    <div class="content-header">
        <div class="header-section">
            <h1>
            <i class="gi gi-airplane"></i><Strong>Manual PIREP</Strong><br><small>Flight Operations | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small>
        </h1>
        </div>
    </div>
    <!-- END Wizard Header -->
    <script type="text/javascript">
        $(document).ready(function() {
            $("#myModal").modal('show');
        });
    </script>
    <!-- Modal -->
    <div id="myModal" class="modal fade" role="dialog">
        <div class="modal-dialog">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Manual PIREP</h4>
                </div>
                <div class="modal-body">
                    <p class="text-success">Flight Sim Crash ? Forgot to Launch ACARS Tracker? Violation of Flight Operations?</p>
                    <p>We understand it is not always possible to get it right, we allow our Pilots to file a Manual PIREP, but also keeping in mind the potential abuse of this module, we are strictly monitoring the usage of this module.</p>
                    <p>Please make sure you give the reason for filing a manual PIREP</p>
                </div>
                <div class="modal-footer">
                    <div class="modal-title text-center">
                        <strong>Flight Operations</strong> | <?php echo SITE_NAME?> &copy;
                        <?php echo date ("Y"); ?>
                    </div>
                    <button class="btn btn-success" data-dismiss="modal">Continue</button>
                </div>
            </div>

        </div>
    </div>
    <!-- Progress Bar Wizard Block -->
    <div class="block">
        <!-- Progress Bars Wizard Title -->
        <div class="block-title">
            <h2><i class="gi gi-airplane"></i> <strong>File</strong> PIREP</h2>
        </div>
        <!-- END Progress Bar Wizard Title -->

        <!-- Progress Bar Wizard Content -->
        <div class="row">
            <div class="col-sm-4 col-sm-offset-1">
                <div class="block-section">
                    <h3 class="sub-header text-center"><strong>File PIREP with 3 easy steps!</strong></h3>
                    <p class="clearfix"><i class="fa fa-plus fa-5x text-primary pull-left"></i>Sim Crashed? <span class="text-success"><strong>No Worries!</strong></span> Here at <?php echo SITE_NAME?>, we Undersand. Just File a Manual PIREP. Enter Flight Details, Paste the Flight Log in Comments and File!</p>
                    <p>
                        <a href="<?php echo url('/Documentation/pireps');?>" class="btn btn-lg btn-primary btn-block">PIREP Manual <i class="fa fa-book"></i></a>
                    </p>
                </div>
            </div>
            <div class="col-sm-6 col-sm-offset-1">
                <!-- Wizard Progress Bar, functionality initialized in js/pages/formsWizard.js -->
                <div class="progress progress-striped active">
                    <div id="progress-bar-wizard" class="progress-bar progress-bar-danger" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0"></div>
                </div>

                <!-- END Wizard Progress Bar -->

                <!-- Progress Wizard Content -->
                <form id="progress-wizard" action="<?php echo url('/pireps/mine');?>" method="post" class="form-horizontal">
                    <!-- First Step -->
                    <div id="progress-first" class="step">
                        <div class="wizard-steps">
                            <div class="row">
                                <div class="col-xs-4 active">
                                    <span>Pilot</span>
                                </div>
                                <div class="col-xs-4">
                                    <span>Schedule</span>
                                </div>
                                <div class="col-xs-4">
                                    <span>Filght Details</span>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="example-username">Pilot Name</label>
                            <div class="col-md-8">
                                <input type="text" id="example-progress-username" name="example-progress-username" class="form-control" value="<?php echo Auth::$pilot->firstname . ' ' . Auth::$pilot->lastname;?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="code">Airline</label>
                            <div class="col-md-8">
                                <select class="select-chosen" name="code" id="code">
                                    <option value="">Select your airline</option>
                                    <?php
							foreach($airline_list as $airline) {
								$sel = ($_POST['code'] == $airline->code || $bid->code == $airline->code)?'selected':'';
								echo '<option value="'.$airline->code.'" '.$sel.'>'.$airline->code.' - '.$airline->name.'</option>';
							}
							?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="flightnum">Flight Number</label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="flightnum" value="<?php if(isset($bid->flightnum)) { echo $bid->flightnum; }?><?php if(isset($_POST['flightnum'])) { echo $_POST['flightnum'];} ?>" placeholder="Example: 582" />
                            </div>
                        </div>
                    </div>
                    <!-- END First Step -->

                    <!-- Second Step -->
                    <div id="progress-second" class="step">
                        <div class="wizard-steps">
                            <div class="row">
                                <div class="col-xs-4">
                                    <span>Pilot</span>
                                </div>
                                <div class="col-xs-4 active">
                                    <span>Schedule</span>
                                </div>
                                <div class="col-xs-4">
                                    <span>Filght Details</span>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="depicao">Departure Airport</label>
                            <div class="col-md-8" id="depairport">
                                <select class="select-chosen" id="depicao" name="depicao">
                                    <option value="">Select a departure airport</option>
                                    <?php
								foreach($airport_list as $airport) {
									$sel = ($_POST['depicao'] == $airport->icao || $bid->depicao == $airport->icao)?'selected':'';
									echo '<option value="'.$airport->icao.'" '.$sel.'>'.$airport->icao . ' - '.$airport->name .'</option>';
								}
								?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="arricao">Arrival Airport</label>
                            <div class="col-md-8" id="arrairport">
                                <select class="select-chosen" id="arricao" name="arricao">
                                    <option value="">Select an arrival airport</option>
                                    <?php
								foreach($airport_list as $airport) {
									$sel = ($_POST['arricao'] == $airport->icao || $bid->arricao == $airport->icao)?'selected':'';
									echo '<option value="'.$airport->icao.'" '.$sel.'>'.$airport->icao . ' - '.$airport->name .'</option>';
								}
								?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="aircraft">Aircraft</label>
                            <div class="col-md-8">
                                <select class="select-chosen" name="aircraft" id="aircraft">
                                    <option value="">Select the aircraft of this flight</option>
                                    <?php
							foreach($aircraft_list as $aircraft)
							{
								$sel = ($_POST['aircraft'] == $aircraft->name || $bid->registration == $aircraft->registration)?'selected':'';
								echo '<option value="'.$aircraft->id.'" '.$sel.'>'.$aircraft->name.' - '.$aircraft->registration.'</option>';
							}
							?>
                                </select>
                            </div>
                        </div>

                        <div class="form-group has-success">
                            <label class="col-md-4 control-label" for="fuelused">Fuel Used</label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="fuelused" value="<?php echo $_POST['fuelused']; ?>" />
                            </div>
                        </div>
                    </div>
                    <!-- END Second Step -->

                    <!-- Third Step -->
                    <div id="progress-third" class="step">
                        <div class="wizard-steps">
                            <div class="row">
                                <div class="col-xs-4">
                                    <span>Pilot</span>
                                </div>
                                <div class="col-xs-4">
                                    <span>Schedule</span>
                                </div>
                                <div class="col-xs-4 active">
                                    <span>Filght Details</span>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="flighttime">Flight Time</label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="flighttime" value="<?php echo $_POST['flighttime'] ?>" placeholder="Example: 5.30" />
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="route">Route</label>
                            <div class="col-md-8">
                                <textarea name="route" class="form-control" style="width: 100%"><?php echo (!isset($_POST['route'])) ? $bid->route : $_POST['route']; ?></textarea>
                            </div>
                        </div>
                        <div class="form-group has-success">
                            <label class="col-md-4 control-label" for="comment">Reason for Manual PIREP</label>
                            <div class="col-md-8">
                                <textarea name="comment" class="form-control" style="width: 100%; height: 150px;"><?php echo $_POST['comment'] ?></textarea>
                            </div>
                        </div>
                    </div>
                    <!-- END Third Step -->

                    <!-- Form Buttons -->
                    <div class="form-group form-actions">
                        <div class="col-md-8 col-md-offset-4">
                            <?php $bidid = ( isset($bid) )? $bid->bidid:$_POST['bid']; ?>
                                <input type="hidden" name="bid" value="<?php echo $bidid ?>" />
                                <input type="reset" class="btn btn-sm btn-warning ui-wizard-content ui-formwizard-button" id="back3" value="Back">
                                <input type="submit" name="submit_pirep" class="btn btn-sm btn-primary" id="next3" value="Next">
                        </div>
                    </div>
                    <!-- END Form Buttons -->
                </form>
                <!-- END Progress Wizard Content -->
            </div>
        </div>
        <!-- END Progress Bar Wizard Content -->
    </div>
    <!-- END Progress Bar Wizard Block -->
