<?php
   /**
    * iCrew v4 Premium - Virtual Airline Crew Center
    * Copyright (c) 2017 iCrewSystems
    *
    * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
    * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
    * No part of the website design or layout may be reproduced or transmitted in any form or by any other
    * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
    * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems.
    *
    * @author: Leonard Selvaraja
    * @copyright: Copyright (c) 2017, iCrewSystems
    * @link http://www.icrewsystems.com
    * @service name: iCrewSystems Virtual Airline Premium Services (with additions)
    * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
    *
    */
   ?>
<!-- Blank Header -->
<div class="content-header">
   <div class="header-section">
      <h1>
         <i class="gi gi-airplane"></i><Strong>PIREP</Strong> Review Wall <br><small>Flight Operations | <?php echo SITE_NAME?> &copy; <?php echo date("Y") ?></small>
      </h1>
   </div>
</div>
<!-- END Blank Header -->
<div class="row">
   <div class="col-md-12">
      <a href="javascript::(0)" class="widget widget-hover-effect5">
         <div class="widget-simple">
            <h3 class="widget-content text-center animation-pullDown">
               <strong><?php echo $pirep->code ?><?php echo $pirep->flightnum ?></strong><br>
               <small><?php echo date(DATE_FORMAT, $pirep->submitdate);?></small>
            </h3>
         </div>
      </a>
   </div>
</div>
<?php
   $check = $pirep->flightnum;

   if (strpos($check, 'OPR') !== false) {
       ?>
<script type="text/javascript">
   $(window).load(function(){
       $('#success').modal('show');
   });
</script>
<div id="success" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
   <div class="modal-dialog">
      <div class="modal-content">
         <!-- Modal Header -->
         <div class="modal-header text-center">
            <h2 class="modal-title"><Strong>PIREP Review Wall</Strong><br><small>UID #<?php echo $pirep->pirepid * 4; ?></small></h2>
         </div>
         <!-- END Modal Header -->
         <!-- Modal Body -->
         <div class="modal-body">
            <p>
            <div class="alert alert-warning">
               This PIREP <strong>#<?php echo $pirep->pirepid; ?></strong> was a Crew Location Transfer Flight. <br>
            </div>
            <br>
            How does it affect the review page?
            <ul>
               <li>The Distance travelled will be <strong>added</strong> to the Pilot's log book / account.</li>
               <li>Since the PIREP Rating algorithm cannot be bypassed, it is displayed. But the Parameters used for the JumpSeat Flights are strategically planned and will not affect the Airline Statistics.</li>
               <li>The Hours shown on the PIREP details will be added to the pilot's logbook, but will not be accounted for Promotions</li>
               <li>No vMoney will be credited to the Pilot's account irrespective of the Flight's cost. The Pilot would have paid for the Jumpseat.</li>
               <li>The Landing Rate will not be counted for the Pilot's average landing rate.</li>
            </ul>
            </p>
         </div>
         <div class="modal-footer">
            <center>
               <h4><small><strong><span class="text-muted"> Flight Operations | <?php echo SITE_NAME; ?> &copy; <?php echo date("Y"); ?></span></strong></small></h4>
            </center>
         </div>
         <!-- END Modal Body -->
      </div>
   </div>
</div>
<?php
   }

   else if($pirep->flightnum == 'JUMP') {
   	?>
<script type="text/javascript">
   $(window).load(function(){
       $('#success').modal('show');
   });
</script>
<div id="success" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
   <div class="modal-dialog">
      <div class="modal-content">
         <!-- Modal Header -->
         <div class="modal-header text-center">
            <h2 class="modal-title"><Strong>PIREP Review Wall</Strong><br><small>UID #<?php echo $pirep->pirepid * 4; ?></small></h2>
         </div>
         <!-- END Modal Header -->
         <!-- Modal Body -->
         <div class="modal-body">
            <p>
            <div class="alert alert-warning">
               This PIREP <strong>#<?php echo $pirep->pirepid; ?></strong> which was filed by <strong><?php echo $pirep->firstname.' '.$pirep->lastname;?></strong> was a JumpSeat Flight. <br>
            </div>
            <br>
            How does it affect the review page?
            <ul>
               <li>The Distance travelled will be <strong>added</strong> to the Pilot's log book / account.</li>
               <li>Since the PIREP Rating algorithm cannot be bypassed, it is displayed. But the Parameters used for the JumpSeat Flights are strategically planned and will not affect the Airline Statistics.</li>
               <li>The Hours shown on the PIREP details will be added to the pilot's logbook, but will not be accounted for Promotions</li>
               <li>No vMoney will be credited to the Pilot's account irrespective of the Flight's cost. The Pilot would have paid for the Jumpseat.</li>
               <li>The Landing Rate will not be counted for the Pilot's average landing rate.</li>
            </ul>
            </p>
         </div>
         <div class="modal-footer">
            <center>
               <h4><small><strong><span class="text-muted"> Flight Operations | <?php echo SITE_NAME; ?> &copy; <?php echo date("Y"); ?></span></strong></small></h4>
            </center>
         </div>
         <!-- END Modal Body -->
      </div>
   </div>
</div>
<?php	}
   ?>
<div class="col-md-6">
   <div class="widget">
      <div class="widget-extra-full">
         <div id="widget-carousel6" class="carousel slide remove-margin">
            <div class="carousel-inner">
               <div class="active item">
                  <h3 class="text-center">
                     <?php echo $pirep->firstname.' '.$pirep->lastname;?><br>
                     <small><span class="text-muted">Pilot in Command</span></small>
                  </h3>
               </div>
            </div>
         </div>
      </div>
      <!-- <div class="widget-main">
         <div class="list-group remove-margin">
         	<a href="javascript:void(0)" class="list-group-item">
         		<span class="pull-right"><?php echo $pirep->depicao; ?></span>
         		<h5 class="list-group-item-heading remove-margin"> <Strong>Origin</Strong> </h5>
         	</a>
         	<a href="javascript:void(0)" class="list-group-item">
         		<span class="pull-right"><?php echo $pirep->arricao; ?></span>
         		<h5 class="list-group-item-heading remove-margin"> <strong>Destination</strong>  </h5>
         	</a>
         	<a href="javascript:void(0)" class="list-group-item">
         		<span class="pull-right"><?php echo $pirep->flighttime_stamp; ?> Hrs</span>
         		<h5 class="list-group-item-heading remove-margin"> <Strong>Duration</Strong> </h5>
         	</a>
         	<a href="javascript:void(0)" class="list-group-item">
         		<span class="pull-right"><?php echo $pirep->distance; ?> NM</span>
         		<h5 class="list-group-item-heading remove-margin"> <Strong>Distance</Strong> </h5>
         	</a>
         	<a href="javascript:void(0)" class="list-group-item">
         		<span class="pull-right"><?php echo $pirep->load ?></span>
         		<h5 class="list-group-item-heading remove-margin"> <Strong>Passengers</Strong> </h5>
         	</a>
         	<a href="javascript:void(0)" class="list-group-item">
         		<span class="pull-right"><?php echo $pirep->landingrate ?> FPM</span>
         		<h5 class="list-group-item-heading remove-margin"> <Strong>Landing Rate</Strong> </h5>
         	</a>
         	<a href="javascript:void(0)" class="list-group-item">
         		<span class="pull-right"><?php echo $pirep->fuelused; ?> LBS</span>
         		<h5 class="list-group-item-heading remove-margin"> <Strong>Fuel Used</Strong> </h5>
         	</a>
         	<a href="javascript:void(0)" class="list-group-item">
         		<span class="pull-right"> <?php echo Config::Get('MONEY_UNIT'); ?> <?php echo $pirep->pilotpay; ?></span>
         		<h5 class="list-group-item-heading remove-margin"> <Strong>Pilot Pay</Strong> </h5>
         	</a>
         </div>
         </div> -->
      <div class="widget-main">
         <div class="list-group remove-margin">
           <a href="javascript:void(0)" class="list-group-item">
              <span class="pull-right"><?php echo $pirep->depname?> (<?php echo $pirep->depicao; ?>)</span>
              <h5 class="list-group-item-heading remove-margin"> <Strong>Origin</Strong> </h5>
           </a>
            <a href="javascript:void(0)" class="list-group-item">
               <span class="pull-right"><?php echo $pirep->arrname?> (<?php echo $pirep->arricao; ?>)</span>
               <h5 class="list-group-item-heading remove-margin"> <strong>Destination</strong>  </h5>
            </a>
            <a href="javascript:void(0)" class="list-group-item">
               <span class="pull-right"><?php echo $pirep->aircraft . " ($pirep->registration)"?></span>
               <h5 class="list-group-item-heading remove-margin"> <strong>Equipment</strong>  </h5>
            </a>
            <a href="javascript:void(0)" class="list-group-item">
               <span class="pull-right"><?php
                  $aircraft = OperationsData::getAircraftByName($pirep->aircraft);
                  $ac_icao = $aircraft->icao;


                                $schedule = SchedulesData::getScheduleByFlight($pirep->code,$pirep->flightnum);
                                $fltime = explode(".", $schedule->flighttime);
                                $minstar = substr($fltime[1],0,1);
                                $minstarmin = substr($fltime[1],1,2);
                                $flmin = $minstar * 10;
                                $flhou = $fltime[0] * 60;
                                $flminu = $flhou + $flmin + $minstarmin;

                                $actfltime = explode(".", $pirep->flighttime);
                                $actminstar = substr($actfltime[1],0,1);
                                $actminstarmin = substr($actfltime[1],1,2);
                                $actflmin = $actminstar * 10;
                                $actflhou = $actfltime[0] * 60;
                                $actflminu = $actflhou + $actflmin + $actminstarmin;

                                if(($flminu - 20) > $actflminu) {
                                echo " <span class='label label-info'><b>Early</b></span>";
                                } elseif (($flminu + 15) < $actflminu) {
                                echo "<span class='label label-warning'><b>Delayed</b></span>";
                                } else {
                                echo "<span class='label label-success'><b>On Time</b></span>"; }
                                ?></span>
               <h5 class="list-group-item-heading remove-margin"> <Strong>Flight Status</Strong> </h5>
            </a>
            <a href="javascript:void(0)" class="list-group-item">
               <span class="pull-right"><?php echo $pirep->flighttime_stamp; ?> Hrs</span>
               <h5 class="list-group-item-heading remove-margin"> <Strong>Duration</Strong> </h5>
            </a>
            <a href="javascript:void(0)" class="list-group-item">
               <span class="pull-right"><?php echo $pirep->distance; ?> NM</span>
               <h5 class="list-group-item-heading remove-margin"> <Strong>Distance</Strong> </h5>
            </a>
            <a href="javascript:void(0)" class="list-group-item">
               <span class="pull-right"><?php echo $pirep->load ?> (Limit. <?php echo $aircraft->maxpax; ?> Pax) </span>
               <h5 class="list-group-item-heading remove-margin"> <Strong>Passengers on Board</Strong> </h5>
            </a>
            <a href="javascript:void(0)" class="list-group-item">
               <h5><span class="pull-right"><?php echo $pirep->landingrate?> FPM <?php
                  if(abs($pirep->landingrate) == 0) {
                    echo '<span class="label label-primary">Manual PIREP / Jumpseat</span>';
                  }
                  else if(abs($pirep->landingrate) <= 100) {
                     echo '<span class="label label-success">Greased Landing</span>';
                   }
                  elseif( abs($pirep->landingrate) >=101  && abs($pirep->landingrate) <= 200) {
                    echo '<span class="label label-success">Good Landing</span>';
                  } elseif( abs($pirep->landingrate) >=201  && abs($pirep->landingrate) <= 400) {
                    echo '<span class="label label-warning">Satisfactory Landing</span>';
                  }
                  elseif( abs($pirep->landingrate) >=401  && abs($pirep->landingrate) <= 5000) {
                    echo '<span class="label label-danger">Hard Landing</span>';
                  }

                  ?></h5>
               </span>
               <h5 class="list-group-item-heading remove-margin"> <Strong>Landing Rate</Strong> </h5>
            </a>
            <a href="javascript:void(0)" class="list-group-item">
               <span class="pull-right">
               	<?php 
               		$weight_unit = 'UKNOWN';            	
               
            		if(Config::get('WeightUnit') == '1') { 
            			$weight_unit = 'lbs';
            			$fuelused = $pirep->fuelused;
            		} else { 
            			$weight_unit = 'kgs';
            			$fuelused = ceil($pirep->fuelused / 2.204);
            		} 
               	?>
               	(<?php echo $fuelused;?> 
               <?php 
            	
				
            		
            		echo $weight_unit;
            		?> fuel used @ <?php echo $pirep->fuelunitcost?> / <?php echo $weight_unit; ?>)</span>
               <h5 class="list-group-item-heading remove-margin"> <Strong>Fuel Used</Strong> </h5>
            </a>
            <a href="javascript:void(0)" class="list-group-item">
               <span class="pull-right"><?php echo FinanceData::FormatMoney($pirep->fuelused * $pirep->fuelunitcost);?></span>
               <h5 class="list-group-item-heading remove-margin"> <Strong>Fuel Cost</Strong> </h5>
            </a>
            <a href="javascript:void(0)" class="list-group-item">
               <span class="pull-right"> <?php 
            	$pilot = PilotData::getPilotData($pirep->pilotid);
//if($pirep->flighttime < 1)
			//	{
				$hours = intval($pirep->flighttime);
				$minutes = ($pirep->flighttime - $hours) ;
				$pay = $pilot->payrate ;
				$payhr = ($pay / 60 * $minutes * 100);
			$totpay = ($pay * $hours) + $payhr ;
				$pilot_pay = FinanceData::FormatMoney($totpay);
		//		}
//else
			//	{
			//	$pilot_pay = FinanceData::FormatMoney($pilot->payrate * $pirep->flighttime);
				//}	
               echo $pilot_pay;?></span>
               <h5 class="list-group-item-heading remove-margin"> <Strong>Pilot Pay (per hour based on rank)</Strong> </h5>
            </a>
            <a href="javascript:void(0)" class="list-group-item">
               <span class="pull-right"> (<?php echo $pirep->load;?> Passengers / <?php echo FinanceData::FormatMoney($pirep->price);?> per ticket)</span>
               <h5 class="list-group-item-heading remove-margin"> <Strong>Gross Revenue Cost</Strong> </h5>
            </a>
            <a href="javascript:void(0)" class="list-group-item">
               <span class="pull-right"> <?php echo FinanceData::FormatMoney($pirep->load * $pirep->price);?></span>
               <h5 class="list-group-item-heading remove-margin"> <Strong>Airline Gross Revenue </Strong> </h5>
            </a>
            <a href="javascript:void(0)" class="list-group-item">
               <span class="pull-right"> <?php echo FinanceData::FormatMoney($pirep->revenue);?></span>
               <h5 class="list-group-item-heading remove-margin"> <Strong>Airline Net Revenue </Strong> </h5>
            </a>
         </div>
      </div>
      <div class="widget-extra-full">
         <div id="widget-carousel6" class="carousel slide remove-margin">
            <div class="carousel-inner">
               <div class="active item">
                  <h3 class="text-center">
                     <?php
                        $pirepsts = $pirep->accepted;
                        if ($pirepsts == 1)
                        {
                        	$labelclr = "success";
                        	$message = "Accepted";
                        }
                        else if ($pirepsts == 0)
                        {
                        	$labelclr = "warning";
                        	$message = "Processing";
                        }
                        else
                        {
                        	$labelclr = "danger";
                        	$message = "Rejected";
                        }
                        ?>
                     <span class="label label-<?php echo $labelclr; ?>"><?php echo $message; ?></span>
                  </h3>
               </div>
            </div>
         </div>
      </div>
      <div class="widget-simple themed-background-muted">
         <div class="widget-content widget-content-light text-center">
            <h3><?php echo $pirep->source; ?></h3>
         </div>
         <br>
      </div>
   </div>
</div>
<?php
   //From SQL Database
   $fuelused = $pirep->fuelused;
   $flightime = $pirep->flighttime;
   $hours = date("H",strtotime($flightime));
   $minutes = date("i",strtotime($flightime));
   $flighttime = ($hours * 60) + $minutes;


   switch ($ac_icao) {
     // Add your own aicrafts from here https://www.airliners.net/forum/viewtopic.php?t=1355819

     case "A319":
     $per_hour_consumption_rate = 5357.233;
     break;

     case "B77L":
     $per_hour_consumption_rate = 16534.67;
     break;

     case "A388":
     $per_hour_consumption_rate = 24250.849;
     break;

     case "B77W":
     $per_hour_consumption_rate = 13404.11;
     break;

     case "B738":
     $per_hour_consumption_rate = 5577.6952;
     break;


     default:
     $per_hour_consumption_rate = 8000;
     break;
   }


   $fcph = ($flighttime / 60) * $per_hour_consumption_rate ;
   //(FUEL CONSUMPTION PER HOUR) 2945 Lbs per hour, 1335 Kgs per hour.
   $totalconsumption = $fcph;
   //% for the chart :
   if($pirep->flightnum == 'JUMP') {
      $efficiency = 100;
   } else if($pirep->source == 'manual') {
       $efficiency = 100;
   } else {
     $efficiency = ($totalconsumption / $fuelused) * 100;
   }


   ?>
<!--LANDING RATE CHART-->
<?php
   $lrr = $pirep->landingrate;
   $lr = floor(100 - (($lrr / LANDING_RATE_LIMIT) * 100));
   //color for the LR Chart

   if ($lr < 20)
   {
     $lrcolor = "#ff000c";
     $rating_impact_lr = 35;
   }
   else if ($lr < 40)
   {
     $lrcolor = "ff5400";
     $rating_impact_lr = 25;
   }
   else if ($lr < 60 )
   {
     $lrcolor = "ff9400";
     $rating_impact_lr = 20;
   }
   else if ($lr < 80 )
   {
     $lrcolor = "#aeff00";
     $rating_impact_lr = 15;
   }
   else
   {
     $lrcolor = "#0cff00";
     $rating_impact_lr = 10;
   }
   //LR Chart


   ?>
<!--REVENUE ALGORITHM-->
<?php
   //From SQL Database
   $gross = $pirep->gross;
   $expenses = $pirep->expenses;
   $revenue = $pirep->revenue;

   {
     $revenue1 = $pirep->revenue;
     $gross1 = $pirep->gross;
   }
   // %for Chart
   if($pirep->flightnum == 'JUMP') {
       $profit = 100;
     } else if($pirep->source == 'manual') {
       $profit = 100;
     } else {
       $profit = round(($revenue1 / $gross1) * 100);
     }


     if($profit > 100) {
       $profit = 100;
     }



     if($efficiency > 100) {
       $efficiency = 100;
     }
     if($lr > 100) {
       $lr = 100;
     }


     // echo $revenue1;
     // echo "<br>";
     // echo $gross;
     //
     // echo "<br> Profit:";
     // echo $profit;
   ?>
<!-- PIREP Block -->
<div class="col-md-6 ">
   <!-- Block with Options -->
   <div class="block">
      <!-- Block with Options Title -->
      <div class="block-title">
         <h2><i class="gi gi-airplane"></i> <strong>PIREP</strong> Rating</h2>
      </div>
      <!--FLIGHT RATING -->
      <?php
         $rating = floor((($profit + $efficiency) / 2) - $rating_impact_lr);
         /*1 star*/
         if ($rating < 20)
         {
         	$stars = '<i class="fa fa-star text-warning"></i>  <i class="fa fa-star-o text-warning"></i> <i class="fa fa-star-o text-warning"></i> <i class="fa fa-star-o text-warning"></i> <i class="fa fa-star-o text-warning"></i>';
         $commentss = 'Try increasing your landing smoothness or fuel efficiency.';
         }
         elseif ($rating < 30)
         {
         	$stars = '<i class="fa fa-star text-warning"></i> <i class="fa fa-star-o text-warning"></i> <i class="fa fa-star-o text-warning"></i> <i class="fa fa-star-o text-warning"></i> <i class="fa fa-star-o text-warning"></i>';
         	$commentss = 'Poor performance, get back to the books Captain.';
         }
         /*2 Stars*/
         elseif ($rating < 40)
         {
         	$stars = '<i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star-o text-warning"></i> <i class="fa fa-star-o text-warning"></i> <i class="fa fa-star-o text-warning"></i>';
         	$commentss = 'Not looking good. How was your fuel efficiency?';
         }
         elseif ($rating < 50)
         {
         	$stars = '<i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star-o text-warning"></i>';
         	$commentss = 'Good, but looking at your log books, we believe you can do much better!';
         }
         /*3 Stars*/
         elseif ($rating < 60)
         {
         	$stars = '<i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star-o text-warning"></i><i class="fa fa-star-o text-warning"></i>';
         	$commentss = 'Good job, but maybe we can increase those stars next time!';
         }
         /*4 Stars*/
         elseif ($rating < 70)
         {
         	$stars = '<i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star-o text-warning"></i>';
         	$commentss = 'On the edge captain, we dont compromise on our safety, and efficiency! Watch it please';
         }

         elseif ($rating < 80)
         {
         	$stars = '<i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star-o text-warning"></i>';
         	$commentss = 'Wow, Your flight records were awesome, Just one more star, keep it coming captain!';
         }
         /*5 Stars*/
         elseif ($rating < 90)
         {
         	$stars = '<i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i><i class="fa fa-star text-warning"></i>';
         	$commentss = 'Excellent, Your flight was just as great as you are!';
         }

         else
         {
         	$stars = '<i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star text-warning"></i> <i class="fa fa-star-o text-warning"></i>';
         	$commentss = 'Good, but be a little more accurate with how much fuel you carry!';
         }
         ?>
      <a href="javascript::(0)" data-toggle="tooltip" title="The PIREP Rating is calculated by taking Efficiency, Revenue and Landing Smoothness into account" class="widget widget-hover-effect5">
         <div class="widget-simple">
            <h3 class="widget-content text-center animation-pullDown">
               <?php echo $stars; ?>
               <small>
                  <p class="text-muted"><?php echo $commentss; ?></p>
               </small>
            </h3>
         </div>
      </a>
      <div class="col-sm-4">
         <div class="pie-chart block-section easyPieChart" data-percent="<?php echo floor($efficiency); ?>" data-size="100" data-bar-color="#4cff00" style="width: 130px; height: 130px; line-height: 130px;">
            <span><?php echo floor($efficiency); ?> % <i class="gi gi-leaf"></i></span>
            <canvas width="130" height="130"></canvas>
         </div>
         <p class="text-center">Efficency</p>
      </div>
      <div class="col-sm-4">
         <div class="pie-chart block-section easyPieChart" data-percent="<?php echo floor($profit); ?>" data-size="100" data-bar-color="#00d0ff" style="width: 130px; height: 130px; line-height: 130px;">
            <span><?php echo floor($profit); ?> % <?php echo Config::Get('MONEY_UNIT'); ?></span>
            <canvas width="130" height="130"></canvas>
         </div>
         <p class="text-center">Revenue</p>
      </div>
      <div class="col-sm-4">
         <div class="pie-chart block-section easyPieChart" data-percent="<?php echo $lr; ?>" data-size="100" data-bar-color="<?php echo $lrcolor; ?>" style="width: 130px; height: 130px; line-height: 130px;">
            <span><?php echo floor($lr) ; ?> % </span>
            <canvas width="130" height="130"></canvas>
         </div>
         <p class="text-center">Landing Smoothness</p>
      </div>
      <br><br><br><br><br><br><br><br><br><br>
   </div>
</div>
<div class="row">
   <div class="col-md-6">
      <!-- Block with Options Left -->
      <div class="block">
         <!-- Block with Options Left Title -->
         <div class="block-title clearfix">
            <h2 class="pull-left"><i class="gi gi-google_maps"></i> <strong>PIREP</strong> Route</h2>
         </div>
         <!-- END Block with Options Left Title -->
         <p class="text-muted text-center">
            <?php
               if (!$pirep->route)
               {
               	echo 'OWN NAVIGATION';
               }
               else
               {
               	echo "<code>".$pirep->route."</code>";
               }
               ?>
         </p>
         <!-- Block with Options Left Content -->
         <p>
            <?php
               Template::set('pirepid', $pirep->pirepid);
               Template::Show('routemap_new.php');
               ?>
         </p>
         <!-- END Block with Options Left Content -->
      </div>
      <!-- END Block with Options Left -->
   </div>
</div>
<div class="row">
   <div class="col-md-6">
      <!-- Block with Options Left -->
      <div class="block">
         <!-- Block with Options Left Title -->
         <div class="block-title clearfix">
            <h2 class="pull-left"><strong>PIREP</strong> Comments <i class="gi gi-comments"></i></h2>
         </div>
         <!-- END Block with Options Left Title -->
         <!-- Block with Options Left Content -->
         <p>
            <?php
               if($comments)
               {
                    ?>
         <div class="widget-extra">
            <div class="timeline">
               <ul class="timeline-list">
                  <?php
                     foreach($comments as $comment) {
                           ?>
                  <li class="active">
                     <div class="timeline-icon themed-background-fire themed-border-fire"><i class="fa fa-file-text"></i></div>
                     <div class="timeline-time"><small><?php echo date(DATE_FORMAT. ' H:i A', $comment->postdate); ?></small></div>
                     <div class="timeline-content">
                        <p class="push-bit"><a href="<?php echo SITE_URL; ?>/index.php/profile/view/<?php echo $pirep->id; ?>"><strong><?php echo $comment->firstname.' '.$comment->lastname; ?></strong></a></p>
                        <?php echo $comment->comment; ?>
                     </div>
                  </li>
                  <?php
                     }

                     ?>
               </ul>
            </div>
         </div>
         <?php
            }
            else
            {
              ?>
         <table id="tabledlist" class="tablesorter">
            <thead>
            </thead>
            <tbody>
               <tr>
                  <div class="alert alert-danger">
                     There are no comments for this PIREP
                  </div>
               </tr>
            </tbody>
         </table>
         <?php	}
         $now = time(); // or your date as well
         $your_date = $pirep->submitdate;
         $datediff = $now - $your_date;
         $days_since = round($datediff / (60 * 60 * 24));
         if($days_since <= (PIREP_CUSTOM_FIELD_EDIT / 24)) {
           ?>
           <br><?php
            Template::show('pireps_addcomment');
         } else {
           ?>
            <span class="text-muted">
              <i>You can add comments to a PIREP upto 48 hours after submission.</i>
            </span>
            <br /><br />
           <?php
         }


        ?>
         <!-- END Block with Options Left Content -->
      </div>
      <!-- END Block with Options Left -->
   </div>
   <div class="col-md-6">
      <!-- Block with Options Left -->
      <div class="block">
         <!-- Block with Options Left Title -->
         <div class="block-title clearfix">
            <h2 class="pull-right"><strong>PIREP</strong> Log <i class="gi gi-log_book"></i></h2>
         </div>
         <!-- END Block with Options Left Title -->
         <!-- Block with Options Left Content -->
         <p>
            <?php
               if($pirep->log != '')
               {
               ?>
         <p>
            <?php
               /* If it's FSFK, don't show the toggle. We want all the details and pretty
               	images showing up by default */
               if($pirep->source != 'fsfk')
               {
               	?>
         <p id="log" style="display: none;">
            <?php
               }
               else
               {
               	echo '<p>';
               }
               ?>
         <div>
            <?php
               # Simple, each line of the log ends with *
               # Just explode and loop.
               $log = explode('*', $pirep->log);
               foreach($log as $line)
               {
               	echo $line .'<br />';
               }
               ?>
         </div>
         </p>
         </p>
         <?php
            }
            else {
            	?>
         <div class="alert alert-danger">
            There is no <strong>PIREP LOG</strong> for this flight.
         </div>
         <?php
            }
            ?>
         <!-- END Block with Options Left Content -->
      </div>
      <!-- END Block with Options Left -->
   </div>
</div>
<!-- END PIREP Block -->
