<!-- Forms General Header -->
<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="gi gi-airplane"></i><Strong>Electronic Logbook</Strong><br><small>Pilot Resources | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>
<!-- END Forms General Header -->

<div class="row">
	<div class="col-md-12">
		 <div class="block">
            <div class="col-md-12">
				 <h2 class="text-center"><Strong><?php echo SITE_NAME?></Strong><br><h3 class="text-center"><small>ICAO Style Log book</small></h3></h2><br><hr size="30">
            </div>
		 <h4 class="text-center">
		 	<small>Belongs to </small>
		 	<br><strong><?php echo $pilot->firstname . ' ' . $pilot->lastname?></strong>
		 </h4>
		 	<hr size="30">
		 	<h4 class="text-center">
		 	<small>Base Airport </small>
		 	<br><strong><?php echo $pilot->hub?></strong>
		 </h4>
		 	<hr size="30">
		 <h4 class="text-center text-success">
            <small> Total Log hours</small><br><strong><?php echo $userinfo->totalhours;?></strong>
         </h4>
         	<br><hr>
         <h4 class="text-center"><small>Endorsements  <br></small>
         	<?php
         	$endorsements =  PilotData::GetFieldValue($pilot->pilotid, 'Endorsement 1');
         	if(!$endorsements) { echo '<span class="text-muted">Not Typerated</span>'; }
         	else
         	{ echo '<span class="text-success">'.$endorsements.'</span>';
         	}
         	?>
         	</h4><br>
        </div>
    </div>
    <div class="col-md-12">
    	<div class="block">
            <!-- Input Groups - Buttons Title -->
            <div class="block-title">
                <h2><i class="gi gi-log_book"></i> <strong>Flown</strong> Flights</h2>
            </div>
            <!-- END Input Groups - Buttons Title -->

            <!-- Input Groups - Buttons Content -->
            <?php
                if(!$pireps)
                {
                    echo '
                    <div class="content">
                        <div class="col-xs">
                            <!-- Danger Alert -->
                            <div class="alert alert-info">
                                <h3 class="font-w300 push-15">Error</h3>
                                <p>You have not filed any reports. File one through the ACARS software or manual report submission to see its details and status on this page.</p>
                            </div>
                            <!-- END Danger Alert -->
                        </div>
                    </div>
                    ';
                } else {
            ?>
            <table id="tabledlist" class="tablesorter table table-hover">
                <thead>

                        <center>

                        		<th class="text-center"><font face="courier">DATE OF FLIGHT</font><br><SMALL>(dd/mm/yyyy)</SMALL></th>
                            	<th class="text-center"><font face="courier">CALL SIGN</font><br><SMALL><?php echo $pilot->code; ?>XXX</SMALL></th>
                            	<th class="text-center"><font face="courier">DEPARTURE</font><br><SMALL>(ICAO)</SMALL></th>
                            	<th class="text-center"><font face="courier">ARRIVAL</font><br><SMALL>(ICAO)</SMALL></th>
                            	<th class="text-center"><font face="courier">TIME OF FLIGHT</font><br><SMALL>(HH.MM)</SMALL></th>
                            	<th class="text-center"><font face="courier">PIC NAME</font><br><SMALL></SMALL></th>



                            <?php
                                // Only show this column if they're logged in, and the pilot viewing is the
                                //	owner/submitter of the PIREPs
                                if(Auth::LoggedIn() && Auth::$userinfo->pilotid == $userinfo->pilotid)
                                {
                                    echo '<th><font face="courier">OPTIONS</font></th>';
                                }
                            ?>
                        </center>

                </thead>
                <tbody>
                    <?php
                        foreach($pireps as $report)
                        {
                    ?>
                    <tr>
                    	<td class="text-center">
                            <?php echo date(DATE_FORMAT, $report->submitdate); ?>
                        </td>
                        <td class="text-center">
                            <?php echo $report->code . $report->flightnum; ?>
                        </td>
                        <td class="text-center">
                            <?php echo $report->depicao; ?>
                        </td>
                        <td class="text-center">
                            <?php echo $report->arricao; ?>
                        </td>
                        <td class="text-center">
                            <?php echo $report->flighttime; ?>
                        </td>
                        <td class="text-center">
                            Capt. <?php echo $report->firstname . ' ' . $report->lastname; ?>
                        </td>

                        <td class="text-center">
                           <a class="label label-default" data-toggle="tooltip" title="POST FLIGHT REVIEW" href="<?php echo url('/pireps/view/'.$report->pirepid);?>"><i class="gi gi-eye_open"></i> PFR</a>
                        </td>

                    </tr>
                    <?php
                    }
                    ?>
                </tbody>
            </table>

            <?php
            }
            ?>
        	<!-- END Input Groups - Buttons Content -->
        </div>
    </div>
</div>
