<?php 
/**
 * iCrew v4 Premium - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 * 
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other 
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems. 
 * 
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Premium Services (with additions) 
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 * 
 */
?>
<div class="row">
	<div class="col-md-12">
		<div class="content-header content-header-media ">
			<div class="header-section">
				<?php $avatar = PilotData::getPilotAvatar($pilot->pilotid); ?>
					<img src="<?php echo $avatar; ?>" alt="avatar" class="sidebar-user-avatar pull-right">
					<h1><strong><?php echo $pilot->firstname. ' '.$pilot->lastname; ?></strong> <br><small><?php echo $pilot->code; ?><?php echo $pilot->pilotid;?> | <?php echo $pilot->rank; ?></small></h1>
			</div>
			<img src="https://i.pinimg.com/736x/b9/c0/13/b9c01394c3dec86cb0d2570b1a97a2cd--material-design-ui.jpg" class="animation-pulseSlow">
		</div>
	</div>
</div>

<?php 
	$privacy = PilotData::GetFieldValue($pilot->pilotid, 'Maintain Privacy?');
	$friend_id = $pilot->pilotid;
	$my_id = Auth::$userinfo->pilotid;
	/*Checks if I am already friends with the guy*/
	$status = ICSFriends::checkFriends($friend_id, $my_id);
		
	/*Checks if I am viewing my own account */
	$self = ICSFriends::check_self_acc($friend_id, $my_id);
	
	if($privacy == 'Yes') 
	{
		if($status->req_status == 1) {
			?>
			<?php 
			if($status == 1 && $self != 0) {
		
		if($status->req_status == 0) {
			$req_sts = 'Request Sent';
			$req_sts_icon = '<i class="fa fa-user-plus"></i>';
			$req_sts_icon_clr = 'warning';
			$text_for_friends_modal = 'You have already sent a friend request to '.$pilot->firstname.', You will be notified once they accept your friend request!';
			
			
		} else if ($status->req_status == 1) {
			$req_sts = 'Friends';
			$req_sts_icon = '<i class="fa fa-check"></i>';
			$req_sts_icon_clr = 'success';
			$friends_since = 'Since ' . date('d.m.Y', strtotime($status->date));
			$text_for_friends_modal = "Are you sure you want to unfriend ".$pilot->firstname."? You cannot be friends with them again";
			
		} else if ($status->req_status == 2) {
			$req_sts = 'You can\'t be friends';
			$req_sts_icon = '<i class="fa fa-user-times"></i>';
			$req_sts_icon_clr = 'danger';
			$text_for_friends_modal = 'This user has rejected your friend request. Sorry';
			
		}
	} else {
			$req_sts = 'Send Friend Request';
			$req_sts_icon = '<i class="fa fa-user-plus"></i>';
			$req_sts_icon_clr = 'info';
			$href='';
			$text_for_friends_modal = 'Would you like to send a friend request to '.$pilot->firstname.' ?';
	}
	
	//If there are any POST Form actions, the functions will be initiallized
      if($_POST['action'] == 'sendreq') {
      	$self_id = Auth::$userinfo->pilotid;
      	$friend_id = $pilot->pilotid;
      	ICSFriends::send_request($self_id, $friend_id); 
      
?>
      	<script>
    $(function() {
    setTimeout(function() {
    $.bootstrapGrowl("<h4>iCrew <strong>Notifications </strong> </h4>You sent a friend request to  <?php echo $pilot->firstname; ?>, you will receive a notification once they accept your request. <br> This may take a few seconds to update in the system, instead of reloading, try going back to see your request status", {
    	ele: 'body', // which element to append to
    	type: 'success', // (null, 'info', 'danger', 'success')
    	offset: {from: 'top', amount: 20}, // 'top', or 'bottom'
    	align: 'right', // ('left', 'right', or 'center')
    	width: 250, // (integer, or 'auto')
    	delay: 11000, // Time while the message will be displayed. It's not equivalent to the *demo* timeOut!
    	allow_dismiss: true, // If true then will display a cross to close the popup.
    	stackup_spacing: 10 // spacing between consecutively stacked growls.
    });
    }, 2000);
    });      
</script>
      	<?php 
      }
      
       else if($_POST['action'] == 'send_imail') {
       		$who_to = $pilot->pilotid;
       		$who_from = Auth::$userinfo->pilotid;
       		$subject = $_POST['subject'];
       		$newmessage = $_POST['message'];
       		ICSFriends::send_new_mail($who_to, $who_from, $subject, $newmessage);
      ?>
      	<script>
    $(function() {
    setTimeout(function() {
    $.bootstrapGrowl("<h4>iCrew <strong>Notifications </strong> </h4>Your iMail was successfully sent to <?php echo $pilot->firstname; ?> at <?php echo date("H:i A d-m-Y"); ?>", {
    	ele: 'body', // which element to append to
    	type: 'success', // (null, 'info', 'danger', 'success')
    	offset: {from: 'top', amount: 20}, // 'top', or 'bottom'
    	align: 'right', // ('left', 'right', or 'center')
    	width: 250, // (integer, or 'auto')
    	delay: 11000, // Time while the message will be displayed. It's not equivalent to the *demo* timeOut!
    	allow_dismiss: true, // If true then will display a cross to close the popup.
    	stackup_spacing: 10 // spacing between consecutively stacked growls.
    });
    }, 3000);
    });      
</script>
      	<?php 
      }
       else if ($_POST['action'] == 'unfriend') {
       		
      //Unfriending 
       if($_POST['action'] == 'unfriend') {
      	$my_id = Auth::$userinfo->pilotid;
      	$friend_id = $pilot->pilotid;
      	ICSFriends::RejectRequest($friend_id, $my_id); 
      		?>
      		<script>
    $(function() {
    setTimeout(function() {
    $.bootstrapGrowl("<h4>iCrew <strong>Notifications </strong> </h4>You unfriended  <?php echo $pilot->firstname; ?>, you will receive a notification once they accept your request. <br> This may take a few seconds to update in the system, instead of reloading, try going back to see your request status", {
    	ele: 'body', // which element to append to
    	type: 'danger', // (null, 'info', 'danger', 'success')
    	offset: {from: 'top', amount: 20}, // 'top', or 'bottom'
    	align: 'right', // ('left', 'right', or 'center')
    	width: 250, // (integer, or 'auto')
    	delay: 11000, // Time while the message will be displayed. It's not equivalent to the *demo* timeOut!
    	allow_dismiss: true, // If true then will display a cross to close the popup.
    	stackup_spacing: 10 // spacing between consecutively stacked growls.
    });
    }, 2000);
    });      
</script>
      		<?php
       }
       }
?>



<div class="row">
	<div class="col-md-4">
		<div class="widget">
			<div class="widget-advanced">
				<div class="widget-header text-left themed-background-dark">
					<h3 class="widget-content-light">
						<span class="themed-color-night"><strong>Contact</strong> Box</span><br>
						<?php 
							$verification = PIREPData::getLastReports($pilot->pilotid, 1, PIREP_ACCEPTED);
							if(!$verification) {
								$verification_status = 'Not Verified <i class="fa fa-times"></i>';
								$veri_clr = 'warning';
							} else if(!$verification) {
								$verification_status = 'Verified <i class="fa fa-check"></i> ';
								$veri_clr = 'success';
							}
							
						?>
						<small><span class="label label-<?php echo $veri_clr; ?>"><?php echo $verification_status; ?></span></small>
						
					</h3>
					
				</div>
			<div class="widget-main">
				<span class="widget-image-container animation-bigEntrance">
					<span class="widget-icon themed-background-dark"><i class="gi gi-conversation"></i></span>
				</span>
				<!-- Widget -->
				<a data-toggle="modal" data-target="#friends" class="widget widget-hover-effect1 themed-background-<?php echo $req_sts_icon_clr; ?>">
	            <div class="widget-simple">
	                <div class="widget-simple text-center">
								<h5 class="widget-content widget-content-light">
									<strong><?php echo $req_sts_icon .' '. strtoupper($req_sts); ?></strong>
									<small><?php echo strtoupper($friends_since); ?></small>
								</h5>
						</div>
	            </div>
	        </a>
	        <!--MODAL STUFF-->
<div id="friends" class="modal fade" role="dialog">
  <div class="modal-dialog modal-md">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title text-center theme-background"><strong><small><?php echo SITE_NAME; ?> | Membership Department</small></strong></h4>
      </div>
      <div class="modal-body">
        <p><?php echo $text_for_friends_modal; ?></p>
      </div>
      
      <div class="modal-footer">
      	<form action="<?php $_SERVER["PHP_SELF"]; ?>" method="post">
      		<?php if($status->req_status == 1) {
      			?>
				<button type="submit" class="btn btn-md btn-alt btn-<?php echo $req_sts_icon_clr; ?>" name="action" value="unfriend" >
				 Unfriend
				</button>
				<?php
				
			} 
			 else {
				?>
				<button type="submit" class="btn btn-md btn-alt btn-<?php echo $req_sts_icon_clr; ?>" name="action" value="sendreq" >
				 <?php echo $req_sts_icon .' '. strtoupper($req_sts); ?>
				</button>
				<?php
			}
			?>
			<button type="button" class="btn btn-md btn-default btn-alt" data-dismiss="modal">Close</button>
      	</form>
        
      </div>
    </div>

  </div>
</div>

<!--MODAL FOR IMAIL-->
<div id="imail_modal" class="modal fade" role="dialog">
  <div class="modal-dialog modal-md">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title text-center theme-background"><strong><?php echo SITE_NAME; ?> | Communications Department</strong></h4>
      </div>
      <div class="modal-body">
        <p>
        	<form action="<?php $_SERVER["PHP_SELF"]; ?>" method="post">
        	<div class="alert alert-info">
        		You are sending this iMail to <?php echo $pilot->firstname.' '.$pilot->lastname; ?>
        	</div>
        	<label class="form-group">
        		Subject
        	</label>
        	<input class="form-control" type="text" name="subject" value="<?php echo $mail_sub; ?>" />
        	<br>
        	<label class="form-group">
        		Message
        	</label>
        	<textarea class="form-actions form-control" name="message" placeholder="Enter Your Message Here..."></textarea>
        </p>
      </div>
      
      <div class="modal-footer">
      	
      		<button type="submit" class="btn btn-md btn-default btn-alt btn-success" name="action" value="send_imail" >Send iMail</button>
			<button type="button" class="btn btn-md btn-default btn-alt" data-dismiss="modal">Cancel</button>
      	</form>

      </div>
    </div>

  </div>
</div>
	        <a data-toggle="modal" data-target="#imail_modal" class="widget widget-hover-effect1">
	            <div class="widget-simple">
	                <div class="widget-icon pull-left themed-background animation-fadeIn">
	                    <i class="gi gi-message"></i>
	                </div>
	                <div class="pull-right">
	                    <!-- Jquery Sparkline (initialized in js/pages/index.js), for more examples you can check out http://omnipotent.net/jquery.sparkline/#s-about -->
	                    <span id="mini-chart-sales"></span>
	                </div>
	                <h3 class="widget-content pull-right text-center animation-pullDown">
	                   <strong>Send iMail</strong>
	                    <small>"<?php echo $mail_sub; ?>"</small>
	                </h3>
	            </div>
	        </a>
	        <!-- END Widget -->
	        <?php 
				$currank1 = $pilot->rankid;
				if($currank1 == 1)
				{
				  $currank = $currank1;
				}
				else
				{
				  $currank = $currank1 - 1;
				}
				
				switch($currank)
				{
				  case 0:
						 $rnkc = ($currank/8) * 100;
					break;
					case 1:
						 $rnkc = ($currank/8) * 100;
					break;
					case 2:
						$rnkc = ($currank/8) * 100;
						break;
					case 3: 
						$rnkc = ($currank/8) * 100;
						break;
					case 4:
						$rnkc = ($currank/8) * 100;
						break;
					case 5:
						$rnkc = ($currank/8) * 100;
						break;
					case 6: 
						$rnkc = ($currank/8) * 100;
						break;
					case 7:
						$rnkc = ($currank/8) * 100;
						break;
					case 8: 
						$rnkc = ($currank/8) * 100;
						break;
						
						default:
						$rnkc = ($currank/8) * 100;
							break;
				}
				?>
	         <!-- Widget -->
	        <a href="<?php echo SITE_URL ?>/index.php/Ranks" class="widget widget-hover-effect1">
	            <div class="widget-simple">
	                <div class="widget-icon pull-left themed-background animation-fadeIn">
	                    <div class="pie-chart easyPieChart" data-percent="<?php echo $rnkc;?>" data-size="67" data-bar-color="#26ff00" style="width: 90px; height: 90px; line-height: 90px;">
							<span><i class="fa fa-graduation-cap fa-success"></i></span>
							<canvas width="70" height="70"></canvas></div>
	                </div>
	                <div class="text-right">
	                	<h3 class="widget-content pull-right text-center text-success animation-pullDown ">
	                    	<Strong><?php echo $pilot->rank ?></Strong>
	                    	<small>Click here to check details</small>
	                	</h3>
	                </div>
	            </div>
	        </a>
	        <!-- END Widget -->
	        <!-- Widget -->
	        <?php
		        $livesettings = PilotData::GetFieldValue($pilot->pilotid, 'Show Live Stream');
		        $liveid = PilotData::GetFieldValue($pilot->pilotid, 'Live Stream ID');
		        $liveplatform =  PilotData::GetFieldValue($pilot->pilotid, 'Live Stream Platform');
		        if($liveplatform == 'YouTube')
		        {
		          $url = "https://www.youtube.com/channel/";
		          $hrefurl = $url.''.$liveid;
		          $icon = 'youtube';
		          $iconclr = 'danger';
		          $small = 'www.youtube.com';
		        }
		        else if($liveplatform == 'Twitch')
		        {
		          $url = "https://go.twitch.tv/";
		          $hrefurl = $url.''.$liveid;
		           $icon = 'twitch';
		           $iconclr = 'amethyst';
		           $small = 'www.twitch.tv';
		        }
		        else 
		        {
		          $url = "javascript::void(0);";
		          $hrefurl = $url;
		          $icon = 'warning';
		          $iconclr = 'warning';
		          $small = 'www.twitch.tv';
		        }
		        
		        
		      ?>
	        <a href="<?php echo $hrefurl ?>" class="widget widget-hover-effect1">
	            <div class="widget-simple">
	                <div class="widget-icon pull-left themed-background animation-fadeIn">
	                    <i class="fa fa-television text-<?php echo $iconclr; ?>"></i>
	                </div>
	                <div class="text-right">
	                	<h3 class="widget-content pull-right text-center text-info animation-pullDown">
	                    	<Strong>
	                    	<?php echo $liveid; ?>
	                    	</Strong>
	                    	<small><?php echo $small ?></small>
	                	</h3>
	                </div>
	            </div>
	        </a>
	        <!-- END Widget -->
	        <div class="text-center text-muted">
	        	~ Member Since ~<br>
	        	<i><?php echo date('M Y', strtotime($pilot->joindate)); ?></i><br>
	        	<small>#pilotpower</small>
	        </div>
			</div>
			</div>
		</div>
	</div>
	<div class="col-md-8">
		<div class="block">
			<div class="block-title">
				<h3><strong>Pilot </strong>Details</h3>
			</div>
			<table class="table table-borderless table-striped table-vcenter animation-fadeIn">
			<tbody>
				<tr>
				<td class="text-right"><strong>Airline Rank</strong></td>
				<td><?php echo $pilot->rank ?></td>
				</tr>
			
			<tr>
				<td class="text-right" style="width: 50%;"><strong>Base Airport</strong></td>
				<td><?php echo $pilot->hub ?></td>
			</tr>
			
			<tr>
				<td class="text-right"><strong>IVAO VID</strong></td>
				<td><?php $ivao = PilotData::GetFieldValue($pilot->pilotid, 'IVAO'); 
					if ($ivao > "0")
					{
						echo '<a target="_blank" class="text-success" href="https://www.ivao.aero/Member.aspx?Id='.$ivao.'">'.$ivao.'</a>';
					}
					else 
					{
						echo '<span class="text-muted">Not Provided</span>';
					}
					?></td>
			</tr>
			<tr>
				<td class="text-right"><strong>VATSIM CID</strong></td>
				<td><?php $vatsim = PilotData::GetFieldValue($pilot->pilotid, 'VATSIM'); 
					if ($vatsim > "0")
					
					{
						echo '<a target="_blank" class="text-success" href="http://www.vataware.com/pilot/'.$vatsim.'">'.$vatsim.'</a>';
					}
					else 
					{
						echo '<span class="text-muted">Not Provided</span>';
					}
				?></td>
			</tr>
			
			<tr>
				<td class="text-right"><strong>Pilot Origin </strong></td>
				<td><?php echo '<img src="'.Countries::getCountryImage($pilot->location).'" alt="'.Countries::getCountryName($pilot->location).'" />'?> (<?php echo $pilot->location; ?>)</td>
			</tr>
			<tr>
				<td class="text-right"><strong>Total Pay </strong></td>
				<td><i class="fa fa-usd"></i> <?php $number = $pilot->totalpay;
						echo number_format($number, 0, '.', ','); ?> /-</td>
			</tr>
			<tr>
				<td class="text-right"><strong>Status</strong></td>
				<td>
					<?php 
					$status = $pilot->retired;
					if ($status < 1)
					{
					 	echo'<span class="label label-success"><i class="fa fa-check"></i> Active </span>';
					}
					else 
					{
						echo '<span class="label label-danger"><i class="gi gi-power"></i> Retired </span>';
					}
					?>
				</td>
			</tr>
		</tbody>
	</table>
		</div>
	</div>
	
	<div class="col-md-8">
		<div class="block">
			<div class="block-title">
				<h3><strong>Pilot</strong> Statistics</h3>
			</div>
			<?php $lastpirep = PIREPData::getLastReports($pilot->pilotid, 1, PIREP_ACCEPTED);
			if(!$lastpirep)
			{ ?>
			    <p class="alert alert-info">
            Oops, looks like there is nothing to calculate from. No worries, we'll have something to show you when <strong><?php echo $pilot->firstname; ?></strong> files a PIREP
          </p>
    <?php } ?>
			<div class="col-sm-3">
				<!-- Widget -->
	        		<a href="javascript::void(0);" class="widget widget-hover-effect2">
	            		<div class="widget-simple">
	                		<h3 class="widget-content text-center text-warning animation-pullDown visible-lg">
	                    		 <strong><?php echo $pilot->totalhours; ?></strong>
	                    		<small>Total Hours</small>
	                		</h3>
	            		</div>
	        		</a>
	        	<!-- END Widget -->
			</div>
			<div class="col-sm-3">
				<!-- Widget -->
	        		<a href="javascript::void(0);" class="widget widget-hover-effect2">
	            		<div class="widget-simple">
	                		<h3 class="widget-content text-center animation-pullDown visible-lg">
	                    		 <strong><?php echo $pilot->totalflights; ?></strong>
	                    		<small>Total Flights</small>
	                		</h3>
	            		</div>
	        		</a>
	        	<!-- END Widget -->
			</div>
			<div class="col-sm-3">
				<!-- Widget -->
				<?php $last_location = PIREPData::getLastReports($pilot->pilotid, 1, PIREP_ACCEPTED);
									$icao = $last_location->arricao; ?>
	        		<a href="http://icrew.iflyva.in/index.php/airports/get_airport?icao=<?php if(!$icao) { echo $pilot->hub; } else { echo $icao; } ?>" class="widget widget-hover-effect2">
	            		<div class="widget-simple">
	                		<h3 class="widget-content text-center text-danger animation-pullDown visible-lg">
	                    		 <strong><?php $last_location = PIREPData::getLastReports($pilot->pilotid, 1, PIREP_ACCEPTED);
									$icao = $last_location->arricao; 
										if(!$last_location) {
								echo $pilot->hub;
								} else { echo $icao; ?><?php
								} ?></strong>
	                    		<small>Current Location </small>
	                		</h3>
	            		</div>
	        		</a>
	        	<!-- END Widget -->
			</div>
			<div class="col-sm-3">
				<!-- Widget -->
	        		<a href="javascript::void(0);" class="widget widget-hover-effect2">
	            		<div class="widget-simple">
	                		<h3 class="widget-content text-center text-success animation-pullDown visible-lg">
	                    		 <strong><?php $newdate = date('d m Y', strtotime($pilot->lastlogin)); echo $newdate;  ?></strong>
	                    		<small>Last Active</small>
	                		</h3>
	            		</div>
	        		</a>
	        	<!-- END Widget -->
			</div>
			
			<?php  
			
			if(!$lastpirep)
			{
				$lrc = 0;
			}
			else if($lastpirep > 0)
			{
				$lr = $lastpirep->landingrate;
			//color for the LR Chart
            if ($lr > -10 && $lr < -200)
            {
            	$lrcolor = "#23bf00";
            }
            else if ($lr > -200 && $lr < -350)
            {
            	$lrcolor = "#faff00";
            }
            else if ($lr > -350 && $lr < -500 )
            {
            	$lrcolor = "#faff00";
            }
            else if ($lr > -500 && $lr < -650 )
            {
            	$lrcolor = "#ff000c";
            }
            else
            {
            	$lrcolor = "#26ff00";
            }
            //LR Chart
            
            $lrc = ($lr / 650) * -100  ;
				   }
			
            
            //From SQL Database
            $gross = $lastpirep->gross;
            $expenses = $lastpirep->expenses;
            $revenue = $lastpirep->revenue;
            if(!$lastpirep)
            {
              $revenue1 = 1;
            	$gross1 = 100;
            }
            else if ($revenue < 0)
            {
            	$revenue1 = 1;
            	$gross1 = 100;
            }
            else 
            {
            	$revenue1 = $lastpirep->revenue;
            	$gross1 = $lastpirep->gross;
            }
            // %for Chart
            $profit = ($revenue1 / $gross1) * 100;
            
            
			        /*EFFICIENCY ALGORITHM*/
            
            	//From SQL Database
            	
            	//% for the chart : 
            	if(!$lastpirep)
              {
              $totalconsumption = 1;
            	$fuelused = 100;
              }
              else
              {
               $fuelused = $lastpirep->fuelused;
            	$flightime = $lastpirep->flighttime;
            	$hours = date("H",strtotime($flightime));
				      $minutes = date("i",strtotime($flightime));
				      $flighttime = ($hours * 60) + $minutes;
            	$fcph = ($flighttime / 60) * 1335 ; //(FUEL CONSUMPTION PER HOUR) 2945 Lbs per hour, 1335 Kgs per hour.
            	$totalconsumption = 400 + 200 + 2000 + $fcph; 
              }
            	$efficiency = ($totalconsumption / $fuelused) * 100;
            ?>
            
            
			<div class="col-sm-4">
				<div class="widget">
					<div class="widget-extra-full text-center">
						<div class="pie-chart easyPieChart" data-percent="<?php echo $lrc;?>" data-size="90" data-bar-color="#003fff">
							<span><i class="fa fa-paper-plane"></i></span>
							<canvas width="90" height="90"></canvas></div><br><span class="text-muted">Landing Smoothness</span>
					</div>
				</div>
			</div>
			
		
				
            
			<div class="col-sm-4">
				<div class="widget">
					<div class="widget-extra-full text-center">
						<div class="pie-chart easyPieChart" data-percent="<?php echo $profit ?>" data-size="90" data-bar-color="#ffa500" style="width: 90px; height: 90px; line-height: 90px;">
							<span><i class="fa fa-usd"></i></span>
							<canvas width="90" height="90"></canvas></div>
							<br><span class="text-muted"> Revenue Earned </span>
					</div>
				</div>
			</div>
			
			
            <div class="col-sm-4">
				<div class="widget">
					<div class="widget-extra-full text-center">
						<div class="pie-chart easyPieChart" data-percent="<?php echo $efficiency ?>" data-size="90" data-bar-color="#00ff3f" style="width: 90px; height: 90px; line-height: 90px;">
							<span><i class="fa fa-leaf"></i></span>
							<canvas width="90" height="90"></canvas></div>
							<br><span class="text-muted"> Efficiency per flight</span>
					</div>
				</div>
			</div>
			
			<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
		</div>
	</div>
	
</div>	            



<div class="row">
	<div class="col-md-12">
		 <div class="block">
            <!-- Quick Stats Title -->
            <div class="block-title text-center ">
                <h2><strong>Recent</strong>  Flights</h2>
            </div>
            
            <div class="col-md-12">
				 <h2 class="text-center"><font face="bauhaus"><?php echo SITE_NAME?></font><br><h3 class="text-center"><small>ICAO Style Log book</small></h3></h2><br><hr size="30">
            </div>
		 <h4 class="text-center"><small>Belongs to </small><br><strong><?php echo $pilot->firstname . ' ' . $pilot->lastname?></strong></h4><hr size="30">
		 <h4 class="text-center text-success">
                        <small> Total Log hours</small><br><strong><?php echo $userinfo->totalhours;?></strong> <br><hr>
                        <h4 class="text-center"><small>Endorsements  <br></small> <strong><?php
         	$endorsements =  PilotData::GetFieldValue($pilot->pilotid, 'Endorsements');
         	if(!$endorsements) { echo '<span class="text-muted">Not Typerated</span>'; } 
         	else
         	{ echo '<span class="text-success">'.$endorsements.'</span>'; 
         	} 
         	?></strong> </h4><hr>
          
         <Center>
         	<button type="button" class="btn btn-alt btn-default" data-toggle="modal" data-target="#myModal">Open</button>
         </Center><br>
        </div>
        
   </div>
</div>	
 
<!-- Trigger the modal with a button -->


<!-- Modal -->
<div id="myModal" class="modal fade" role="dialog">
  <div class="modal-dialog modal-lg">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title text-center"><font face="Bauhaus"><?php echo SITE_NAME?></font><br>PIREP Logbook<br><small>Belongs to <?php echo  $pilot->firstname.' '.$pilot->lastname;?></small></h4>
      </div>
      <div class="modal-body">
        <p>
		    <?php
				$pilotid = $userinfo->pilotid;
				$reports = PIREPData::getLastReports($pilotid, 500,'');
			?>
			<?php
			if(!$reports) {
				echo '
	            <div class="alert alert-info">
	                <h3 class="font-w300 push-15">Information</h3>
	                <p>Oops, No Reports Found for this Pilot.</p>
	            </div></div></div></div>
				';
				return;
			}
			?>
			<div class="table-responsive">
				<table id="example-datatable" class="table table-vcenter table-condensed table-bordered">
				<thead>
					<tr>
						<th class="text-center">Operating Crew<br><h5 class="text-center"><small>P1 / P2</small></h5></th>
						<th class="text-center">Flight Number</th>
						<th class="text-center">Date of Flight (DOF)</th>
						<th class="text-center">Departure (DEP)</th>
						<th class="text-center">Arrival (ARR)</th>
						<th class="text-center">Hours of Flight (HOF)</th>
						<th class="text-center">Passengers On Board (POB)</th>
						<th class="text-center">Landing Rate</th>
						<th class="text-center">Fuel Used</th>
						
					</tr>
				</thead>
				<?php
				foreach($reports as $report)
				{
				?>
				<tr>
					<th class="text-center">P1 : <small><?php echo $pilot->firstname . ' ' . $pilot->lastname?></small></th>
					<td class="text-center"><a href="<?php echo url('/pireps/view/'.$report->pirepid);?>"><?php echo $report->code . $report->flightnum; ?></a></td>
					<td class="text-center"><?php echo $report->submitdate; ?></td>
					<td class="text-center"><?php echo $report->depicao; ?></td>
					<td class="text-center"><?php echo $report->arricao; ?></td>
					<td class="text-center"><?php echo $report->flighttime; ?> Hrs</td>
					<td class="text-center"><?php echo $report->load; ?> pax</td>
					<td class="text-center"><?php echo $report->landingrate; ?> fpm</td>
					<td class="text-center"><?php echo $report->fuelused; ?> Kgs</td>
					
					<?php
					}
					?>
					
				</tr>
				
				
			</table>
			</div>
			</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>

  </div>
</div>
			<?php
		} else {
			if($status == 1 && $self != 0) {
		
		if($status->req_status == 0) {
			$req_sts = 'Request Sent';
			$req_sts_icon = '<i class="fa fa-user-plus"></i>';
			$req_sts_icon_clr = 'warning';
			$text_for_friends_modal = 'You have already sent a friend request to '.$pilot->firstname.', You will be notified once they accept your friend request!';
			
			
		} else if ($status->req_status == 1) {
			$req_sts = 'Friends';
			$req_sts_icon = '<i class="fa fa-check"></i>';
			$req_sts_icon_clr = 'success';
			$friends_since = 'Since ' . date('d.m.Y', strtotime($status->date));
			$text_for_friends_modal = "Are you sure you want to unfriend ".$pilot->firstname."? You cannot be friends with them again";
			
		} else if ($status->req_status == 2) {
			$req_sts = 'You can\'t be friends';
			$req_sts_icon = '<i class="fa fa-user-times"></i>';
			$req_sts_icon_clr = 'danger';
			$text_for_friends_modal = 'This user has rejected your friend request. Sorry';
			
		}
	} else {
			$req_sts = 'Send Friend Request';
			$req_sts_icon = '<i class="fa fa-user-plus"></i>';
			$req_sts_icon_clr = 'info';
			$href='';
			$text_for_friends_modal = 'Would you like to send a friend request to '.$pilot->firstname.' ?';
	}
		?>
			<div class="row">
				<div class="col-md-12">
				<div class="block">
					<div class="block-title">
						<h3>Pilot's <strong>Information</strong></h3>
					</div>
					<div class="alert alert-warning">
						<strong>Oops</strong><br>
						To view this user's details, you need to be their friend.
					</div>
					<a data-toggle="modal" data-target="#friends" class="widget widget-hover-effect1 themed-background-<?php echo $req_sts_icon_clr; ?>">
	            <div class="widget-simple">
	                <div class="widget-simple text-center">
								<h5 class="widget-content widget-content-light">
									<strong><?php echo $req_sts_icon .' '. strtoupper($req_sts); ?></strong>
									<small><?php echo strtoupper($friends_since); ?></small>
								</h5>
						</div>
	            </div>
	        </a>
				</div>
			</div>
			</div>
			<div id="friends" class="modal fade" role="dialog">
  <div class="modal-dialog modal-md">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title text-center theme-background"><strong><small><?php echo SITE_NAME; ?> | Membership Department</small></strong></h4>
      </div>
      <div class="modal-body">
        <p><?php echo $text_for_friends_modal; ?></p>
      </div>
      
      <div class="modal-footer">
      	<form action="<?php $_SERVER["PHP_SELF"]; ?>" method="post">
			<?php if($status->req_status == 0) {
				
			} elseif($status->req_status == 2) {
			
			} 
			elseif($status->req_status == 3) {
			
			} 
			 else {
				?>
				<button type="submit" class="btn btn-md btn-alt btn-<?php echo $req_sts_icon_clr; ?>" name="action" value="sendreq" >
				 <?php echo $req_sts_icon .' '. strtoupper($req_sts); ?>
				</button>
				<?php
			}
			?>
      		<button type="button" class="btn btn-md btn-default btn-alt" data-dismiss="modal">Close</button>
      	</form>
        
      </div>
    </div>

  </div>
</div>

<?php if($_POST['action'] == 'sendreq') {
      	$self_id = Auth::$userinfo->pilotid;
      	$friend_id = $pilot->pilotid;
      	ICSFriends::send_request($self_id, $friend_id); 
      	
      
	?>
	<script>
    $(function() {
    setTimeout(function() {
    $.bootstrapGrowl("<h4>iCrew <strong>Notifications </strong> </h4>You sent a friend request to  <?php echo $pilot->firstname; ?>, you will receive a notification once they accept your request. <br> This may take a few seconds to update in the system, instead of reloading, try going back to see your request status", {
    	ele: 'body', // which element to append to
    	type: 'success', // (null, 'info', 'danger', 'success')
    	offset: {from: 'top', amount: 20}, // 'top', or 'bottom'
    	align: 'right', // ('left', 'right', or 'center')
    	width: 250, // (integer, or 'auto')
    	delay: 11000, // Time while the message will be displayed. It's not equivalent to the *demo* timeOut!
    	allow_dismiss: true, // If true then will display a cross to close the popup.
    	stackup_spacing: 10 // spacing between consecutively stacked growls.
    });
    }, 2000);
    });      
</script>
	<?php
}

		}
	} 
	elseif ($status->req_status == 2 || $status->req_status == 3 ) {
		?>
			<div class="alert alert-warning">
				<strong>Oops</strong><br>
				Information unavailable.
			</div>
		<?php 
	}	
	else {
		
	
	
	if($status == 1 && $self != 0) {
		
		if($status->req_status == 0) {
			$req_sts = 'Request Sent';
			$req_sts_icon = '<i class="fa fa-user-plus"></i>';
			$req_sts_icon_clr = 'warning';
			$text_for_friends_modal = 'You have already sent a friend request to '.$pilot->firstname.', You will be notified once they accept your friend request!';
			
			
		} else if ($status->req_status == 1) {
			$req_sts = 'Friends';
			$req_sts_icon = '<i class="fa fa-check"></i>';
			$req_sts_icon_clr = 'success';
			$friends_since = 'Since ' . date('d.m.Y', strtotime($status->date));
			$text_for_friends_modal = "Are you sure you want to unfriend ".$pilot->firstname."? You cannot be friends with them again";
			
		} else if ($status->req_status == 2) {
			$req_sts = 'You can\'t be friends';
			$req_sts_icon = '<i class="fa fa-user-times"></i>';
			$req_sts_icon_clr = 'danger';
			$text_for_friends_modal = 'This user has rejected your friend request. Sorry';
			
		}
	} else {
			$req_sts = 'Send Friend Request';
			$req_sts_icon = '<i class="fa fa-user-plus"></i>';
			$req_sts_icon_clr = 'info';
			$href='';
			$text_for_friends_modal = 'Would you like to send a friend request to '.$pilot->firstname.' ?';
	}
	
	$mailsub = array('How about a group flight together?', 'How about a charter flight?', 'Wanna fly?', 'Looking for a wingman?');
	$mail_sub = $mailsub[array_rand($mailsub)];
?>



<?php 

} ?>

