<?php 
/**
 * iCrew v4 Premium - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 * 
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other 
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems. 
 * 
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Premium Services (with additions) 
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 * 
 */
?>
<!-- Blank Header -->
<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="gi gi-user"></i><strong>Edit Profile</strong><br><small>Accounts and Settings | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>
<!-- END Blank Header -->

<div class="row">
	<div class="col-md-12">
		<div class="block">
			<div class="block-title">
				<h2>Options </h2>
			</div>
			<ul class="nav-horizontal text-center">
				<li>
					<a data-toggle="tab" href="#home"><i class="fa fa-5x fa-user"></i> Account </a>
				</li>
				
				<li>
					<a data-toggle="tab" href="#menu1"><i class="fa-5x gi gi-asterisk"></i> Password</a>
				</li>
				
				<li>
					<a data-toggle="tab" href="#menu2"><i class="fa-5x fa fa-file-image-o"></i> Profile Avatar</a>
				</li>
				<br>
			</ul>
			<br>
		</div>
	</div>
</div>

<div class="tab-content">
	
	
  <div id="home" class="tab-pane fade in active">
   	<div class="row">
		<div class="col-md-12">
    	<!-- Edit Contact Block -->
        <div class="block">
            <!-- Edit Contact Title -->
            
            <div class="block-title">
                <h2><i class="fa fa-user"></i> Account <strong>Details</strong></h2>
            </div>
            <!-- END Edit Contact Title -->
                <div class="alert alert-danger">
                  YouTube LiveStreamers, Enter your channel UID.
                  Twitch LiveStreamers, Enter Your Channel Name
                </div>
            <!-- Edit Contact Content -->
            <form action="<?php echo url('/Profile');?>" method="post" class="form-horizontal form-bordered">
              
	    
                <div class="form-group">
                    <label class="col-xs-3 control-label" for="material-text2">First Name</label>
                    <div class="col-xs-9">
                        <input class="form-control" type="text" id="material-text2" name="material-text2" placeholder="<?php echo $pilot->firstname;?>" /disabled>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-xs-3 control-label" for="material-text2">Last Name</label>
                    <div class="col-xs-9">
                        <input class="form-control" type="text" id="material-text2" name="material-text2" placeholder="<?php echo $pilot->lastname;?>" /disabled>
                        <span class="text-muted"><small>You cannot change your Name. If you need to change name, open a <a href="<?php echo SITE_URL?>/index.php/helpdesk">support ticket</a>.</small></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-xs-3 control-label" for="material-text2">Hub</label>
                    <div class="col-xs-9">
                        <input class="form-control" type="text" id="material-text2" name="material-text2" placeholder="<?php echo $pilot->hub;?>" /disabled>
                        <span class="text-muted"><small>To change your Operating Hub, you need to open a <a href="<?php echo SITE_URL?>/index.php/helpdesk">Support ticket</a></small></span>
                    </div>
                </div>
                
                
                <div class="form-group">
                    <label class="col-xs-3 control-label" for="email">Email</label>
                    <div class="col-xs-9">
                        <input class="form-control" type="text" id="email" name="email" value="<?php echo $pilot->email;?>" placeholder="johndoe@example.com">
                        <span class="text-muted"><small>All e-mails regarding Flight operations and Human resources will be sent to this email ID.</small></span>
                    </div>
                </div>
                
                
                
	
                <div class="form-group">
                    <label class="col-xs-3 control-label" for="location">Country</label>
                    <div class="col-xs-9">
                        <select class="form-control select-chosen" id="location" name="location" style="width: 100%;" data-placeholder="Choose one..">
							<?php
							foreach($countries as $countryCode=>$countryName)
							{
								if($pilot->location == $countryCode)
									$sel = 'selected="selected"';
								else	
									$sel = '';
								echo '<option value="'.$countryCode.'" '.$sel.'>'.$countryName.'</option>';
							}
							?>
						</select>
                    </div>
                </div>
                 <?php
				if($customfields) {
					
				foreach($customfields as $field)
				{
					if($field->public == 0)
					{
							
					}
					else
					{
						
					
				  echo '<div class="form-group">';
					echo '<label class="col-xs-3 control-label">'.$field->title.'</label>';
				?> <div class="col-xs-9"> 
				
				<?php 
						if($field->type == 'dropdown') {
				$field_values = SettingsData::GetField($field->fieldid);				
				$values = explode(',', $field_values->value);
				
				
				echo "<select class='form-control' name=\"{$field->fieldname}\">";
			
				if(is_array($values)) {		
				    
					foreach($values as $val) {
						$val = trim($val);
						
						if($val == $field->value)
							$sel = " selected ";
						else
							$sel = '';
						
						echo "<option value=\"{$val}\" {$sel}>{$val}</option>";
					}
				}
				
				echo '</select>';
			} elseif($field->type == 'textarea') {
				echo '<textarea class="form-control" name="'.$field->fieldname.'" class="customfield_textarea">'.$field->value.'</textarea>';
			} else {
				echo '<input type="text" class="form-control" name="'.$field->fieldname.'" value="'.$field->value.'" />';
			}
			
		echo '</div>
	</div>';	
		}
				}
	}
	?>
                <div class="form-group form-actions">
                    <div class="col-xs-9 col-xs-offset-3">
                        <input type="hidden" name="action" value="saveprofile" />
						<input class="btn btn-sm btn-primary" type="submit" name="submit" value="Save Changes" />
                    </div>
                </div>
            </form>
            <!-- END Edit Contact Content -->
        </div>
        <!-- END Edit Contact Block -->
    </div>
	</div>
 </div>
  
 
  <div id="menu1" class="tab-pane fade">
    <div class="row">
	    <div class="col-md-12">
        <!-- Change Password -->
        <div class="block">
            <!-- Change Password Title -->
            <div class="block-title clearfix">
                <h2 class="pull-right"><strong>Change</strong> Password <i class="gi gi-asterisk"></i></h2>
            </div>
            <!-- END Change Password Title -->

            <!-- Change Password Content -->
            <form action="<?php echo url('/profile');?>" class="form-bordered" method="post">
                <div class="form-group">
                    <div class="input-group">
                        <span class="input-group-addon"><i class="gi gi-asterisk"></i></span>
                        <input type="password" name="oldpassword" class="form-control" placeholder="Enter Old Password">
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-group">
                        <span class="input-group-addon"><i class="gi gi-asterisk"></i></span>
                        <input type="password" id="password" name="password1" class="form-control" value="" placeholder="Enter New Password">
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-group">
                        <span class="input-group-addon"><i class="gi gi-asterisk"></i></span>
                        <input type="password" name="password2" class="form-control" value="" placeholder="Confirm New Password">
                    </div>
                </div>
                <div class="form-group form-actions">
                    <input type="hidden" name="action" value="changepassword" />
	                <input type="submit" name="submit" class="btn btn-sm btn-primary" value="Save Password" />
                </div>
            </form>
            <!-- END Change Password Content -->
        </div>
        <!-- END Change Password -->
      </div>
	  </div>
  </div>
  
  <div id="menu2" class="tab-pane fade">
    <div class="row">
	    <div class="col-md-12">
        <!-- Change Password -->
        <div class="block">
            <!-- Change Password Title -->
            <div class="block-title clearfix">
                <h2 class="pull-left"><strong>Profile</strong> Avatar <i class="fa fa-file-image-o"></i></h2>
            </div>
            <!-- END Change Password Title -->
			
			<form name="myform" action="<?php echo SITE_URL ?>/index.php/profile/upload" method="POST" enctype="multipart/form-data">
		
	<div class="form-group">
	  <label class="col-xs-3 control-label" for="avatar">Avatar</label>
        <div class="col-xs-9">
			<input type="file" name="avatar">
			
			
			<span class="text-muted">Your image will be resized to <?php echo Config::Get('AVATAR_MAX_HEIGHT').'x'.Config::Get('AVATAR_MAX_WIDTH');?>px</span>
        </div>
	</div>
	
	<div class="form-group">
	  <label class="col-xs-3 control-label" for="avatar">Current Avatar:</label>
        <div class="col-xs-9">
			<?php	
				$pilotCode = PilotData::getPilotCode(Auth::$userinfo->code, Auth::$userinfo->pilotid).'_'.Auth::$userinfo->hub;
			if(!file_exists(SITE_ROOT.AVATAR_PATH.'/'.$pilotCode.'.png')) {
				$image = SITE_URL.'/lib/images/noavatar.png';
			} else {
				$image = SITE_URL.AVATAR_PATH.'/'.$pilotCode.'.png';
			}
		?>
		<br><br>
		<img src="<?php echo $image; ?>" />
		<br><br>
		
		</div>
	</div>

	<div class="form-action">
		<input type="submit" value="Upload Avatar" class="btn btn-primary">
	</div>

			</form>
  
 
            <!-- END Change Password Content -->
        </div>
        <!-- END Change Password -->
      </div>
	  </div>
  </div>
  
  
 
</div>



