<?php
/**
 * iCrew v4 Premium - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 *
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems.
 *
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Premium Services (with additions)
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 *
 */
?>
<!--Page Header-->
<?php

	//Checking for Friend Requests
	$pending_req = ICSFriends::getAllRequests(Auth::$userinfo->pilotid);
	if($pending_req)
		{
			$howmany = count($pending_req);
				if($howmany > 0) {
					$i = 1;
					$from = '';
					foreach ($pending_req as $pr)

						{

						$friend_data = PilotData::getPilotData($pr->self_id);
							if($i == $howmany) {
								$comma = ' ';
							}
							else {
								$comma = ', ';
							}
						$from .= $friend_data->firstname.' '.$friend_data->lastname.''.$conjunction.''.$comma.'';
					$i++;

					}
				}

				//echo $from;
				?>

				<script>
					$(function() {
					setTimeout(function() {
					$.bootstrapGrowl("<h4>iCrew <strong>Notifications </strong> </h4> You have <?php echo $howmany; ?> friendrequest(s) from <?php echo $from; ?> ", {
					ele: 'body', // which element to append to
					type: 'warning', // (null, 'info', 'danger', 'success')
					offset: {from: 'top', amount: 20}, // 'top', or 'bottom'
					align: 'right', // ('left', 'right', or 'center')
					width: 250, // (integer, or 'auto')
					delay: 11000, // Time while the message will be displayed. It's not equivalent to the *demo* timeOut!
					allow_dismiss: true, // If true then will display a cross to close the popup.
					stackup_spacing: 10 // spacing between consecutively stacked growls.
					});
					}, 2000);
					});
				</script>
				<?php
		}

	$style =  PilotData::GetFieldValue($pilot->pilotid, 'Profile Style'); ?>
	<?php if(!$style)
	{ ?>
<div class="widget-advanced widget-advanced-alt">
   <div class="widget">
      <div class="widget-advanced">
         <div class="widget-header text-center">
            <img src="https://assets.icrewsystems.com/images/a0e8bd31f62bf60495015807bd0187c8b8037aee1ce6deba2c5b7a66dc59daf4.jpg" style="width: 100%; height: auto;" alt="background" class="widget-background animation-pulseSlow">
                <br><br><br><br><br><h3 class="widget-content widget-content-image widget-content-light clearfix"><center>

               <?php echo SITE_NAME?><br>
               <small><?php echo VA_TAGLINE?></small><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br></center>
            </h3>
         </div>
         <div class="widget-main text-center">
          <div class="row">
	          <div class="col-md-12">
		<?php $recentpirep = PIREPData::getLastReports(Auth::$userinfo->pilotid, 1, PIREP_ACCEPTED); ?>

				<?php
					$time = date("H");
					
					
					if($time >= 1 && $time < 10) {
					  $greet = "<h4><strong>Good Morning, ".Auth::$userinfo->firstname."!</strong></h4>";
					  $color = "success";
					} elseif($time >= 10 && $time < 17) {
						$greet = "<h4><Strong>Good Day, ".Auth::$userinfo->firstname."!</strong></h4>";
						 $color = "warning";
					} else {
						$greet = "<h4><strong>Good Evening, ".Auth::$userinfo->firstname."!</strong></h4>";
						$color = "info";
					}
				if(!$recentpirep)
				{
					$message = "Welcome to ".SITE_NAME.", we see you haven't logged any flights with us, are you up for an adventure?";
					$color = "danger";
					}
					else if($recentpirep->accepted == 1)
					{
						 $message = 'Your PIREP for flight <strong>'.$recentpirep->code.'-'.$recentpirep->flightnum.'</strong> ('.$recentpirep->depicao.' - '.$recentpirep->arricao.') has been accepted on '.date("D-M-d-Y",strtotime($recentpirep->modifieddate)).' and '.Config::Get('MONEY_UNIT').$recentpirep->pilotpay .' vMoney was credited to your Pilot Account. Click <a href="'.SITE_URL.'/index.php/pireps/view/'.$recentpirep->pirepid.'" class="alert-link" >here</a> to view Post Flight Evaluation';
					}
					else if($recentpirep->accepted == 0)
					{
						 $message = 'Your PIREP for flight <strong>'.$recentpirep->code.'-'.$recentpirep->flightnum.'</strong> ('.$recentpirep->depicao.' - '.$recentpirep->arricao.') was successfully filed on '.date("D-M-d-Y",strtotime($recentpirep->submitdate)).', it will be soon processed by an administrator';
					}

				?>
			<div class="alert alert-<?php echo $color; ?> alert-dismissable animation-fadeIn">
			  <?php echo $greet.' '.$message; ?>
			</div>
	</div>
          </div>
        </div>
      </div>
   </div>
</div>
	<?php } else { ?>
<div class="content-header content-header-media">
    <div class="header-section">
        <div class="row">
            <div class="col-md-4 col-lg-6 hidden-xs hidden-sm">
                <h1>Welcome <strong><?php echo Auth::$userinfo->firstname; ?></strong><br><small>Are you ready to fly?</small></h1>
            </div>
            <div class="col-md-8 col-lg-6">
                <div class="row text-center">
                	<div class="col-xs-4 col-sm-3 hidden-xs">

                    </div>
                	<div class="col-xs-4 col-sm-3">
                        <h2 class="animation-hatch">
							<?php echo MONEY_UNIT ?> <strong><?php echo Auth::$userinfo->totalpay; ?></strong><br>
							<small>vMoney</small>
						</h2>
                    </div>
                    <div class="col-xs-4 col-sm-3">
                        <h2 class="animation-hatch">
							<strong><?php echo Auth::$userinfo->hub; ?></strong><br>
							<small>Airline Hub</small>
						</h2>
                    </div>
                    <div class="col-xs-4 col-sm-3">
                        <h2 class="animation-hatch">
							<strong><?php echo PilotData::GetPilotCode(Auth::$userinfo->code, Auth::$userinfo->pilotid); ?></strong><br>
							<small>Airline Callsign</small>
						</h2>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
	<div class="col-md-12">
		<?php $recentpirep = PIREPData::getLastReports(Auth::$userinfo->pilotid, 1, PIREP_ACCEPTED); ?>

				<?php
					$time = date("H");
					if ($time < "1") {
					  $greet = "<h4><strong>Good Morning Captain!</strong></h4>";
					  $color = "success";
					} elseif ($time < "10") {
						$greet = "<h4><Strong>Good Day Captain!</strong></h4>";
						 $color = "warning";
					} else {
						$greet = "<h4><strong>Good Evening Captain!</strong></h4>";
						 $color = "info";
					}
				if(!$recentpirep)
				{
					$message = "Welcome to ".SITE_NAME.", we see you haven't logged any flights with us! Are you up for an adventure?";
					$color = "danger";
					}
					else if($recentpirep->accepted == 1)
					{
						 $message = 'Your PIREP for flight <strong>'.$recentpirep->code.'-'.$recentpirep->flightnum.'</strong> ('.$recentpirep->depicao.' - '.$recentpirep->arricao.') has been accepted on '.date("m-d-y",strtotime($recentpirep->modifieddate)).' and &#36; '.$recentpirep->pilotpay.' vMoney was credited to your Pilot Account. Click <a href="'.SITE_URL.'/index.php/pireps/view/'.$recentpirep->pirepid.'" class="alert-link" >here</a> to view Post Flight Evaluation';
					}
					else if($recentpirep->accepted == 0)
					{
						 $message = 'Your PIREP for flight <strong>'.$recentpirep->code.'-'.$recentpirep->flightnum.'</strong> ('.$recentpirep->depicao.' - '.$recentpirep->arricao.') was successfully filed on '.date("m-d-y",strtotime($recentpirep->submitdate)).', it will be soon processed by an administrator';
					}

				?>
			<div class="alert alert-<?php echo $color; ?> animation-fadeIn">
			  <?php echo $greet.' '.$message; ?>
			</div>
	</div>
</div>
<?php } ?>

<p>
	<?php
	// MainController::Run('BootstrapNotifications', 'index');
	$notificationsetting =  PilotData::GetFieldValue($pilot->pilotid, 'Show Notifications'); ?>
	<?php if($notificationsetting == Yes)
	{
		// MainController::Run('BootstrapNotifications', 'index');
    }
    else
    {
    }
    ?>
   <!-- <div class="row">
	<div class="col-md-4">
		<a href="<?php echo SITE_URL?>/index.php/schedules" class="widget widget-hover-effect1">
			<div class="widget-simple">
				<h3 class="widget-content text-success text-center animation-pullDown">
					<span class="label label-danger">BOOKING CENTER</span>
					<br>
					<small>Flight Operations</small>
				</h3>
			</div>
		</a>
	</div>
	<div class="col-md-4">
		<a href="<?php echo SITE_URL?>/index.php/CharterOps" class="widget widget-hover-effect1">
			<div class="widget-simple">
				<h3 class="widget-content text-success text-center animation-pullDown">
					<span class="label label-info">CHARTER OPS</span>
					<br>
					<small>Flight Operations</small>
				</h3>
			</div>
		</a>
	</div>
	<div class="col-md-4">
		<a href="<?php echo SITE_URL?>/index.php/CargoOps" class="widget widget-hover-effect1">
			<div class="widget-simple">
				<h3 class="widget-content text-success text-center animation-pullDown">
					<span class="label label-success">CARGO OPS</span>
					<br>
					<small>Flight Operations</small>
				</h3>
			</div>
		</a>
	</div>

</div>-->
<div class="widget">
	<div class="widget-simple">
	<h4 class="widget-content text-center">
		<span class="themed-color">
			<strong><?php echo Auth::$userinfo->firstname;?> <?php echo Auth::$userinfo->lastname;?></strong>
		</span>
			<small><?php echo Auth::$userinfo->rank;?></small>
	</h4>
	</div>

	<div class="widget-extra">
		<div class="row text-center text-muted themed-background-night">

			<div class="col-sm-2 hidden-xs">
				<h3 class="widget-content text">
					<p class="text-center">
						<?php echo Auth::$userinfo->code;?><?php echo Auth::$userinfo->pilotid;?><br>
							<small><i class="fa fa-bolt"></i> Airline Callsign</small>
					</p>
				</h3>
			</div>

			<div class="col-sm-2">
				<h3 class="widget-content text">
					<p class="text-center">
						<?php echo Auth::$userinfo->totalhours;?><br>
                            <small><i class="fa fa-clock-o"></i> Hours Flown</small>
					</p>
				</h3>
			</div>

			<div class="col-sm-2 hidden-xs">
				<h3 class="widget-content text">
					<p class="text-center">
						<?php echo Auth::$userinfo->totalflights?><br>
                            <small><i class="fa fa-plane"></i> Flights Flown</small>
					</p>
				</h3>
			</div>



			<div class="col-sm-2">
				<h3 class="widget-content text">
					<p class="text-center">
						<?php echo Auth::$userinfo->hub?><br>
                            <small><i class="fa fa-map-marker"></i> My Hub</small>
					</p>
				</h3>
			</div>

			<div class="col-sm-2">
				<h3 class="widget-content text">
					<p class="text-center">
						<?php echo Config::Get('MONEY_UNIT'); ?><?php $number = Auth::$pilot->totalpay;
						echo number_format($number, 0, '.', ','); ?><br>
                            <small><i class="fa fa-money"></i> vMoney</small>
					</p>
				</h3>
			</div>

			<div class="col-sm-2 hidden-xs">
				<h3 class="widget-content text">
					<p class="text-center">
						<a href="<?php echo SITE_URL?>/index.php/Ranks" data-toggle="tooltip" data-placement="top" title="<?php echo Auth::$pilot->rank;?>">
							<img src="<?php echo Auth::$pilot->rankimage ?>" class="img-rounded" alt="<?php echo Auth::$pilot->rank?>" width="Auto;" height="Auto;"></a><br>
							<small><i class="fa fa-star"></i> My Rank</small>

					</p>
				</h3>
			</div>
			<?php
				$get_rank_information = RanksData::getRankName(Auth::$userinfo->rank);
				$current_mh = $get_rank_information->minhours;
				$difference = $nextrank->minhours - $current_mh; //hours between 2 ranks
				$hours_in_rank = $pilot_hours - $get_rank_information->minhours;
				if($difference == 0){
					$percent = 100;
				} else {
					$percent = round(((100 * $hours_in_rank)/$difference));
				}


				if($percent > 100) {
					$percent = 100;
					?>
					<div class="col-md-12">
						<div class="progress">
							<div class="progress-bar progress-bar-striped progress-bar-success active" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $percent; ?>%">
								<p style="text-align:center">You've got it all! Cheers captain</p>
							</div>
						</div>
					</div>
					<p style="text-align:center">
						Thank you flying with us, Captain! You are our proud veteran, contact our PR team to get your certificate now!
            		</p>
					<?php
				} else {
					?>
					<div class="col-md-12">
						<div class="progress">
							<div class="progress-bar progress-bar-striped progress-bar-danger active" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $percent; ?>%">
								<p style="text-align:center"><?php echo $percent; ?>% of Hour requirement Complete</p>
							</div>
						</div>
					</div>
					<p style="text-align:center">You have <?php echo round(($nextrank->minhours - $pilot_hours))?> hours
                		left until your promotion to <?php echo $nextrank->rank?>.
            		</p>
					<?php
				}
			?>
		</div>
	</div>
</div>
<!--END Info Bar-->
<!--Stats Bar-->
<div class="block">
	<div class="block-title">
		<h2><i class="fa fa-line-chart"></i> <strong>Pilot</strong> Stats</h2>
	</div>

<?php


function getTotalHoursPilot()
{
	$query = "SELECT SUM(flighttime) AS hours FROM ".TABLE_PREFIX."pireps WHERE pilotid = ".Auth::$userinfo->pilotid." AND accepted = 1";
	$result = DB::get_row($query);
	if (!$result) return 0;
	return ($result->hours == '') ? 0 : $result->hours;
}

function getTotalMilesPilot()
{
	$query = "SELECT SUM(distance) AS distance FROM ".TABLE_PREFIX."pireps WHERE pilotid = ".Auth::$userinfo->pilotid." AND accepted = 1";
	$result = DB::get_row($query);
	if (!$result) return 0;
	return ($result->distance == '') ? 0 : $result->distance;
}

function getTotalPassengersPilot()
{
	$query = "SELECT SUM(`load`) AS passengers FROM ".TABLE_PREFIX."pireps WHERE pilotid = ".Auth::$userinfo->pilotid." AND accepted = 1";
	$result = DB::get_row($query);
	if (!$result) return 0;
	return ($result->passengers == '') ? 0 : $result->passengers;
}


function getAvgLandingPilot()
{
	$query = "SELECT AVG(landingrate) AS rate FROM ".TABLE_PREFIX."pireps WHERE pilotid = ".Auth::$userinfo->pilotid." AND landingrate != 0 AND accepted = 1";
	$result = DB::get_row($query);
	if (!$result) return 0;
	return ($result->rate == '') ? 0 : $result->rate;
}

?>


	<div class="row">
		<div class="col-lg-3">
			<a data-toggle="modal" data-target="#pilotstat" class="widget widget-hover-effect2 themed-background-muted-light">
				<div class="widget-simple">
					<!--<div class="widget-icon pull-right themed-background">
						<i class="fa fa-truck"></i>
					</div>-->
					<h4 class="widget-content text-left">
						<strong><?php $number = getAvgLandingPilot();
						echo number_format($number, 0, '.', ','); ?>

						fpm</strong>
						<small>Landing Rate <strong>Average</strong></small>

					</h4>
				</div>
			</a>
		</div>

		<div class="col-lg-3">
			<a data-toggle="modal" data-target="#pilotstat" class="widget widget-hover-effect2 themed-background-muted-light">
				<div class="widget-simple">
					<!--<div class="widget-icon pull-right themed-background">
						<i class="fa fa-truck"></i>
					</div>-->
					<h4 class="widget-content text-left">
						<strong><?php $number = getTotalPassengersPilot();
						echo number_format($number, 0, '.', ','); ?></strong>
						<small>Passengers <strong>Carried</strong></small>
					</h4>
				</div>
			</a>
		</div>

		<div class="col-lg-3">
			<a data-toggle="modal" data-target="#pilotstat" class="widget widget-hover-effect2 themed-background-muted-light">
				<div class="widget-simple">
					<!--<div class="widget-icon pull-right themed-background">
						<i class="fa fa-truck"></i>
					</div>-->
					<h4 class="widget-content text-left">
						<strong><?php $number = getTotalMilesPilot();

						echo number_format($number, 0, '.', ','); ?> NM</strong>
						<small>Miles <strong>Flown</strong></small>

					</h4>
				</div>
			</a>
		</div>

		<div class="col-lg-3">
			<a data-toggle="modal" data-target="#pilotstat" class="widget widget-hover-effect2 themed-background-muted-light">
				<div class="widget-simple">
					<!--<div class="widget-icon pull-right themed-background">
						<i class="fa fa-truck"></i>
					</div>-->
					<h4 class="widget-content text-left">
						<strong><?php echo Config::Get('MONEY_UNIT'); ?> <?php $number = getTotalHoursPilot();
						if($number != 0) {
							$profit = $number;
						} else {
							$profit = $number;
						}
						echo number_format($profit, 2, '.', ','); ?> </strong>
						<small>Profit <strong>Yielded</strong></small>

					</h4>
				</div>
			</a>
		</div>

	</div>
</div>

<div class="row">
		<div class="col-md-12">
			<div class="widget">
				<div class="widget-advanced widget-advanced-alt">
					<div class="widget-header text-left">
						<img src="https://assets.icrewsystems.com/images/8893055d4a1d6d8b25d249c0aa7a14c1caca787e4f865f494c8a47a8d495bddb.jpg" style="width: 100%;; height: auto;" class="widget-background animation-pulseSlow">
						<h3 class="widget-content widget-content-image widget-content-light clearfix">
							Current Location <i class="gi gi-google_maps animation-pulse"></i>
								<Strong>
									<?php
										$last_location = PIREPData::getLastReports(Auth::$userinfo->pilotid, 1, PIREP_ACCEPTED);
										$icao = $last_location->arricao;
										if(!$last_location) {
											echo Auth::$userinfo->hub;
											} else { echo $icao; ?>
										<?php
										} ?>
								</Strong>

								<br>

								<small>
									<?php $last_location = PIREPData::getLastReports(Auth::$userinfo->pilotid, 1, PIREP_ACCEPTED);
										$icao = $last_location->arricao;
										if(!$last_location) {
										$icao = Auth::$userinfo->hub;
									    AirportData::getMetar($icao);
										} else { ?>
										<font face="courier">
											<?php echo AirportData::getMetar($icao); ?>	
										</font>
										<?php
										} ?>
								</small>
						</h3>
					</div>

					<div class="widget-main">
						<div class="row">
						  <div class="text-center">


						<div class="col-md-6">
								<?php
									$bids = SchedulesData::GetBids(Auth::$userinfo->pilotid);
									if(!$bids) {
									echo '
										<a href="'.SITE_URL.'/index.php/Schedules" class="widget widget-hover-effect1">
										<div class="widget-simple text-danger">
										<h4>
										No <strong>Flights</strong><br>
										<small>
										No bids found, Click to Bid One
										</small>
										</h4>
										</div>
										</a></div>
										';
										} else {
										?>
								<a href="<?php echo SITE_URL ?>/index.php/Schedules/bids" class="widget widget-hover-effect1">
									<div class="widget-simple text-success">
										<h4>
											Next <strong>Flight</strong><br>
											<small>
												<?php foreach($bids as $bid) { ?>
												<?php echo $bid->code . $bid->flightnum; ?> (<?php echo $bid->depicao; ?> <i class="fa fa-plane"></i> <?php echo $bid->arricao; ?>)
												<?php } ?>
											</small>
										</h4>
									</div>
								</a>
							</div> <?php  }  ?>

						<div class="col-md-6 text-center">
							<?php
							if($report) {
							echo '
									<a href="'.SITE_URL.'/index.php/Pireps/mine" class="widget widget-hover-effect1">
									<div class="widget-simple ">
									<h3 class="widget-content animation-pullDown themed-color-dark">
									Latest <strong>Flight</strong>
									<small>'.$report->code . $report->flightnum. ', ' .$report->depicao. ' <i class="fa fa-plane"></i> ' .$report->arricao.'</small>
									</h3>
									</div>
									</a>
									<!-- END Widget -->

	    						 ';	} else { ?>

        				<a href="<?php echo url('/Schedules');?>" class="widget widget-hover-effect1">
            			<div class="widget-simple">
            				<h3 class="widget-content animation-pullDown">
                      Latest <strong>Flight</strong>
                    	<small>Welcome to iCrew. Ready for your first flight? Fly now!</small>
                		</h3>
                	</div>
        				</a>

          	  <?php
                }
              ?>
            </div>


					</div>
						</div>
				</div>

			</div>
		</div>
	</div>
</div>
<!--MAP SECTION-->
<?php
	MainController::Run('ICSMap', 'full');
?>
<!--END MAP SECTION-->
<div class="row">
	<div class="col-md-6">
	<?php
  $bestflighttimeweeks = TopPilots::BestFlightTime_profile();
  $pilotcode = PilotData::getPilotCode($bestflighttimeweek->code, $bestflighttimeweek->pilotid);

    if(!$bestflighttimeweeks)
    {
      $bestflighttimemonth = TopPilots::BestDistance_Allotime();
      foreach($bestflighttimemonth as $bestflighttimemonth)
      {
        $pilotprofile = $bestflighttimemonth;
        $pilotoftheweek = $bestflighttimemonth->firstname.' '.$bestflighttimemonth->lastname;
      }

    }
    else
    {

	foreach($bestflighttimeweeks as $bestflighttimeweeks)
	{
	  $pilotprofile = $bestflighttimeweeks;
	  $pilotoftheweek = $bestflighttimeweeks->firstname.' '.$bestflighttimeweeks->lastname;

 	}
    }
?>
    <div class="widget">
    <div class="widget-advanced widget-advanced-alt themed-color">
      <div class="widget-header text-left">
        <?php
          $pics = file_get_contents(SITE_URL.'/iCrew/backgrounds/backgrounds.txt'); //Take the contents from the file to the variable
          $pictures = explode(',',$pics); //Split it by ','
        ?>
      	<img src="https://i.imgur.com/wVEgAsy.png" style="width: 100%;; height: auto;" class="widget-background animation-pulseSlow">
        <h3 class="widget-content widget-content-image widget-content-light clearfix">
          <a href="<?php echo SITE_URL; ?>/index.php/profile/view/<?php echo $pilotprofile->pilotid; ?>" class="pull-right">
            <i class="fa fa-user text-muted widget-icon"></i>
          </a>
          <a href="<?php echo SITE_URL; ?>/index.php/profile/view/<?php echo $pilotprofile->pilotid; ?>" class="themed-color-default"><?php echo $pilotoftheweek ?></a><br>
            <small>Pilot of the Week</small>
        </h3>
      </div>
  </div>
		</div>

		<div class="block">
			<div class="block-title">
				<h4><i class="hi hi-envelope"></i> <strong>Airline</strong> NOTAMs</h4>
			</div>
			<?php MainController::Run('Notams','widget'); ?>

		</div>


	</div>
	<div class="col-md-6">
		<?php MainController::Run('Events','widget'); ?>
	</div>
</div>

<div class="row">
	<div class="col-md-12">
		<div class="block">
			<div class="block-title">
			  <div class="block-options pull-right">
			  	<?php $lastbid = SchedulesData::GetAllBids();
			  		if(count($lastbid) > 0)
			  		{
			  			$departurestatus = 'Upcoming';
			  			$animation = 'animation-pulse';
			  			$departurecolor = 'success';
			  		}
			  		else
			  		{
			  			$departurestatus = 'No Departures';
			  			$animation = '';
			  			$departurecolor = 'info';
			  		}

			  	?>
			      <span class="label label-<?php echo $departurecolor.' '.$departurecolor?> "><?php echo $departurestatus ?></span>
			  </div>
			</div>
			<h3><i class="fa fa-clock-o"></i> <Strong>Upcoming</Strong> Departures</h3>

						<?php

						if (count($lastbid) > 0)
						{ ?>
						<div class="table-responsive">
							<table id="upcomingdepartures" class="table table-hover table-striped">
							<thead>
								<tr>
									<th><div align="center">OPR</div></th>
									<th><div align="center">FLT</div></th>
									<th><div align="center">PIC</div></th>
									<th><div align="center">ADD</div></th>
									<th style="display:none;"><div align="center">EXP</div></th>
									<th><div align="center">DEP</div></th>
									<th><div align="center">ARR</div></th>
									<th><div align="center">REG</div></th>
								</tr>
							</thead>
						<tbody>
						<?php
							foreach($lastbid as $lastbid)
							{
							?>
							<tr>
							<?php
							$flightid = $lastbid->id;
							?>
							<td height="25" width="10%" align="center">
								<img src="<?php echo fileurl('/lib/images/airline/'.$lastbid->code.'.png'); ?>" alt="" width="90px;" height="auto;" />
							</td>
							<td height="25" width="10%" align="center">
								<span><?php echo $lastbid->code; ?><?php echo $lastbid->flightnum; ?></span>
							</td>
							<?php
							$params = $lastbid->pilotid;

							$pilot = PilotData::GetPilotData($params);
							$pname = $pilot->firstname;
							$psurname = $pilot->lastname;
							$now = strtotime(date(DATE_FORMAT,strtotime($lastbid->dateadded)));
							$expire_time = '+'.Config::Get('BID_EXPIRE_TIME').' hours';
            	$date = date(DATE_FORMAT, strtotime($expire_time, $now));

							?>
							<td height="25" width="10%" align="center"><span><?php echo $pname; ?> <?php echo $psurname; ?></span></td>
							<td  height="25" width="10%" align="center"><span class="text-success"><?php echo date(DATE_FORMAT,strtotime($lastbid->dateadded)); ?></span></td>
							<td style="display:none;" height="25" width="10%" align="center"><span class="text-danger"><?php echo $date; ?></span></td>
							<td  height="25" width="10%" align="center"><span><font face=""><?php echo '<a class="btn btn-default btn-sm" data-toggle="tooltip" data-placement="top" title="Click to view Airport Information!" href="  '.SITE_URL.'/index.php/airports/get_airport?icao='.$lastbid->depicao.'">'.$lastbid->depicao.'</a>';?></font></span></td>
							<td height="25" width="10%" align="center"><span><font face=""><?php echo '<a class="btn btn-default btn-sm" data-toggle="tooltip" data-placement="top" title="Click to view Airport Information!" href=" '.SITE_URL.'/index.php/airports/get_airport?icao='.$lastbid->arricao.'">'.$lastbid->arricao.'</a>';?></font></span></td>
							<td height="25" width="10%" align="center"><span><a class="btn btn- btn-sm" data-toggle="tooltip" data-placement="top" title="Click to view Aircraft Information!" href="<?php echo SITE_URL?>/index.php/vFleetTracker/view/<?php echo '' . $lastbid->registration . ''; ?>"><?php echo $lastbid->registration; ?></a></td>
							</tr>
							<?php
							} ?>
							</tbody>
						</table>
						</div>

						<?php	} else { ?>

							<div class="alert alert-danger">
								<strong>Oops</strong><br>
								There are no upcoming departures at the moment.
							</div>

							<?php
							}
							?>



		</div>
	</div>

    <div class="col-md-12">
        <!-- Latest Orders Block -->
        <div class="block">
            <!-- Latest Orders Title -->
            <div class="block-title">
                <div class="block-options pull-right">
                    <a href="<?php echo url('/Pireps/mine');?>" class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="View Mine"><i class="fa fa-eye"></i></a>
                </div>
            </div>
            <h3><i class="gi gi-airplane"></i> <strong>Latest</strong> PIREPs</h3>
            <!-- END Latest Orders Title -->

            <!-- Latest Orders Content -->
            <?php
			$count = 25; 
			$pireps = PIREPData::getRecentReportsByCount($count);
			?>


			<div  class="table-responsive">
				<table  id="recentpireps" class="table table-striped table-responsive">
				<thead>
					<tr>
						<th>
							OPR
						</th>
						<th>FLT</th>
						<th>DEP</th>
						<th>ARR</th>
						<th>BLK</th>
						<th>PIC</th>
						<th>STS</th>
						<th>PIREP</th>
						<th>DOF</th>
						<th>Options</th>
					</tr>
				</thead>
			<tbody>

			 <?php

			 if(count($pireps) > 0)
			{
			 foreach ($pireps as $pirep)
			 {
			   $pilotinfo = PilotData::getPilotData($pirep->pilotid);
			   $pilotid = PilotData::getPilotCode($pilotinfo->code, $pilotinfo->pilotid);

			   if($pirep->accepted == PIREP_REJECTED) $status = '<span class="label label-danger">Rejected</span>';
			   elseif($pirep->accepted == PIREP_ACCEPTED) $status = '<span class="label label-success">Accepted</span>';
			   elseif ($pirep->accepted == PIREP_PENDING) $status = '<span class="label label-warning animation-pulse">Pending</span>';
				elseif($pirep->accepted == PIREP_INPROGRESS)  $status = '<span class="label label-warning animation-pulse">Under Manual Review</span>';

			   echo '<tr>';
				 echo '<td><img src="'.fileurl('/lib/images/airline/'.$pirep->code.'.png').'" alt="" width="90px;" height="auto;" />';
			   echo '<td>'.$pirep->code.$pirep->flightnum.'</td>';
			   echo '<td>'.$pirep->depicao.'</td>';
			   echo '<td>'.$pirep->arricao.'</td>';
			   echo '<td>'.$pirep->flighttime.' Hrs</td>';
			   echo '<td><Strong>'.$pilotinfo->firstname.' '.$pilotinfo->lastname.'</strong></td>';
			   $schedule = SchedulesData::getScheduleByFlight($pirep->code,$pirep->flightnum);
          $fltime = explode(".", $schedule->flighttime);
          $minstar = substr($fltime[1],0,1);
          $minstarmin = substr($fltime[1],1,2);
          if($minstar == 0) {
          	$minstar = 1;
          } else {
          	$flmin = $minstar * 10;
          }

          if($fltime[0] == 0) {
          	$fltime[0] = 1;
          } else {
          	$flhou = $fltime[0] * 60;
          }

          $flminu = $flhou + $flmin + $minstarmin;
          $actfltime = explode(".", $pirep->flighttime);
          $actminstar = substr($actfltime[1],0,1);
          $actminstarmin = substr($actfltime[1],1,2);

          if($actminstar == 0) {
          	$actminstar = 1;
          }
          else {
          	$actflmin = $actminstar * 10;
          }

          $actflhou = $actfltime[0] * 60;
          $actflminu = $actflhou + $actflmin + $actminstarmin;
          if(($flminu - 20) > $actflminu) {
            echo '<td><span class="text-info"><Strong>EARLY</strong></span></td>';
          } elseif (($flminu + 15) < $actflminu) {
          echo '<td><span class="text-success"><Strong>ON TIME</strong></span></td>';
          } else {
          echo '<td><span class="text-success"><Strong>ON TIME</strong></span></td>'; }

			   echo '<td>'.$status.'</td>';
				 echo '<td>'.date('H:i d-m-Y', $pirep->submitdate).' UTC</td>';
			   echo '<td class="btn-group btn-group-xs">
						<a href="'.SITE_URL.'/index.php/pireps/view/'.$pirep->pirepid.'" class="btn btn-xs btn-default" data-toggle="tooltip" title="" data-original-title="View PIREP"><i class="gi gi-send "></i></a>
						<a href="'.SITE_URL.'/index.php/profile/view/'.$pirep->pilotid.'" class="btn btn-xs btn-default" data-toggle="tooltip" title="" data-original-title="View Pilot"><i class="fa fa-eye "></i></a>
					</td>';
			   echo '</tr>';
			 }
			}
			else
			{
			   echo '<tr><td>There are no recent flights!</td></tr>';
			}
			?>
			  </tbody>
			</table>
			</div>
            <!-- END Latest Orders Content -->
        </div>




        <!-- END Latest Orders Block -->
    </div>
</div>



<!--END Notification Alert END-->
<!--END Page Header-->

<div class="row">
	<div class="col-md-6">
	<div class="widget">
		<div class="widget-advanced">
			<div class="widget-header text-center themed-background-night">
				<h3 class="widget-content"><strong>Monthly</strong> Stats</h3>
			</div>
			<div class="widget-main">
				<a href="javascript:void(0)" class="widget-image-container">
					<span class="widget-icon themed-background"><i class="fa fa-calendar"></i></span>
				</a>
					<p>
            	<?php

				/*
				Added in 2.0!
				*/
				$chart_width = '800';
				$chart_height = '250';
				/* Don Not need to change anything below this here */
				?>
				<div align="left" style="width: 100%;">
					<div id="monthdata" style="height: 250px;"></div>
				</div>
				<script type="text/javascript">
					var json = (function () {
					var json = null;
					$.ajax({
						'async': false,
						'global': false,
						'url': "<?php echo actionurl('/pilots/morrisstatsbymonth');?>",
						'dataType': "json",
						'success': function (data) {
						json = data;
					}
				});
				return json;
				})
			();

		new Morris.Area({
		// ID of the element in which to draw the chart.
		element: 'monthdata',
		// Chart data records -- each entry in this array corresponds to a point on
		// the chart.
		data: json,
		// The name of the data record attribute that contains x-values.
		xkey: 'ym',
		// A list of names of data record attributes that contain y-values.
		ykeys: ['total'],
		// Labels for the ykeys -- will be displayed when you hover over the
		// chart.
		labels: ['Total Flights'],
		behaveLikeLine: true,
		fillOpacity: 0.6,
    	hideHover: 'auto',
    	behaveLikeLine: true,
    	resize: true,
    	pointFillColors:['#E0140F'],
	    pointStrokeColors: ['#E0140F'],
    	lineColors:['#E0140F'],
    	// goals: [250, 1],
    	// goalStrokeWidth: [2],
    	// goalLineColors: ['#afasas']
		});
		</script>
            </p>
			</div>
		</div>
	</div>
</div>

<div class="col-md-6">
	<div class="widget">
		<div class="widget-advanced">
			<div class="widget-header text-center themed-background-night">
				<h3 class="widget-content"><strong>Activity</strong> Feed</h3>
			</div>
		<div class="widget-main">
			<a href="<?php echo SITE_URL; ?>/index.php/ICSActivities" class="widget-image-container">
				<span class="widget-icon themed-background"><i class="fa fa-hourglass-1"></i></span>
			</a>
      <div style="overflow: auto; height: 270px; border: 0px solid #666; margin-bottom: 20px; padding: 5px; padding-top: 0px; padding-bottom: 20px;">
        <?php MainController::Run('ICSActivities', 'widget'); ?>
      </div>
      </div>
		</div>
	</div>
</div>

</div>

<div id="pilotstat" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title"><strong>Statistic </strong>Reports</h4>
      </div>
      <div class="modal-body">
        <p class="h4 text-danger">
          <Strong>Q: </Strong>What are these stats? How are they calculated?
        </p>
        <p><span class="h4"><strong>A: </strong></span><?php echo SITE_NAME?> keeps track of data from your each and every flight, such datum include <b>landing rates, passengers carried, miles flown, </b>and<b> profits yielded.</b>
        These datum are taken on average with the number of flights you have recorded with <?php echo SITE_NAME?>. These datum are updated after each and every flight.
        </p>
        <p>Click <a href="<?php echo SITE_URL?>/index.php/statistics">here</a> to know more about the Virtual Airline's Statistics!</p>
      </div>
      <div class="modal-footer">
        <h5 class="modal-title text-center"><strong><?php echo SITE_NAME?></strong> | Flight Operations &copy; <?php echo date ("Y"); ?></h5>
       </div>
    </div>

  </div>
</div>

<script src="<?php echo SITE_URL; ?>/lib/skins/iCrew/js/pages/tablesDatatables.js"></script>
<script>$(function(){ TablesDatatables.init(); });</script>
<script>
//$(document).ready(function() {
//		$('#upcomingdepartures').DataTable();
//		$('#recentpireps').DataTable();
//	});
</script>