<?php if(!defined('IN_PHPVMS') && IN_PHPVMS !== true) { die(); } ?>
<div class="mapcenter" align="center">
	<div id="routemap" style="width: 80%; height: <?php echo Config::Get('MAP_HEIGHT')?>"></div>
</div>
<?php
/**
 * 
 * This is the new Google Maps v3 code. Be careful of changing
 * things here, only do something if you know what you're doing.
 * 	          
 * These are some options for the map, you can change here.
 * 
 * This map is used for schedules and PIREPS
 * 
 * By default, the zoom level and center are ignored, and the map 
 * will try to fit the all the flights in. If you want to manually set
 * the zoom level and center, set "autozoom" to false.
 * 
 * If you want to adjust the size of the map - Look at the above
 * "routemap" div with the CSS width/height parameters. You can 
 * easily adjust it from there.
 * 
 * And for reference, you want to tinker:
 * http://code.google.com/apis/maps/documentation/v3/basics.html
 */
 
if(isset($pirep))
	$mapdata = $pirep;
if(isset($schedule))
	$mapdata = $schedule;
?>
<?php
/*	This is a small template for information about a navpoint popup 
	
	Variables available:
	
	<%=nav.title%>
	<%=nav.name%>
	<%=nav.freq%>
	<%=nav.lat%>
	<%=nav.lng%>
	<%=nav.type%>	2=NDB 3=VOR 4=DME 5=FIX 6=TRACK
 */
?>
<script type="text/html" id="navpoint_bubble">
	<span style="font-size: 10px; text-align:left; width: 100%" align="left">
	<strong>Fix name: </strong><%=nav.title%> (<%=nav.name%>)<br />
	<strong>Type: </strong>
	<?php	/* Show the type of point */ ?>
	<% if(nav.type == 2) { %> NDB <% } %>
	<% if(nav.type == 3) { %> VOR <% } %>
	<% if(nav.type == 4) { %> DME <% } %>
	<% if(nav.type == 5) { %> FIX <% } %>
	<% if(nav.type == 6) { %> TRACK <% } %>
	<br />
	<?php	/* Only show frequency if it's not a 0*/ ?>
	<% if(nav.freq != 0) { %>
	<strong>Frequency: </strong><%=nav.freq%>
	<% } %>
	</span>
</script>

<?php
/*	Below here is all the javascript for the map. Be careful of what you
	modify!! */
?>
<script type="text/javascript">
function initMap() {
	var options= {
    mapTypeControlOptions: {
      mapTypeIds: []
    }, // here´s the array of controls
    disableDefaultUI: true, // a way to quickly hide all controls
    mapTypeControl: true,
    scaleControl: true,
    zoomControl: true,
    zoomControlOptions: {
      style: google.maps.ZoomControlStyle.LARGE 
    },
    mapTypeId: google.maps.MapTypeId.ROADMAP,
    styles: [ {
        "featureType": "landscape",
        "stylers": [ {
            "color": "#24282d"
        }
        ]
    }
    ,
    {
        "featureType": "administrative",
        "stylers": [ {
            "visibility": "off"
        }
        ]
    }
    ,
    {
        "featureType": "transit",
        "stylers": [ {
            "visibility": "off"
        }
        ]
    }
    ,
    {
        "featureType": "road",
        "stylers": [ {
            "visibility": "off"
        }
        ]
    }
    ,
    {
        "featureType": "water",
        "stylers": [ {
            "color": "#303844"
        }
        ]
    }
    ,
    {
        "featureType": "poi",
        "stylers": [ {
            "visibility": "off"
        }
        ]
    }
    ,
    {
        featureType: "all",
        elementType: "labels",
        stylers: [ {
            visibility: "off"
        }
        ]
    }
    ]
};

/*Polyline Symbol*/
      var lineSymbol = {
     path: 'M 157.98695,184.38488 L 173.37483,168.20017 C 182.38616,159.18884 197.56012,162.31477 197.56012,162.31477 L 242.58958,168.47612 L 265.39575,146.16045 C 277.41087,134.35989 288.26269,152.4142 283.54247,158.63631 L 271.83305,172.24635 L 320.32641,181.22794 L 336.78707,162.03882 C 354.38063,141.01237 367.47041,159.95529 359.53185,171.11218 L 348.89521,184.56906 L 421.75804,194.07153 C 484.40828,133.78139 509.98537,108.77262 526.46939,123.63021 C 543.05967,138.5836 513.71315,168.38877 456.64135,227.17701 L 467.00204,302.24678 L 482.26714,289.52597 C 491.27847,282.01653 507.27901,294.06392 490.75822,309.72648 L 469.76089,329.52825 L 478.61969,378.66527 L 491.73923,368.58052 C 503.32523,359.35463 517.39476,371.55518 501.7322,388.29052 L 480.88803,409.28786 C 480.02981,409.93153 487.69305,452.38631 487.69305,452.38631 C 492.41327,473.19821 480.67347,480.80195 480.67347,480.80195 L 466.35838,493.27782 L 411.97962,339.67439 C 407.47395,326.15738 396.0546,311.47862 376.97351,313.22076 C 366.8894,314.29354 341.41552,331.49026 337.98263,335.56682 L 279.00579,392.27531 C 277.5039,393.34809 288.07915,465.99635 288.07915,465.99635 C 288.07915,468.14191 269.38054,492.66454 269.38054,492.66454 L 232.01433,426.14725 L 213.56128,434.7301 L 224.35108,417.93211 L 157.06733,379.9526 L 182.29502,361.49956 C 194.31014,364.28878 257.3034,371.36975 258.59073,370.72608 C 258.59073,370.72608 309.88762,319.85344 312.81633,316.77643 C 329.76623,298.96831 335.46935,292.31456 338.04402,283.51778 C 340.6208,274.71377 336.23117,261.81195 309.62838,245.4769 C 272.93937,222.94855 157.98695,184.38488 157.98695,184.38488 z',
     scale: 0.055,
     rotation: -45,
     strokeColor: '#FAFAFA',
     fillColor: '#a0d2e1',
     fillOpacity: 1,
     anchor: new google.maps.Point(500, 170)
   };
   
	
	var iconBase = 'https://icrew.skydream-airlines.com/iCrew/map/';
    var iconBase1 = 'http://maps.google.com/mapfiles/ms/micons/';



var map = new google.maps.Map(document.getElementById("routemap"), options);
var dep_location = new google.maps.LatLng(<?php echo $mapdata->deplat?>,<?php echo $mapdata->deplng;?>);
var arr_location = new google.maps.LatLng(<?php echo $mapdata->arrlat?>,<?php echo $mapdata->arrlng;?>);

var bounds = new google.maps.LatLngBounds();                                                                                                     
bounds.extend(dep_location);
bounds.extend(arr_location);

 var depMarker = new google.maps.Marker({
       position: dep_location,
       map: map,
       icon: iconBase + 'green_plane.png',
       title: "<?php echo $mapdata->depname;?>",
       animation:google.maps.Animation.DROP
   });
   var departureinfo = '<?php echo $mapdata->depname;?>, you take off from here';

   var departurewindow = new google.maps.InfoWindow({
       content: departureinfo
   });

   depMarker.addListener('click', function() {
     departurewindow.open(map, depMarker);
   });


   /*Arrival START*/
   var arrivalinfo = '<?php echo $mapdata->arrname;?>, you will be arriving here';

   var arrivalwindow = new google.maps.InfoWindow({
       content: arrivalinfo
   });

   var arrMarker = new google.maps.Marker({
       position: arr_location,
       map: map,
       icon: iconBase + 'red_plane.png',
       title: "<?php echo $mapdata->arrname;?>",
       animation:google.maps.Animation.DROP
   });

   arrMarker.addListener('click', function() {
     arrivalwindow.open(map, arrMarker);
   });


<?php
/* Populate the route */
if(is_array($mapdata->route_details))
{
	$list = array();
	
	foreach($mapdata->route_details as $route)
	{
		if($route->type == NAV_VOR)
			$icon = fileurl('/lib/images/icon_vor.png');
		else
			$icon = fileurl('/lib/images/icon_fix.png');
		
		/*	Build info array for the bubble */
		?>
		var v<?php echo $route->name?>_info = {
			freq: "<?php echo $route->freq ?>",
			name: "<?php echo $route->name ?>",
			title: "<?php echo $route->title ?>",
			type: "<?php echo $route->type ?>",
			lat: "<?php echo $route->lat ?>",
			lng: "<?php echo $route->lng ?>"
		};
		
		var v<?php echo $route->name?>_navpoint_info = tmpl("navpoint_bubble", {nav: v<?php echo $route->name?>_info});
		var v<?php echo $route->name?>_coords = new google.maps.LatLng(<?php echo $route->lat?>, <?php echo $route->lng?>);
		var v<?php echo $route->name?>_marker = new google.maps.Marker({
			position: v<?php echo $route->name?>_coords,
			map: map,
			icon: "<?php echo $icon; ?>",
			title: "<?php echo $route->title; ?>",
			infowindow_content: v<?php echo $route->name?>_navpoint_info
		})
		
		bounds.extend(v<?php echo $route->name?>_coords);
		
		google.maps.event.addListener(v<?php echo $route->name?>_marker, 'click', function() 
		{
			info_window = new google.maps.InfoWindow({ 
				content: this.infowindow_content,
				position: this.position
			});
			
			info_window.open(map, this);
		});
		
		<?php
			
		// For the polyline
		$list[] = "v{$route->name}_coords";
	}
}
?>

 var A = new google.maps.Polyline({
   path: [dep_location, <?php if(count($list) > 0) { echo implode(',', $list).','; }?> arr_location],
   icons: [{
   icon: lineSymbol,
   offset: '100%'
   }],
   strokeColor: '#FAFAFA',
   strokeOpacity: 0.4,
   strokeWeight: 5,
   geodesic: false,
   map: map,
   });

   animateCircle(A);
   function animateCircle(line) {
   var count = 0;
   window.setInterval(function() {
   count = (count + 1) % 200;
   var icons = line.get('icons');
   icons[0].offset = (count / 2) + '%';
   line.set('icons', icons);
   }, 50);
   }

  
// Resize the view to fit it all in
map.fitBounds(bounds); 
}
</script>