<?php
/**
 * iCrew v4 Premium - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 *
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems.
 *
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Premium Services (with additions)
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 *
 */
?>
<!-- Blank Header -->
<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="gi gi-airplane"></i><Strong>Flight Booking</Strong><br><small> Flight Operations | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>
<ol class="breadcrumb breadcrumb-top">
  <li><a href="<?php echo SITE_URL?>/index.php"><i class="fa fa-home"></i></a></li>
  <li><a href="<?php echo SITE_URL?>/index.php/Schedules">Flight Operations</a></li>
  <li>Current Bids</li>
</ol>
<!-- END Blank Header -->
<div class="row">
    <div class="col-md-12">

      <div class="alert alert-warning alert-dismissable animation-fadeIn">
        <strong>Warning</strong><br>
        The bid will be automatically deleted if the flight is not flown within 48 hours of bidding!
      </div>


    	<div class="block">
            <!-- Input Groups - Buttons Title -->
            <div class="block-title">
              <div class="block-options pull-right">
                <label class="label label-default">
                    Dispatch ID : <?php
                    if(!$bids)
                    {
                      echo 'Unable to Fetch request, please Bid a flight first.';
                    }
                    else
                    {
                      foreach($bids as $bid)
        $bido = $bid->distance;
        for ($bido = 0; $bido <= 12; $bido++)
          {
            $bidd = $bido + $bido;
        echo floor($bidd);
          }
                    }

       ?>
                </label>
              </div>
                <h2><i class="gi gi-notes_2"></i> <strong>Current</strong> Bids</h2>
            </div>
            <!-- END Input Groups - Buttons Title -->

            <!-- Input Groups - Buttons Content -->
            <?php
                if(!$bids)
                {
                    echo '<div class="alert alert-info">
						<h3 class="font-w300 push-15">Error</h3>
						<p>Oops, it looks like you have not bid on any flights yet! Click <a class="alert-link" href="'.SITE_URL.'/index.php/Schedules">here</a> to make a bid.</p>
					</div>';
                } else {
            ?>
            <table class="table table-hover table-responsive">
                <thead>
                    <tr>
                        <th>Flight #</th>
                        <th>Route</th>
                        <th>Aircraft</th>
                        <th>Departure Time</th>
                        <th>Arrival Time</th>
                        <th>Distance</th>
                        <th>Options</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        foreach($bids as $bid)
                        {
                    ?>
                    <tr id="bid<?php echo $bid->bidid ?>">
                        <td><?php echo $bid->code . $bid->flightnum; ?></td>
                        <td align="left"><?php echo $bid->depicao; ?> <i class="fa fa-plane"></i> <?php echo $bid->arricao; ?></td>
                        <td align="left"><?php echo $bid->aircraft; ?> (<?php echo $bid->registration?>)</td>
                        <td><?php echo $bid->deptime;?></td>
                        <td><?php echo $bid->arrtime;?></td>
                        <td><?php echo $bid->distance;?>nm</td>
                        <td>
                        	<a data-toggle="tooltip" data-placement="top" title="File PIREP" class="btn btn-sm btn-primary" href="<?php echo url('/pireps/filepirep/'.$bid->bidid);?>"><i class="gi gi-airplane"></i></a>
                            <a data-toggle="tooltip" data-placement="top" onclick="hotsnackbar('hserror', 'Double click to remove!');" title="Remove Bid (Double Click)" id="<?php echo $bid->bidid; ?>" class="btn btn-sm btn-danger deleteitem" href="<?php echo url('/schedules/removebid');?>"><i class="hi hi-remove"></i></a>
                            <a data-toggle="tooltip" data-placement="top" title="Schedule Briefing" class="btn btn-sm btn-warning" href="<?php echo url('/schedules/brief/'.$bid->id);?>"><i class="gi gi-notes_2"></i></a>
                            <a data-toggle="tooltip" data-placement="top" title="Boarding Pass" class="btn btn-sm btn-info" href="<?php echo url('/schedules/boardingpass/'.$bid->id);?>" /><i class="hi hi-tag"></i></a>
                        </td>
                    </tr>
                    <?php
                        }
                    ?>
                </tbody>
            </table>
            <?php
                }
            ?>
        	<!-- END Input Groups - Buttons Content -->
        </div>
    </div>
</div>
