<?php 
/**
 * iCrew v4 Premium - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 * 
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other 
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems. 
 * 
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Premium Services (with additions) 
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 * 
 */
?>
<!-- Blank Header -->
<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="gi gi-airplane"></i>Boarding Pass<br><small>Boarding Pass for Your Upcoming Flight</small>
        </h1>
    </div>
</div>
<!-- END Blank Header -->

<!-- Example Block -->
<div class="block">
    <!-- Example Title -->
    <div class="block-title">
    	<div class="block-options pull-right">
            <a onClick="myFunction()" class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="Print"><i class="hi hi-floppy_disk"></i></a>
            <script> function myFunction() { window.print(); } </script>
        </div>
        <h2><i class="gi gi-airplane"></i> Boarding Pass</h2>
    </div>
    <!-- END Example Title -->

    <!-- Example Content -->
    <p>
    	<style>
		/* Some integrated styles here, for the popup */
		.boardingpass {
			font-family: Tahoma, Verdana;
			font-size: 14px;
		}
		.boardingpass h3 {
			background: none;
			padding-left: 3px;
			padding-bottom: 2px;
		}
		.boardingpass .thickline
		{
			background: #333;
			height: 2px;
		}
		</style>
		<table width="90%" class="boardingpass">
			<tr>
				<td width="1%"><img src="<?php echo SITE_URL?>/lib/images/barcode.png" /></td>
			</tr>
			<tr>
				<td colspan="2"><h3><strong><font face="bauhaus"><?php echo SITE_NAME?></strong> Boarding Pass</h3></td>
			</tr>
			<tr class="thickline">
				<td colspan="2"></td>
			</tr>
			<tr>
				<td valign="top">
					<table class="boardingpass">
						<tr>
						<td>
							<strong>Date:</strong> <br />
							<strong>Name: </strong> <br />
							<strong>Frequent Flyer Number: </strong><br />
							<strong>Boarding Pass Number: </strong> 
						</td>
						<td>
							<?php echo date('Y-m-d'); ?><br />
							<?php echo Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname?><br />
							<?php echo Auth::$userinfo->code.strtoupper(substr(md5(Auth::$userinfo->pilotid), 0, 6))?><br />
							<?php echo $schedule->bidid; ?><br />
						</td>
						</tr>
					</table>
				</td>
				<td valign="top">
					<strong>Gate:</strong> <?php # We are gonna get a random gate
						echo chr(rand(65, 90)); // echo's a random letter between A and Z
						echo rand(1, 30);		// gate # (between 1 and 30)
					?><br />
					<strong>Confirmation:</strong>
					<?php 
						# Generate a hash from the bid id, and get the first 6 characters
						# That'll be used for our confirmation number, and upper-case them
						echo strtoupper(substr(md5($schedule->bidid), 0, 6));
					?>
				</td>
			</tr>
			<tr class="thickline">
				<td colspan="2"></td>
			</tr>
			<tr>
				<td valign="top">
					<strong>Flight Number: </strong><?php echo $schedule->code.$schedule->flightnum?><br />
					<strong>Departure: </strong><?php echo $schedule->deptime; ?><br />
					<strong>Arrival: </strong><?php echo $schedule->arrtime;?><br />
				</td>
				<td valign="top">
					<strong>Aircraft: </strong><?php echo $schedule->aircraft?> <br />	
					<?php echo "$schedule->depname ($schedule->depicao)";?><br />
					<?php echo "$schedule->arrname ($schedule->arricao)"; ?><br />
				</td>
			</tr>
		</table>
    </p>
</div>