<!-- Blank Header -->
<div class="content-header">
   <div class="header-section">
      <h1>
         <i class="gi gi-airplane"></i><Strong>Flight Briefing</Strong><br><small>Flight Operations | <?php
            echo SITE_NAME;
            ?> &copy; <?php
            echo date("Y");
            ?></small>
      </h1>
   </div>
</div>
<ol class="breadcrumb breadcrumb-top">
   <li><a href="<?php
      echo SITE_URL;
      ?>/index.php"><i class="fa fa-home"></i></a></li>
   <li><a href="<?php
      echo SITE_URL;
      ?>/index.php/Schedules">Flight Operations</a></li>
   <li>VADS Flight Briefing</li>
</ol>
<!-- END Blank Header -->
<div class="widget">
   <div class="widget-simple text-center">
      <h4 class="widget-content">
         <h1 class="text-center animation-fadeIn">
            <span class="label label-danger">
            <strong><?php
               echo $schedule->code;
               ?> <?php
               echo $schedule->flightnum;
               ?></strong></small></span><br>
            <small><?php
               echo $schedule->depicao;
               ?> <i class="fa fa-plane animation-pulse"></i> <?php
               echo $schedule->arricao;
               ?></small><br>
               <?php  $airline = OperationsData::getAirlineByCode($route->code);
                $operator = $airline->name;
                $logo = SITE_URL."/lib/images/airline/".$schedule->code.".png";
				?>
				<img src="<?php echo $logo; ?>" style="height: auto; width: 70px;" /><br>
            <!-- Display current Date-->

         </h1>
      </h4>
   </div>
   <div class="widget-extra themed-background-muted">
      <div class="row text-center">
         <div class="col-md-12">
            <h3 class="widget-content-light ">
               <strong><?php
               echo date("F jS \ Y ");
               ?></strong>
            </h3>
         </div>
      </div>
   </div>
   <div class="widget-extra themed-background-dark">
      <div class="row text-center">
         <div class="col-xs-6">
            <h3 class="widget-content-light ">
               <a href="javascript:void(0)" class="text-primary"><strong>ETD</strong></a><br>
               <small><?php
                  echo "{$schedule->deptime}";
                  ?></small>
            </h3>
         </div>
         <div class="col-xs-6">
            <h3 class="widget-content-light ">
               <a href="javascript:void(0)" class="text-primary"><strong>ETA</strong></a><br>
               <small><?php
                  echo "{$schedule->arrtime}";
                  ?></small>
            </h3>
         </div>
      </div>
   </div>
</div>
<?php
   $depicao = $schedule->depicao;
   $arricao = $schedule->arricao;
   $depinfo = OperationsData::getAirportInfo($depicao);
   $arrinfo = OperationsData::getAirportInfo($arricao);
   $depflag = $depinfo->country;
   $arrflag = $arrinfo->country;
   ?>
<?php
   // Route -> basic from vau.aero
   // Wx from ADDS, NOAA
   // Airports data from flightplan database
   // aircrafts...... own database





   // $url = "https://api.flightplandatabase.com/auto/generate";
   // $apiKey = "";
   // $ch = curl_init($url);
   // # Setup request to send json via POST.
   // $payload = json_encode(
   //     array(
   //         "fromICAO"=> "$schedule->depicao",
   //         "toICAO" => "$schedule->arricao",
   //         "fromName" => "$depinfo->name",
   //         "toName" => "$arrinfo->name",
   //         "tags" => "[atlantic]"
   //         ) );
   // curl_setopt( $ch, CURLOPT_POSTFIELDS, $payload );
   // $headers = [
   //     'Content-Type: application/json',
   //     'Authorization: Basic '.$apiKey.''
   // ];

   // curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
   // # Return response instead of printing.
   // curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
   // # Send request.
   // $result = curl_exec($ch);
   // curl_close($ch);
   # Print response.


   // echo $result;


   ?>
<?php
   ?>
<div class="row">
   <div class="col-md-6">
      <div class="block">
         <div class="block-title">
            <div class="block-options pull-right">
               <button onclick="copyToClipboard('#route')" id="rtecopy" class="btn btn-sm btn-default" style="display:none;">
               Copy route
               </button>
            </div>
            <h3><strong>Route</strong></h3>
         </div>
         <p id="route"></p>
         <?php
            // TIHS WOULD CHANGE FROM AIRLINE TO AIRLINE, CHECK BEFORE RELEASE



            if (strpos($schedule->route, 'Enter filed route here before submitting Pirep') !== false) {
                $url     = "https://vau.aero/route/getRoute.php?dep=" . $schedule->depicao . "&nats=R&airac=1812&dest=" . $schedule->arricao . "&rt=OFF&level=H";
                $context = stream_context_create(array(
                    "https" => array(
                        "header" => "User-Agent: Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36"
                    )
                ));
                $route   = file_get_contents($url, false, $context);
                $route_e = explode("#", $route);
                if ($route_e[2] != '') {
                    $fpl_route = $route_e[2];
                    $sql = "UPDATE `phpvms_schedules` SET `route` = '" . $fpl_route . "' WHERE `id` = " . $schedule->id . "";
                    DB::query($sql);
            ?><script>var allow_copy = 1;</script><?php
            } else {
                $fpl_route = "<i class='fa fa-times text-danger'></i> Error : Unable to find route";
            ?><script>var allow_copy = 0;</script><?php
            }
            } else if ($schedule->route != 'American Airlines Passenger Schedule. Enter filed route here before submitting Pirep.') {
            $fpl_route = $schedule->route;
            ?><script>var allow_copy = 1;</script><?php
            } else {
                $fpl_route = "<i class='fa fa-times text-danger'></i> Error : Unable to find route";
            ?><script>var allow_copy = 0;</script><?php
            }

            ?>
         <script>
            var loading_complete = 0;
            function loading() {
                document.getElementById("route").innerHTML = "<center> Fetching route...<br><br> <img src='https://cdn2.scratch.mit.edu/get_image/gallery/2982031_200x130.png' style='width: 50px; height: auto;'></center>";
                setTimeout(function() {
                    document.getElementById("route").innerHTML = "<code><?php
               echo $fpl_route;
               ?></code>";
                    var loading_complete = 1;

                    }, 3000)
                }
            loading();
         </script>
         <script>
            $('#rtecopy').delay(3000).show(0);
         </script>
         <script>
            function copyToClipboard(element) {
                if(allow_copy == 1){
                    var $temp = $("<input>");
                        $("body").append($temp);
                        $temp.val($(element).text()).select();
                        document.execCommand("copy");
                        hotsnackbar('hsdone', 'Route copied to clipboard');
                        $temp.remove();
                } else {
                    hotsnackbar('hserror', 'Oops, no route generated');
                }

            }
         </script>
      </div>

      <div class="block">
         <div class="block-title">
            <div class="block-options pull-right">
               <ul class="nav nav-tabs">
                  <li class="active"><a data-toggle="tab" href="#schdetails" aria-expanded="true">Schedule</a></li>
                  <li><a data-toggle="tab" href="#dispatchconfig" aria-expanded="false"> Dispatch</a></li>
                  <li><a data-toggle="tab" href="#ofpconfig" aria-expanded="false">OFP</a></li>
               </ul>
            </div>
            <h3><strong>Flight</strong> Dispatch Options</h3>
         </div>
         <!--<p id="flightinfo_loading"></p>-->
          <form id="sbapiform" method="get" action="http://www.simbrief.com/ofp/ofp.loader.api.php" target="SBworker">
         <div class="tab-content" id="asd">
            <!-- style="display:none;" -->
            <div id="schdetails" class="tab-pane fade in active">
               <div class="tab-content">
                  <div class="schedule-briefing">
                     <div class="alert alert-info">
                        Please enter the intended take off time slot, this will be used by Simbrief.com to generate your OFP
                     </div>
                     <table class="table table-hover">
                        <tr>
                           <td>
                              <script>
                                 $(function() {
                                   $( "#datepicker" ).datepicker({dateFormat: "Mddy"
                                   });
                                 });
                              </script>
                              <input class="form-control dispinput" value="<?php
                                 echo date('m/d/Y');
                                 ?>" name="date" size="7" type="text" id="datepicker" required>
                           </td>
                           <td>
                              <div class="form-group">
                                 <div class="input-group bootstrap-timepicker">
                                    <div class="bootstrap-timepicker-widget dropdown-menu">
                                       <table>
                                          <tbody>
                                             <tr>
                                                <td><a href="#" data-action="incrementHour"><i class="fa fa-chevron-up"></i></a></td>
                                                <td class="separator">&nbsp;</td>
                                                <td><a href="#" data-action="incrementMinute"><i class="fa fa-chevron-up"></i></a></td>
                                                <td class="separator">&nbsp;</td>
                                                <td><a href="#" data-action="incrementSecond"><i class="fa fa-chevron-up"></i></a></td>
                                             </tr>
                                             <tr>
                                                <td><input type="text" class="form-control bootstrap-timepicker-hour" maxlength="2"></td>
                                                <td class="separator">:</td>
                                                <td><input type="text" class="form-control bootstrap-timepicker-minute" maxlength="2"></td>
                                                <td class="separator">:</td>
                                                <td><input type="text" class="form-control bootstrap-timepicker-second" maxlength="2"></td>
                                             </tr>
                                             <tr>
                                                <td><a href="#" data-action="decrementHour"><i class="fa fa-chevron-down"></i></a></td>
                                                <td class="separator"></td>
                                                <td><a href="#" data-action="decrementMinute"><i class="fa fa-chevron-down"></i></a></td>
                                                <td class="separator">&nbsp;</td>
                                                <td><a href="#" data-action="decrementSecond"><i class="fa fa-chevron-down"></i></a></td>
                                             </tr>
                                          </tbody>
                                       </table>
                                    </div>
                                    
                                    <input type="text" name="timepicker" id="timepicker" onclick="updateTimes();" class="form-control input-timepicker24">
                                    
                                    
                                    <input type="hidden" name="dephour" id="dephour" class="form-control input-timepicker24">
                                    <input type="hidden" name="depmin" id="depmin" class="form-control input-timepicker24">
                                    
                                    <script>
                                    	function updateTimes() {
                                    		var timepicker = document.getElementById('timepicker').value;
                                    		var dephour = document.getElementById('dephour');
                                    		var depmin = document.getElementById('depmin');
                                    		
                                    		var times = timepicker.split(':');
                                    		dephour.value = times[0];
                                    		depmin.value = times[1];
                                    		document.getElementById('selectedTime').innerHTML = dephour.value + ':' + depmin.value;
                                    	}
                                    	
                                    	updateTimes();
                                    </script>
                                    
                                    <span class="input-group-btn">
                                    <a href="javascript:void(0)" class="btn btn-primary"><i class="fa fa-clock-o"></i></a>
                                    </span>
                                 </div>
                                 
                                 <p class="text-muted">
                                 	 <br>
                                 	 Departure time: <span id="selectedTime">NOT SELECTED</span> <span onclick="updateTimes();" class="btn btn-xs btn-success">Update</span>
                                 </p>
                              </div>
                           </td>
                        </tr>
                     </table>
                  </div>
               </div>
            </div>
            <div id="dispatchconfig" class="tab-pane fade">
               <table class="table table-hover">
                  <tr>
                     <td>Aircraft:</td>
                     <td><select class="form-control dispinput" name="type" value="<?php
                        echo $schedule->aircraft;
                        ?>">
                        <?php
                           $ac        = $schedule->aircraft;
                           $equipment = OperationsData::getAircraftByName($ac);
                           $equip     = $equipment;
                           echo '<option value="' . $equip->icao . '">' . $equip->icao . ' - ' . $equip->name . '</option>';
                           ?>
                        </select>
                     </td>
                  </tr>
                  <tr>
                     <td>Airline:</td>
                     <td><input class="form-control dispinput" name="airline" size="5" type="text" placeholder="PIA" maxlength="3" value="<?php
                        echo "$schedule->code";
                        ?>"></td>
                  </tr>
                  <tr>
                     <td>Registration:</td>
                     <td><input class="form-control dispinput" name="reg" size="5" type="text" placeholder="APLBC" maxlength="6" value="<?php
                        echo "$schedule->registration";
                        ?>"></td>
                  </tr>
                  <tr>
                     <td>Flight #:</td>
                     <td><input class="form-control dispinput" name="fltnum" size="5" type="text" placeholder="123" maxlength="4" value="<?php
                        echo "$schedule->flightnum";
                        ?>"></td>
                  </tr>
                  <tr>
                     <td>Origin:</td>
                     <td><input class="form-control dispinput" name="orig" size="5" type="text" placeholder="ZZZZ" maxlength="4" value="<?php
                        echo "$schedule->depicao";
                        ?>"></td>
                  </tr>
                  <tr>
                     <td>Destination:</td>
                     <td><input class="form-control dispinput" name="dest" size="5" type="text" placeholder="ZZZZ" maxlength="4" value="<?php
                        echo "$schedule->arricao";
                        ?>"></td>
                  </tr>
                  
                  <tr>
                     <td>Route:</td>
                     
                     <td>
                     	<textarea class="form-control" name="route"><?php echo $schedule->route; ?></textarea>
                     	<span class="text-muted">
                     	<small>
                     		You can override the default route with your own route to generate an OFP
                     	</small>
                     </span>
                     </td>
                     
                     
                  </tr>
                  <tr>
                     <td>Units:</td>
                     <td>
                        <select class="form-control dispinput" name="units">
                           <option value="KGS" selected>KGS</option>
                           <option value="LBS">LBS</option>
                        </select>
                     </td>
                  </tr>
                  <tr>
                     <td>Cont Fuel: </td>
                     <td>
                        <select class="form-control dispinput" name="contpct">
                           <option value="auto" selected>AUTO</option>
                           <option value="0">0 PCT</option>
                           <option value="0.02">2 PCT</option>
                           <option value="0.03">3 PCT</option>
                           <option value="0.05">5 PCT</option>
                           <option value="0.1">10 PCT</option>
                           <option value="0.15">15 PCT</option>
                           <option value="0.2">20 PCT</option>
                        </select>
                     </td>
                  </tr>
                  <tr>
                     <td>Reserve Fuel: </td>
                     <td>
                        <select class="form-control dispinput" name="resvrule">
                           <option value="auto">AUTO</option>
                           <option value="0">0 MIN</option>
                           <option value="15">15 MIN</option>
                           <option value="30">30 MIN</option>
                           <option value="45" selected>45 MIN</option>
                           <option value="60">60 MIN</option>
                           <option value="75">75 MIN</option>
                           <option value="90">90 MIN</option>
                        </select>
                     </td>
                  </tr>
               </table>
            </div>
            <div id="ofpconfig" class="tab-pane fade">
               <table class="table table-borderless">
                  <tr>
                     <td><label class="col-md-6 control-label" for="navlog">Detailed Navlog:</label> </td>
                     <td class="pull-right">
                        <label class="switch switch-primary"><input type="hidden" name="navlog" value="0">
                        <input type="checkbox" name="navlog" value="1" checked><span></span></label>
                     </td>
                  </tr>
                  <tr>
                     <td><label class="col-md-6 control-label" for="etops">ETOPS Planning:</label> </td>
                     <td class="pull-right">
                        <label class="switch switch-primary"><input type="hidden" name="etops" value="0">
                        <input type="checkbox" name="etops" value="1" checked><span></span></label>
                     </td>
                  </tr>
                  <tr>
                     <td><label class="col-md-6 control-label" for="stepclimbs">Plan Stepclimbs: </label></td>
                     <td class="pull-right">
                        <label class="switch switch-primary"><input type="hidden" name="stepclimbs" value="0">
                        <input type="checkbox" name="stepclimbs" value="1" checked><span></span></label>
                     </td>
                  </tr>
                  <tr>
                     <td><label class="col-md-6 control-label" for="tlr">Runway Analysis:</label> </td>
                     <td class="pull-right">
                        <label class="switch switch-primary"><input type="hidden" name="tlr" value="0">
                        <input type="checkbox" name="tlr" value="1" checked><span></span></label>
                     </td>
                  </tr>
                  <tr>
                     <td><label class="col-md-6 control-label" for="notams">Include NOTAMS:</label></td>
                     <td class="pull-right">
                        <label class="switch switch-primary"><input type="hidden" name="notams" value="0">
                        <input type="checkbox" name="notams" value="1" checked><span></span></label>
                     </td>
                  </tr>
                  <tr>
                     <td><label class="col-md-6 control-label" for="firnot">FIR NOTAMS:</label> </td>
                     <td class="pull-right">
                        <label class="switch switch-primary"><input type="hidden" name="firnot" value="0">
                        <input type="checkbox" name="firnot" value="1" checked><span></span></label>
                     </td>
                  </tr>
               </table>
            </div>
         </div>


      <button type="button"class="btn btn-primary btn-block"
               onclick="simbriefsubmit('<?php echo SITE_URL;?>/index.php/SimBrief');"
               value="Generate SimBrief">Generate Simbrief OFP for <?php echo $schedule->code.''.$schedule->flightnum; ?></button>
                <hr>
               <!--  <a data-toggle="tooltip" title="Prefile a VATSIM flight plan" target="_blank" class="btn btn-md btn-block btn-default" href="https://cert.vatsim.net/fp/file.php?2=<?php
                        echo $schedule->code;
                        ?><?php
                        echo $schedule->flightnum;
                        ?>&3=A320%2FL&4=451&5=<?php
                        echo $schedule->depicao;
                        ?>&6=<?php
                        echo $schedule->deptime;
                        ?>&7=34000&8=<?php
                        echo $schedule->route;
                        ?>&9=<?php
                        echo $schedule->arricao;
                        ?>&10a=00=&10b00=&11=PBN%2FA1B1C1D1O1S1+DOF%2F<?php
                        echo date("y");
                        ?><?php
                        echo date("m");
                        ?><?php
                        echo date("d");
                        ?>+REG%2F<?php
                        echo $schedule->registration;
                        ?>+OPR%2F<?php
                        $schedule->code;
                        ?>+RMK%2FTCAS+VA%2F<?php
                        echo SITE_NAME;
                        ?>&12a=&12b=&13=&14=<?php
                        echo Auth::$userinfo->firstname;
                        ?>+<?php
                        echo Auth::$userinfo->lastname;
                        ?>+&voice=%2FV%2F">
                     VATSIM
                     </a>-->
         <i class="text-muted">
         	<small>Prefile flightplan for online networks available after generating simbrief OFP </small>
         </i>
               <br><br>
        </form>
      </div>

      <div class="block">
         <div class="block-title">
            <h3><strong>Flight</strong> Information</h3>
            <div class="block-options pull-right">
               <ul class="nav nav-tabs">
                  <li class="active"><a data-toggle="tab" href="#home" aria-expanded="true">Details</a></li>
                  <li><a data-toggle="tab" href="#menu3" aria-expanded="false"> Airport</a></li>
                  <li><a data-toggle="tab" href="#menu2" aria-expanded="false"> Weather</a></li>
               </ul>
            </div>
         </div>
         <p id="flightinfo_loading"></p>
         <div class="tab-content" id="flightinfo" style="display:none;">
            <div id="home" class="tab-pane fade in active">
               <div class="row">
                  <div class="col-md-6">
                     <strong>Departure Time :</strong> <?php
                        echo $schedule->deptime;
                        ?><br>
                     <strong>Arrival Time : </strong> <?php
                        echo $schedule->arrtime;
                        ?><br>
                     <Strong>Reporting Time : </Strong>
                     <?php
                        $num1    = $schedule->deptime;
                        $num2    = ("1");
                        $reptime = ($num1 - $num2);
                        echo $reptime;
                        ?>:30 <br>
                     <strong>Distance :</strong> <?php
                        echo $schedule->distance;
                        ?> NM<br>
                     <strong>Enroute Time : </strong>
                     <?php
                        if ($flighttime == 0) {
                            echo '<span class="text-muted">Unavailable</span>';
                        } else {
                            echo $flighttime;
                        }
                        ?>
                  </div>
                  <div class="col-md-6">
                     <strong>Aircraft :</strong> <?php
                        echo $schedule->registration;
                        ?><br>
                     <Strong>Type of Flight :</Strong> <?php
                        $depp      = $schedule->depicao;
                        $arr       = $schedule->arricao;
                        $dep_array = str_split($depp);
                        $arr_array = str_split($arr);
                        if ($dep_array[0] == $arr_array[0]) {
                            $operations = "Domestic";
                        } else {
                            $operations = "International";
                        }
                        echo '<Strong><span class="text-success">' . $operations . '</span></strong>';
                        ?><br>
                     <strong>Cost Index : </strong>
                     <?php
                        if ($operations == "International")
                            $ci = "35";
                        else
                            $ci = "25";
                        ?> <span class="text-info "><Strong><?php
                        echo $ci;
                        ?></Strong></span>
                     <br>
                     <?php
                        if ($schedule->flighttype == "P") {
                            echo "<strong>Pax: </strong>";
                        } else if ($schedule->flighttype == "C") {
                            echo "<br><strong>Cargo (KG): </strong>";
                        }
                        ?>
                     <?php
                        $allaircraft = OperationsData::GetAllAircraft(true);
                        foreach ($allaircraft as $aircraft)
                            if ($aircraft->registration == $schedule->registration) {
                                if ($schedule->flighttype == "P") {
                                    echo round($aircraft->maxpax * 0.80, 0);
                                } else if ($schedule->flighttype == "C") {
                                    echo round($aircraft->maxcargo * 0.80, 0);
                                }
                            }
                        ?>
                     <?php
                        if ($schedule->flighttype == "P") {
                            echo "<br><strong>Cargo (KG): </strong>";
                        } else if ($schedule->flighttype == "C") {
                            echo "PAX:";
                        }
                        ?><?php
                        $allaircraft = OperationsData::GetAllAircraft(true);
                        foreach ($allaircraft as $aircraft)
                            if ($aircraft->registration == $schedule->registration) {
                                if ($schedule->flighttype == "P") {
                                    echo round($aircraft->maxcargo * 0.30, 0);
                                }

                                else if ($schedule->flighttype == "C") {

                                    echo round($aircraft->maxcargo * 0.30, 0);
                                }
                            }
                        ?><br>
                     <strong>Cruise Level: </strong>
                     <?php
                        if ($flightlevel == 0) {
                            echo '<span class="text-muted">Un-restricted</span>';
                        } else {
                            echo $flightlevel;
                        }
                        ?>


                  </div>
               </div>
               <br><br>
            </div>
            <div id="menu2" class="tab-pane fade">
               <ul class="nav nav-tabs">
                  <li class="active"><a href="#depp" data-toggle="tab">Departure</a></li>
                  <li><a href="#arr" data-toggle="tab">Arrival</a></li>
                  <li><a href="#adv" data-toggle="tab">Full WX Briefing</a></li>
               </ul>
               <br>
               <div class="tab-content">
                  <div id="depp" class="tab-pane fade in active">
                     <span class="label label-success"><?php
                        echo $schedule->depicao;
                        ?></span><br><br>
                     <p class="well"><?php
                        $icao = $schedule->depicao;
                        ?>
                        <strong>METAR :</strong> <font face="courier"><?php
                           echo AirportData::getMETAR($icao);
                           ?></font>
                     </p>
                  </div>
                  <div id="arr" class="tab-pane fade in">
                     <span class="label label-danger"><?php
                        echo $schedule->arricao;
                        ?></span><br><br>
                     <p class="well" ><?php
                        $icao = $schedule->arricao;
                        ?>
                        <strong>METAR :</strong> <font face="courier"><?php
                           echo AirportData::getMETAR($icao);
                           ?></font>
                     </p>
                  </div>
                  <div id="adv" class="tab-pane fade in">
                     <ul>
                        <li>Full WX Briefing</li>
                        <li>Recorded ATIS</li>
                        <li>Aerodrome Information</li>
                     </ul>
                     <a href="<?php
                        echo SITE_URL;
                        ?>/index.php/advancedwx" class="btn btn-info btn-md">WX Briefing</a><br><br>
                  </div>
               </div>
            </div>
            <div id="menu3" class="tab-pane fade">
               <?php
                  switch ($depflag) {
                      case "India":
                          $code1 = "IN";
                          break;

                      case "Pakistan":
                          $code1 = "PK";
                          break;

                      case "United Arab Emirates":
                          $code1 = "AE";
                          break;

                      case "Nepal":
                          $code1 = "NP";
                          break;

                      case "Thailand":
                          $code1 = "TH";
                          break;

                      case "Singapore":
                          $code1 = "SG";
                          break;

                      case "Bhutan":
                          $code1 = "BT";
                          break;

                      case "France":
                          $code1 = "FR";
                          break;

                      case "Qatar":
                          $code1 = "QA";
                          break;

                      case "SriLanka":
                          $code1 = "LK";
                          break;

                      default:
                          $code1 = "US";

                  }

                  switch ($arrflag) {
                      case "India":
                          $code2 = "IN";
                          break;

                      case "Pakistan":
                          $code2 = "PK";
                          break;

                      case "United Arab Emirates":
                          $code2 = "AE";
                          break;

                      case "Nepal":
                          $code2 = "NP";
                          break;

                      case "Thailand":
                          $code2 = "TH";
                          break;

                      case "Singapore":
                          $code2 = "SG";
                          break;

                      case "Bhutan":
                          $code2 = "BT";
                          break;

                      case "France":
                          $code2 = "FR";
                          break;

                      case "Qatar":
                          $code2 = "QA";
                          break;

                      case "SriLanka":
                          $code2 = "LK";
                          break;

                      default:
                          $code2 = "US";

                  }
                  ?>
               <strong>Departure : </strong> <span class="text-muted">
               <?php
                  $currtime           = $schedule->deptime;
                  $currnet_time_stamp = strtotime($currtime);
                  $currnettime        = date('H:i:s', $currnet_time_stamp);
                  echo $currnettime . ' Local';
                  echo ' | ';

                  $selectedTime = $currtime;
                  $endTime      = strtotime("+300 minutes", strtotime($selectedTime));
                  echo date('h:i:s', $endTime) . ' PST';

                  ?>
               </span>
               <br><br><?php
                  echo $schedule->depicao;
                  ?>
               <?php
                  echo '<img src="' . Countries::getCountryImage($code1) . '" alt="' . Countries::getCountryName($depflag->country) . '" />';
                  ?>
               | <?php
                  echo $depinfo->name;
                  ?>,
               <?php
                  echo $depinfo->country;
                  ?>
               <br>
               Latitude & Longitude : <?php
                  echo $depinfo->lat . ', ' . $depinfo->lng;
                  ?><br>
               Maintainance Available ?
               <?php
                  if ($depinfo->hub == 1) {
                      $maint = "YES";
                      $color = "success";
                  } else {
                      $maint = "NO";
                      $color = "danger";
                  }
                  ?>
               <span class="text-<?php
                  echo $color;
                  ?>"><Strong><?php
                  echo $maint;
                  ?></Strong></span><br>
               Fuel Price : <?php
                  echo Config::Get("MONEY_UNIT");
                  ?><?php
                  if ($depinfo->fuelprice == 0) {
                      echo "20";
                  } else {
                      echo ($depinfo->fuelprice) / 25 * 64;
                  }
                  ?> /L<br><br>
               <strong>Arrival : </strong><span class="text-muted">
               <?php
                  $currtime           = $schedule->arrtime;
                  $currnet_time_stamp = strtotime($currtime);
                  $currnettime        = date('H:i:s', $currnet_time_stamp);
                  echo $currnettime . ' Local';
                  echo ' | ';

                  $selectedTime = $currtime;
                  $endTime      = strtotime("+300 minutes", strtotime($selectedTime));
                  echo date('h:i:s', $endTime) . ' PST';

                  ?>
               </span>
               <br><br><?php
                  echo $schedule->arricao;
                  ?>
               <?php
                  echo '<img src="' . Countries::getCountryImage($code2) . '" alt="' . Countries::getCountryName($arrflag->country) . '" />';
                  ?>
               | <?php
                  echo $arrinfo->name;
                  ?>,
               <?php
                  echo $arrinfo->country;
                  ?>
               <br>
               Latitude & Longitude : <?php
                  echo $arrinfo->lat . ', ' . $arrinfo->lng;
                  ?><br>
               Maintainance Available ?
               <?php
                  if ($arrinfo->hub == 1) {
                      $maint = "YES";
                      $color = "success";
                  } else {
                      $maint = "NO";
                      $color = "danger";
                  }
                  ?>
               <span class="text-<?php
                  echo $color;
                  ?>"><Strong><?php
                  echo $maint;
                  ?></Strong></span><br>
               Fuel Price : <?php
                  echo Config::Get("MONEY_UNIT");
                  ?><?php
                  if ($arrinfo->fuelprice == 0) {
                      echo "20";
                  } else {
                      echo $arrinfo->fuelprice / 25 * 64;
                  }
                  ?> /L<br><br>
            </div>
         </div>
      </div>
      <script>
         function flightinfo_loading() {
                     document.getElementById("flightinfo_loading").innerHTML = "<center> Generating Flight Information...<br><br> <img src='https://cdn2.scratch.mit.edu/get_image/gallery/2982031_200x130.png' style='width: 50px; height: auto;'></center>";
                     setTimeout(function() {
                         setTimeout(function() {
                         document.getElementById("flightinfo_loading").innerHTML = "";
                         var x = document.getElementById("flightinfo");
                             x.style.display = "block";
                             }, 3000)
                         document.getElementById("flightinfo_loading").innerHTML = "<center> Finalizing Airport and Wx info...<br><br> <img src='https://cdn2.scratch.mit.edu/get_image/gallery/2982031_200x130.png' style='width: 50px; height: auto;'></center>";

                         }, 3000)
                         }
                 flightinfo_loading();
      </script>


      <div class="block">
      	<div class="block-title">
      		<h3><strong>Runway</strong> Data</h3>
      	</div>

      	<p id="runway_text"></p>
    	<div id="runwayinfo" style="display:none;">

    			<div class="table-responsive">
      		<table class="table table-hover table-responsive">
      			<h3>Available Runways at <?php echo $schedule->depicao; ?><br><small><?php echo $schedule->depname; ?></small></h3>
<thead>
<th>Designators</th>
<!--<th>Magnetic Variation</th>-->
<th>Heading</th>
<th>Length</th>
<th>Elevation</th>
<th>Composition</th>
<th>Frequency</th>
<th>Glide Slope</th>
</thead>
<?php $runways1 = AirportData::getrunwaysforairport($schedule->depicao); ?>
<?php if($runways1) foreach($runways1 as $runway1) { ?>
<tr>
<td align="center"><?php echo $runway1->RunwayID; ?></td>
<!--<td align="center"><?php echo $runway1->MagVar; ?></td>-->
<td align="center"><?php echo $runway1->Hdg; ?>&deg;</td>
<td align="center"><?php echo $runway1->Len; ?>&nbsp;ft</td>
<td align="center"><?php echo $runway1->Altitude; ?>&nbsp;ft</td>
<td align="center"><?php echo $runway1->Def; ?></td>
<?php if ($runway1->ILSFreq == 0){ ?>
<td align="center">Unequipped</td>
<td align="center">Unequipped</td>
<?php } else {?>
<td align="center"><?php echo $runway1->ILSid; ?> <?php echo $runway1->ILSFreq; ?> </td>
<td align="center"><?php echo $runway1->ILSslope; ?></td>
</tr>
<?php }} ?>
	</table>
</div>
		<div class="table-responsive">
      		<table class="table table-hover table-responsive">
<h3>Available Runways at <?php echo $schedule->arricao; ?><br><small><?php echo $schedule->arrname; ?></small></h3>
<thead>
<th>Designators</th>
<!--<th>Magnetic Variation</th>-->
<th>Heading</th>
<th>Length</th>
<th>Elevation</th>
<th>Composition</th>
<th>Frequency</th>
<th>Glide Slope</th>
</thead>
<?php $runways1 = AirportData::getrunwaysforairport($schedule->arricao); ?>
<?php if($runways1) foreach($runways1 as $runway1) { ?>
<tr>
<td align="center"><?php echo $runway1->RunwayID; ?></td>
<!--<td align="center"><?php echo $runway1->MagVar; ?></td>-->
<td align="center"><?php echo $runway1->Hdg; ?>&deg;</td>
<td align="center"><?php echo $runway1->Len; ?>&nbsp;ft</td>
<td align="center"><?php echo $runway1->Altitude; ?>&nbsp;ft</td>
<td align="center"><?php echo $runway1->Def; ?></td>
<?php if ($runway1->ILSFreq == 0){ ?>
<td align="center">Unequipped</td>
<td align="center">Unequipped</td>
<?php } else {?>
<td align="center"><?php echo $runway1->ILSid; ?> <?php echo $runway1->ILSFreq; ?> </td>
<td align="center"><?php echo $runway1->ILSslope; ?></td>
</tr>
<?php }} ?>

</tr>
</table>
      	</div>
    	</div>
      	<br>
      	<i><span class="text-muted">Data provided by openaip.net</span></i>
      	<br><br>
      	</div>

      	<script>
         function runwayinfo_loading() {
				         document.getElementById("runway_text").innerHTML =	"<center> Getting Runway data....<br><br> <img src='https://cdn2.scratch.mit.edu/get_image/gallery/2982031_200x130.png' style='width: 50px; height: auto;'></center>";
                     setTimeout(function() {
                         document.getElementById("runway_text").innerHTML = "";
                         var x = document.getElementById("runwayinfo");
                             x.style.display = "block";
                             }, 3000)
                         }
                 runwayinfo_loading();
      </script>

   </div>
   <div class="col-md-6">
      <div class="block">
         <div class="block-title">
            <h3><i class="gi gi-google_maps"></i> <Strong>Route</Strong> Map</h3>
         </div>
         <div class="block-header text-center">
            <h5 class="text-muted"> <?php
               echo $schedule->depname; 
               ?> - <?php
               echo $schedule->arrname;
               ?> </h5>
         </div>
         <p>
            <?php
               Template::set('route', $fpl_route);
               Template::Show('route_map.php');
               ?>
         <hr>
         <span class="text-muted text-center"><i>If the map is not loading, please try to reload. This might be to a slow internet connection</i> </span>
         </p>
      </div>
   </div>
   <div class="col-md-6">
      <div class="block">
         <div class="block-title">
            <div class="block-options pull-right">
               <label class="label label-success">
               Departure
               </label>
            </div>
            <h3><i class="gi gi-cloud"></i> <Strong>Weather</Strong> Map</h3>
         </div>
         <p>
            <iframe src="https://embed.windyty.com/?<?php
               echo $depinfo->lat . ',' . $depinfo->lng;
               ?>,5,in:12,menu,message,marker" width="100%" height="360px"></iframe>
         </p>
         </p>
      </div>
      <div class="block">
         <div class="block-title">
            <div class="block-options pull-right">
               <label class="label label-danger">
               Arrival
               </label>
            </div>
            <h3><i class="gi gi-cloud"></i> <Strong>Weather</Strong> Map</h3>
         </div>
         <p>
            <iframe src="https://embed.windyty.com/?<?php
               echo $arrinfo->lat . ',' . $arrinfo->lng;
               ?>,5,in:12,menu,message,marker" width="100%" height="360px"></iframe>
         </p>
         </p>
      </div>
   </div>
</div>
<!-- Modal -->
<div id="myModal" class="modal fade" role="dialog">
   <div class="modal-dialog">
      <!-- Modal content-->
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title"><Strong><?php
               echo SITE_NAME;
               ?> | Manual PIREPS</Strong></h4>
         </div>
         <div class="modal-body">
            <p>The pilot is allowed to file a Manual PIREP only if
            <ul>
               <li>Violation of flight operations <a href="<?php
                  echo SITE_NAME;
                  ?>/index.php/Documentation/pireps">Read More <i class="fa fa-external-link"></i></a> </li>
               <li>Simulator Crash</li>
               <li>Failed to start Flight tracking software</li>
            </ul>
            <br>
            Due to great potential of abuse, each pilot is limited to <strong>10 hours</strong> of manual PIREPs on a rolling month basis.
            <span class="text-muted"> You have to file a manual PIREP <strong>ONLY</strong> through "Current Bids" page.</span>
            </p>
         </div>
         <div class="modal-footer">
            <a href="<?php
               echo SITE_NAME;
               ?>/index.php/Schedules/bids" class="btn btn-success">Continue</a>
         </div>
      </div>
   </div>
</div>
<div id="livestream" class="modal fade" role="dialog">
   <div class="modal-dialog">
      <!-- Modal content-->
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title"><Strong><?php
               echo SITE_NAME;
               ?> | Live Stream</Strong></h4>
         </div>
         <div class="modal-body">
            <p>Going Live ? Great! <br>
               Just let us know your Username, and we'll just do the rest!
               <br><span class="text-muted">Enter your Twitch <Strong>username</Strong>, not the livestream URL</span>
            <form name="livestream" action="<?php
               echo url('/livestream');
               ?>" method="post" class="form-horizontal form-bordered">
               <div class="form-group">
                  <label class="col-md-3 control-label" for="livestream">User Name</label>
                  <div class="col-md-9">
                     <input type="text" id="livestream" name="livestream" class="form-control">
                  </div>
               </div>
            </form>
            <br>
            </p>
         </div>
         <div class="modal-footer">
            <input type="submit" name="submit" value="Submit" class="btn btn-flat btn-primary">
         </div>
      </div>
   </div>
</div>
