<?php 
/**
 * iCrew v4 LITE - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 * 
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other 
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems. 
 * 
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Intermediate Services (with additions) 
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 * 
 */
?>

<!-- Blank Header -->
<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="gi gi-airplane"></i><Strong>Flight Briefing</Strong><br><small>Flight Operations | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>
<ol class="breadcrumb breadcrumb-top">
  <li><a href="<?php echo SITE_URL ?>/index.php"><i class="fa fa-home"></i></a></li>
  <li><a href="<?php echo SITE_URL ?>/index.php/Schedules">Flight Operations</a></li>
  <li>VADS Flight Briefing</li>
</ol>
<!-- END Blank Header -->

<div class="row">
    <div class="col-md-12">
      
      <div class="alert alert-info alert-dismissable animation-fadeIn">
        <strong>Information</strong><br>
        Everytime you add a flight to your bid list, VADS will automatically generate the briefing sheet with current aviation routine WX data, the loads according to the flight parameters and the fuel price according to the airport's live fuel price. To re-generate, delete the bid and re-bid again.
      </div>
       <div class="row">
         <div class="col-sm-4">
          <a data-toggle="modal" href="#myModal" class="widget widget-hover-effect1">
            <div class="widget-simple"> 
            <h3 class="widget-content text-center animation-pullDown">
               <span class="label label-success" id="proceed" style="display: none;">ONLINE</span> <br>
                <small>System <strong>Status</strong></small>
              </h3>
            </div>
          </a>
        </div>
        
        <div class="col-sm-4">
          <a data-toggle="modal" href="#myModal" class="widget widget-hover-effect1">
            <div class="widget-simple"> 
            <h3 class="widget-content text-center animation-pullDown">
               <strong><span class="text-success" id="decline" style="display: none;"><?php echo VA_NAVDATA; ?></span></strong><br>
                <small> NavData <strong>Information</strong></small>
              </h3>
            </div>
          </a>
        </div>
        
        <div class="col-sm-4">
          <a data-toggle="modal" href="#myModal" class="widget widget-hover-effect1">
            <div class="widget-simple"> 
            <h3 class="widget-content text-center animation-pullDown">
               <strong><span class="text-info" id="recline" style="display: none;"><?php echo StatsData::TotalFlights(); ?></span></strong><br>
                <small> Total <strong>Dispatches</strong></small>
              </h3>
            </div>
          </a>
        </div>
        
        <script type="text/javascript" src="//code.jquery.com/jquery-1.10.2.js"></script>
         <script type="text/javascript">
           $('#proceed').delay(3000).show(0);   
         </script>
         <script type="text/javascript">
           $('#decline').delay(4000).show(0);   
         </script>
         <script type="text/javascript">
           $('#recline').delay(4000).show(0);   
         </script>
        </div>
      
    	<div class="block">
            <!-- Input Groups - Buttons Title -->
            <div class="block-title">
              <div class="block-options pull-right">
                <label class="label label-default">
                    Bidding ID : <?php 
                    if(!$bids)
                    {
                      echo "Error, failed to generate, No bids";
                    }
                    else 
                    {
                      foreach($bids as $bid) 
                      $bido = $bid->distance;
                      for ($bido = 0; $bido <= 12; $bido++)
                      {
                        $bidd = $bido + $bido; 
                        echo floor($bidd);
                      }
                    }
        
       ?>
                </label>
              </div>
                <h2><i class="gi gi-notes_2"></i> Flights on <strong>Bids</strong></h2>
            </div>
            <!-- END Input Groups - Buttons Title -->

            <!-- Input Groups - Buttons Content -->
            <?php
                if(!$bids)
                {
                    echo '<div class="alert alert-info">
						<h3 class="font-w300 push-15">Error</h3>
						<p>Oops, it looks like you have not bid on any flights yet! Click <a class="alert-link" href="'.SITE_URL.'/index.php/Schedules">here</a> to make a bid.</p>
					</div>';
                } else {
            ?>
            <div class="table-responsive">
              <table class="table table-hover table-responsive">
                <thead>
                    <tr class="text-center">
                        <th>Flight #</th>
                        <th>Sector</th>
                        <th>Departure Time</th>
                        <th>Arrival Time</th>
                        <th>Operations</th>
                        <th>Routing</th>
                        <th>OFP Status</th>
                        <th>Options</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        foreach($bids as $bid)
                        {
                    ?>
                    <tr class="text-center" id="bid<?php echo $bid->bidid ?>">
                        <td><?php echo $bid->code . $bid->flightnum; ?></td>
                        <td align="left"><?php echo $bid->depicao; ?> <i class="fa fa-plane"></i> <?php echo $bid->arricao; ?></td>
                        <td><?php echo $bid->deptime;?></td>
                        <td><?php echo $bid->arrtime;?></td>
                        <td>
                          <?php 
                          
                          {
                          	$ops = str_split($bid->depicao); 
                          	$ops2 = str_split($bid->arricao); 
                          	
                          	if($ops[0] == $ops2[0]) {
                          		$operations = "Domestic";
                          	} else {
                          		$operations = "International";
                          	}
								echo '<Strong><span class="text-info">'.$operations.'</span></strong>';
                          }
								        ?>
                        </td>
                        <td><?php if(!$bid->route)
                        {
                         echo '<span class="text-danger">Not Available</span>'; 
                        }
                        else 
                        {
                          echo '<span class="text-success">Available</span>';
                        }
                        ?></td>
                        <td><i class="fa fa-check text-success"></i> 
                        </td>
                        <td>
                          <a data-toggle="tooltip" data-placement="top" title="View Briefing Sheet" class="btn btn-sm btn-default" href="<?php echo url('/schedules/brief/'.$bid->id);?>"><i class="fa fa-eye"></i></a>
                        </td>
                    </tr>
                    <?php
                        }
                    ?>
                </tbody>
            </table>
            </div>
            <?php
                }
            ?>
        	<!-- END Input Groups - Buttons Content -->
        </div>
    </div>
</div>
<div id="myModal" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title"><Strong>VADS | Virtual Airline Dispatch System</Strong></h4>
      </div>
      <div class="modal-body">
        <p>This is a brand new feature devloped by iCrew Systems which contains sets of Algorithims to calculate/prepare the necessary values for flight briefing from the given flight parameters
         <br><br> The VADS System does not employ Simbrief or any other Flight calculation tool. But also, it has its own limitations....
         <br><br>        
        </p>
       <span class="text-muted"> If the system is OFFLINE, clear cache data from your browser and try again <br> To Update the NavData, contact the Flight Operations Staff</span>
        </p>
      </div>
      <div class="modal-footer">
        <center><span class="text-muted"><?php echo SITE_NAME; ?> | VADS &copy; iCrewSystems <?php echo date("Y"); ?></span></center>
      </div>
    </div>

  </div>
</div>

