<div class="content-header">
   <div class="header-section">
      <h1>
         <i class="gi gi-airplane"></i><Strong>Flight Booking</Strong><br><small>Flight Operations | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small>
      </h1>
   </div>
</div>
<?php
   // Current location.
   	$current_location = ICSScheduleMap::current_location();
   // Flights from current location.
   	$avail_flights = ICSScheduleMap::flights_from_location($current_location->icao, 100);
   // Onclick Show schedules.

   ?>
<ol class="breadcrumb breadcrumb-top">
   <li><a href="<?php echo SITE_URL?>/index.php"><i class="fa fa-home"></i></a></li>
   <li>Flight Operations</li>
</ol>
<div class="row">
   <div class="col-md-12">
      <a href="javascript::(0)" class="widget widget-hover-effect5">
         <div class="widget-simple">
            <h3 class="widget-content text-center animation-pullDown">
               <strong><?php echo $current_location->icao; ?></strong><br>
               <small>Your current location </small>
            </h3>
         </div>
      </a>
      <?php
         // Quick options logics
         if($current_location->icao == Auth::$userinfo->hub) {
         $backhome_animation = 'effect6';
         $backhome_color = 'muted';
         } else {
         $backhome_animation = 'effect1';
         $backhome_color = 'success';
         }
         ?>
      <span class="text-center text-muted">
         <p>Quick Options</p>
      </span>
      <div class="col-sm-6 col-lg-3">
         <a href="#" class="widget widget-hover-<?php echo $backhome_animation; ?>">
            <div class="widget-simple">
               <h3 class="text-<?php echo $backhome_color; ?> widget-content text-center animation-pullDown">
                  Back <strong>Home</strong><br>
                  <small>Schedules to <?php echo Auth::$userinfo->hub; ?></small>
               </h3>
            </div>
         </a>
      </div>
      <div class="col-sm-6 col-lg-3">
         <a href="<?php echo url('schedules/route_network/'.$current_location->icao.'?limit=150'); ?>" class="widget widget-hover-effect1">
            <div class="widget-simple">
               <h3 class="text-info widget-content text-center animation-pullDown">
                  Route <strong>Network</strong><br>
                  <small>Route Network from <?php echo $current_location->icao; ?></small>
               </h3>
            </div>
         </a>
      </div>
      <div class="col-sm-6 col-lg-3">
         <a href="<?php echo SITE_URL; ?>/index.php/schedules/jumpseat_to_hub" class="widget widget-hover-<?php echo $backhome_animation; ?>">
            <div class="widget-simple">
               <h3 class="text-<?php echo $backhome_color; ?> widget-content text-center animation-pullDown">
                  Quick <strong>Jump</strong><br>
                  <small>Jumpseat to <?php echo Auth::$userinfo->hub; ?></small>
               </h3>
            </div>
         </a>
      </div>
      <div class="col-sm-6 col-lg-3">
         <a data-toggle="modal" data-target="#exampleModalLong" class="widget widget-hover-effect1">
            <div class="widget-simple">
               <h3 class="text-danger widget-content text-center animation-pullDown">
                  Quick <strong>Reposition</strong><br>
                  <small>Reposition yourself across our network</small>
               </h3>
            </div>
         </a>
      </div>
   </div>

<!-- Modal -->
<div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h3><strong>Choose Jumpseat location</strong>
        	<br>
        	<small>You can jumpseat to any of our hub airports.</small>
        </h3>
      </div>
      <div class="modal-body">
        <form method="POST" action="<?php echo SITE_URL; ?>/index.php/schedules/jumpseat">
        	<p>
        		Choose your destination airport to jumpseat. Caution, jumpseats cost vMoney
        	</p>
        	
        	<?php 
        		if(JUMPSEAT_AIRPORTS_ONLY_HUBS == 1) {
        			// Getting all the hubs. 
        			$airports = OperationsData::getAllHubs();
        		?>
					<select id="destination" name="destination" class="form-control select-chosen">
							<?php
								foreach ($airports as $airport) {
									?>
									<option value="<?php echo $airport->icao; ?>"><?php echo $airport->icao; ?></option>
									<?php
								}
							?>
					</select>	
					
					</div>
			      <div class="modal-footer">
			      	<input type="hidden" name="currentloc" value="<?php echo $current_location->icao; ?>" />
			      	<input type="hidden" name="action" value="Get Jumpseat" />
			        <input type="submit" name="submit" value="Get Jumpseat" class="btn btn-success" />
			        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
			        </form>
			      </div>
        		
        		<?php
        		} else { 
        			
        			// Since they want to Jumpseat all the airports
        			?>
        			
        			<span x-data="jumpseatAlpine">
        				<input type="text" class="form-control" name="destination" id="jumpseat_icao" placeholder="Enter 4 digit ICAO code" @click="resetForm" style="text-transform: uppercase;" />	
        				
        				<br>
        				<p x-show="showJumpseatButton" x-html="message" id="jumpseat_message" class="alert alert-info">
        				</p>
        				
        				<br>
        				<button type="button" x-show="showVerifyButton" class="btn btn-md btn-success" @click="verifyICAO">Verify Airport</button>
        			
        			
        			
        			
        			
        			
        			
        			
				      <div class="modal-footer">
				      	<input type="hidden" name="currentloc" value="<?php echo $current_location->icao; ?>" />
				      	<input type="hidden" name="action" value="Get Jumpseat" />
				        <input x-show="showJumpseatButton" type="submit" name="submit" value="Get Jumpseat" class="btn btn-success" />
				        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
				        </form>
				      </div>
				      </div>
				      </span>
				     
				     
				     <script>
        				function jumpseatAlpine() {
        					return {
        						icaoCode: null,
        						showJumpseatButton: false,
        						showVerifyButton: true,
        						message: null,
        						
        						toggleVerifyButton() {
        							this.showVerifyButton = !this.showVerifyButton;	
        						},
        						
        						toggleJumpseatButton() {
        							this.showJumpseatButton = !this.showJumpseatButton;
        						},
        						
        						resetForm() {
        							this.showJumpseatButton = false;
        							this.showVerifyButton = true;
        							this.message = null;	
        						},
        						
        						verifyICAO() {
        							this.icaoCode = document.getElementById('jumpseat_icao').value;
        							if(this.icaoCode.length != 4) {
        								alert('Please enter a valid ICAO code and try again');
        							} else {
        								
        								
        								this.showVerifyButton = false;
        								this.showJumpseatButton = false;
        								
        								 fetch(`https://theanswer.vuainc.org/action.php/schedules/verify_jumpseat_airport/${this.icaoCode}`)
								          .then(res => res.json())
								          .then(data => {
								          	
								          	if(data.code == 200) {
								          		this.message = data.message;	
									          	this.showVerifyButton = true;
									        	this.showJumpseatButton = true;
								          	} else {
								          		this.message = data.message;
								          		this.showJumpseatButton = false;
								          		this.showVerifyButton = true;
								          	}
								          	
								            
								            
								            
								          });
								          
								         this.showVerifyButton = true;
								         this.showJumpseatButton = true;
        							}
        							
        							
        						},
        						
        						
        						
        					}
        				}
        			</script>
        			<?php
        			
        		}
        	?>
        
      
    </div>
  </div>
</div>
 <div class="col-md-12">
      <div class="block no-border">
         <div class="block-title">
            <div class="block-options pull-right">
               <label class="label label-success">
               Departing from <?php echo $current_location->icao; ?>
               </label>
            </div>
            <h3>Schedule <strong>Search</strong></h3>
         </div>
         <p>
         <form id="form" action="<?php echo url('/schedules/view');?>" method="post">
            <p class="alert alert-warning animation-fadeIn">
               <?php MainController::Run('DestinationTip', 'index'); ?>
            </p>
            <!-- Custom Tabs -->
            <div class="nav-tabs-custom">
               <ul class="nav nav-pills">
                  <li class="active"><a href="#tab_1" data-toggle="tab">Airline</a></li>
                  <li ><a href="#tab_2" data-toggle="tab">Destination</a></li>
                  <li><a href="#tab_3" data-toggle="tab">Aircraft</a></li>
                  <li><a href="#tab_4" data-toggle="tab">Distance</a></li>
                  <li><a href="#tab_5" data-toggle="tab">Type</a></li>
               </ul>
               <div class="tab-content">
                  <div class="tab-pane fade in active" id="tab_1">
                     <br>
                     <div class="form-group">
                        <!-- <input type="text" id="depicao" name="depicao" class="form-control" placeholder="<?php echo $current_location->icao; ?>" value="<?php echo $current_location->icao; ?>" disabled=""> -->
                        <select id="airlines" name="airlines" class="form-control select-chosen">
                           <option value="">Select Airline</option>
                           <?php
                              if(!$airlines) $airlines = array();
                              foreach($airlines as $airlines)
                              {
                              	echo '<option value="'.$airlines->code.'">'.$airlines->name.'</option>';
                              }
                                                   ?>
                        </select>
                     </div>
                  </div>
                  <!-- /.tab-pane -->
                  <div class="tab-pane fade in " id="tab_2">
                     <br>
                     <div class="form-group">
                        <!-- <input id="arricao" type="text" name="arricao" class="form-control" placeholder="Enter ICAO code" onkeypress="limitKeypress(event,this.value,4)"/> -->
                        <select id="arricao" name="arricao" class="form-control select-chosen">
                           <option value="">Select Arrival ICAO</option>
                           <?php

                              foreach($depairports as $airport)
                              {
                                echo '<option value="'.$airport->icao.'">'.$airport->icao.' '.$airport->name.'</option>';
                              }
                              ?>
                        </select>
                     </div>
                  </div>
                  <!-- /.tab-pane -->
                  <div class="tab-pane fade in" id="tab_3">
                     <br>
                     <div class="form-group">
                        <select id="equipment" name="equipment" class="form-control select-chosen">
                           <option value="">Select equipment</option>
                           <?php
                              if(!$equipment) $equipment = array();
                              foreach($equipment as $equip)
                              {
                              	echo '<option value="'.$equip->name.'">'.$equip->name.' ('.$equip->fullname.')</option>';
                              }
                                                   ?>
                        </select>
                     </div>
                  </div>
                  <!-- /.tab-pane -->
                  <div class="tab-pane fade in" id="tab_4">
                     <br>
                     <div class="form-group">
                        <select id="type" name="type" class="form-control select-chosen">
                           <option value="greater">Greater Than</option>
                           <option value="less">Less Than</option>
                        </select>
                     </div>
                     <div class="form-group">
                        <input type="text" name="distance" value="" class="form-control" />
                     </div>
                  </div>
                  <!-- /.tab-pane -->
                  <div class="tab-pane fade in" id="tab_5">
                     <br>
                     <div class="form-group">
                        <select id="type" name="type" class="form-control select-chosen">
                           <option value="">Select Flight Type</option>
                           <?php
                            $types = Config::Get('FLIGHT_TYPES');
                              foreach($types as $type => $code)
                              {
                                echo '<option value="'.$type.'">'.$code.'</option>';
                              }
                                                   ?>
                        </select>
                     </div>
                  </div>
               </div>
               <!-- /.tab-content -->
            </div>
            <!-- nav-tabs-custom -->
            <!-- END Example Content -->
            <script>
               function limitKeypress(event, value, maxLength) {
               if (value != undefined && value.toString().length >= maxLength) {
               event.preventDefault();
               }
               var arricao = getElementByID("arricao");
               arricao.toUpperCase();
               }
            </script>
            <Center>
               <input type="hidden" name="action" value="findflight" />
               <input type="submit" name="submit" value="Search" class="btn btn-flat btn-primary" />
            </Center>
         </form>
         </p>
      </div>
   </div>
   <div class="col-md-12">
      <div class="block">
         <div class="block-title">
            <h3>Flight Map from <?php echo $current_location->name; ?></h3>
         </div>
         <p><?php
        	Template::set('icao', $current_location->icao);
         MainController::Run('Schedules', 'flight_map'); ?></p>
      </div>
   </div>
   
  
   <!-- <div class="col-md-6">
      <div class="block no-border">
         <div class="block-title">
            <h3>Generate <strong>Rosters</strong></h3>
         </div>
         <p><?php MainController::Run('Schedules', 'rosterForm'); ?></p>
      </div>
   </div> -->
</div>
