<style>
.slidecontainer {
    width: 100%;
}

.slider {
    -webkit-appearance: none;
    width: 100%;
    height: 15px;
    border-radius: 5px;
    background: #d3d3d3;
    outline: none;
    opacity: 0.7;
    -webkit-transition: .3s;
    transition: opacity .3s;
}

.slider:hover {
    opacity: 1;
}

.slider::-webkit-slider-thumb {
    -webkit-appearance: none;
    appearance: none;
    width: 25px;
    height: 25px;
    border-radius: 50%;
    background: #2c3e50;
    cursor: pointer;
}

.slider::-moz-range-thumb {
    width: 25px;
    height: 25px;
    border-radius: 50%;
    background: #2c3e50;
    cursor: pointer;
}

</style>

<?php
    $pilotid = Auth::$userinfo->pilotid;
    $last_location = PIREPData::getLastReports($pilotid, 1);
    if(!$last_location) { $last = Auth::$userinfo->hub; } else { $last = $last_location->arricao; }
    $last_name = OperationsData::getAirportInfo($last);
    $equipment = OperationsData::GetAllAircraftSearchList(true);
    $airlines = OperationsData::getAllAirlines(true);
?>

<form name="randomflights" target="_blank" id="randomflights" class="form-horizontal" action="<?php echo SITE_URL?>/index.php/schedules/generateRosters" method="post">
    <div class="form-group">
			<label class="col-sm-4 control-label" for="count">Rosters</label>
		  	<div class="col-sm-6">
			  	<select id="count" name="count" class="form-control" size="1">
				  	<option value="2">1 Trip (2 Legs)</option>
					<option value="4">2 Trips (4 legs)</option>
			  		<option value="6">3 Trips (6 legs)</option>
			  		<option value="8">4 Trips (8 legs)</option>
			  		<option value="10">5 Trips (10 legs)</option>
				  </select>
			  </div>
		</div>
	
		<div class="form-group has-success">
			<label class="col-sm-4 control-label" for="airline">Duration of each Leg</label>
			<div class="col-sm-6">
				<span class='text-warning'>Caution : durations are flexible (+/-) 2 hours</span><br> <br>
				<input type="range" id="rosterDuration" min="2" max="20" value="7" name="duration" class="slider" value="<?php echo $distance; ?>" >
				<br> <span class="label label-success" id="durationShowCase"></span>
				<span id="category">-- Flight Category --</span>
			</div>
		</div>
		<center>
			<input type="hidden" name="depicao" value="<?php echo $last; ?>" />
			<input type="submit" name="submit" class="btn btn-md btn-primary" value="Generate">
		</center>
    </form>

<script src="<?php echo SITE_URL?>/lib/skins/iCrew/js/ion.rangeSlider.js"></script>

<script>

var slider = document.getElementById("rosterDuration");
var output = document.getElementById("durationShowCase");
var flightType = document.getElementById("category");
output.innerHTML = slider.value + " Hours";


slider.oninput = function() {
  output.innerHTML = this.value + " Hours";
  
  
  if (this.value < 3) {
  	flightType.innerHTML = "<span class='label label-info'>Short Haul</span>";
  } else if (this.value < 7) {
	flightType.innerHTML = "<span class='label label-success'>Medium Haul</span>";
  } else if (this.value < 12) {
  	flightType.innerHTML = "<span class='label label-warning'>Long Haul</span>";
  } else if (this.value < 20) {
	flightType.innerHTML = "<span class='label label-danger animation-pulse'>Ultra Long Haul</span>";
  }
}
</script>
