<?php
   /**
    * iCrew v4 Premium - Virtual Airline Crew Center
    * Copyright (c) 2017 iCrewSystems
    *
    * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
    * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
    * No part of the website design or layout may be reproduced or transmitted in any form or by any other
    * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
    * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems.
    *
    * @author: Leonard Selvaraja
    * @copyright: Copyright (c) 2017, iCrewSystems
    * @link http://www.icrewsystems.com
    * @service name: iCrewSystems Virtual Airline Premium Services (with additions)
    * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
    *
    */
   ?>
<div class="content-header">
   <div class="header-section">
      <h1>
         <i class="gi gi-user"></i><strong>Staff Team</strong> <br><small>Corporate | <?php echo SITE_NAME; ?> &copy; <?php echo date("Y"); ?></small>
      </h1>
   </div>
</div>
<!-- Header -->
<div class="alert alert-success alert-dismissable animation-fadeIn">
   Below, you will find the reason for our success. Our efficient and amazingly powerful team, who have dedicated their time and effort for the welfare of <?php echo SITE_NAME; ?>.
</div>
<div class="row">
      <?php
         $stafflevels = vStaffListData::GetAllStaffLevels();
         if(!$stafflevels) {
         	echo '<div class="alert alert-danger">Oops, no staff members added! Fix this ASAP <a href="'.SITE_NAME.'/admin/index.php/vStaffListAdmin/" target="_blank" class="alert-link">Click here</a>';
         	$stafflevels = array();
         	} foreach($stafflevels as $level) { ?>
      <div class="col-md-12">
         <div class="alert alert-warning">
            <center>
               	<h3><strong><?php echo $level->name;?></strong></h3>
            </center>
         </div>
         <?php
            $allstaff = vStaffListData::GetAllStaffInCat($level->id);
            if(!$allstaff){
            	$allstaff = array();
            		echo '<div class="alert alert-danger">Oops, no staff members added! Fix this ASAP <a href="'.SITE_NAME.'/admin/index.php/vStaffListAdmin/" target="_blank" class="alert-link">Click here</a>';
            		} foreach($allstaff as $staff) { ?>
         <div id="<?php echo $staff->pilotid; ?>" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog">
               <div class="modal-content">
                  <!-- Modal Header -->
                  <div class="modal-header text-center">
                     <h2 class="modal-title"> <?php echo $staff->title; ?></h2>
                  </div>
                  <!-- END Modal Header -->
                  <!-- Modal Body -->
                  <div class="modal-body">
                     <p>
                        <?php echo $staff->bio; ?>
                        <br><br>
                        Contact: <?php echo $staff->email;?> <br>
                        iMail ID: <?php
                           $site_name = SITE_URL;
                           $site_name = str_replace("https://", "", $site_name);
                           $site_name = str_replace("http://", "", $site_name);
                           $site_name = str_replace("icrew.", "", $site_name);
                           $firstname = str_replace(' ','', $staff->firstname);
                           $lastname = str_replace(' ','', $staff->lastname);
                           echo strtolower($firstname).'.'.strtolower($lastname).'@'.$site_name;
                           ?>
                     </p>
                  </div>
                  <!-- END Modal Body -->
               </div>
            </div>
         </div>
         <div class="col-md-6">
            <div class="widget">
               <div class="widget-advanced widget-advanced-alt">
                  <div class="widget-header text-center themed-background-dark-flatie">
                     <a data-toggle="modal" data-target="#<?php echo $staff->pilotid; ?>">
                       <?php
                          $pilotdata = PilotData::GetPilotData($staff->pilotid);                          
                          $pilotCode = PilotData::getPilotCode($pilotdata->code, $pilotdata->pilotid).'_'.$pilotdata->hub;
                          if(!file_exists(SITE_ROOT.AVATAR_PATH.'/'.$pilotCode.'.png')) {
                          $image = SITE_URL.'/lib/images/noavatar.png';
                          } else {
                          $image = SITE_URL.AVATAR_PATH.'/'.$pilotCode.'.png';
                          }
                          ?>
                     <?php
                        // if($staff->staffimage == '') {
                        // 	$image = 'https://cdn.discordapp.com/attachments/287923288284332032/701807168344555672/unknown.png';
                        // } else {
                        // 	$image = SITE_URL.'/staff_photos/'.$staff->staffimage;
                        //
                        // }
                        ?>
                     <img src="<?php echo $image; ?>" alt="avatar" class="widget-image img-circle">
                     </a>
                     <h4 class="widget-content-light">
                        <a href="<?php echo SITE_URL; ?>/index.php/profile/view/<?php echo $staff->pilotid; ?>" class="themed-color-flatie"> <?php echo PilotData::GetPilotCode($staff->code, $staff->pilotid); ?> - <?php echo $staff->firstname.' '.$staff->lastname; ?></a><br>
                        <h5> <?php echo $staff->title;?> </h5>
                        <small><img src="<?php echo Countries::getCountryImage($staff->location);?>" alt="<?php echo Countries::getCountryName($staff->location);?>" /> <?php echo Countries::getCountryName($staff->location);?></small>
                     </h4>
                  </div>
                  <div class="widget-main">
                     <center>
                        <a data-toggle="modal" data-target="#<?php echo $staff->pilotid; ?>" class="btn btn-xs btn-primary btn-alt">View Bio</a>
                        <a href="mailto:<?php echo $staff->email; ?>" class="btn btn-xs btn-warning btn-alt">Contact</a>
                        <a href="<?php echo SITE_URL; ?>/index.php/profile/view/<?php echo $staff->pilotid; ?>" class="btn btn-xs btn-success btn-alt">Profile</a>
                     </center>
                     <br>
                     <div class="list-group remove-margin">
                        <a href="javascript:void(0)" class="list-group-item">
                           <span class="pull-right"><strong><?php echo $staff->totalflights; ?></strong></span>
                           <h4 class="list-group-item-heading remove-margin"><i class="fa fa-plane fa-fw"></i> Flights</h4>
                        </a>
                        <a href="javascript:void(0)" class="list-group-item">
                           <span class="pull-right"><strong><?php echo $staff->totalhours; ?> </strong></span>
                           <h4 class="list-group-item-heading remove-margin"><i class="fa fa-briefcase fa-fw"></i> Hours</h4>
                           <p class="list-group-item-text"></p>
                        </a>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <?php }
            }

            ?>
      </div>
   </div>
<!-- Staff List -->
